/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml.servlet;

import com.atlassian.sal.api.ApplicationProperties;
import java.io.IOException;
import java.util.Optional;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.oidc.InitiateOidcLogout;
import org.kantega.atlaskerb.identityproviders.oidc.OidcIdpConfiguration;
import org.kantega.atlaskerb.identityproviders.oidc.OidcLibWrapper;
import org.kantega.atlaskerb.saml.AtlSpServletSupport;
import org.kantega.atlaskerb.saml.logout.SingleLogoutAppHelper;
import org.kantega.atlaskerb.saml.logout.SingleLogoutAppHelperFactory;
import org.kantega.samllib.SpLogoutServlet;
import org.kantega.samllib.spi.ServiceProviderSpi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlSpLogoutServlet
extends SpLogoutServlet {
    private static final Logger log = LoggerFactory.getLogger(AtlSpLogoutServlet.class);
    private static final String PATH_POSTFIX = "/logout";
    private static final String PATH_PREFIX = "/plugins/servlet/no.kantega.saml/sp/";
    private static final String PARAM_ACTION = "action";
    private final AtlSpServletSupport atlSpServletSupport;
    private final SingleLogoutAppHelper logoutAppHelper;
    private final HostApp hostApp;
    private final ApplicationProperties applicationProperties;
    private final OidcLibWrapper oidcLibWrapper;

    @Inject
    public AtlSpLogoutServlet(AtlSpServletSupport atlSpServletSupport, SingleLogoutAppHelperFactory singleLogoutAppHelperFactory, RequireAdminServletDependencyBucket bucket) {
        this.atlSpServletSupport = atlSpServletSupport;
        this.logoutAppHelper = singleLogoutAppHelperFactory.getInstance();
        this.hostApp = bucket.getHostAppFactory().getInstance();
        this.applicationProperties = bucket.getApplicationProperties();
        this.oidcLibWrapper = bucket.getOidcLibWrapper();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Optional maybeIdpConfig = AtlSpServletSupport.getSpId(req, PATH_PREFIX, PATH_POSTFIX).flatMap(this.atlSpServletSupport::getIdpConfig);
        if (!maybeIdpConfig.isPresent()) {
            this.atlSpServletSupport.renderNotFound(req, resp);
        } else {
            IdpConfiguration idpConfig = (IdpConfiguration)maybeIdpConfig.get();
            if (idpConfig.isOidc()) {
                OidcIdpConfiguration oidcConfig = (OidcIdpConfiguration)idpConfig;
                this.performOidcSingleLogout(req, resp, oidcConfig);
            } else if (idpConfig.isSaml()) {
                this.performSamlSingleLogout(req, resp);
            } else {
                throw new SecurityException("Does not recognize the identity provider type.");
            }
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.checkExists(req)) {
            this.atlSpServletSupport.renderNotFound(req, resp);
        } else {
            super.doPost(req, resp);
        }
    }

    protected ServiceProviderSpi getServiceProviderSpi(HttpServletRequest req) {
        return AtlSpServletSupport.getSpId(req, PATH_PREFIX, PATH_POSTFIX).flatMap(this.atlSpServletSupport::getServiceProviderSpi).orElse(null);
    }

    private boolean checkExists(HttpServletRequest req) {
        return this.getServiceProviderSpi(req) != null;
    }

    private void performOidcSingleLogout(HttpServletRequest req, HttpServletResponse resp, OidcIdpConfiguration oidcConf) throws IOException {
        String idTokenSessionFromSession = (String)req.getSession(false).getAttribute("ksso.oidc.idtoken");
        this.hostApp.invalidateSession(resp, req);
        resp.sendRedirect(InitiateOidcLogout.run(oidcConf, this.applicationProperties, this.oidcLibWrapper, this.hostApp, idTokenSessionFromSession));
    }

    private void performSamlSingleLogout(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if ("init".equals(req.getParameter(PARAM_ACTION)) && !this.logoutAppHelper.optionallyValidateXsrfToken(req, resp)) {
            log.debug("Invalid XSRF token, aborting");
            this.atlSpServletSupport.renderNotFound(req, resp);
            return;
        }
        super.doGet(req, resp);
    }
}

