/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.rest.resource.api.usercleanup;

import com.atlassian.annotations.PublicApi;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.control.Try;
import java.io.IOException;
import java.io.Serializable;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.jsoncreatorclasses.CleanupRule;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.jsoncreatorclasses.CronAttributes;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.utils.CleanupAction;
import org.kantega.atlaskerb.rest.util.ResponseUtils;
import org.kantega.atlaskerb.utils.JsonWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="get-cleanup-rule")
@PublicApi
public class GetCleanupRule {
    private static final Logger log = LoggerFactory.getLogger(GetCleanupRule.class);
    private final UserManager userManager;
    private final KerbConfManager kerbConfManager;
    private final HostApp hostApp;
    private final JsonWrapper jsonWrapper;

    @Inject
    public GetCleanupRule(@ComponentImport UserManager userManager, KerbConfManager kerbConfManager, HostAppFactory hostAppFactory, JsonWrapper jsonWrapper) {
        this.userManager = userManager;
        this.kerbConfManager = kerbConfManager;
        this.hostApp = hostAppFactory.getInstance();
        this.jsonWrapper = jsonWrapper;
    }

    private CleanupRule createInitRule(UserProfile userProfile) {
        String[] stringArray;
        String defaultGroupException = this.hostApp.getDefaultAdminGroupName();
        if (defaultGroupException != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = defaultGroupException;
        } else {
            stringArray = new String[]{};
        }
        String[] groupExceptions = stringArray;
        return new CleanupRule(30, false, userProfile.getUsername(), CleanupAction.DEACTIVATE, null, null, groupExceptions, null, new CronAttributes(null, null, null, null, null, null, null, false));
    }

    private Response run(UserProfile userProfile, UserManager userManager) {
        ObjectReader objectReader = this.jsonWrapper.objectReader();
        ObjectWriter objectWriter = this.jsonWrapper.objectWriter();
        if (userManager.isSystemAdmin(userProfile.getUserKey())) {
            CleanupRule rule;
            CleanupRule initRule = this.createInitRule(userProfile);
            try {
                String json = this.kerbConfManager.getUserCleanupRuleJSONString();
                if (json == null) {
                    json = objectWriter.writeValueAsString((Object)initRule);
                    this.kerbConfManager.setUserCleanupRuleJSONString(json);
                    return (Response)this.jsonWrapper.tryBuildJsonString(initRule).map(jsonString -> Response.ok((Object)jsonString, (MediaType)MediaType.APPLICATION_JSON_TYPE).build()).onFailure(throwable -> log.error("Failed to build JSON: ", throwable)).getOrElse((Object)Response.serverError().build());
                }
                rule = (CleanupRule)objectReader.readValue(this.kerbConfManager.getUserCleanupRuleJSONString(), CleanupRule.class);
                if (rule == null) {
                    json = objectWriter.writeValueAsString((Object)initRule);
                    this.kerbConfManager.setUserCleanupRuleJSONString(json);
                    return (Response)this.jsonWrapper.tryBuildJsonString(initRule).map(jsonString -> Response.ok((Object)jsonString, (MediaType)MediaType.APPLICATION_JSON_TYPE).build()).onFailure(throwable -> log.error("Failed to build JSON: ", throwable)).getOrElse((Object)Response.serverError().build());
                }
            }
            catch (IOException e) {
                log.error("Failed to map CleanupRule JSON to Object. Resetting config...", (Throwable)e);
                this.kerbConfManager.setUserCleanupRuleJSONString(null);
                return ResponseUtils.errorWithMessageInJson(Response.Status.BAD_REQUEST, "Failed to map CleanupRule JSON to Object. Resetting config...");
            }
            return (Response)this.jsonWrapper.tryBuildJsonString(rule).map(jsonString -> Response.ok((Object)jsonString, (MediaType)MediaType.APPLICATION_JSON_TYPE).build()).onFailure(throwable -> log.error("Failed to build JSON: ", throwable)).getOrElse((Object)Response.serverError().build());
        }
        return ResponseUtils.errorWithMessageInJson(Response.Status.FORBIDDEN, "Missing access privileges");
    }

    @GET
    @Produces(value={"application/json"})
    public Response doGet(@Context HttpServletRequest request) {
        return ResponseUtils.user(request, this.userManager).wrap((CheckedFunction1<UserProfile, Response>)(CheckedFunction1 & Serializable)userProfile -> (Response)Try.of((CheckedFunction0 & Serializable)() -> this.run((UserProfile)userProfile, this.userManager)).onFailure(e -> log.error("Encountered an exception while atempting to GET cleanup rule. ", e)).getOrElse((Object)Response.serverError().build()));
    }
}

