/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.kerberos.keytab;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.kantega.atlaskerb.kerberos.keytab.KeytabEntry;
import org.kantega.atlaskerb.kerberos.keytab.KeytabFetchResult;
import org.kantega.atlaskerb.kerberos.keytab.KeytabReader;
import org.kantega.atlaskerb.kerberos.keytab.PrincipalName;

public class KeytabFetcher {
    private static final String KDC_PROPERTY = "java.security.krb5.kdc";
    private static final String REALM_PROPERTY = "java.security.krb5.realm";
    private static final String CONF_PROPERTY = "java.security.krb5.realm";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public KeytabFetchResult fetch(String realm, String host, String kdc, String password) throws LoginException {
        String principal = "HTTP/" + host + "@" + realm;
        Configuration configuration = KeytabFetcher.createConfiguration();
        String kdcValue = System.getProperty(KDC_PROPERTY);
        String confValue = System.getProperty("java.security.krb5.realm");
        String realmValue = System.getProperty("java.security.krb5.realm");
        try {
            System.setProperty(KDC_PROPERTY, kdc);
            System.setProperty("java.security.krb5.realm", "/file/does/not/exists");
            System.setProperty("java.security.krb5.realm", realm);
            try {
                NameAndPasswordLoginContext context = new NameAndPasswordLoginContext(configuration, principal, password);
                context.login();
                KeytabFetchResult keytabFetchResult = new KeytabFetchResult(context.getSubject().getPrivateCredentials(KerberosKey.class));
                return keytabFetchResult;
            }
            catch (LoginException e) {
                KeytabFetchResult keytabFetchResult;
                block25: {
                    block23: {
                        NameAndPasswordLoginContext context = new NameAndPasswordLoginContext(configuration, principal, password + "\n");
                        context.login();
                        keytabFetchResult = new KeytabFetchResult(context.getSubject().getPrivateCredentials(KerberosKey.class));
                        if (kdcValue == null) break block23;
                        System.setProperty(KDC_PROPERTY, kdcValue);
                        break block25;
                    }
                    System.clearProperty(KDC_PROPERTY);
                }
                if (realmValue != null) {
                    System.setProperty("java.security.krb5.realm", realmValue);
                } else {
                    System.clearProperty("java.security.krb5.realm");
                }
                if (confValue != null) {
                    System.setProperty("java.security.krb5.realm", confValue);
                } else {
                    System.clearProperty("java.security.krb5.realm");
                }
                return keytabFetchResult;
                {
                    catch (LoginException e1) {
                        KeytabFetchResult keytabFetchResult2;
                        block26: {
                            block24: {
                                keytabFetchResult2 = KeytabFetchResult.LOGIN_FAILED;
                                if (kdcValue == null) break block24;
                                System.setProperty(KDC_PROPERTY, kdcValue);
                                break block26;
                            }
                            System.clearProperty(KDC_PROPERTY);
                        }
                        if (realmValue != null) {
                            System.setProperty("java.security.krb5.realm", realmValue);
                        } else {
                            System.clearProperty("java.security.krb5.realm");
                        }
                        if (confValue != null) {
                            System.setProperty("java.security.krb5.realm", confValue);
                        } else {
                            System.clearProperty("java.security.krb5.realm");
                        }
                        return keytabFetchResult2;
                    }
                }
            }
        }
        finally {
            if (kdcValue != null) {
                System.setProperty(KDC_PROPERTY, kdcValue);
            } else {
                System.clearProperty(KDC_PROPERTY);
            }
            if (realmValue != null) {
                System.setProperty("java.security.krb5.realm", realmValue);
            } else {
                System.clearProperty("java.security.krb5.realm");
            }
            if (confValue != null) {
                System.setProperty("java.security.krb5.realm", confValue);
            } else {
                System.clearProperty("java.security.krb5.realm");
            }
        }
    }

    public static void writeKeys(Set<KerberosKey> keys, int kvno) throws IOException {
        ArrayList<KeytabEntry> entries = new ArrayList<KeytabEntry>();
        for (KerberosKey key : keys) {
            entries.add(new KeytabEntry(PrincipalName.parse(key.getPrincipal().getName(), key.getPrincipal().getNameType()), 0, kvno, key.getKeyType(), key.getEncoded()));
        }
        try (FileOutputStream out = new FileOutputStream("test.keytab");){
            new KeytabReader().write(entries, out);
        }
    }

    private static Configuration createConfiguration() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("useTicketCache", System.getProperty("useTicketCache", "false"));
        options.put("storeKey", "true");
        options.put("debuginfo", "true");
        options.put("refreshKrb5Config", "true");
        final AppConfigurationEntry entry = new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
        return new Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String s) {
                return new AppConfigurationEntry[]{entry};
            }

            @Override
            public void refresh() {
            }
        };
    }

    private static class NameAndPasswordLoginContext
    extends LoginContext {
        public NameAndPasswordLoginContext(Configuration config, final String principal, final String password) throws LoginException {
            super("GSSClientConfig", null, new CallbackHandler(){

                @Override
                public void handle(Callback[] callbacks) {
                    for (Callback callback : callbacks) {
                        if (callback instanceof NameCallback) {
                            ((NameCallback)callback).setName(principal);
                            continue;
                        }
                        if (!(callback instanceof PasswordCallback)) continue;
                        ((PasswordCallback)callback).setPassword(password.toCharArray());
                    }
                }
            }, config);
        }
    }
}

