/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.identityproviders.oidc;

import com.atlassian.crowd.directory.DbCachingRemoteDirectory;
import com.atlassian.crowd.directory.RemoteCrowdDirectory;
import com.atlassian.crowd.directory.SynchronisableDirectoryProperties;
import com.atlassian.crowd.directory.loader.DbCachingRemoteDirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.Attributes;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.exception.ApplicationAccessDeniedException;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.model.authentication.UserAuthenticationContext;
import com.atlassian.crowd.model.authentication.ValidationFactor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.user.UserManager;
import com.kantegasso.oidc.OidcData;
import io.vavr.collection.HashMap;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.io.IOException;
import java.net.URI;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.SafeRedirect;
import org.kantega.atlaskerb.connector.ConnectorConfManager;
import org.kantega.atlaskerb.diagnostics.AuditLogFacade;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.identityproviders.AttributeInfo;
import org.kantega.atlaskerb.identityproviders.GroupEvaluation;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.ManagedGroup;
import org.kantega.atlaskerb.identityproviders.ResponseEvaluationCode;
import org.kantega.atlaskerb.identityproviders.UserRecipe;
import org.kantega.atlaskerb.identityproviders.oidc.OidcDataCache;
import org.kantega.atlaskerb.identityproviders.oidc.OidcDataWrapper;
import org.kantega.atlaskerb.identityproviders.oidc.OidcIdpConfiguration;
import org.kantega.atlaskerb.identityproviders.oidc.OidcLibWrapper;
import org.kantega.atlaskerb.identityproviders.oidc.evaluation.OidcResponseEvaluationResult;
import org.kantega.atlaskerb.identityproviders.oidc.evaluation.OidcResponseEvaluator;
import org.kantega.atlaskerb.kerberos.PrincipalEntry;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.util.ErrorPageRenderer;
import org.kantega.atlaskerb.utils.CookieUtil;
import org.kantega.atlaskerb.utils.ErrorUtils;
import org.kantega.atlaskerb.utils.TestUtils;
import org.kantega.atlaskerb.websudo.WebSudoServlet;
import org.kantega.samllib.spi.ServiceProviderSpi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResumeOidcLoginServlet
extends HttpServlet {
    public static final String SESSION_IDENTIFICATION_KEY = "sessionIdentification";
    private static final String RELATIVE_SERVLET_URL = "/plugins/servlet/no.kantega.kerberosauth.kerberosauth-plugin/callback";
    private static final Logger log = LoggerFactory.getLogger(ResumeOidcLoginServlet.class);
    private final ApplicationProperties applicationProperties;
    private final KerbConfManager kerbConfManager;
    private final UserManager userManager;
    private final OidcDataCache oidcDataCache;
    private final IdpConfManager idpConfManager;
    private final HostApp hostApp;
    private final AuditLogFacade auditLogFacade;
    private final OidcResponseEvaluator responseEvaluator;
    private final ConnectorConfManager connectorConfManager;
    private final OidcLibWrapper oidcLibWrapper;
    private final String USERNAME_ATTR = ServiceProviderSpi.class.getName() + "_username";
    private final SafeRedirect safeRedirect;
    private final ErrorPageRenderer errorPageRenderer;

    @Inject
    public ResumeOidcLoginServlet(@ComponentImport ApplicationProperties applicationProperties, @ComponentImport UserManager userManager, OidcDataCache oidcDataCache, IdpConfManager idpConfManager, AuditLogFacade auditLogFacade, KerbConfManager kerbConfManager, OidcResponseEvaluator responseEvaluator, ConnectorConfManager connectorConfManager, SafeRedirect safeRedirect, HostAppFactory hostAppFactory, OidcLibWrapper oidcLibWrapper, ErrorPageRenderer errorPageRenderer) {
        this.applicationProperties = applicationProperties;
        this.userManager = userManager;
        this.oidcDataCache = oidcDataCache;
        this.idpConfManager = idpConfManager;
        this.kerbConfManager = kerbConfManager;
        this.auditLogFacade = auditLogFacade;
        this.connectorConfManager = connectorConfManager;
        this.responseEvaluator = responseEvaluator;
        this.safeRedirect = safeRedirect;
        this.hostApp = hostAppFactory.getInstance();
        this.oidcLibWrapper = oidcLibWrapper;
        this.errorPageRenderer = errorPageRenderer;
    }

    public static String getCallbackUrl(ApplicationProperties applicationProperties) {
        String baseUrl = applicationProperties.getBaseUrl(UrlMode.ABSOLUTE);
        return ResumeOidcLoginServlet.getCallbackUrl(baseUrl);
    }

    public static String getCallbackUrl(String baseUrl) {
        return URI.create(baseUrl + RELATIVE_SERVLET_URL).toString();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ArrayList<String> errors = new ArrayList<String>();
        String state = req.getParameter("state");
        String code = req.getParameter("code");
        String error = req.getParameter("error");
        String errorDescription = req.getParameter("error_description");
        if (StringUtils.isBlank((CharSequence)state) || StringUtils.isBlank((CharSequence)code)) {
            if (error != null) {
                errors.add(error);
            }
            if (errorDescription != null) {
                errors.add(errorDescription);
            }
            if (errors.isEmpty()) {
                errors.add(ErrorUtils.createErrorMessage("KSSO-B7O6HYJBLH", "Did not retrieve a valid state and code pair from OpenID Connect provider."));
            }
            this.errorPageRenderer.renderErrors(Response.Status.BAD_REQUEST, Collections.singletonList(StringUtils.join(errors, (String)"; ")), null, resp);
            return;
        }
        Option maybeOidcResumeDataWrapper = this.oidcDataCache.pop(state).filter(oidcDataWrapper -> (Boolean)oidcDataWrapper.getOidcData().get("state").map(restoredState -> restoredState.equals(state)).getOrElse((Object)false));
        if (maybeOidcResumeDataWrapper.isEmpty()) {
            this.errorPageRenderer.renderError(Response.Status.BAD_REQUEST, ErrorUtils.createErrorMessage(" KSSO-CIK2G41VZA", "Unable to resume login. Try logging in again."), null, resp);
            return;
        }
        OidcDataWrapper oidcResumeDataWrapper = (OidcDataWrapper)maybeOidcResumeDataWrapper.get();
        OidcData oidcResumeData = oidcResumeDataWrapper.getOidcData();
        String idpConfigurationId = oidcResumeDataWrapper.getIdpId();
        String targetUrl = oidcResumeDataWrapper.getTargetUrl();
        boolean isTest = oidcResumeDataWrapper.isTest();
        OidcIdpConfiguration idpConfiguration = (OidcIdpConfiguration)this.idpConfManager.getIdentityProviderById(idpConfigurationId);
        Either maybeResumed = this.oidcLibWrapper.resume(oidcResumeData, state, code).peekLeft(leftMessage -> {
            ErrorUtils.KssoError kssoError = ErrorUtils.createKssoError("KSSO-I54BMS31JV", "Failed OIDC resume login: " + leftMessage);
            log.error(kssoError.asMessage());
            if (isTest) {
                TestUtils.recordTestFailedAfterResponse(idpConfiguration, this.idpConfManager, oidcResumeData, kssoError, ResponseEvaluationCode.FAILED_OIDC_RESUME_LOGIN).onFailure(throwable -> log.warn(ErrorUtils.createErrorMessage("KSSO-TP7XLL997P", "Error recording test result: " + throwable.getMessage()), throwable));
            }
        });
        if (maybeResumed.isLeft()) {
            if (isTest) {
                TestUtils.renderTestResult(req, resp, idpConfiguration, this.idpConfManager, this.userManager, state);
            } else {
                String message = ErrorUtils.createErrorMessage("KSSO-I54BMS31JV", "Failed OIDC resume login: " + (String)maybeResumed.getLeft());
                this.errorPageRenderer.renderError(Response.Status.BAD_REQUEST, message, null, resp);
            }
            return;
        }
        OidcData oidcDataAfterResume = (OidcData)maybeResumed.get();
        Option maybeProfileJson = oidcDataAfterResume.getProfile();
        if (maybeProfileJson.isEmpty()) {
            ErrorUtils.KssoError kssoError = ErrorUtils.createKssoError("KSSO-5B9PSJG932", "profile is empty.");
            log.error(kssoError.asMessage());
            if (isTest) {
                TestUtils.recordTestFailedAfterResponse(idpConfiguration, this.idpConfManager, (OidcData)maybeResumed.get(), kssoError, ResponseEvaluationCode.FAILED_OIDC_RESUME_LOGIN).onFailure(throwable -> log.warn(ErrorUtils.createErrorMessage("KSSO-PS9T75D3O2", "Error recording test result: " + throwable.getMessage()), throwable));
                TestUtils.renderTestResult(req, resp, idpConfiguration, this.idpConfManager, this.userManager, state);
            } else {
                this.errorPageRenderer.renderError(Response.Status.BAD_REQUEST, kssoError.asMessage(), null, resp);
            }
            return;
        }
        JSONObject profileJson = (JSONObject)maybeProfileJson.get();
        OidcResponseEvaluationResult evaluationResult = this.responseEvaluator.evaluate(idpConfiguration, profileJson, idpConfiguration.getUsernameAttributePriority(), idpConfiguration.getCustomNameAttribute(), idpConfiguration.getCustomGivenNameAttribute(), idpConfiguration.getCustomSurnameAttribute(), idpConfiguration.getNameAttributeMapping(), idpConfiguration.getCustomEmailAttribute(), true);
        if (evaluationResult.isFailed()) {
            ErrorUtils.KssoError kssoError = ErrorUtils.createKssoError("KSSO-W7OR4T3R8R", "Response evaluation failed: " + evaluationResult.getErrorMessage());
            log.error(kssoError.asMessage());
            if (isTest) {
                this.idpConfManager.recordOidcTestResult(idpConfigurationId, state, OidcResponseEvaluationResult.Builder.of(evaluationResult).setErrorMessage(kssoError.asMessage()).setCode(ResponseEvaluationCode.FAILED_OIDC_RESUME_LOGIN).build(), profileJson);
                TestUtils.recordTestFailedAfterResponse(idpConfiguration, this.idpConfManager, (OidcData)maybeResumed.get(), kssoError, ResponseEvaluationCode.FAILED_OIDC_RESUME_LOGIN).onFailure(throwable -> log.warn(ErrorUtils.createErrorMessage("KSSO-9G5KATZURV", "Error recording test result: " + throwable.getMessage()), throwable));
                TestUtils.renderTestResult(req, resp, idpConfiguration, this.idpConfManager, this.userManager, state);
            } else {
                this.errorPageRenderer.renderError(Response.Status.BAD_REQUEST, kssoError.asMessage(), null, resp);
            }
            return;
        }
        if (isTest) {
            this.idpConfManager.recordOidcTestResult(idpConfigurationId, state, evaluationResult, profileJson);
            TestUtils.recordTestProcedureAfterResponse(idpConfiguration, this.idpConfManager, (OidcData)maybeResumed.get(), evaluationResult.getCode());
            TestUtils.renderTestResult(req, resp, idpConfiguration, this.idpConfManager, this.userManager, state);
        } else {
            this.performAtlassianLogin(oidcDataAfterResume, profileJson, targetUrl, evaluationResult, idpConfiguration, req, resp);
        }
    }

    private void performAtlassianLogin(OidcData oidcData, JSONObject profileJson, String requestedUrl, OidcResponseEvaluationResult evaluationResult, OidcIdpConfiguration idpConfiguration, HttpServletRequest req, HttpServletResponse res) throws IOException {
        ArrayList<String> errors = new ArrayList<String>();
        if (!this.idpConfManager.isLicenseValid()) {
            this.errorPageRenderer.renderError(Response.Status.UNAUTHORIZED, "Kantega SSO Plugin license is not valid. Please contact your administrator.", requestedUrl, res);
            return;
        }
        PrincipalEntry principalEntry = evaluationResult.getResolvedPrincipalEntry();
        AttributeInfo configuredUsernameAttribute = evaluationResult.getConfiguredUsernameAttributeInfo();
        if (configuredUsernameAttribute == null && !profileJson.has("preferred_username")) {
            errors.add("The response did not contain the expected OIDC username attribute");
        } else if (evaluationResult.isUserDomainRejected()) {
            String userDomain = evaluationResult.getUserDomain();
            if (userDomain != null) {
                errors.add("Identity provider does not allow logging in users from domain @" + userDomain);
                this.auditLogFacade.loginFailed(evaluationResult.getSearchedUsername(), "OIDC", "Identity provider does not allow logging in users from domain");
            } else {
                errors.add("Identity provider configuration restricts login to usernames with a known domain. The authenticated username does not end with a domain");
                this.auditLogFacade.loginFailed(evaluationResult.getSearchedUsername(), "OIDC", "Identity provider configuration restricts login to usernames with a known domain. The authenticated username does not end with a domain");
            }
        } else {
            String username = evaluationResult.getSearchedUsername();
            Set<String> idpGroupParameters = idpConfiguration.getIdpGroupsAttributes();
            HashSet<String> appGroupAssertions = new HashSet<String>();
            for (String gp : idpGroupParameters) {
                try {
                    appGroupAssertions.addAll(profileJson.getJSONArray(gp).toList().stream().map(Object::toString).collect(Collectors.toList()));
                }
                catch (JSONException jSONException) {}
            }
            List<ManagedGroup> managedOrAutoGroups = idpConfiguration.isCreateAllIncomingGroups() ? idpConfiguration.getAutoGroups() : idpConfiguration.getManagedGroups();
            this.responseEvaluator.evaluateGroups(username, managedOrAutoGroups, appGroupAssertions, evaluationResult.getGroupEvaluation(), idpConfiguration.isCreateAllIncomingGroups(), false);
            UserRecipe userRecipe = evaluationResult.getUserRecipe();
            Optional<Directory> jitDirectory = this.hostApp.findJitDirectory(idpConfiguration.getJitDirectory());
            if (jitDirectory.isPresent()) {
                if (principalEntry == null) {
                    if (idpConfiguration.getUserNotFoundPolicy() == IdpConfiguration.UserNotFoundPolicy.CREATE) {
                        principalEntry = this.createUser(jitDirectory.get(), idpConfiguration, errors, evaluationResult, null, userRecipe, username);
                    } else {
                        if (idpConfiguration.isAuthenticatedAnonymousBrowsingEnabled()) {
                            this.addAuthenticatedAnonymousBrowsingSession(idpConfiguration, req, res, username, requestedUrl);
                            return;
                        }
                        errors.add(String.format("Account not found in %s for username %s using OIDC", this.applicationProperties.getDisplayName(), username));
                        this.auditLogFacade.loginFailed(username, "OIDC", "Account not found in " + this.applicationProperties.getDisplayName());
                    }
                } else if (!(!this.userExistInJITDirectory(jitDirectory.get(), evaluationResult) || principalEntry.getUserState() != PrincipalEntry.UserState.FOUND && principalEntry.getUserState() != PrincipalEntry.UserState.INACTIVE || idpConfiguration.getUserUpdateNamePolicy() != IdpConfiguration.UserUpdateNamePolicy.UPDATE_NAME && idpConfiguration.getUserUpdateEmailPolicy() != IdpConfiguration.UserUpdateEmailPolicy.UPDATE_EMAIL && idpConfiguration.getUserActivatePolicy() != IdpConfiguration.UserActivatePolicy.ACTIVATE)) {
                    this.responseEvaluator.updateUser(evaluationResult.getUserProfile(), jitDirectory.get(), errors, userRecipe, idpConfiguration.getUserUpdateNamePolicy(), idpConfiguration.getUserUpdateEmailPolicy(), idpConfiguration.getUserActivatePolicy(), principalEntry.getUserState(), IdpConfiguration.SSOProtocol.OIDC);
                    if (idpConfiguration.getUserActivatePolicy() == IdpConfiguration.UserActivatePolicy.ACTIVATE) {
                        Principal p = principalEntry.getPrincipal().get();
                        principalEntry = new PrincipalEntry(p, PrincipalEntry.UserState.FOUND);
                    }
                }
                Option.of((Object)idpConfiguration).filter(idp -> idp.getUserNotFoundPolicy() == IdpConfiguration.UserNotFoundPolicy.CREATE || idp.getUserUpdateNamePolicy() == IdpConfiguration.UserUpdateNamePolicy.UPDATE_NAME || idp.getUserUpdateEmailPolicy() == IdpConfiguration.UserUpdateEmailPolicy.UPDATE_EMAIL).peek(idp -> HashMap.ofAll(idp.getUserProfileKeyMap()).filterValues(StringUtils::isNotBlank).mapValues(arg_0 -> ((OidcData)oidcData).get(arg_0)).filterValues(Option::isDefined).mapValues(Option::get).forEach((key, value) -> this.hostApp.setUserProfileValue(username, (String)key, (String)value)));
            } else {
                if (idpConfiguration.isAuthenticatedAnonymousBrowsingEnabled()) {
                    this.addAuthenticatedAnonymousBrowsingSession(idpConfiguration, req, res, username, requestedUrl);
                    return;
                }
                errors.add("Count not create or update user with Just-in-time provisioning (JIT). JIT directory is not specified.");
            }
            if (principalEntry != null && principalEntry.getPrincipal().isPresent()) {
                Principal principal = principalEntry.getPrincipal().get();
                Directory userDirectory = evaluationResult.getResolvedUserDirectory();
                if (userDirectory != null && userDirectory.getType() == DirectoryType.CROWD) {
                    try {
                        this.authenticateUserInCrowdSSO(principal, userDirectory);
                    }
                    catch (OperationFailedException e) {
                        this.errorPageRenderer.renderError(Response.Status.UNAUTHORIZED, "Failed to authenticate user in remote Crowd directory", requestedUrl, res);
                        this.auditLogFacade.loginFailed(principal.getName(), "OIDC", "Failed to authenticate user in remote Crowd directory.");
                        return;
                    }
                }
                if (!this.updateGroupMemberships(evaluationResult, principal, idpConfiguration, username)) {
                    errors.add("Failed updating group memberships for user");
                    this.auditLogFacade.loginFailed(principal.getName(), "OIDC", "Failed updating group memberships for user.");
                } else {
                    boolean canLogin;
                    boolean isPrincipalFound;
                    boolean bl = isPrincipalFound = principalEntry.getUserState() == PrincipalEntry.UserState.FOUND;
                    if (isPrincipalFound) {
                        this.hostApp.publishUserAuthenticatedEvent(principalEntry.getPrincipal().get(), req, res);
                    }
                    if ((canLogin = this.hostApp.canLogin(principal, req)) && isPrincipalFound) {
                        CookieUtil.setLastIdpAccountCookie(idpConfiguration.getId(), req, res);
                        req.getSession().setAttribute("ksso.oidc.idtoken", oidcData.get("id_token").get());
                        req.getSession().setAttribute("ksso.oidc.session.user", (Object)username);
                        req.getSession().setAttribute("ksso.oidc.idp.id", (Object)idpConfiguration.getId());
                        this.hostApp.authenticateWithProduct(req, res, principal);
                        WebSudoServlet.setForcedAuthSessionId(req, idpConfiguration.getId());
                        if (this.kerbConfManager.isRemembermeCookieEnabled()) {
                            this.hostApp.setRememberMeCookie(req, res, principal.getName());
                        }
                        if (!StringUtils.isBlank((CharSequence)requestedUrl)) {
                            if (StringUtils.startsWith((CharSequence)requestedUrl, (CharSequence)(req.getContextPath() + RELATIVE_SERVLET_URL))) {
                                requestedUrl = req.getContextPath() + "/";
                            }
                            this.safeRedirect.sendRedirect(requestedUrl, req, res);
                        } else {
                            res.sendRedirect(req.getContextPath() + "/");
                        }
                        this.auditLogFacade.loginSuccess(principal.getName(), "OIDC with IdP: " + idpConfiguration.getName() + ", id: " + idpConfiguration.getId());
                        return;
                    }
                    if (!canLogin) {
                        errors.add(String.format("Account does not have permission to use %s", this.applicationProperties.getDisplayName()));
                        this.auditLogFacade.loginFailed(principal.getName(), "OIDC", String.format("Account does not have permission to use %s", this.applicationProperties.getDisplayName()));
                    }
                    if (principalEntry.getUserState() == PrincipalEntry.UserState.INACTIVE) {
                        errors.add(String.format("User %s is not active", principal.getName()));
                        this.auditLogFacade.loginFailed(principal.getName(), "OIDC", "User is not active.");
                    }
                }
            } else {
                if (idpConfiguration.isAuthenticatedAnonymousBrowsingEnabled()) {
                    this.addAuthenticatedAnonymousBrowsingSession(idpConfiguration, req, res, username, requestedUrl);
                    return;
                }
                errors.add(String.format("Principal (account) for %s not found. Unable to authenticate user", username));
            }
        }
        this.errorPageRenderer.renderErrors(Response.Status.BAD_REQUEST, errors, requestedUrl, res);
    }

    private boolean userExistInJITDirectory(Directory directory, OidcResponseEvaluationResult evaluationResult) {
        return directory.getId().equals(evaluationResult.getResolvedUserDirectory().getId());
    }

    private PrincipalEntry createUser(Directory directory, OidcIdpConfiguration idpConfiguration, List<String> errors, OidcResponseEvaluationResult evaluationResult, PrincipalEntry principalEntry, UserRecipe userRecipe, String usernameFromIdp) {
        if (userRecipe != null && userRecipe.isComplete()) {
            try {
                if (IdpConfManager.hasRequiredGroupsForCreation(idpConfiguration, evaluationResult.getGroupEvaluation())) {
                    this.addUser(userRecipe, directory, idpConfiguration, usernameFromIdp);
                    principalEntry = new PrincipalEntry(this.userManager.resolve(userRecipe.getUsername().getValue()), PrincipalEntry.UserState.FOUND);
                    log.debug("Successfully");
                } else {
                    if (idpConfiguration.isAuthenticatedAnonymousBrowsingEnabled()) {
                        return null;
                    }
                    if (idpConfiguration.isManagedGroupsRequiredForJITCreation() && !idpConfiguration.isCreateAllIncomingGroups()) {
                        errors.add("Account could not be created.  did not have any managed groups in the user info endpoint from " + idpConfiguration.getName());
                        this.auditLogFacade.loginFailed(evaluationResult.getSearchedUsername(), "OIDC", "Account could not be created. User did not have any managed groups in the user info endpoint from " + idpConfiguration.getName());
                    } else if (idpConfiguration.getAutoCreateUserPolicy() == IdpConfiguration.AutoCreateUserPolicy.MATCHED_GROUPS) {
                        errors.add("Account could not be created. User did not have any matched auto create groups in the user info endpoint from " + idpConfiguration.getName());
                        this.auditLogFacade.loginFailed(evaluationResult.getSearchedUsername(), "OIDC", "Account could not be created. User did not have any matched auto create groups in the user info endpoint from " + idpConfiguration.getName());
                    }
                }
            }
            catch (Exception e) {
                UUID uuid = UUID.randomUUID();
                String message = "Failed creating account for OIDC user " + userRecipe.getUsername().getValue() + " in directory \"" + directory.getName() + "\" (Log correlation ID: " + uuid + "). " + idpConfiguration.getMessageIfJitDirIsAD(userRecipe, this.hostApp);
                this.auditLogFacade.loginFailed(evaluationResult.getSearchedUsername(), "OIDC", message);
                log.error(message, (Throwable)e);
                errors.add(message);
            }
        } else if (userRecipe == null) {
            errors.add("Account cannot be created because of missing user recipe");
            this.auditLogFacade.loginFailed(evaluationResult.getSearchedUsername(), "OIDC", "Account can not be created because of missing user recipe.");
        } else {
            if (userRecipe.getName() == null) {
                errors.add("Account cannot be created because no name attributes were included in the user info endpoint");
                this.auditLogFacade.loginFailed(evaluationResult.getSearchedUsername(), "OIDC", "Account can not be created because configured name attribute was not included in the user info endpoint.");
            }
            if (userRecipe.getEmail() == null) {
                errors.add("Account cannot be created because no email attribute was included in the user info endpoint");
                this.auditLogFacade.loginFailed(evaluationResult.getSearchedUsername(), "OIDC", "Account can not be created because configured email attribute was not included in the user info endpoint.");
            }
        }
        return principalEntry;
    }

    private void addAuthenticatedAnonymousBrowsingSession(OidcIdpConfiguration idpConfiguration, HttpServletRequest req, HttpServletResponse resp, String username, String targetUrl) throws IOException {
        this.hostApp.addAuthenticatedAnonymousBrowsingSession(username, idpConfiguration, req, resp, targetUrl);
        log.debug("Added authenticated anonymous browsing session after verified OIDC login for: " + (String)Option.of((Object)username).getOrElse((Object)"[anonymous]"));
        this.auditLogFacade.loginSuccess((String)Option.of((Object)username).getOrElse((Object)"[anonymous]"), "Authenticated anonymous browsing OIDC with IdP: " + idpConfiguration.getName() + ", id: " + idpConfiguration.getId());
    }

    private void authenticateUserInCrowdSSO(Principal principal, Directory userDirectory) throws OperationFailedException {
        String appName = (String)userDirectory.getAttributes().get("application.name");
        if (appName != null && this.connectorConfManager.getDirectory(appName) == null) {
            try {
                SynchronisableDirectoryProperties.SyncGroupMembershipsAfterAuth groupSyncMode = SynchronisableDirectoryProperties.SyncGroupMembershipsAfterAuth.forDirectory((Attributes)userDirectory);
                if (groupSyncMode == SynchronisableDirectoryProperties.SyncGroupMembershipsAfterAuth.ALWAYS) {
                    DbCachingRemoteDirectoryInstanceLoader instanceLoader = (DbCachingRemoteDirectoryInstanceLoader)ComponentLocator.getComponent(DbCachingRemoteDirectoryInstanceLoader.class);
                    DbCachingRemoteDirectory directory = (DbCachingRemoteDirectory)instanceLoader.getDirectory(userDirectory);
                    RemoteCrowdDirectory crowdDirectory = (RemoteCrowdDirectory)this.hostApp.getAuthorativeDirectory(directory);
                    try {
                        String token = crowdDirectory.getCrowdClient().authenticateSSOUserWithoutValidatingPassword(new UserAuthenticationContext(principal.getName(), null, new ValidationFactor[0], null));
                        crowdDirectory.getCrowdClient().invalidateSSOToken(token);
                    }
                    catch (OperationFailedException e) {
                        log.debug("REST-call failed. Likely because of a remote jira");
                    }
                    catch (ApplicationAccessDeniedException | ApplicationPermissionException | InactiveAccountException | InvalidAuthenticationException e) {
                        log.error("Error authenticating user remotely", e);
                    }
                }
            }
            catch (NoClassDefFoundError e) {
                log.debug("Unable to perform user sync on login since Crowd API is too old and not compatible with triggering this. Sync will happen on next scheduled synchronisation");
            }
        }
    }

    private void addUser(UserRecipe userRecipe, Directory dir, OidcIdpConfiguration idpConfiguration, String usernameFromIdp) {
        try {
            this.hostApp.addUser(dir, this.hostApp.normalizeUsername(userRecipe.getUsername().getValue()), userRecipe.getName().getValue(), userRecipe.getEmail().getValue(), idpConfiguration.getDefaultGroupsFilteredForUser(usernameFromIdp), true);
        }
        catch (UserAlreadyExistsException e) {
            log.warn("Was unable to create user {} with just-in-time provisioning because the user already exist locally. Make sure your user directores are synchronized. ", (Object)this.hostApp.normalizeUsername(userRecipe.getUsername().getValue()));
        }
    }

    boolean updateGroupMemberships(OidcResponseEvaluationResult evaluationResult, Principal principal, OidcIdpConfiguration idpConfiguration, String usernameFromIdp) {
        GroupEvaluation groupEvaluation = evaluationResult.getGroupEvaluation();
        if (idpConfiguration.isCreateAllIncomingGroups() && groupEvaluation.syncUserIdpGroups(this.hostApp, principal, idpConfiguration.isRemoveNonIdpGroupsFromUser(), idpConfiguration.getDefaultGroupsFilteredForUser(usernameFromIdp))) {
            return false;
        }
        Set<String> defaultGroupsForUser = idpConfiguration.getDefaultGroupsFilteredForUser(usernameFromIdp);
        if (groupEvaluation.setManagedGroups(this.hostApp, principal, defaultGroupsForUser)) {
            return groupEvaluation.setDefaultGroups(this.hostApp, principal, defaultGroupsForUser);
        }
        return false;
    }
}

