/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.diagnostics;

import org.kantega.atlaskerb.security.SanitizedLogStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AuditLogFacade {
    private final Logger log = LoggerFactory.getLogger((String)"com.kantegasso.AuditLog");

    public void loginSuccess(String username, String authtype) {
        String message = String.format("The user '%s' has PASSED authentication", username);
        message = authtype != null ? String.format(message + " using %s.", authtype) : message + ".";
        SanitizedLogStatement.of(message).andThenLog(msg -> this.log.info(msg));
    }

    public void loginFailed(String username, String authtype, String reason) {
        String message = String.format("The user '%s' has FAILED authentication", username);
        String string = message = authtype != null ? String.format(message + " using %s.", authtype) : message + ".";
        if (reason != null) {
            message = message + " Reason: " + reason;
        }
        SanitizedLogStatement.of(message).andThenLog(msg -> this.log.info(msg));
    }
}

