/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.connector.okta;

import com.atlassian.json.jsonorg.JSONException;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.kantega.atlaskerb.MultipartHttpRequest;
import org.kantega.atlaskerb.connector.ConnectorType;
import org.kantega.atlaskerb.connector.api.ConnectorAPI;
import org.kantega.atlaskerb.connector.model.Directory;
import org.kantega.atlaskerb.connector.okta.OktaApi;
import org.kantega.atlaskerb.connector.okta.OktaDirectory;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.w3c.dom.Element;

public class OktaConnectorType
implements ConnectorType {
    @Override
    public ConnectorAPI getConnectorApi(Directory directory) {
        OktaDirectory o = (OktaDirectory)directory;
        return new OktaApi(o.getDomain(), o.getToken());
    }

    @Override
    public String getKey() {
        return "OKTA";
    }

    @Override
    public String getDisplayName() {
        return "Okta";
    }

    @Override
    public String getEditDirectoryTemplate() {
        return "okta/edit-connector.vm";
    }

    @Override
    public Directory processEditDirectoryPost(MultipartHttpRequest multipartRequest, Map<String, Object> model, Directory existingConnector, Directory.Common common) {
        String newToken;
        String domain = multipartRequest.getParameter("domain").trim();
        model.put("domain", domain);
        String token = null;
        if (existingConnector != null) {
            OktaDirectory dir = (OktaDirectory)existingConnector;
            token = dir.getToken();
            model.put("tokenDefined", true);
        }
        if ((newToken = multipartRequest.getParameter("token")) != null) {
            newToken = newToken.trim();
        }
        if (newToken != null && !newToken.isEmpty()) {
            token = newToken;
            model.put("suppliedToken", newToken);
            model.put("tokenDefined", false);
        }
        HashSet<String> missingFields = new HashSet<String>();
        model.put("missingFields", missingFields);
        if (domain.isEmpty()) {
            missingFields.add("domain");
        }
        if (token == null || token.isEmpty()) {
            missingFields.add("token");
        }
        if (!missingFields.isEmpty()) {
            return null;
        }
        try {
            OktaApi connectorAPI = new OktaApi(domain, token);
            connectorAPI.findAllGroups(group -> {});
            return new OktaDirectory(common, domain, token);
        }
        catch (JSONException e) {
            model.put("domain", domain);
            model.put("token", token);
            model.put("exception", "Unexpected response message received. Are you sure the domain adress is correct?");
            return null;
        }
        catch (Exception e) {
            model.put("domain", domain);
            model.put("token", token);
            model.put("exception", e.getMessage());
            return null;
        }
    }

    @Override
    public void persist(Directory directory, Element element) {
        OktaDirectory dir = (OktaDirectory)directory;
        element.setAttribute("domain", dir.getDomain());
        element.setAttribute("token", dir.getToken());
    }

    @Override
    public IdpConfiguration.Kind getIdentityProviderKind() {
        return IdpConfiguration.Kind.OKTA;
    }

    @Override
    public void editDirectory(HttpServletRequest req, Directory directory, Map<String, Object> model) {
        if (directory != null) {
            OktaDirectory dir = (OktaDirectory)directory;
            model.put("domain", dir.getDomain());
            model.put("tokenDefined", dir.getToken() != null);
        }
    }

    @Override
    public Directory parse(Element element, Directory.Common common) {
        return new OktaDirectory(common, element.getAttribute("domain"), element.getAttribute("token"));
    }
}

