/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.update.data;

import com.atlassian.sal.api.message.Message;
import io.vavr.collection.List;
import java.io.Serializable;
import javax.annotation.Nullable;
import org.kantega.atlaskerb.update.KssoUpdateManager;
import org.kantega.atlaskerb.update.data.UpdateResult;

public class UpdateMessage
implements Message {
    private final KssoUpdateManager.ResultCode resultCode;
    private final String message;
    private final List<? extends UpdateResult> updateResults;
    private final String configPageUri;
    private final String configPageName;

    public UpdateMessage(KssoUpdateManager.ResultCode resultCode, String message) {
        this.resultCode = resultCode;
        this.message = String.format("[%s] %s", resultCode.name(), message);
        this.updateResults = List.empty();
        this.configPageUri = null;
        this.configPageName = null;
    }

    public UpdateMessage(KssoUpdateManager.ResultCode resultCode, String message, String configPageUri, String configPageTitle) {
        this.resultCode = resultCode;
        this.message = String.format("[%s] %s", resultCode.name(), message);
        this.updateResults = List.empty();
        this.configPageUri = configPageUri;
        this.configPageName = configPageTitle;
    }

    public UpdateMessage(KssoUpdateManager.ResultCode resultCode, String message, List<? extends UpdateResult> updateResults) {
        this.resultCode = resultCode;
        this.message = String.format("[%s] %s", resultCode.name(), message);
        this.updateResults = updateResults;
        this.configPageUri = null;
        this.configPageName = null;
    }

    public String toString() {
        return "UpdateMessage{resultCode=" + (Object)((Object)this.resultCode) + ", message='" + this.message + '\'' + '}';
    }

    public String getKey() {
        return this.message;
    }

    public Serializable[] getArguments() {
        return new Serializable[0];
    }

    public boolean isSuccess() {
        return this.resultCode == KssoUpdateManager.ResultCode.SUCCESS;
    }

    public boolean isFailure() {
        return this.resultCode == KssoUpdateManager.ResultCode.FAILURE;
    }

    public KssoUpdateManager.ResultCode getResultCode() {
        return this.resultCode;
    }

    public String getMessage() {
        return this.message;
    }

    public List<? extends UpdateResult> getUpdateResults() {
        return this.updateResults;
    }

    @Nullable
    public String getConfigPageUri() {
        return this.configPageUri;
    }

    @Nullable
    public String getConfigPageName() {
        return this.configPageName;
    }
}

