/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml.login;

import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;
import org.kantega.atlaskerb.DebugInfo;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;

public class RedirectProperties
implements DebugInfo {
    private final IdpConfiguration.RedirectPolicy redirectPolicy;
    private final Set<String> redirectGroups;
    private final boolean sendLoginHint;
    private final boolean knownAutoRedirect;
    private final boolean visible;
    private final Set<Long> matchedUserDirectoryIds;
    private final boolean invertUserGroupMatch;

    public RedirectProperties(IdpConfiguration.RedirectPolicy redirectPolicy, Set<String> redirectGroups, boolean sendLoginHint, boolean knownAutoRedirect, boolean visible, Set<Long> matchedUserDirectoryIds, boolean invertUserGroupMatch) {
        this.redirectPolicy = redirectPolicy;
        this.redirectGroups = redirectGroups;
        this.sendLoginHint = sendLoginHint;
        this.knownAutoRedirect = knownAutoRedirect;
        this.visible = visible;
        this.matchedUserDirectoryIds = matchedUserDirectoryIds;
        this.invertUserGroupMatch = invertUserGroupMatch;
    }

    public RedirectProperties(RedirectProperties otherRedirectProperties) {
        this.redirectPolicy = otherRedirectProperties.getRedirectPolicy();
        this.redirectGroups = otherRedirectProperties.getRedirectGroups();
        this.sendLoginHint = otherRedirectProperties.isSendLoginHint();
        this.knownAutoRedirect = otherRedirectProperties.isKnownAutoRedirect();
        this.visible = otherRedirectProperties.isVisible();
        this.matchedUserDirectoryIds = otherRedirectProperties.getMatchedUserDirectoryIds();
        this.invertUserGroupMatch = otherRedirectProperties.getInvertUserGroupMatch();
    }

    public IdpConfiguration.RedirectPolicy getRedirectPolicy() {
        return this.redirectPolicy;
    }

    public Set<String> getRedirectGroups() {
        return this.redirectGroups;
    }

    public boolean isSendLoginHint() {
        return this.sendLoginHint;
    }

    public boolean isKnownAutoRedirect() {
        return this.knownAutoRedirect;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public Set<Long> getMatchedUserDirectoryIds() {
        return this.matchedUserDirectoryIds;
    }

    public boolean getInvertUserGroupMatch() {
        return this.invertUserGroupMatch;
    }

    @Override
    public JSONObject asJson() {
        JSONObject json = new JSONObject();
        json.put("redirectPolicy", (Object)this.getRedirectPolicy().name());
        json.put("redirectGroups", (Object)new JSONArray(this.getRedirectGroups()));
        json.put("sendLoginHint", this.isSendLoginHint());
        json.put("knownAutoRedirect", this.isKnownAutoRedirect());
        json.put("visible", this.isVisible());
        json.put("matchedUserDirectoryIds", this.getMatchedUserDirectoryIds());
        json.put("invertUserGroupMatch", this.getInvertUserGroupMatch());
        return json;
    }
}

