/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.rest.resource.api.usercleanup;

import com.atlassian.annotations.PublicApi;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.control.Try;
import java.io.Serializable;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.kantega.atlaskerb.InactiveUserCleaner;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.rest.util.ResponseUtils;
import org.kantega.atlaskerb.utils.JsonWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="reset-execute-status")
@PublicApi
public class ResetExecuteStatus {
    private static final Logger log = LoggerFactory.getLogger(ResetExecuteStatus.class);
    UserManager userManager;
    HostApp hostApp;
    JsonWrapper jsonWrapper;

    @Inject
    public ResetExecuteStatus(@ComponentImport UserManager userManager, HostAppFactory hostAppFactory, JsonWrapper jsonWrapper) {
        this.userManager = userManager;
        this.hostApp = hostAppFactory.getInstance();
        this.jsonWrapper = jsonWrapper;
    }

    private Response run(UserProfile userProfile, UserManager userManager) {
        if (!userManager.isSystemAdmin(userProfile.getUserKey())) {
            return ResponseUtils.errorWithMessageInJson(Response.Status.FORBIDDEN, "Missing access privileges");
        }
        InactiveUserCleaner.CleanupStatus userCleanupExecuteStatus = this.hostApp.getUserCleanupExecuteStatus();
        if (userCleanupExecuteStatus != InactiveUserCleaner.CleanupStatus.NOT_RUN) {
            this.hostApp.setUserCleanupExecuteStatus(InactiveUserCleaner.CleanupStatus.NOT_RUN);
        }
        return Response.ok().build();
    }

    @POST
    @Produces(value={"application/json"})
    public Response doPost(@Context HttpServletRequest request) {
        return ResponseUtils.user(request, this.userManager).wrap((CheckedFunction1<UserProfile, Response>)(CheckedFunction1 & Serializable)userProfile -> (Response)Try.of((CheckedFunction0 & Serializable)() -> this.run((UserProfile)userProfile, this.userManager)).onFailure(e -> log.error("Encountered an exception while attempting to reset cleanup execution status. ", e)).getOrElse((Object)Response.serverError().build()));
    }
}

