/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.rest.resource.api.snapshot;

import com.atlassian.plugin.PluginException;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import io.vavr.CheckedFunction1;
import io.vavr.control.Option;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.json.JSONObject;
import org.kantega.atlaskerb.backup.BackupInfo;
import org.kantega.atlaskerb.backup.BackupService;
import org.kantega.atlaskerb.rest.resource.api.snapshot.SnapshotCreatedResponseModel;
import org.kantega.atlaskerb.rest.resource.api.snapshot.SnapshotInfoModel;
import org.kantega.atlaskerb.rest.resource.api.snapshot.SnapshotRestoredResponseModel;
import org.kantega.atlaskerb.rest.util.ResponseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/config/snapshot/")
public class ConfigSnapshotResource {
    private final Logger log = LoggerFactory.getLogger(ConfigSnapshotResource.class);
    private final UserManager userManager;
    private final BackupService snapshotService;

    @Inject
    public ConfigSnapshotResource(@ComponentImport UserManager userManager, BackupService snapshotService) {
        this.userManager = userManager;
        this.snapshotService = snapshotService;
    }

    @GET
    @Produces(value={"application/json"})
    public Response doGet(@Context HttpServletRequest request) {
        return ResponseUtils.sysadminOnly(request, this.userManager).wrap((CheckedFunction1<UserProfile, Response>)(CheckedFunction1 & Serializable)_u -> {
            List<BackupInfo> snapshots = this.snapshotService.getBackups();
            List snapshotInfoModelList = snapshots.stream().map(SnapshotInfoModel::new).collect(Collectors.toList());
            JSONObject debugJson = new JSONObject();
            debugJson.put("snapshotInfo", snapshotInfoModelList);
            this.log.info("Kantega SSO API Retrieving configuration snapshots");
            this.log.debug(String.format("Kantega SSO API Listing available snapshots %s", debugJson.toString(4)));
            return Response.ok(snapshotInfoModelList).build();
        });
    }

    @POST
    @Produces(value={"application/json"})
    public Response doPost(@Context HttpServletRequest request, @DefaultValue(value="") @QueryParam(value="description") String snapshotInput) {
        return ResponseUtils.sysadminOnly(request, this.userManager).wrap((CheckedFunction1<UserProfile, Response>)(CheckedFunction1 & Serializable)_u -> {
            String snapshotDescription = snapshotInput.isEmpty() ? this.snapshotService.filename() : snapshotInput;
            File snapshot = this.snapshotService.createBackup(snapshotDescription);
            this.log.info(String.format("Kantega SSO API Created snapshot via REST api %s", snapshot.getName()));
            return Response.ok((Object)new SnapshotCreatedResponseModel(snapshot.getName())).build();
        });
    }

    @Path(value="/restore/{id}")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response doPost(@Context HttpServletRequest request, @PathParam(value="id") String snapshotInput, @QueryParam(value="makeSnapshot") boolean makeSnapshot) {
        return ResponseUtils.sysadminOnly(request, this.userManager).wrap((CheckedFunction1<UserProfile, Response>)(CheckedFunction1 & Serializable)_u -> {
            String snapshotFullName = snapshotInput + ".zip";
            JSONObject jsonObject = new JSONObject();
            BackupInfo snapshot = this.snapshotService.findBackup(snapshotFullName);
            jsonObject.put("snapshot", (Object)snapshot);
            this.log.info(String.format("Kantega SSO API restoring snapshot %s", jsonObject.toString(4)));
            Option<File> maybeSnapshotFile = this.snapshotService.getBackupFile(snapshotFullName);
            if (maybeSnapshotFile.isEmpty()) {
                this.log.error(String.format("Kantega SSO API restoring snapshot failed, file not found %s", snapshotFullName));
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            File snapshotFile = (File)maybeSnapshotFile.get();
            if (!snapshotFile.canRead()) {
                this.log.error(String.format("Kantega SSO API restoring snapshot failed, file not readable %s", snapshotFullName));
                throw new PluginException(String.format("Can't read snapshot file %s", snapshotFullName));
            }
            if (snapshot != null) {
                this.snapshotService.restoreFromFile(snapshotFile, makeSnapshot);
            }
            this.log.info(String.format("Kantega SSO API successfully restored snapshot %s", snapshotFullName));
            return Response.ok((Object)new SnapshotRestoredResponseModel(snapshotFile.getName())).build();
        });
    }
}

