/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import io.vavr.collection.List;
import io.vavr.control.Option;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.IpRestrictionConfig;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.update.KssoUpdateManager;
import org.kantega.atlaskerb.utils.InternetAddressUtils;
import org.kantega.atlaskerb.utils.ListParseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicAuthServlet
extends RequireAdminServlet {
    private final KerbConfManager kerbConfManager;
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;
    private final Logger log = LoggerFactory.getLogger(BasicAuthServlet.class);

    @Inject
    public BasicAuthServlet(RequireAdminServletDependencyBucket bucket, @ComponentImport PluginAccessor pluginAccessor) {
        super(bucket);
        this.kerbConfManager = bucket.getKerbConfManager();
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.buildModelAndRenderTemplate(req, resp, new HashMap<String, Object>());
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        super.doPost(req, resp);
        this.kerbConfManager.setBasicAuthEnabled(StringUtils.equals((CharSequence)"on", (CharSequence)req.getParameter("basicAuthEnabled")));
        HashMap<String, Object> basicAuthLoginIpRestrictions = this.setBasicAuthIpRestrictions(req);
        if (basicAuthLoginIpRestrictions.containsKey("basicAuthRegexFailedBlockedList") || basicAuthLoginIpRestrictions.containsKey("basicAuthRegexFailedUnblockedList")) {
            this.buildModelAndRenderTemplate(req, resp, basicAuthLoginIpRestrictions);
            return;
        }
        resp.sendRedirect("basic-auth");
    }

    private HashMap<String, Object> setBasicAuthIpRestrictions(HttpServletRequest req) {
        HashMap<String, Object> additionalData = new HashMap<String, Object>();
        String basicAuthIpRestrictionType = req.getParameter("basicAuthIpRestrictionType");
        String basicAuthIpUnblockedList = req.getParameter("basicAuthIpUnblockedList");
        String basicAuthIpBlockedList = req.getParameter("basicAuthIpBlockedList");
        Option.of((Object)basicAuthIpRestrictionType).filter(StringUtils::isNotBlank).toTry().mapTry(KerbConfManager.IpRestrictionType::getValueByNameOrAlias).onFailure(t -> this.log.debug("Couldn't save IP restriction type " + basicAuthIpRestrictionType, t)).peek(this.kerbConfManager::setBasicAuthIpRestrictionType);
        if (basicAuthIpBlockedList == null || basicAuthIpUnblockedList == null) {
            return additionalData;
        }
        Option maybeValidUnblockedList = Option.of((Object)basicAuthIpUnblockedList).filter(InternetAddressUtils::isValidPermissionList).peek(this.kerbConfManager::setBasicAuthIpUnblockedList).onEmpty(() -> additionalData.put("basicAuthIpUnblockedList", basicAuthIpUnblockedList)).onEmpty(() -> additionalData.put("basicAuthRegexFailedUnblockedList", true)).onEmpty(() -> additionalData.put("invalidDataInIpUnblockedList", Option.of((Object)basicAuthIpUnblockedList).map(ListParseUtils::parseListFromNewlines).map(KssoUpdateManager::onlyIpRestrictErrorMessagesCommaSeparated).getOrNull()));
        Option maybeValidBlockedList = Option.of((Object)req.getParameter("basicAuthIpBlockedList")).filter(InternetAddressUtils::isValidPermissionList).peek(this.kerbConfManager::setBasicAuthIpBlockedList).onEmpty(() -> additionalData.put("basicAuthIpBlockedList", basicAuthIpBlockedList)).onEmpty(() -> additionalData.put("basicAuthRegexFailedBlockedList", true)).onEmpty(() -> additionalData.put("invalidDataInIpBlockedList", Option.of((Object)basicAuthIpBlockedList).map(ListParseUtils::parseListFromNewlines).map(KssoUpdateManager::onlyIpRestrictErrorMessagesCommaSeparated).getOrNull()));
        boolean success = List.of((Object[])new Option[]{maybeValidUnblockedList, maybeValidBlockedList}).forAll(Option::isDefined);
        if (!success) {
            additionalData.put("basicAuthIpRegexError", true);
        }
        return additionalData;
    }

    private void buildModelAndRenderTemplate(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> additionalData) throws IOException {
        Map<String, Object> model = this.buildModel(req);
        model.putAll(additionalData);
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/basic-auth.vm", model, (Writer)resp.getWriter());
    }

    private Map<String, Object> buildModel(HttpServletRequest req) {
        Map<String, Object> model = this.newModel(req);
        IpRestrictionConfig ipRestrictionConfig = this.kerbConfManager.getIpRestrictionConfig();
        this.newModel(req);
        model.put("topMenu", "dashboard");
        model.put("menuItem", "basic-auth");
        model.put("basicAuthEnabled", this.kerbConfManager.isBasicAuthEnabled());
        model.put("basicAuthIpUnblockedList", StringUtils.trimToNull((String)ListParseUtils.arrayToStringWithNewlines(ipRestrictionConfig.getBasicAuthIpUnblockedList())));
        model.put("basicAuthIpBlockedList", StringUtils.trimToNull((String)ListParseUtils.arrayToStringWithNewlines(ipRestrictionConfig.getBasicAuthIpBlockedList())));
        model.put("basicAuthIpRestrictionType", (Object)ipRestrictionConfig.getBasicAuthIpRestrictionType());
        String contextPath = req.getContextPath();
        model.put("contextPath", contextPath);
        model.put("homeDirectory", this.kerbConfManager.getKerberosHomeDirectoryPath());
        model.put("displayName", this.applicationProperties.getDisplayName());
        return model;
    }
}

