/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.hostapp;

import com.atlassian.bitbucket.mail.MailMessage;
import com.atlassian.bitbucket.mail.MailService;
import com.atlassian.bitbucket.user.UserAdminService;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.api.UserWithAttributes;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.auth.AuthenticationController;
import com.atlassian.sal.api.auth.AuthenticationListener;
import com.atlassian.sal.api.auth.Authenticator;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import io.vavr.NotImplementedError;
import io.vavr.collection.List;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Collections;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.SafeRedirect;
import org.kantega.atlaskerb.hostapp.DefaultHostApp;
import org.kantega.atlaskerb.hostapp.StatusPreservableHeaderAwareResponse;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.kantega.atlaskerb.utils.JsonWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BitbucketHostApp
extends DefaultHostApp {
    private final MailService mailService;
    private final Method clearSecurityContextHolderMethod;
    private final Message SUCCESS_MESSAGE = new Message(){

        public Serializable[] getArguments() {
            return null;
        }

        public String getKey() {
            return "Successful authentication";
        }
    };
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public BitbucketHostApp(TransactionTemplate transactionTemplate, ApplicationProperties applicationProperties, AuthenticationListener authenticationListener, EventPublisher eventPublisher, AuthenticationController authenticationController, CrowdDirectoryService crowdDirectoryService, CrowdService crowdService, SafeRedirect safeRedirect, KerbConfManager kerbConfManager, JsonWrapper jsonWrapper) {
        super(transactionTemplate, applicationProperties, authenticationListener, eventPublisher, authenticationController, crowdDirectoryService, crowdService, safeRedirect, kerbConfManager, jsonWrapper);
        this.preemptivePathMappings.add("/");
        this.preemptivePathMappings.add("/repos?visibility=public");
        this.preemptivePathMappings.add("/projects");
        this.preemptivePathMappings.add("/projects/*");
        this.mailService = (MailService)ComponentLocator.getComponent(MailService.class);
        this.hasRestApi = true;
        try {
            ClassLoader loader = this.getClass().getClassLoader().getParent();
            Class<?> clazz = loader.loadClass("org.springframework.security.core.context.SecurityContextHolder");
            this.clearSecurityContextHolderMethod = clazz.getMethod("clearContext", new Class[0]);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new RuntimeException("Could not load SecurityContextHolder.clearContext method", e);
        }
    }

    @Override
    public boolean isPreemptiveRequestMapped(HttpServletRequest req) {
        String r = req.getRequestURI().substring(req.getContextPath().length());
        return super.isPreemptiveRequestMapped(req) || r.equals("/projects") || r.startsWith("/projects/") || r.equals("/") || r.equals("/repos") && "visibility=public".equals(req.getQueryString());
    }

    @Override
    public boolean isProductMatch(String product) {
        return StringUtils.equalsIgnoreCase((CharSequence)"bitbucket", (CharSequence)product);
    }

    @Override
    public String getUserManagerLink() {
        return "/admin/users?create";
    }

    @Override
    public boolean isRequestMapped(HttpServletRequest req, String r) {
        return this.isPageWithLoginForm(req, r) || this.isScmRequest(req) && this.kerbConfManager.isBitbucketScmUrlsEnabled() || this.isKerberosScmRequest(req);
    }

    @Override
    public boolean isPageWithLoginForm(HttpServletRequest req, String requestUrl) {
        return this.isMainLoginPage(requestUrl) || requestUrl.equals("/mvc/login");
    }

    @Override
    public boolean isMainLoginPage(String requestUrl) {
        return requestUrl.equals("/login");
    }

    @Override
    protected boolean isAppLoggedIn(HttpSession session) {
        return session.getAttribute("__bbs.security.ctx") != null;
    }

    @Override
    public boolean shouldLoginManually(HttpServletRequest req, HttpServletResponse res) {
        if (this.isScmRequest(req) && !this.kerbConfManager.isBitbucketScmUrlsEnabled()) {
            return true;
        }
        if ((this.isScmRequest(req) || this.isKerberosScmRequest(req)) && !this.hasBasicAuth(req)) {
            return false;
        }
        String r = req.getRequestURI().substring(req.getContextPath().length());
        return r.equals("/login") && req.getParameter("next") == null && req.getParameter("nextUrl") == null;
    }

    @Override
    public boolean isLoginRequest(HttpServletRequest req) {
        String r = req.getRequestURI().substring(req.getContextPath().length());
        return "/j_atl_security_check".equals(r) && "POST".equals(req.getMethod());
    }

    @Override
    public boolean isPasswordLoginRequest(HttpServletRequest req) {
        return StringUtils.isNotBlank((CharSequence)req.getParameter("j_password"));
    }

    @Override
    public String getLoginRequestUsername(HttpServletRequest req) {
        return req.getParameter("j_username");
    }

    private boolean hasBasicAuth(HttpServletRequest req) {
        String authorization = req.getHeader("Authorization");
        return authorization != null && authorization.startsWith("Basic ");
    }

    private boolean isScmRequest(HttpServletRequest req) {
        return req.getServletPath().startsWith("/scm");
    }

    private boolean isKerberosScmRequest(HttpServletRequest req) {
        return req.getServletPath().startsWith("/kerberos-scm");
    }

    @Override
    public void dispatchToLogin(HttpServletRequest req, HttpServletResponse resp, FilterChain chain) throws IOException, ServletException {
        String requestPath = req.getRequestURI().substring(req.getContextPath().length());
        if (this.isRestApi(requestPath)) {
            chain.doFilter((ServletRequest)req, (ServletResponse)new StatusPreservableHeaderAwareResponse(resp));
        } else if (this.isScmRequest(req) || this.isKerberosScmRequest(req)) {
            resp.setHeader("WWW-Authenticate", "Basic realm=\"Atlassian Bitbucket\"");
            resp.addHeader("WWW-Authenticate", "Negotiate");
        } else if (req.getQueryString() != null && req.getQueryString().contains("logout?SAMLResponse")) {
            this.metaRefresh(resp, "login?next=");
        } else if (this.shouldDispatchToLoginPage() && !requestPath.startsWith("/login")) {
            String qs = req.getQueryString() != null ? "?" + req.getQueryString() : "";
            resp.sendRedirect(req.getContextPath() + "/login?next=" + HttpUrlUtils.urlEncode(requestPath + qs));
        } else {
            chain.doFilter((ServletRequest)req, (ServletResponse)resp);
        }
    }

    @Override
    public void invalidateSession(HttpServletResponse res, HttpServletRequest req) {
        try {
            this.clearSecurityContextHolderMethod.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Failed to invoke SecurityContextHolder.clearContext", e);
        }
        super.invalidateSession(res, req);
    }

    @Override
    public Principal authenticateWithProduct(HttpServletRequest req, HttpServletResponse res, Principal user) {
        this.authenticationListener.authenticationSuccess((Authenticator.Result)new Authenticator.Result.Success(this.SUCCESS_MESSAGE, user), req, res);
        Integer userId = this.getUserId(user);
        try {
            Class<?> ausClass = CrowdDirectoryService.class.getClassLoader().loadClass("com.atlassian.stash.internal.spring.security.AuthenticatedUserState");
            Object userState = ausClass.getConstructor(Integer.TYPE, Map.class).newInstance(userId, Collections.emptyMap());
            req.getSession().setAttribute("__bbs.security.ctx", userState);
            this.resetCaptchaOnSsoLogin(user);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return user;
    }

    private void resetCaptchaOnSsoLogin(Principal user) {
        try {
            this.log.debug("Resetting captcha for user {} during SSO login.", (Object)user.getName());
            Object crowdControl = ComponentLocator.getComponent(UserAdminService.class.getClassLoader().loadClass("com.atlassian.stash.internal.crowd.CrowdControl"));
            Method setUserAttribute = crowdControl.getClass().getMethod("setUserAttribute", User.class, String.class, Object.class);
            setUserAttribute.invoke(crowdControl, this.crowdService.getUser(user.getName()), "failedAuthenticationAttemptCount", 0L);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            this.log.warn("Problem resetting capthca on SSO login", (Throwable)e);
        }
    }

    Integer getUserId(Principal user) {
        try {
            Field id = user.getClass().getSuperclass().getDeclaredField("id");
            id.setAccessible(true);
            return (Integer)id.get(user);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void postSuccessfulLoginWithKerberosAction(Principal user, HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws IOException, ServletException {
        this.preventCaching(res);
        if (this.isScmRequest(req) || this.isKerberosScmRequest(req) || this.isRestApi(req.getRequestURI().substring(req.getContextPath().length()))) {
            String userAgent = req.getHeader("User-Agent");
            if (userAgent != null && userAgent.contains("JGit")) {
                res.setHeader("WWW-Authenticate", "Negotiate");
            }
            chain.doFilter((ServletRequest)new AuthenticatedRequest(user, req), (ServletResponse)res);
        } else {
            String next = req.getParameter("next");
            if (next == null) {
                next = req.getParameter("nextUrl");
            }
            if (next != null) {
                if (next.startsWith("http")) {
                    this.safeRedirect.sendRedirect(next, req, res);
                } else {
                    this.safeRedirect.sendRedirect(req.getContextPath() + next, req, res);
                }
            } else {
                this.safeRedirect.sendRedirect(req.getRequestURI(), req, res);
            }
        }
    }

    @Override
    public String getRedirectTarget(HttpServletRequest req) {
        String next = req.getParameter("next");
        if (next == null) {
            next = req.getParameter("nextUrl");
        }
        if (next != null) {
            if (next.startsWith("http")) {
                return next;
            }
            return req.getContextPath() + next;
        }
        return req.getContextPath();
    }

    @Override
    public boolean isSMTPSupported() {
        return true;
    }

    @Override
    public boolean isSMTPEnabled() {
        return this.mailService.isHostConfigured();
    }

    @Override
    public void sendEmail(String recipient, String subject, String body) {
        this.mailService.submit(new MailMessage.Builder().to(new String[]{recipient}).subject(subject).text(body).build());
    }

    @Override
    public String getLastLoginMillisFromUserWithAttributes(UserWithAttributes user) {
        return user.getValue("lastAuthenticationTimestamp");
    }

    @Override
    public String getLastLoginParameter() {
        return "lastAuthenticationTimestamp";
    }

    @Override
    public File getHomeDirectory() {
        File localHome = new File(this.applicationProperties.getHomeDirectory(), "kerberos");
        if (localHome.exists()) {
            return localHome;
        }
        return new File(this.applicationProperties.getHomeDirectory() + "/shared/", "kerberos");
    }

    @Override
    public String getLoginPage() {
        return "/login";
    }

    @Override
    public String getLogoutPage() {
        return "/logout";
    }

    @Override
    public int getDefaultApiServerPort() {
        return 5503;
    }

    @Override
    public boolean isRestApiExcluded(String r) {
        return r.startsWith("/rest/mirroring/") || r.startsWith("/rest/ssh/") || super.isRestApiExcluded(r);
    }

    @Override
    public JSONObject asJson() {
        JSONObject json = super.asJson();
        json.put("mailServiceIsHostConfigured", this.mailService.isHostConfigured());
        return json;
    }

    @Override
    public List<String> getUserProfileKeys() {
        return List.empty();
    }

    @Override
    public void setUserProfileValue(String username, String key, String value) {
    }

    @Override
    public String getUserProfileValue(String username, String key) {
        return "";
    }

    @Override
    public void setUserProfilePicture(String username, String url) {
        throw new NotImplementedError("Awaiting investigation of security features in Atlassian products.");
    }

    @Override
    public boolean isRESTRequestMapped(HttpServletRequest req, String r) {
        String referer = req.getHeader("referer");
        if (StringUtils.contains((CharSequence)referer, (CharSequence)"?")) {
            referer = StringUtils.substring((String)referer, (int)0, (int)referer.indexOf("?"));
        }
        return super.isRESTRequestMapped(req, r) && !StringUtils.endsWith((CharSequence)referer, (CharSequence)"/login") && !StringUtils.endsWith((CharSequence)referer, (CharSequence)"/logout") && !StringUtils.endsWith((CharSequence)r, (CharSequence)"/rest/analytics/1.0/publish/bulk") && !StringUtils.endsWith((CharSequence)r, (CharSequence)"/rest/qr/1.0/batching");
    }

    @Override
    public String getDefaultAdminGroupName() {
        if (this.getAllGroups().stream().anyMatch(group -> group.getName().equals("stash-administrators"))) {
            return "stash-administrators";
        }
        return null;
    }

    private class AuthenticatedRequest
    extends HttpServletRequestWrapper {
        private final Principal user;

        public AuthenticatedRequest(Principal user, HttpServletRequest request) {
            super(request);
            this.user = user;
        }

        public String getRemoteUser() {
            return this.user.getName();
        }

        public Principal getUserPrincipal() {
            return this.user;
        }
    }
}

