/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.sal.api.web.context.HttpContext;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.lang.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.SSOScriptLoginHookCondition;
import org.kantega.atlaskerb.saml.ServiceDeskSignupFilter;
import org.kantega.atlaskerb.saml.util.ScriptInjector;
import org.kantega.atlaskerb.userlookup.UserLookupService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceDeskLoginFilter
implements Filter {
    private final TemplateRenderer templateRenderer;
    private final SSOScriptLoginHookCondition SSOScriptLoginHookCondition;
    private final HostApp hostApp;
    private final KerbConfManager kerbConfManager;
    private final IdpConfManager idpConfManager;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ScriptInjector scriptInjector;
    private final UserLookupService userLookupService;

    @Inject
    public ServiceDeskLoginFilter(@ComponentImport WebResourceManager webResourceManager, @ComponentImport TemplateRenderer templateRenderer, @ComponentImport HttpContext httpContext, HostAppFactory hostAppFactory, IdpConfManager idpConfManager, RequireAdminServletDependencyBucket bucket) {
        this.hostApp = hostAppFactory.getInstance();
        this.templateRenderer = templateRenderer;
        this.kerbConfManager = bucket.getKerbConfManager();
        this.idpConfManager = idpConfManager;
        this.userLookupService = bucket.getUserLookupService();
        this.SSOScriptLoginHookCondition = new SSOScriptLoginHookCondition(httpContext, bucket);
        this.scriptInjector = new ScriptInjector(webResourceManager, templateRenderer, this.kerbConfManager);
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean enableFederatedSSO;
        final HttpServletRequest req = (HttpServletRequest)request;
        final HttpServletResponse resp = (HttpServletResponse)response;
        final String emailFromHeader = ServiceDeskSignupFilter.getEmailFromHeader(req, this.kerbConfManager);
        final String jsmSignupEmailUnblockedList = this.kerbConfManager.getJsmSignupEmailUnblockedList();
        final String jsmUrlFormUrlparts = this.kerbConfManager.getJsmSignupFormUrlparts();
        boolean bl = enableFederatedSSO = this.SSOScriptLoginHookCondition.shouldDoFederatedSSO(req) && this.idpConfManager.isLoginEnabledForJSM();
        if (this.kerbConfManager.isTraditionalLoginJsmPrevented() && this.noDirectoryOrGroupAllowingTraditionalLogin() || enableFederatedSSO) {
            chain.doFilter((ServletRequest)req, (ServletResponse)new HttpServletResponseWrapper(resp){
                ServletOutputStream out;

                public ServletOutputStream getOutputStream() throws IOException {
                    if (this.out == null) {
                        ServiceDeskLoginFilter.this.log.debug("Setting up ServiceDeskLoginFilter. ServletOutputStream out == null");
                        this.out = new InjectingOutputStream(req, ServiceDeskLoginFilter.this.hostApp.shouldLoginManually(req, resp), ServiceDeskLoginFilter.this.hostApp.shouldDisableRedirect(req), enableFederatedSSO, ServiceDeskLoginFilter.this.kerbConfManager.isTraditionalLoginJsmPrevented() && ServiceDeskLoginFilter.this.noDirectoryOrGroupAllowingTraditionalLogin(), super.getOutputStream(), ServiceDeskLoginFilter.this.idpConfManager.getRedirectProgressDelay(), emailFromHeader, jsmSignupEmailUnblockedList, jsmUrlFormUrlparts);
                    }
                    return this.out;
                }
            });
        } else if (StringUtils.isNotBlank((String)emailFromHeader) || StringUtils.isNotBlank((String)jsmSignupEmailUnblockedList)) {
            chain.doFilter((ServletRequest)req, (ServletResponse)new HttpServletResponseWrapper(resp){
                ServletOutputStream out;

                public ServletOutputStream getOutputStream() throws IOException {
                    if (this.out == null) {
                        ServiceDeskLoginFilter.this.log.debug("Setting up InjectingEmailOutputStream. ServletOutputStream out == null");
                        this.out = new InjectingEmailOutputStream(emailFromHeader, jsmSignupEmailUnblockedList, jsmUrlFormUrlparts, super.getOutputStream());
                    }
                    return this.out;
                }
            });
        } else {
            chain.doFilter((ServletRequest)req, (ServletResponse)resp);
        }
    }

    private boolean noDirectoryOrGroupAllowingTraditionalLogin() {
        return this.userLookupService.getCachedDirectoriesAllowingTraditionalLogin().size() == 0 && this.kerbConfManager.getAllowTraditionalLoginGroups().size() == 0 && this.kerbConfManager.getDisallowTraditionalLoginGroups().size() == 0;
    }

    public void destroy() {
    }

    private class InjectingEmailOutputStream
    extends ServletOutputStream {
        private final String emailFromHeader;
        private final String jsmSignupEmailUnblockedList;
        private final String jsmUrlFormUrlparts;
        private final ServletOutputStream out;
        private final byte[] headStart;

        public InjectingEmailOutputStream(String emailFromHeader, String jsmSignupEmailUnblockedList, String jsmUrlFormUrlparts, ServletOutputStream outputStream) {
            this.emailFromHeader = emailFromHeader;
            this.jsmSignupEmailUnblockedList = jsmSignupEmailUnblockedList;
            this.jsmUrlFormUrlparts = jsmUrlFormUrlparts;
            this.out = outputStream;
            this.headStart = "<head>".getBytes(StandardCharsets.UTF_8);
        }

        public void write(int b) throws IOException {
            this.out.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            int head = this.findHeadStart(b, off, len);
            if (head != -1) {
                this.out.write(b, off, head - off + this.headStart.length);
                StringWriter inject = new StringWriter();
                ServiceDeskLoginFilter.this.log.debug("Writing js changes. emailFromHeader: " + this.emailFromHeader);
                HashMap<String, String> model = new HashMap<String, String>();
                model.put("emailFromHeader", this.emailFromHeader);
                model.put("jsmSignupEmailUnblockedList", this.jsmSignupEmailUnblockedList);
                model.put("jsmUrlFormUrlparts", this.jsmUrlFormUrlparts);
                ServiceDeskLoginFilter.this.templateRenderer.render("templates/atlaskerb/jsm-signup-email.vm", model, (Writer)inject);
                this.out.write(inject.toString().getBytes(StandardCharsets.UTF_8));
                this.out.write(b, head + this.headStart.length, len - head - this.headStart.length);
            } else {
                this.out.write(b, off, len);
            }
        }

        private int findHeadStart(byte[] b, int off, int len) {
            for (int i = off; i < off + len - this.headStart.length; ++i) {
                if (!this.findHeadStart(b, i)) continue;
                return i;
            }
            return -1;
        }

        private boolean findHeadStart(byte[] b, int i) {
            for (int h = 0; h < this.headStart.length; ++h) {
                if (b[i + h] == this.headStart[h]) continue;
                return false;
            }
            return true;
        }

        public boolean isReady() {
            return this.out.isReady();
        }

        public void setWriteListener(WriteListener writeListener) {
            this.out.setWriteListener(writeListener);
        }
    }

    private class InjectingOutputStream
    extends ServletOutputStream {
        private final int samlRedirectDelay;
        private final boolean manualLogin;
        private final boolean shouldDisableRedirect;
        private final boolean enableSaml;
        private final boolean isTraditionalLoginDisabled;
        private final ServletOutputStream out;
        private final byte[] headStart;
        private final String emailFromHeader;
        private final String jsmSignupEmailUnblockedList;
        private final String jsmUrlFormUrlparts;

        public InjectingOutputStream(HttpServletRequest req, boolean manualLogin, boolean shouldDisableRedirect, boolean enableSaml, boolean isTraditionalLoginDisabled, ServletOutputStream outputStream, int samlRedirectDelay, String emailFromHeader, String jsmSignupEmailUnblockedList, String jsmUrlFormUrlparts) {
            this.manualLogin = manualLogin;
            this.shouldDisableRedirect = shouldDisableRedirect;
            this.enableSaml = enableSaml;
            this.isTraditionalLoginDisabled = isTraditionalLoginDisabled;
            this.out = outputStream;
            this.samlRedirectDelay = samlRedirectDelay;
            this.emailFromHeader = emailFromHeader;
            this.jsmSignupEmailUnblockedList = jsmSignupEmailUnblockedList;
            this.jsmUrlFormUrlparts = jsmUrlFormUrlparts;
            this.headStart = "<head>".getBytes(StandardCharsets.UTF_8);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            int head = this.findHeadStart(b, off, len);
            if (head != -1) {
                this.out.write(b, off, head - off + this.headStart.length);
                StringWriter inject = ServiceDeskLoginFilter.this.scriptInjector.prepareInjectScript(this.isTraditionalLoginDisabled, this.enableSaml, this.manualLogin, this.shouldDisableRedirect, this.samlRedirectDelay, this.emailFromHeader, this.jsmSignupEmailUnblockedList, this.jsmUrlFormUrlparts);
                this.out.write(inject.toString().getBytes(StandardCharsets.UTF_8));
                this.out.write(b, head + this.headStart.length, len - head - this.headStart.length);
            } else {
                this.out.write(b, off, len);
            }
        }

        private int findHeadStart(byte[] b, int off, int len) {
            for (int i = off; i < off + len - this.headStart.length; ++i) {
                if (!this.findHeadStart(b, i)) continue;
                return i;
            }
            return -1;
        }

        private boolean findHeadStart(byte[] b, int i) {
            for (int h = 0; h < this.headStart.length; ++h) {
                if (b[i + h] == this.headStart[h]) continue;
                return false;
            }
            return true;
        }

        public void print(String s) throws IOException {
            this.out.print(s);
        }

        public void print(boolean b) throws IOException {
            this.out.print(b);
        }

        public void print(char c) throws IOException {
            this.out.print(c);
        }

        public void print(int i) throws IOException {
            this.out.print(i);
        }

        public void print(long l) throws IOException {
            this.out.print(l);
        }

        public void print(float f) throws IOException {
            this.out.print(f);
        }

        public void print(double d) throws IOException {
            this.out.print(d);
        }

        public void println() throws IOException {
            this.out.println();
        }

        public void println(String s) throws IOException {
            this.out.println(s);
        }

        public void println(boolean b) throws IOException {
            this.out.println(b);
        }

        public void println(char c) throws IOException {
            this.out.println(c);
        }

        public void println(int i) throws IOException {
            this.out.println(i);
        }

        public void println(long l) throws IOException {
            this.out.println(l);
        }

        public void println(float f) throws IOException {
            this.out.println(f);
        }

        public void println(double d) throws IOException {
            this.out.println(d);
        }

        public boolean isReady() {
            return this.out.isReady();
        }

        public void setWriteListener(WriteListener writeListener) {
            this.out.setWriteListener(writeListener);
        }

        public void write(int b) throws IOException {
            this.out.write(b);
        }

        public void write(byte[] b) throws IOException {
            this.out.write(b);
        }

        public void flush() throws IOException {
            this.out.flush();
        }

        public void close() throws IOException {
            this.out.close();
        }
    }
}

