/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SafeRedirect {
    private static final Logger log = LoggerFactory.getLogger(SafeRedirect.class);
    private static final String SEND_REDIRECT_ONGOING = "com.atlassian.web.servlet.plugin.request.RedirectInterceptingResponse.sendRedirect";
    private final ApplicationProperties applicationProperties;

    @Inject
    public SafeRedirect(@ComponentImport ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    public void sendRedirect(String url, HttpServletRequest req, HttpServletResponse res) throws IOException {
        String fallback = req.getContextPath() + "/";
        req.setAttribute(SEND_REDIRECT_ONGOING, (Object)Boolean.TRUE);
        if (this.isLocal(url)) {
            log.debug("Local redirect to '{}'", (Object)url);
            try {
                new URI(url);
                res.sendRedirect(url);
            }
            catch (URISyntaxException e) {
                log.debug("URISyntaxException for '{}'; will url encode before redirecting. Msg: {}", (Object)url, (Object)e.getMessage());
                res.sendRedirect(URLEncoder.encode(url, StandardCharsets.UTF_8.name()));
            }
        } else {
            String absoluteUrl = this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE);
            boolean isFallback = !url.startsWith(absoluteUrl);
            String redirectUrl = isFallback ? fallback : url;
            log.debug("Non local redirect to '{}' (is fallback: {})", (Object)redirectUrl, (Object)isFallback);
            res.sendRedirect(redirectUrl);
        }
    }

    public boolean isLocal(String uri) {
        return !StringUtils.contains((CharSequence)uri, (CharSequence)"://");
    }
}

