/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.control.Try;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.kantega.atlaskerb.LdapTestResult;
import org.kantega.atlaskerb.kerberos.keytab.EncryptionType;
import org.kantega.atlaskerb.security.LdapSecurity;
import org.kantega.atlaskerb.security.SanitizedLogStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LdapPrincipalSearcher {
    private final Logger log = LoggerFactory.getLogger(LdapPrincipalSearcher.class);

    public boolean checkMembership(DirContext context, String defaultNamingContext, String username, Set<String> groups) throws NamingException {
        StringBuilder groupsFilterBuilder = new StringBuilder();
        for (String group : groups) {
            LdapSecurity.encodeFilter("(memberOf:1.2.840.113556.1.4.1941:={0})", group).peek(groupsFilterBuilder::append).onFailure(t -> SanitizedLogStatement.of(group).andThenLog(g -> this.log.warn("Failed to properly encode group filter for: " + g, t)));
        }
        String groupFilter = groups.size() > 1 ? "(|" + groupsFilterBuilder + ")" : groupsFilterBuilder.toString();
        return (Boolean)LdapSecurity.encodeFilter("(&(samAccountName={0}){2})", username, groupFilter).mapTry((CheckedFunction1 & Serializable)sanitizedFilter -> !this.findAccountsByFilter(context, defaultNamingContext, (String)sanitizedFilter).isEmpty()).onFailure(t -> SanitizedLogStatement.of(username).andThenLog(sanitizedUsername -> this.log.warn("Failed to search LDAP for account: " + sanitizedUsername, t))).getOrElse((Object)false);
    }

    public List<LdapTestResult> findReadOnlyDomainControllers(DirContext context, String defaultNamingContext) throws NamingException {
        return (List)LdapSecurity.escapeDistinguishedNameValues("OU=Domain Controllers," + defaultNamingContext).toTry().andThenTry(context::lookup).mapTry((CheckedFunction1 & Serializable)domainControllerContext -> this.findAccountsByFilter(context, (String)domainControllerContext, "(msDS-RevealOnDemandGroup=*)", new String[]{"msDS-RevealOnDemandGroup", "msDS-NeverRevealGroup"})).getOrElse(Collections.emptyList());
    }

    public List<LdapTestResult> findAccountsForSpn(DirContext context, String defaultNamingContext, String servicePrincipalName) throws NamingException {
        List accountsByFilter = (List)LdapSecurity.encodeFilter("(servicePrincipalName={0})", servicePrincipalName).mapTry((CheckedFunction1 & Serializable)encodedFilter -> this.findAccountsByFilter(context, defaultNamingContext, (String)encodedFilter)).onFailure(throwable -> SanitizedLogStatement.of(servicePrincipalName).andThenLog(sanitizedSPN -> this.log.debug("Failed to search for service account with servicePrincipalName" + servicePrincipalName, throwable))).getOrElse(Collections.emptyList());
        for (LdapTestResult result : accountsByFilter) {
            result.getServicePrincipalAliases().remove(servicePrincipalName);
            result.setServicePrincipalName(servicePrincipalName);
        }
        return accountsByFilter;
    }

    public List<LdapTestResult> findAccountsForAccountName(DirContext context, String defaultNamingContext, String accountName) throws NamingException {
        return (List)LdapSecurity.encodeFilter("(samAccountName={0})", accountName).onFailure(throwable -> SanitizedLogStatement.of(accountName).andThenLog(name -> this.log.warn("Failed to submit LDAP query with account name " + name, throwable))).map(sanitizedFilter -> this.findAccountsByFilter(context, defaultNamingContext, (String)sanitizedFilter)).getOrElse(ArrayList::new);
    }

    private List<LdapTestResult> findAccountsByFilter(DirContext context, String defaultNamingContext, String filter) {
        return this.findAccountsByFilter(context, defaultNamingContext, filter, new String[0]);
    }

    private List<LdapTestResult> findAccountsByFilter(DirContext context, String defaultNamingContext, String filter, String[] additionalAttributes) {
        ArrayList<LdapTestResult> results = new ArrayList<LdapTestResult>();
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        ArrayList<String> returningAttributes = new ArrayList<String>();
        returningAttributes.addAll(Arrays.asList("sAMAccountName", "msDS-KeyVersionNumber", "userAccountControl", "userPrincipalName", "servicePrincipalName", "msDS-SupportedEncryptionTypes"));
        returningAttributes.addAll(Arrays.asList(additionalAttributes));
        searchControls.setReturningAttributes(returningAttributes.toArray(new String[0]));
        Try.of((CheckedFunction0 & Serializable)() -> context.search(defaultNamingContext, filter, searchControls)).andThenTry(answer -> {
            while (answer.hasMoreElements()) {
                Attribute supportedAttributeTypesAttr;
                LdapTestResult result = new LdapTestResult();
                SearchResult next = (SearchResult)answer.next();
                String nameInNamespace = next.getNameInNamespace();
                result.setDn(nameInNamespace);
                Attributes attributes = next.getAttributes();
                result.setServicePrincipalUsername(attributes.get("sAMAccountName").get().toString());
                this.inspectUserAccountControl(result, attributes);
                this.inspectKeyVersionNumber(result, attributes);
                Attribute userPrincipalName = attributes.get("userPrincipalName");
                if (userPrincipalName != null) {
                    result.setUserPrincipalName(userPrincipalName.get().toString());
                }
                if ((supportedAttributeTypesAttr = attributes.get("msDS-SupportedEncryptionTypes")) != null) {
                    int supportedEncryptionTypes = Integer.parseInt((String)supportedAttributeTypesAttr.get());
                    result.setSupportedEnctypeDefault(supportedEncryptionTypes == 0);
                    for (EncryptionType encryptionType : EncryptionType.getKnownEncryptionTypes()) {
                        if ((supportedEncryptionTypes & encryptionType.getMask()) == 0) continue;
                        result.getSupportedEncryptionTypes().add(encryptionType);
                    }
                } else {
                    result.setSupportedEnctypeDefault(true);
                }
                Attribute principalName = attributes.get("servicePrincipalName");
                if (principalName != null) {
                    for (int i = 0; i < principalName.size(); ++i) {
                        String name = principalName.get(i).toString();
                        result.addServicePrincipalAlias(name);
                    }
                }
                for (String additionalAttribute : additionalAttributes) {
                    Attribute attribute = attributes.get(additionalAttribute);
                    result.addAttribute(additionalAttribute, attribute);
                }
                results.add(result);
            }
        });
        return results;
    }

    private void inspectKeyVersionNumber(LdapTestResult result, Attributes attributes) throws NamingException {
        Attribute attr = attributes.get("msDS-KeyVersionNumber");
        if (attr != null) {
            result.setLdapKeyVersionNumber(Integer.parseInt((String)attr.get()));
        } else {
            result.addUnreadableAttribute("msDS-KeyVersionNumber");
        }
    }

    private void inspectUserAccountControl(LdapTestResult result, Attributes attributes) throws NamingException {
        Attribute attr = attributes.get("userAccountControl");
        if (attr != null) {
            int userAccountControl = Integer.parseInt((String)attr.get());
            result.setAccountDisabled((userAccountControl & 2) != 0);
            result.setAccountPasswordNeverExpires((userAccountControl & 0x10000) != 0);
            result.setAccountPasswordHasExpired((userAccountControl & 0x800000) != 0);
            result.setAccountDesOnly((userAccountControl & 0x200000) != 0);
        } else {
            result.addUnreadableAttribute("userAccountControl");
        }
    }
}

