/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.jetbrains.annotations.NotNull;

public class BambooFixBuggyPSH
implements Filter {
    private final boolean isBamboo;

    @Inject
    public BambooFixBuggyPSH(@ComponentImport ApplicationProperties applicationProperties) {
        this.isBamboo = "Bamboo".equals(applicationProperties.getDisplayName());
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        if (!this.isBamboo) {
            chain.doFilter(request, response);
            return;
        }
        String r = req.getRequestURI().substring(req.getContextPath().length());
        if (!r.contains("/contextbatch/js/") || !r.endsWith("-_super/batch.js")) {
            chain.doFilter(request, response);
            return;
        }
        chain.doFilter(request, (ServletResponse)new HttpServletResponseWrapper(resp){
            public ServletOutputStream out;

            public ServletOutputStream getOutputStream() throws IOException {
                if (this.out == null) {
                    this.out = new FixingOutputStream(super.getOutputStream());
                }
                return this.out;
            }
        });
    }

    public void destroy() {
    }

    private class FixingOutputStream
    extends ServletOutputStream {
        private final byte[] match;
        private final ServletOutputStream out;

        public FixingOutputStream(ServletOutputStream out) {
            this.out = out;
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            try {
                bout.write("var".getBytes(StandardCharsets.US_ASCII));
            }
            catch (IOException e) {
                throw new RuntimeException();
            }
            bout.write(194);
            bout.write(160);
            this.match = bout.toByteArray();
        }

        public void print(String s) throws IOException {
            this.out.print(s);
        }

        public void print(boolean b) throws IOException {
            this.out.print(b);
        }

        public void print(char c) throws IOException {
            this.out.print(c);
        }

        public void print(int i) throws IOException {
            this.out.print(i);
        }

        public void print(long l) throws IOException {
            this.out.print(l);
        }

        public void print(float f) throws IOException {
            this.out.print(f);
        }

        public void print(double d) throws IOException {
            this.out.print(d);
        }

        public void println() throws IOException {
            this.out.println();
        }

        public void println(String s) throws IOException {
            this.out.println(s);
        }

        public void println(boolean b) throws IOException {
            this.out.println(b);
        }

        public void println(char c) throws IOException {
            this.out.println(c);
        }

        public void println(int i) throws IOException {
            this.out.println(i);
        }

        public void println(long l) throws IOException {
            this.out.println(l);
        }

        public void println(float f) throws IOException {
            this.out.println(f);
        }

        public void println(double d) throws IOException {
            this.out.println(d);
        }

        public boolean isReady() {
            return this.out.isReady();
        }

        public void setWriteListener(WriteListener writeListener) {
            this.out.setWriteListener(writeListener);
        }

        public void write(int b) throws IOException {
            this.out.write(b);
        }

        public void write(@NotNull byte[] b) throws IOException {
            this.out.write(b);
        }

        public void write(@NotNull byte[] b, int off, int len) throws IOException {
            this.replace(b, off, len);
            this.out.write(b, off, len);
        }

        private void replace(byte[] b, int off, int len) {
            for (int i = off; i < off + len - this.match.length; ++i) {
                if (!this.findMatch(b, i)) continue;
                b[i + 3] = 32;
                b[i + 4] = 32;
            }
        }

        private boolean findMatch(byte[] b, int f) {
            for (int i = 0; i < this.match.length; ++i) {
                if (this.match[i] == b[i + f]) continue;
                return false;
            }
            return true;
        }

        public void flush() throws IOException {
            this.out.flush();
        }

        public void close() throws IOException {
            this.out.close();
        }
    }
}

