/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import io.vavr.API;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.Function0;
import io.vavr.collection.Array;
import io.vavr.collection.HashMap;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.UsernameSearchResult;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.login.RedirectProperties;
import org.kantega.atlaskerb.userlookup.UserLookupService;
import org.kantega.atlaskerb.utils.ErrorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoverIdpHelper {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final HostApp hostApp;
    private final UserLookupService userLookupService;
    private final IdpConfManager idpConfManager;
    private final boolean isJsmLogin;

    public DiscoverIdpHelper(HostApp hostApp, UserLookupService userLookupService, IdpConfManager idpConfManager, boolean isJsmLogin) {
        this.hostApp = hostApp;
        this.userLookupService = userLookupService;
        this.idpConfManager = idpConfManager;
        this.isJsmLogin = isJsmLogin;
    }

    RedirectProperties getRedirectProperties(IdpConfiguration idpConfiguration) {
        API.Match.Case[] caseArray = new API.Match.Case[2];
        caseArray[0] = API.Case((API.Match.Pattern0)API.$((Object)true), idpConfiguration::getJsmRedirectProperties);
        caseArray[1] = API.Case((API.Match.Pattern0)API.$((Object)false), idpConfiguration::getRedirectProperties);
        return (RedirectProperties)API.Match((Object)this.isJsmLogin).of(caseArray);
    }

    IdpConfiguration.RedirectPolicy getRedirectPolicy(IdpConfiguration idpConfiguration) {
        return this.getRedirectProperties(idpConfiguration).getRedirectPolicy();
    }

    List<IdpConfiguration> discoverIdpProviders(String username) {
        return Array.ofAll(this.idpConfManager.getIdentityProviders()).filter(IdpConfiguration::isEnabled).filter(configuration -> this.isMatchingKnownDomain(username, (IdpConfiguration)configuration) || this.isMatchingUserDirectory(username, (IdpConfiguration)configuration) || this.isMatchingUserGroup(username, (IdpConfiguration)configuration)).flatMap(configuration -> HashMap.of((Object)configuration.getId(), (Object)configuration).values()).asJava();
    }

    boolean isMatchingKnownDomain(String maybeUsername, IdpConfiguration configuration) {
        return (Boolean)Option.of((Object)maybeUsername).filter(_username -> this.getRedirectPolicy(configuration) == IdpConfiguration.RedirectPolicy.KNOWN_DOMAIN).map(username -> username.contains("@") ? username.substring(username.indexOf("@") + 1).toLowerCase() : null).map(domain -> this.isMatchingDomain((String)domain, configuration)).getOrElse((Object)false);
    }

    boolean isMatchingUserDirectory(String maybeUsername, IdpConfiguration configuration) {
        RedirectProperties redirectProperties = this.getRedirectProperties(configuration);
        return (Boolean)Option.of((Object)maybeUsername).filter(_username -> redirectProperties.getRedirectPolicy() == IdpConfiguration.RedirectPolicy.USER_DIRECTORY).map(this.hostApp::getDirectoryForUser).filter(Objects::nonNull).map(directoryForUser -> redirectProperties.getMatchedUserDirectoryIds().contains(directoryForUser.getId())).getOrElse((Object)false);
    }

    boolean isMatchingUserGroup(String maybeUsername, IdpConfiguration configuration) {
        RedirectProperties redirectProperties = this.getRedirectProperties(configuration);
        UsernameSearchResult usernameSearchResult = (UsernameSearchResult)Option.of((Object)maybeUsername).filter(_username -> redirectProperties.getRedirectPolicy() == IdpConfiguration.RedirectPolicy.USER_GROUP).flatMap(username -> this.getUsernameSearchResult((String)username, configuration)).filter(result -> Objects.nonNull(result.getDirectory())).getOrElse((Object)UsernameSearchResult.notFound(null));
        return redirectProperties.getInvertUserGroupMatch() != ((Boolean)((Function0)API.Match((Object)usernameSearchResult).of(new API.Match.Case[]{API.Case((API.Match.Pattern0)API.$(UsernameSearchResult::isResolved), usr -> API.Function((Function0 & Serializable)() -> (Boolean)Try.of((CheckedFunction0 & Serializable)() -> usr).mapTry((CheckedFunction1 & Serializable)result -> this.hostApp.getDirectoryManager().searchNestedGroupRelationships(result.getDirectory().getId().longValue(), this.getMembershipQuery(result.getUserProfile().getUsername()))).mapTry((CheckedFunction1 & Serializable)userCurrentGroups -> this.isUserMemberOfAtLeastOneGroup((List<String>)userCurrentGroups, redirectProperties.getRedirectGroups())).onFailure(e -> this.log.error(ErrorUtils.createErrorMessage("KSSO-9J6JGVLKLD", "Unable to resolve user group memberships while redirecting user to IDP during login."), e)).getOrElse((Object)false))), API.Case((API.Match.Pattern0)API.$(), usr -> API.Function((Function0 & Serializable)() -> false))})).apply()).booleanValue();
    }

    private boolean isUserMemberOfAtLeastOneGroup(List<String> userCurrentGroups, Set<String> groups) {
        return Array.ofAll(userCurrentGroups).distinct().filter(Objects::nonNull).filter(groups::contains).nonEmpty();
    }

    private boolean isMatchingDomain(String domain, IdpConfiguration configuration) {
        return (Boolean)Option.of((Object)domain).filter(_domain -> configuration.isEnabled()).filter(_domain -> this.getRedirectPolicy(configuration) != IdpConfiguration.RedirectPolicy.NONE).filter(Objects::nonNull).map(_domain -> configuration.getKnownDomains().contains(_domain)).getOrElse((Object)false);
    }

    @NotNull
    private Option<UsernameSearchResult> getUsernameSearchResult(String username, IdpConfiguration configuration) {
        return Option.ofOptional(this.userLookupService.searchUserAccount(username, configuration.getUserNotFoundPolicy(), configuration.getUserLookupAttribute(), false).stream().filter(r -> r.getResolvedUserPrincipalEntry() != null).findFirst());
    }

    private MembershipQuery<String> getMembershipQuery(String username) {
        return QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(username).startingAt(0).returningAtMost(-1);
    }

    List<IdpConfiguration> getVisibleProviders() {
        ArrayList<IdpConfiguration> matches = new ArrayList<IdpConfiguration>();
        for (IdpConfiguration configuration : this.idpConfManager.getIdentityProviders()) {
            boolean idpVisible;
            boolean bl = idpVisible = this.isJsmLogin ? configuration.getJsmRedirectProperties().isVisible() : configuration.getRedirectProperties().isVisible();
            if (!configuration.isEnabled() || !idpVisible) continue;
            matches.add(configuration);
        }
        return matches;
    }
}

