/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.kerberos.servlet;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;

public class ConfigureRestAction
extends RequireAdminServlet {
    private final KerbConfManager kerbConfManager;
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;

    @Inject
    public ConfigureRestAction(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.kerbConfManager = bucket.getKerbConfManager();
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        model.put("restEnabled", this.kerbConfManager.isKerberosRestAuthEnabled());
        String actualUrl = this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE);
        model.put("actualBaseUrl", actualUrl);
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("excludedPaths", StringUtils.join(this.kerbConfManager.getRestExcludedPaths(), (String)"\n"));
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/restapi.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean restAuthEnabled = StringUtils.equalsIgnoreCase((CharSequence)"on", (CharSequence)req.getParameter("rest_auth"));
        String excludedPathsStr = req.getParameter("excludedPaths");
        LinkedHashSet<String> paths = new LinkedHashSet<String>();
        if (excludedPathsStr != null && !excludedPathsStr.isEmpty()) {
            String[] lines = excludedPathsStr.split("\\r?\\n");
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i].trim().replace(",", "");
                if (StringUtils.isBlank((CharSequence)line)) continue;
                paths.add(line);
            }
        }
        this.kerbConfManager.setRestExcludedPaths(paths);
        this.kerbConfManager.setKerberosRestAuthEnabled(restAuthEnabled);
        resp.sendRedirect("restapi");
    }
}

