/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.hostapp;

import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusPreservableHeaderAwareResponse
extends HttpServletResponseWrapper {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final boolean preserveStatus;

    public StatusPreservableHeaderAwareResponse(HttpServletResponse resp, boolean preserveStatus) {
        super(resp);
        this.preserveStatus = preserveStatus;
    }

    public StatusPreservableHeaderAwareResponse(HttpServletResponse resp) {
        super(resp);
        this.preserveStatus = true;
    }

    public void setStatus(int sc, String sm) {
        if (!this.preserveStatus) {
            super.setStatus(sc, sm);
        }
    }

    public void addHeader(String name, String value) {
        if ("WWW-Authenticate".equalsIgnoreCase(name) && this.getHeader("WWW-Authenticate") != null) {
            this.log.debug("resp.addHeader('{}', '{}') dropped: Negotiate already requested (Kerberos for REST).", (Object)name, (Object)value);
        } else {
            super.addHeader(name, value);
        }
    }

    public void setStatus(int sc) {
        if (!this.preserveStatus) {
            super.setStatus(sc);
        }
    }

    public void sendError(int sc, String msg) throws IOException {
        if (!this.preserveStatus) {
            super.sendError(sc, msg);
        }
    }

    public void sendError(int sc) throws IOException {
        if (!this.preserveStatus) {
            super.sendError(sc);
        }
    }
}

