/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.connector.keycloak;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.kantega.atlaskerb.MultipartHttpRequest;
import org.kantega.atlaskerb.connector.ConnectorType;
import org.kantega.atlaskerb.connector.api.ConnectorAPI;
import org.kantega.atlaskerb.connector.keycloak.KeycloakApi;
import org.kantega.atlaskerb.connector.keycloak.KeycloakDirectory;
import org.kantega.atlaskerb.connector.model.Directory;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.w3c.dom.Element;

public class KeycloakConnectorType
implements ConnectorType {
    @Override
    public ConnectorAPI getConnectorApi(Directory directory) {
        KeycloakDirectory k = (KeycloakDirectory)directory;
        return new KeycloakApi(k.getRealm(), k.getClientId(), k.getClientSecret(), k.getUsername(), k.getPassword(), k.getUriSchemeBuilder());
    }

    @Override
    public String getKey() {
        return "KEYCLOAK";
    }

    @Override
    public String getDisplayName() {
        return "Keycloak";
    }

    @Override
    public String getEditDirectoryTemplate() {
        return "keycloak/edit-connector.vm";
    }

    @Override
    public Directory processEditDirectoryPost(MultipartHttpRequest multipartRequest, Map<String, Object> model, Directory existingConnector, Directory.Common common) {
        String realm = multipartRequest.getParameter("realm").trim();
        String clientId = multipartRequest.getParameter("client_id").trim();
        String clientSecret = multipartRequest.getParameter("client_secret").trim();
        String username = multipartRequest.getParameter("kc_username").trim();
        String password = multipartRequest.getParameter("kc_password").trim();
        String uriScheme = multipartRequest.getParameter("uri_scheme").trim();
        return new KeycloakDirectory(common, realm, clientId, clientSecret, username, password, uriScheme);
    }

    @Override
    public void persist(Directory directory, Element document) {
        KeycloakDirectory dir = (KeycloakDirectory)directory;
        document.setAttribute("realm", dir.getRealm());
        document.setAttribute("client_id", dir.getClientId());
        document.setAttribute("client_secret", dir.getClientSecret());
        document.setAttribute("kc_username", dir.getUsername());
        document.setAttribute("kc_password", dir.getPassword());
        document.setAttribute("uri_scheme", dir.getUriScheme());
    }

    @Override
    public Directory parse(Element element, Directory.Common common) {
        return new KeycloakDirectory(common, element.getAttribute("realm"), element.getAttribute("client_id"), element.getAttribute("client_secret"), element.getAttribute("kc_username"), element.getAttribute("kc_password"), element.getAttribute("uri_scheme"));
    }

    @Override
    public void editDirectory(HttpServletRequest req, Directory directory, Map<String, Object> model) {
        if (directory != null) {
            KeycloakDirectory dir = (KeycloakDirectory)directory;
            model.put("clientId", dir.getClientId());
            model.put("clientSecret", dir.getClientSecret());
            model.put("realm", dir.getRealm());
            model.put("username", dir.getUsername());
            model.put("password", dir.getPassword());
            model.put("uriScheme", dir.getUriScheme());
        }
    }

    @Override
    public IdpConfiguration.Kind getIdentityProviderKind() {
        return IdpConfiguration.Kind.KEYCLOAK;
    }
}

