/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.kerberos.servlet;

import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;

public class ConfigureScmUrlsAction
extends RequireAdminServlet {
    private final KerbConfManager kerbConfManager;
    private final TemplateRenderer renderer;

    @Inject
    public ConfigureScmUrlsAction(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.kerbConfManager = bucket.getKerbConfManager();
        this.renderer = bucket.getTemplateRenderer();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.setContentType("text/html");
        Map<String, Object> model = this.newModel(req);
        model.put("bitbucketScmUrlsEnabled", this.kerbConfManager.isBitbucketScmUrlsEnabled());
        model.put("bitbucketScmUrlsUsed", this.kerbConfManager.isBitbucketScmUrlsUsed());
        model.put("bitbucketKerberosScmUrlsEnabled", this.kerbConfManager.isBitbucketKerberosScmUrlsEnabled());
        model.put("bitbucketKerberosScmUrlsDefault", this.kerbConfManager.isBitbucketKerberosScmUrlsDefault());
        this.renderer.render("templates/atlaskerb/bitbucketscm.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (req.getParameter("scm") == null) {
            this.kerbConfManager.setBitbucketScmUrlsEnabled(false);
        } else if ("on".equals(req.getParameter("scm"))) {
            this.kerbConfManager.setBitbucketScmUrlsEnabled(true);
        }
        if (req.getParameter("kerberosScm") != null) {
            boolean enabled = req.getParameter("kerberosScmEnabled") != null;
            this.kerbConfManager.setBitbucketKerberosScmUrlsEnabled(enabled);
            this.kerbConfManager.setBitbucketKerberosScmUrlsDefault(enabled && req.getParameter("kerberosScmDefault") != null);
        }
        resp.sendRedirect("bitbucketscm");
    }
}

