/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.connector.azure;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.kantega.atlaskerb.MultipartHttpRequest;
import org.kantega.atlaskerb.connector.ConnectorType;
import org.kantega.atlaskerb.connector.api.ConnectorAPI;
import org.kantega.atlaskerb.connector.api.ConnectorApiException;
import org.kantega.atlaskerb.connector.azure.AzureDirectory;
import org.kantega.atlaskerb.connector.azure.AzureGraphApi;
import org.kantega.atlaskerb.connector.model.Directory;
import org.kantega.atlaskerb.connector.model.SecurityGroupFilter;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.w3c.dom.Element;

public class AzureAdConnectorType
implements ConnectorType {
    private static final String TENANT_ID = "tenantId";
    private static final String APPLICATION_ID = "applicationId";
    private static final String APPLICATION_SECRET = "applicationSecret";
    private static final String USE_SAMACCOUNT_NAME = "useSAMAccountName";

    @Override
    public ConnectorAPI getConnectorApi(Directory directory) {
        AzureDirectory adir = (AzureDirectory)directory;
        return new AzureGraphApi(adir.getTenantId(), adir.getApplicationId(), adir.getApplicationSecret(), adir.isUseSAMAccountName(), directory.getSecurityGroupFilter());
    }

    @Override
    public String getKey() {
        return "AZURE_AD";
    }

    @Override
    public String getEditDirectoryTemplate() {
        return "azure/edit-connector.vm";
    }

    @Override
    public Directory processEditDirectoryPost(MultipartHttpRequest multipartRequest, Map<String, Object> model, Directory existingConnector, Directory.Common common) {
        String newAppSecret;
        model.put("redirectUrl", this.getRedirectUrl((HttpServletRequest)multipartRequest));
        String tenantId = multipartRequest.getParameter(TENANT_ID).trim();
        String applicationId = multipartRequest.getParameter(APPLICATION_ID).trim();
        String applicationSecret = null;
        if (existingConnector != null) {
            AzureDirectory dir = (AzureDirectory)existingConnector;
            applicationSecret = dir.getApplicationSecret();
            model.put("applicationSecretDefined", true);
        }
        if ((newAppSecret = multipartRequest.getParameter(APPLICATION_SECRET)) != null) {
            newAppSecret = newAppSecret.trim();
        }
        if (newAppSecret != null && !newAppSecret.isEmpty()) {
            applicationSecret = newAppSecret;
            model.put("suppliedSecret", newAppSecret);
            model.put("applicationSecretDefined", false);
        }
        HashSet<String> missingFields = new HashSet<String>();
        model.put("missingFields", missingFields);
        if (tenantId.isEmpty()) {
            missingFields.add(TENANT_ID);
        }
        if (applicationId.isEmpty()) {
            missingFields.add(APPLICATION_ID);
        }
        if (applicationSecret == null || applicationSecret.isEmpty()) {
            missingFields.add(APPLICATION_SECRET);
        }
        model.put(TENANT_ID, tenantId);
        model.put(APPLICATION_ID, applicationId);
        model.put("requiredFields", true);
        if (!missingFields.isEmpty()) {
            return null;
        }
        try {
            AzureGraphApi connectorAPI = new AzureGraphApi(tenantId, applicationId, applicationSecret, false, existingConnector == null ? SecurityGroupFilter.SECURITY_GROUPS_ONLY : existingConnector.getSecurityGroupFilter());
            connectorAPI.findAllGroups(item -> {});
            return new AzureDirectory(common, tenantId, applicationId, applicationSecret);
        }
        catch (ConnectorApiException e) {
            model.put(TENANT_ID, tenantId);
            model.put(APPLICATION_ID, applicationId);
            model.put("jsonException", e);
            return null;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getDisplayName() {
        return "Azure AD";
    }

    @Override
    public void persist(Directory directory, Element element) {
        AzureDirectory dir = (AzureDirectory)directory;
        element.setAttribute(TENANT_ID, dir.getTenantId());
        element.setAttribute(APPLICATION_ID, dir.getApplicationId());
        element.setAttribute(APPLICATION_SECRET, dir.getApplicationSecret());
        element.setAttribute(USE_SAMACCOUNT_NAME, String.valueOf(dir.isUseSAMAccountName()));
    }

    @Override
    public IdpConfiguration.Kind getIdentityProviderKind() {
        return IdpConfiguration.Kind.AZURE_AD;
    }

    @Override
    public void editDirectory(HttpServletRequest request, Directory directory, Map<String, Object> model) {
        model.put("redirectUrl", this.getRedirectUrl(request));
        if (directory != null) {
            AzureDirectory dir = (AzureDirectory)directory;
            model.put(TENANT_ID, dir.getTenantId());
            model.put(APPLICATION_ID, dir.getApplicationId());
            model.put("applicationSecretDefined", dir.getApplicationSecret() != null);
        }
    }

    private String getRedirectUrl(HttpServletRequest req) {
        try {
            URI uri = new URI(req.getRequestURL().toString());
            URI serviceUri = new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), req.getContextPath() + "/kantegasso/azac", null, null);
            return serviceUri.toString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Directory parse(Element element, Directory.Common common) {
        return new AzureDirectory(common, element.getAttribute(TENANT_ID), element.getAttribute(APPLICATION_ID), element.getAttribute(APPLICATION_SECRET), Boolean.parseBoolean(element.getAttribute(USE_SAMACCOUNT_NAME)));
    }
}

