/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.connector.admin;

import com.atlassian.crowd.directory.RemoteCrowdDirectory;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.DirectorySynchronisationInformation;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.ImmutableDirectory;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.group.InternalDirectoryGroup;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.UserQuery;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kantega.atlaskerb.DateTool;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.apiserver.ApiServer;
import org.kantega.atlaskerb.apiserver.ApiServerConfManager;
import org.kantega.atlaskerb.apiserver.ApiServerConfigState;
import org.kantega.atlaskerb.connector.ConnectorConfManager;
import org.kantega.atlaskerb.connector.ConnectorType;
import org.kantega.atlaskerb.connector.admin.CrowdDirectoryFinder;
import org.kantega.atlaskerb.connector.model.Directory;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.saml.IdpConfManager;

public class ShowConnectorAction
extends RequireAdminServlet {
    private final TransactionTemplate transactionTemplate;
    private final ApplicationProperties applicationProperties;
    private final ConnectorConfManager connectorConfManager;
    private final TemplateRenderer renderer;
    private final CrowdDirectoryFinder directoryFinder;
    private final ApiServerConfManager apiServerConfManager;
    private final HostApp hostApp;
    private final ApiServer apiServer;
    private final IdpConfManager idpConfManager;

    @Inject
    public ShowConnectorAction(RequireAdminServletDependencyBucket bucket, @ComponentImport TransactionTemplate transactionTemplate, ApiServerConfManager apiServerConfManager, ApiServer apiServer) {
        super(bucket);
        this.applicationProperties = bucket.getApplicationProperties();
        this.connectorConfManager = bucket.getConnectorConfManager();
        this.renderer = bucket.getTemplateRenderer();
        this.hostApp = bucket.getHostAppFactory().getInstance();
        this.idpConfManager = bucket.getIdpConfManager();
        this.transactionTemplate = transactionTemplate;
        this.directoryFinder = new CrowdDirectoryFinder(this.hostApp);
        this.apiServer = apiServer;
        this.apiServerConfManager = apiServerConfManager;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Directory dir = this.connectorConfManager.getDirectory(this.getId(req));
        if (dir == null) {
            resp.sendError(404);
        } else {
            Map<String, Object> model = this.newModel(req);
            model.put("isSyncDirCompatible", this.hostApp.isSyncDirCompatible());
            com.atlassian.crowd.embedded.api.Directory cd = this.directoryFinder.findDirectory(dir.getId());
            if (cd != null) {
                model.put("dirId", cd.getId());
                model.put("dirName", cd.getName());
            }
            this.renderPage(resp, dir, model);
        }
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Directory dir = this.connectorConfManager.getDirectory(this.getId(req));
        if (dir == null) {
            resp.sendError(404);
        } else {
            String port;
            String address;
            Exception e;
            if (req.getParameter("autoAdd") != null && this.directoryFinder.findDirectory(dir.getId()) == null) {
                this.addCrowdDirectory(dir, req.getParameter("permission_mode"), req.getParameter("synchronizeUsersNow") != null, req.getParameter("defaultGroups"), req.getParameter("useNestedGroups") != null);
            } else if (req.getParameter("syncNow") != null) {
                this.setEnabledState(dir, true);
                this.synchronizeDirectory(dir);
            } else if (req.getParameter("enableCrowdDir") != null) {
                this.setEnabledState(dir, true);
            } else if (req.getParameter("startServer") != null && (e = this.apiServer.configChanged(this.apiServerConfManager.setApiServerConfig(true, address = req.getParameter("crowdApiAddress"), Integer.parseInt(port = req.getParameter("crowdApiPort"))))) != null) {
                Map<String, Object> model = this.newModel(req);
                model.put("isSyncDirCompatible", this.hostApp.isSyncDirCompatible());
                com.atlassian.crowd.embedded.api.Directory cd = this.directoryFinder.findDirectory(dir.getId());
                model.put("dirId", cd.getId());
                model.put("dirName", cd.getName());
                model.put("startException", e);
                this.renderPage(resp, dir, model);
                return;
            }
            resp.sendRedirect(dir.getId());
        }
    }

    private void addCrowdDirectory(Directory dir, String permissionMode, boolean synchronizeUsersNow, String defaultGroups, boolean useNestedGroups) {
        final CrowdDirectoryService directoryService = this.hostApp.getCrowdDirectoryService();
        final ImmutableDirectory.Builder builder = ImmutableDirectory.newBuilder();
        Date now = new Date();
        builder.setCreatedDate(now);
        builder.setUpdatedDate(now);
        HashMap<String, String> attributes = new HashMap<String, String>();
        if ("READ_ONLY_LOCAL_GROUPS".equals(permissionMode)) {
            builder.setAllowedOperations(EnumSet.of(OperationType.UPDATE_GROUP, OperationType.CREATE_GROUP, OperationType.DELETE_GROUP, OperationType.UPDATE_GROUP_ATTRIBUTE, OperationType.UPDATE_USER_ATTRIBUTE));
            attributes.put("ldap.local.groups", "true");
        } else {
            builder.setAllowedOperations(new HashSet<OperationType>(Arrays.asList(OperationType.UPDATE_GROUP_ATTRIBUTE, OperationType.UPDATE_USER_ATTRIBUTE)));
        }
        builder.setActive(false);
        builder.setId(Long.valueOf(0L));
        builder.setImplementationClass(RemoteCrowdDirectory.class.getName());
        builder.setName(this.getDirectorySafeName(dir));
        builder.setType(DirectoryType.CROWD);
        attributes.put("application.name", dir.getId());
        attributes.put("application.password", dir.getPassword());
        attributes.put("crowd.server.url", this.apiServerConfManager.getCrowdServerUrl());
        attributes.put("crowd.sync.incremental.enabled", "false");
        attributes.put("crowd.sync.group.membership.after.successful.user.auth.enabled", "false");
        attributes.put("useNestedGroups", String.valueOf(useNestedGroups));
        attributes.put("directory.cache.synchronise.interval", "3600");
        builder.setAttributes(attributes);
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<com.atlassian.crowd.embedded.api.Directory>(){

            public com.atlassian.crowd.embedded.api.Directory doInTransaction() {
                return directoryService.addDirectory(builder.toDirectory());
            }
        });
        if (synchronizeUsersNow) {
            this.setEnabledState(dir, true);
            this.synchronizeDirectory(dir);
        }
    }

    private String getDirectorySafeName(Directory dir) {
        String baseName;
        HashSet<String> existingNames = new HashSet<String>();
        for (com.atlassian.crowd.embedded.api.Directory directory : this.hostApp.getCrowdDirectoryService().findAllDirectories()) {
            existingNames.add(directory.getName());
        }
        String name = baseName = this.connectorConfManager.getConnectorTypes().get(dir.getKind()).getDisplayName() + ": " + dir.getDisplayName();
        int i = 1;
        while (existingNames.contains(name)) {
            name = baseName + " (" + i + ")";
            ++i;
        }
        return name;
    }

    private void synchronizeDirectory(Directory dir) {
        com.atlassian.crowd.embedded.api.Directory cd = this.directoryFinder.findDirectory(dir.getId());
        boolean active = cd.isActive();
        try {
            if (!active) {
                this.setEnabledState(dir, true);
            }
            DirectorySynchronisationInformation origSyncInfo = this.hostApp.getCrowdDirectoryService().getDirectorySynchronisationInformation(cd.getId().longValue());
            this.hostApp.getCrowdDirectoryService().synchroniseDirectory(cd.getId().longValue());
            this.detectJobStarted(cd, origSyncInfo);
        }
        catch (InterruptedException origSyncInfo) {
        }
        catch (DirectoryInstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (DirectoryNotFoundException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (!active) {
                this.setEnabledState(dir, false);
            }
        }
    }

    private void detectJobStarted(com.atlassian.crowd.embedded.api.Directory cd, DirectorySynchronisationInformation origSyncInfo) throws InterruptedException, DirectoryInstantiationException, DirectoryNotFoundException {
        DirectorySynchronisationInformation syncInfo = null;
        for (int i = 0; i < 60; ++i) {
            Thread.sleep(100L);
            syncInfo = this.hostApp.getDirectoryManager().getDirectorySynchronisationInformation(cd.getId().longValue());
            if (!this.hasChanged(origSyncInfo, syncInfo)) continue;
            return;
        }
    }

    private boolean hasChanged(DirectorySynchronisationInformation origSyncInfo, DirectorySynchronisationInformation syncInfo) {
        if (origSyncInfo.isSynchronising() != syncInfo.isSynchronising()) {
            return true;
        }
        if (origSyncInfo.getLastRound() != null && syncInfo.getLastRound() != null) {
            return origSyncInfo.getLastRound().getStartTime() != syncInfo.getLastRound().getStartTime();
        }
        return origSyncInfo.getLastRound() != null || syncInfo.getLastRound() != null;
    }

    private void setEnabledState(final Directory dir, final boolean active) {
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<com.atlassian.crowd.embedded.api.Directory>(){

            public com.atlassian.crowd.embedded.api.Directory doInTransaction() {
                com.atlassian.crowd.embedded.api.Directory cd = ShowConnectorAction.this.directoryFinder.findDirectory(dir.getId());
                ImmutableDirectory.Builder builder = ImmutableDirectory.newBuilder((com.atlassian.crowd.embedded.api.Directory)cd);
                builder.setActive(active);
                com.atlassian.crowd.embedded.api.Directory updatedDirectory = builder.toDirectory();
                return ShowConnectorAction.this.hostApp.getCrowdDirectoryService().updateDirectory(updatedDirectory);
            }
        });
    }

    private String getId(HttpServletRequest req) {
        String p = req.getPathInfo();
        return p.substring(p.lastIndexOf("/") + 1);
    }

    private void renderPage(HttpServletResponse resp, Directory dir, Map<String, Object> model) throws IOException {
        model.put("dateTool", new DateTool());
        model.put("dir", dir);
        model.put("serverURL", this.apiServerConfManager.getCrowdServerUrl());
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("crowdApiServerRunning", this.apiServer.isRunning());
        ApiServerConfigState apiServerConfig = this.apiServerConfManager.getConfig();
        model.put("crowdApiServerEnabled", apiServerConfig.isEnabled());
        model.put("crowdApiAddress", apiServerConfig.getAddress());
        model.put("crowdApiPort", apiServerConfig.getPort());
        ConnectorType connectorType = this.connectorConfManager.getConnectorTypes().get(dir.getKind());
        model.put("connectorType", connectorType);
        model.put("kind", dir.getKind());
        model.put("groupSelectionMode", (Object)dir.getUserMembershipFilter().getMode());
        model.put("userTypeSelectionMode", dir.getUserTypeSelectionFilter().getMode().name());
        model.put("topMenu", "connectors");
        model.put("menuItem", "showConnector");
        model.put("currentConnector", dir);
        List<IdpConfiguration> providersOfKind = this.idpConfManager.getProvidersByKind(connectorType.getIdentityProviderKind());
        model.put("providersOfKind", providersOfKind);
        new CrowdHelper().renderPage(dir, model, this.directoryFinder, this.hostApp);
        resp.setContentType("text/html");
        resp.setCharacterEncoding(StandardCharsets.UTF_8.name());
        this.renderer.render("templates/atlaskerb/connector/show-connector.vm", model, (Writer)resp.getWriter());
    }

    static class CrowdHelper {
        CrowdHelper() {
        }

        public void renderPage(Directory dir, Map<String, Object> model, CrowdDirectoryFinder directoryFinder, HostApp hostApp) {
            com.atlassian.crowd.embedded.api.Directory cd = directoryFinder.findDirectory(dir.getId());
            DirectoryManager directoryManager = hostApp.getDirectoryManager();
            if (cd != null) {
                model.put("crowdDirectory", cd);
                try {
                    int maxResults = 4;
                    List users = directoryManager.searchUsers(cd.getId().longValue(), (EntityQuery)new UserQuery(User.class, (SearchRestriction)NullRestrictionImpl.INSTANCE, 0, maxResults));
                    model.put("directoryUsers", users);
                    model.put("maxUsers", maxResults == users.size());
                    model.put("lastUserIndex", users.size());
                    EntityQuery groupQuery = QueryBuilder.queryFor(InternalDirectoryGroup.class, (EntityDescriptor)EntityDescriptor.group()).returningAtMost(maxResults);
                    List groups = directoryManager.searchGroups(cd.getId().longValue(), groupQuery);
                    model.put("directoryGroups", groups);
                    model.put("maxGroups", maxResults == groups.size());
                    model.put("lastGroupIndex", groups.size());
                    model.put("dirsync", directoryManager.getDirectorySynchronisationInformation(cd.getId().longValue()));
                }
                catch (DirectoryNotFoundException e) {
                    throw new RuntimeException(e);
                }
                catch (OperationFailedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

