/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.connector.admin;

import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.connector.ConnectorConfManager;
import org.kantega.atlaskerb.connector.admin.CrowdDirectoryFinder;
import org.kantega.atlaskerb.connector.model.Directory;
import org.kantega.atlaskerb.hostapp.HostApp;

public class DirectoryUserAction
extends RequireAdminServlet {
    private final ApplicationProperties applicationProperties;
    private final ConnectorConfManager connectorConfManager;
    private final TemplateRenderer renderer;
    private final HostApp hostApp;

    @Inject
    public DirectoryUserAction(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.applicationProperties = bucket.getApplicationProperties();
        this.connectorConfManager = bucket.getConnectorConfManager();
        this.renderer = bucket.getTemplateRenderer();
        this.hostApp = bucket.getHostAppFactory().getInstance();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        String id = req.getParameter("id");
        Directory dir = this.connectorConfManager.getDirectory(id);
        if (dir == null) {
            resp.sendError(404);
            return;
        }
        model.put("currentConnector", dir);
        model.put("topMenu", "connectors");
        model.put("menuItem", "directoryUsers");
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("connectorType", this.connectorConfManager.getConnectorTypes().get(dir.getKind()));
        String username = req.getParameter("username");
        model.put("username", username);
        this.render(dir, username, resp, model);
    }

    private void render(Directory dir, String username, HttpServletResponse resp, Map<String, Object> model) throws IOException {
        try {
            com.atlassian.crowd.embedded.api.Directory cd = new CrowdDirectoryFinder(this.hostApp).findDirectory(dir.getId());
            DirectoryManager directoryManager = this.hostApp.getDirectoryManager();
            MembershipQuery membershipQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(username).startingAt(0).returningAtMost(-1);
            List groupNames = directoryManager.searchNestedGroupRelationships(cd.getId().longValue(), membershipQuery);
            List userGroups = groupNames.stream().map(groupName -> {
                try {
                    return directoryManager.findGroupByName(cd.getId().longValue(), groupName);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList());
            model.put("groups", userGroups);
            User user = directoryManager.findUserByName(cd.getId().longValue(), username);
            model.put("userAccount", user);
            model.put("isActive", user.isActive());
            resp.setContentType("text/html");
            resp.setCharacterEncoding(StandardCharsets.UTF_8.name());
            this.renderer.render("templates/atlaskerb/connector/user-groups.vm", model, (Writer)resp.getWriter());
        }
        catch (DirectoryNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (OperationFailedException e) {
            throw new RuntimeException(e);
        }
        catch (UserNotFoundException e) {
            resp.sendError(404, "No such user found");
        }
    }
}

