/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml.servlet;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.sal.api.ApplicationProperties;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.IdpConfigurationBuilder;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.SamlXmlParser;
import org.kantega.atlaskerb.saml.login.RedirectProperties;
import org.kantega.atlaskerb.userlookup.UserLookupService;
import org.kantega.atlaskerb.utils.HttpUrlUtils;

public class IdpRedirectRulesServlet
extends RequireAdminServlet {
    private final IdpConfManager idpConfManager;
    private final KerbConfManager kerbConfManager;
    private final ApplicationProperties applicationProperties;
    private final UserLookupService userLookupService;
    private final HostApp hostApp;
    private final Set<String> tabs = new HashSet<String>(Arrays.asList("location", "accounts", "domains", "idpsetup"));

    @Inject
    public IdpRedirectRulesServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.idpConfManager = bucket.getIdpConfManager();
        this.kerbConfManager = bucket.getKerbConfManager();
        this.applicationProperties = bucket.getApplicationProperties();
        this.userLookupService = bucket.getUserLookupService();
        this.hostApp = bucket.getHostAppFactory().getInstance();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.renderPage(req, resp, this.newModel(req));
    }

    private void renderPage(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> model) throws IOException {
        resp.setContentType("text/html");
        String id = IdpConfManager.IdpServletUtil.getId(req);
        model.put("isJsdInstalled", this.kerbConfManager.isJsmInstalled());
        IdpConfiguration configuration = this.idpConfManager.getIdentityProviderById(id);
        model.put("redirectProgressDelay", this.idpConfManager.getRedirectProgressDelay());
        model.put("usernamePasswordLinkEnabled", this.idpConfManager.getUsernamePasswordLinkEnabled());
        model.put("loginEnabledForJSD", this.idpConfManager.isLoginEnabledForJSM());
        model.put("inheritRedirectRulesInJsm", this.idpConfManager.getInheritRedirectRulesInJsm());
        model.put("multipleProviders", this.idpConfManager.getIdentityProviders().size() > 1);
        model.put("redirectProperties", configuration.getRedirectProperties());
        model.put("jsmRedirectProperties", configuration.getJsmRedirectProperties());
        model.put("isShouldForceLogin", this.kerbConfManager.isShouldForceLogin());
        model.put("isRequireLoginEnabled", this.kerbConfManager.isRequireLoginEnabled());
        List<IdpConfiguration.RedirectPolicy> exclusiveRedirectPolicies = Arrays.asList(IdpConfiguration.RedirectPolicy.HARD, IdpConfiguration.RedirectPolicy.ALL);
        Collection idpConfigurations = this.idpConfManager.getIdentityProviders().stream().filter(config -> config.isEnabled()).collect(Collectors.toList());
        List exclusiveConfigurations = idpConfigurations.stream().filter(config -> exclusiveRedirectPolicies.contains((Object)config.getRedirectProperties().getRedirectPolicy())).collect(Collectors.toList());
        List activeNonExclusiveConfigurations = idpConfigurations.stream().filter(config -> {
            if (config.getRedirectProperties().getRedirectPolicy() == IdpConfiguration.RedirectPolicy.NONE) {
                return false;
            }
            return !exclusiveConfigurations.contains(config);
        }).collect(Collectors.toList());
        if (exclusiveConfigurations.size() > 0) {
            model.put("exclusiveConfigurations", exclusiveConfigurations);
            if (exclusiveConfigurations.size() > 1) {
                model.put("warningMultipleExclusiveConfigurations", true);
            }
            if (activeNonExclusiveConfigurations.size() > 0) {
                model.put("warningUnusedActiveConfigurations", true);
                model.put("activeNonExclusiveConfigurations", activeNonExclusiveConfigurations);
            }
        }
        List exclusiveJsmConfigurations = idpConfigurations.stream().filter(config -> exclusiveRedirectPolicies.contains((Object)config.getJsmRedirectProperties().getRedirectPolicy())).collect(Collectors.toList());
        List activeNonExclusiveJsmConfigurations = idpConfigurations.stream().filter(config -> {
            if (config.getJsmRedirectProperties().getRedirectPolicy() == IdpConfiguration.RedirectPolicy.NONE) {
                return false;
            }
            return !exclusiveJsmConfigurations.contains(config);
        }).collect(Collectors.toList());
        if (exclusiveJsmConfigurations.size() > 0) {
            model.put("exclusiveJsmConfigurations", exclusiveJsmConfigurations);
            if (exclusiveJsmConfigurations.size() > 1) {
                model.put("warningMultipleExclusiveJsmConfigurations", true);
            }
            if (activeNonExclusiveJsmConfigurations.size() > 0) {
                model.put("warningUnusedActiveJsmConfigurations", true);
                model.put("activeNonExclusiveJsmConfigurations", activeNonExclusiveJsmConfigurations);
            }
        }
        model.put("topMenu", "SAML");
        model.put("menuItem", "redirect-rules");
        model.put("idp", configuration);
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("knownDomains", configuration.getKnownDomains());
        model.put("multipleDomains", configuration.getKnownDomains().size() > 1);
        model.put("matchedUserDirectoryIds", configuration.getRedirectProperties().getMatchedUserDirectoryIds());
        model.put("jsmMatchedUserDirectoryIds", configuration.getJsmRedirectProperties().getMatchedUserDirectoryIds());
        model.put("userDirectories", this.userLookupService.getActiveUserDirectories());
        model.put("redirectGroups", this.idpConfManager.commaSeparated(configuration.getRedirectProperties().getRedirectGroups()));
        model.put("jsmRedirectGroups", this.idpConfManager.commaSeparated(configuration.getJsmRedirectProperties().getRedirectGroups()));
        model.put("noRedirectParameter", "?noredirect");
        model.put("noRedirectUrl", this.hostApp.getLoginPage() + "?noredirect");
        model.put("noSsoParameter", "?nosso");
        model.put("noSsoUrl", this.hostApp.getLoginPage() + "?nosso");
        this.getTemplateRenderer().render("templates/saml/idp-redirect-rules.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String id = IdpConfManager.IdpServletUtil.getId(req);
        IdpConfiguration configuration = this.idpConfManager.getIdentityProviderById(id);
        IdpConfigurationBuilder<?, ?> builder = IdpConfigurationBuilder.ofGeneric(this.idpConfManager.getIdentityProviderById(id));
        if (!"jsm".equals(HttpUrlUtils.getLastParameter("tab", req))) {
            RedirectProperties redirectProperties = this.getRedirectProperties(req, "redirectPolicy", "visible", "knownAutoRedirect", "sendLoginHint", "directory_", "redirectGroups", "invertRedirectGroups");
            if (this.idpConfManager.getInheritRedirectRulesInJsm()) {
                builder.setJsmRedirectProperties(redirectProperties);
            }
            builder.setRedirectProperties(redirectProperties);
            this.idpConfManager.setUsernamePasswordLinkEnabled(StringUtils.equals((CharSequence)"on", (CharSequence)req.getParameter("usernamePasswordLinkEnabled")));
            this.idpConfManager.setRedirectProgressDelay(req.getParameter("redirectProgressDelay"));
        } else {
            boolean inheritRedirectRulesInJsm = req.getParameter("inheritRedirectRulesInJsm") != null;
            this.idpConfManager.setInheritRedirectRulesInJsm(inheritRedirectRulesInJsm);
            if (inheritRedirectRulesInJsm) {
                builder.setJsmRedirectProperties(configuration.getRedirectProperties());
            } else {
                RedirectProperties jsmRedirectProperties = this.getRedirectProperties(req, "jsmRedirectPolicy", "jsmVisible", "jsmKnownAutoRedirect", "jsmSendLoginHint", "jsmDirectory_", "jsmRedirectGroups", "jsmInvertRedirectGroups");
                builder.setJsmRedirectProperties(jsmRedirectProperties);
            }
            this.idpConfManager.setLoginEnabledForJSD(StringUtils.equals((CharSequence)"on", (CharSequence)req.getParameter("loginEnabledForJSD")));
            if (configuration.getRedirectProperties().getRedirectPolicy() == IdpConfiguration.RedirectPolicy.HARD) {
                this.idpConfManager.setUsernamePasswordLinkEnabled(StringUtils.equals((CharSequence)"on", (CharSequence)req.getParameter("usernamePasswordLinkEnabled")));
                this.idpConfManager.setRedirectProgressDelay(req.getParameter("redirectProgressDelay"));
            }
        }
        this.idpConfManager.updateIdpConfiguration((IdpConfiguration)builder.build());
        StringBuffer queryString = new StringBuffer();
        HttpUrlUtils.buildQueryString(queryString, "backUrl", req);
        HttpUrlUtils.buildQueryString(queryString, "backLinkDescription", req);
        HttpUrlUtils.buildQueryString(queryString, "tab", req);
        resp.sendRedirect("redirect-rules" + queryString);
    }

    @NotNull
    private RedirectProperties getRedirectProperties(HttpServletRequest req, String redirectPolicyParam, String visibleParam, String knownAutoRedirectParam, String sendLoginHintParam, String directoryPrefix, String redirectGroupsParam, String invertRedirectGroupsParam) {
        String redirectPolicyString = req.getParameter(redirectPolicyParam);
        if (redirectPolicyString == null) {
            redirectPolicyString = IdpConfiguration.RedirectPolicy.ALL.name();
        }
        IdpConfiguration.RedirectPolicy redirectPolicy = IdpConfiguration.RedirectPolicy.valueOf(redirectPolicyString);
        boolean visible = req.getParameter(visibleParam) != null;
        boolean knownAutoRedirect = false;
        boolean sendLoginHint = false;
        if (redirectPolicy == IdpConfiguration.RedirectPolicy.KNOWN_DOMAIN || redirectPolicy == IdpConfiguration.RedirectPolicy.USER_DIRECTORY || redirectPolicy == IdpConfiguration.RedirectPolicy.USER_GROUP || redirectPolicy == IdpConfiguration.RedirectPolicy.FALLBACK) {
            knownAutoRedirect = req.getParameter(knownAutoRedirectParam) != null;
            sendLoginHint = req.getParameter(sendLoginHintParam) != null;
        }
        LinkedHashSet<Long> matching = new LinkedHashSet<Long>();
        for (Directory directory : this.userLookupService.getActiveUserDirectories()) {
            if (req.getParameter(directoryPrefix + directory.getId()) == null) continue;
            matching.add(directory.getId());
        }
        String redirectGroupsParamvalue = req.getParameter(redirectGroupsParam);
        LinkedHashSet<String> redirectGroups = SamlXmlParser.parseSet(redirectGroupsParamvalue);
        boolean invertRedirectGroupsParamValue = "true".equals(req.getParameter(invertRedirectGroupsParam));
        return new RedirectProperties(redirectPolicy, redirectGroups, sendLoginHint, knownAutoRedirect, visible, matching, invertRedirectGroupsParamValue);
    }
}

