/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.rest.resource.api.usercleanup;

import com.atlassian.annotations.PublicApi;
import com.atlassian.config.ConfigurationException;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.control.Try;
import java.io.Serializable;
import java.util.UUID;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.joda.time.DateTime;
import org.kantega.atlaskerb.InactiveUserCleaner;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.jsoncreatorclasses.DryRunAttributes;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.jsoncreatorclasses.UserCleanupResult;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.jsoncreatorclasses.UserSummary;
import org.kantega.atlaskerb.rest.util.ResponseUtils;
import org.kantega.atlaskerb.utils.JsonWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="execute")
@PublicApi
public class Execute {
    private static final Logger log = LoggerFactory.getLogger(Execute.class);
    private final UserManager userManager;
    private final HostApp hostApp;
    private final JsonWrapper jsonWrapper;

    @Inject
    public Execute(@ComponentImport UserManager userManager, HostAppFactory hostAppFactory, JsonWrapper jsonWrapper) {
        this.userManager = userManager;
        this.hostApp = hostAppFactory.getInstance();
        this.jsonWrapper = jsonWrapper;
    }

    private Response run(UserProfile userProfile, UserManager userManager, DryRunAttributes dryRunAttributes) throws ConfigurationException {
        if (userManager.isSystemAdmin(userProfile.getUserKey())) {
            if (!dryRunAttributes.isDryRun() && this.hostApp.getUserCleanupExecuteStatus() != InactiveUserCleaner.CleanupStatus.RUNNING) {
                UUID runUUID = UUID.randomUUID();
                DateTime runStartTime = DateTime.now();
                this.hostApp.getInactiveUserCleaner().getWorkers().submit(new CleanupRunnable(runUUID, runStartTime));
                UserCleanupResult result = new UserCleanupResult(runUUID.toString(), runUUID.toString(), runStartTime.toString(), false, false, new UserSummary[0]);
                return (Response)this.jsonWrapper.tryBuildJsonString(result).map(jsonString -> Response.ok((Object)jsonString, (MediaType)MediaType.APPLICATION_JSON_TYPE).build()).onFailure(throwable -> log.error("Failed to build JSON: ", throwable)).getOrElse((Object)Response.serverError().build());
            }
            UserCleanupResult result = this.hostApp.cleanupInactiveUsers(userProfile.getUsername(), dryRunAttributes, DateTime.now(), UUID.randomUUID().toString());
            return (Response)this.jsonWrapper.tryBuildJsonString(result).map(jsonString -> Response.ok((Object)jsonString, (MediaType)MediaType.APPLICATION_JSON_TYPE).build()).onFailure(throwable -> log.error("Failed to build JSON: ", throwable)).getOrElse((Object)Response.serverError().build());
        }
        return ResponseUtils.errorWithMessageInJson(Response.Status.FORBIDDEN, "Missing access privileges");
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response doPost(@Context HttpServletRequest request, DryRunAttributes dryRunAttributes) {
        return ResponseUtils.user(request, this.userManager).wrap((CheckedFunction1<UserProfile, Response>)(CheckedFunction1 & Serializable)userProfile -> (Response)Try.of((CheckedFunction0 & Serializable)() -> this.run((UserProfile)userProfile, this.userManager, dryRunAttributes)).onFailure(e -> log.error("Encountered an exception while atempting to cleanup users. ", e)).getOrElse((Object)Response.serverError().build()));
    }

    class CleanupRunnable
    implements Runnable {
        private final UUID runId;
        private final DateTime runStartTime;

        public CleanupRunnable(UUID runId, DateTime runStartTime) {
            this.runId = runId;
            this.runStartTime = runStartTime;
        }

        @Override
        public void run() {
            try {
                String threadName = Thread.currentThread().getName();
                long threadId = Thread.currentThread().getId();
                log.info(String.format("User cleanup thread starting at %s %s %d %s", this.runStartTime.toString(), threadName, threadId, this.runId));
                Execute.this.hostApp.setUserCleanupExecuteStatus(InactiveUserCleaner.CleanupStatus.RUNNING);
                Execute.this.hostApp.cleanupInactiveUsers(null, new DryRunAttributes(false, false), this.runStartTime, this.runId.toString());
                Execute.this.hostApp.setUserCleanupExecuteStatus(InactiveUserCleaner.CleanupStatus.SUCCESS);
            }
            catch (ConfigurationException e) {
                log.error("User cleanup failed", (Throwable)e);
                Execute.this.hostApp.setUserCleanupExecuteStatus(InactiveUserCleaner.CleanupStatus.FAILED);
            }
        }
    }
}

