/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.connector.keycloak;

import com.atlassian.json.jsonorg.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.utils.URIBuilder;
import org.kantega.atlaskerb.connector.AbstractConnectorHttpClient;
import org.kantega.atlaskerb.connector.ConnectorHttpClient;
import org.kantega.atlaskerb.connector.ConnectorIOUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeycloakHttpClient
extends AbstractConnectorHttpClient {
    private static final Logger log = LoggerFactory.getLogger(KeycloakHttpClient.class);
    private final String realm;
    private final String clientId;
    private final String clientSecret;
    private final URIBuilder uriScheme;
    private final String username;
    private final String password;

    KeycloakHttpClient(String realm, String clientId, String clientSecret, String username, String password, URIBuilder uriScheme) {
        this.realm = realm;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.username = username;
        this.password = password;
        this.uriScheme = uriScheme;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected ConnectorHttpClient.AuthContext createAuthContext() throws InterruptedException {
        try {
            this.uriScheme.setPath("realms/" + URLEncoder.encode(this.realm, StandardCharsets.UTF_8.name()) + "/protocol/openid-connect/token");
            HttpURLConnection con = ConnectorIOUtil.openConnection(this.uriScheme.toString());
            con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            con.setDoOutput(true);
            StringBuilder sb = new StringBuilder().append("client_id=").append(URLEncoder.encode(this.clientId, StandardCharsets.UTF_8.name())).append("&client_secret=").append(URLEncoder.encode(this.clientSecret, StandardCharsets.UTF_8.name())).append("&grant_type=password").append("&username=").append(URLEncoder.encode(this.username, StandardCharsets.UTF_8.name())).append("&password=").append(URLEncoder.encode(this.password, StandardCharsets.UTF_8.name()));
            try (OutputStream outputStream = con.getOutputStream();){
                IOUtils.write((String)sb.toString(), (OutputStream)outputStream, (String)StandardCharsets.UTF_8.name());
            }
            var4_5 = null;
            try (InputStream inputStream = con.getInputStream();){
                JSONObject tokenJson = new JSONObject(ConnectorIOUtil.toString(inputStream, StandardCharsets.UTF_8.name()));
                inputStream.close();
                String accessToken = tokenJson.getString("access_token");
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("Authorization", "Bearer " + accessToken);
                headers.put("Accept", "application/json");
                ConnectorHttpClient.AuthContext authContext = new ConnectorHttpClient.AuthContext(headers);
                return authContext;
            }
            catch (Throwable throwable) {
                var4_5 = throwable;
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void waitForRateLimit(HttpURLConnection conn) throws RuntimeException {
        throw new RuntimeException("Rate limiting not supported for Keycloak connector");
    }
}

