/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.util.SessionIdentificationHelper;
import org.kantega.atlaskerb.security.CookieSecurity;
import org.kantega.samllib.validation.SAMLSessionIdentification;

public class RememberCustomerPortalLogoutFilter
implements Filter {
    private final ApplicationProperties applicationProperties;
    private final IdpConfManager idpConfManager;

    @Inject
    RememberCustomerPortalLogoutFilter(@ComponentImport ApplicationProperties applicationProperties, IdpConfManager idpConfManager) {
        this.applicationProperties = applicationProperties;
        this.idpConfManager = idpConfManager;
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        String cookieValue = "true";
        SAMLSessionIdentification sessionIdentification = null;
        Object oidcSessionIdKey = null;
        IdpConfiguration idpConf = null;
        if (StringUtils.isNotBlank((CharSequence)((String)req.getSession().getAttribute("sessionIdentification"))) && (sessionIdentification = (SAMLSessionIdentification)Optional.ofNullable(req.getSession(false)).flatMap(sess -> Optional.ofNullable((String)sess.getAttribute("sessionIdentification"))).map(SessionIdentificationHelper::fromJson).orElse(null)) != null) {
            idpConf = this.idpConfManager.getIdentityProviderById(sessionIdentification.getIdpId());
        }
        if (StringUtils.isNotBlank((CharSequence)((String)req.getSession().getAttribute("ksso.oidc.idp.id")))) {
            idpConf = this.idpConfManager.getIdentityProviderById((String)req.getSession().getAttribute("ksso.oidc.idp.id"));
        }
        if (idpConf != null && idpConf.isSingleLogoutEnabled()) {
            cookieValue = Base64.getEncoder().encodeToString(String.format("%s#%s", idpConf.getId(), sessionIdentification).getBytes(StandardCharsets.UTF_8));
        }
        Cookie cookie = CookieSecurity.cookieWithDynamicSecurity(this.applicationProperties, "krb_custport_logout", cookieValue);
        cookie.setPath(req.getContextPath() + "/");
        res.addCookie(cookie);
        chain.doFilter((ServletRequest)req, (ServletResponse)res);
    }

    public void destroy() {
    }
}

