/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.jobs;

import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.fasterxml.jackson.databind.ObjectReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.inject.Inject;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.jobs.ApiServerConfigJobRunner;
import org.kantega.atlaskerb.jobs.UpdateCertMetadataJobRunner;
import org.kantega.atlaskerb.jobs.UserCleanupJobRunner;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.jsoncreatorclasses.CleanupRule;
import org.kantega.atlaskerb.utils.JsonWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class JobManager
implements InitializingBean,
DisposableBean {
    private final SchedulerService schedulerService;
    private final ApiServerConfigJobRunner apiServerConfigJobRunner;
    private final UpdateCertMetadataJobRunner updateCertMetadataJobRunner;
    private final UserCleanupJobRunner userCleanupJobRunner;
    private final List<JobId> scheduledJobIds = new CopyOnWriteArrayList<JobId>();
    private final List<JobRunnerKey> registeredJobRunnerKeys = new CopyOnWriteArrayList<JobRunnerKey>();
    private final Map<JobRunnerKey, List<JobId>> jobIdsPerRunnerKey = new HashMap<JobRunnerKey, List<JobId>>();
    KerbConfManager kerbConfManager;
    private final Logger log = LoggerFactory.getLogger(JobManager.class);
    private final JsonWrapper jsonWrapper;

    @Inject
    public JobManager(ApiServerConfigJobRunner apiServerConfigJobRunner, UpdateCertMetadataJobRunner updateCertMetadataJobRunner, UserCleanupJobRunner userCleanupJobRunner, KerbConfManager kerbConfManager, JsonWrapper jsonWrapper) {
        this.schedulerService = (SchedulerService)ComponentLocator.getComponent(SchedulerService.class);
        this.apiServerConfigJobRunner = apiServerConfigJobRunner;
        this.updateCertMetadataJobRunner = updateCertMetadataJobRunner;
        this.userCleanupJobRunner = userCleanupJobRunner;
        this.kerbConfManager = kerbConfManager;
        this.jsonWrapper = jsonWrapper;
    }

    public void afterPropertiesSet() {
        this.scheduleApiServerConfigJob();
        this.scheduleSamlCertMetadataJob();
        String cleanupRuleJson = this.kerbConfManager.getUserCleanupRuleJSONString();
        if (cleanupRuleJson != null) {
            ObjectReader om = this.jsonWrapper.objectReader();
            try {
                CleanupRule cleanupRule = (CleanupRule)om.readValue(cleanupRuleJson, CleanupRule.class);
                if (cleanupRule == null || cleanupRule.getCronAttributes() == null) {
                    this.log.warn("Failed to restart user cleanup job after app restart. CronAttributes was missing in cleanup rule: " + cleanupRuleJson);
                    return;
                }
                if (cleanupRule.getCronAttributes().getScheduleEnabled() && cleanupRule.getCronAttributes().getCronSchedule() != null) {
                    this.scheduleJob(cleanupRule.getCronAttributes().getCronSpringSchedule(), UserCleanupJobRunner.JOB_RUNNER_KEY);
                }
            }
            catch (Exception e) {
                this.log.warn("Failed to restart user cleanup job after app restart", (Throwable)e);
            }
        }
    }

    private void scheduleApiServerConfigJob() {
        JobRunnerKey jobRunnerKey = ApiServerConfigJobRunner.JOB_RUNNER_KEY;
        Schedule schedule = Schedule.forInterval((long)120000L, (Date)new Date(System.currentTimeMillis() + 20000L));
        this.scheduleJob(jobRunnerKey, schedule, this.apiServerConfigJobRunner);
    }

    public void scheduleJob(String cron, JobRunnerKey runnerKey) {
        Schedule schedule = Schedule.forCronExpression((String)cron);
        if (runnerKey.equals((Object)UserCleanupJobRunner.JOB_RUNNER_KEY)) {
            this.scheduleJob(UserCleanupJobRunner.JOB_RUNNER_KEY, schedule, this.userCleanupJobRunner);
        }
    }

    public void destroyJobsWithRunnerKey(JobRunnerKey runnerKey) {
        if (!this.registeredJobRunnerKeys.contains(runnerKey) && !this.jobIdsPerRunnerKey.containsKey(runnerKey)) {
            return;
        }
        if (this.jobIdsPerRunnerKey.containsKey(runnerKey)) {
            for (JobId scheduledJobId : this.jobIdsPerRunnerKey.get(runnerKey)) {
                this.schedulerService.unscheduleJob(scheduledJobId);
            }
        }
        this.schedulerService.unregisterJobRunner(runnerKey);
        this.jobIdsPerRunnerKey.remove(runnerKey);
        this.registeredJobRunnerKeys.remove(runnerKey);
    }

    private void scheduleSamlCertMetadataJob() {
        long twentyFourHoursInMillis = 86400000L;
        Schedule schedule = Schedule.forInterval((long)twentyFourHoursInMillis, (Date)new Date(System.currentTimeMillis() + 20000L));
        this.scheduleJob(UpdateCertMetadataJobRunner.JOB_RUNNER_KEY, schedule, this.updateCertMetadataJobRunner);
    }

    private void scheduleJob(JobRunnerKey jobRunnerKey, Schedule schedule, JobRunner runner) {
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)jobRunnerKey).withSchedule(schedule).withRunMode(RunMode.RUN_LOCALLY);
        this.schedulerService.registerJobRunner(jobRunnerKey, runner);
        this.registeredJobRunnerKeys.add(jobRunnerKey);
        try {
            JobId jobId = this.schedulerService.scheduleJobWithGeneratedId(jobConfig);
            if (this.jobIdsPerRunnerKey.containsKey(jobRunnerKey)) {
                this.jobIdsPerRunnerKey.get(jobRunnerKey).add(jobId);
            } else {
                ArrayList<JobId> newList = new ArrayList<JobId>();
                newList.add(jobId);
                this.jobIdsPerRunnerKey.put(jobRunnerKey, newList);
            }
            this.scheduledJobIds.add(jobId);
        }
        catch (SchedulerServiceException e) {
            throw new RuntimeException(e);
        }
    }

    public void destroy() {
        for (JobId scheduledJobId : this.scheduledJobIds) {
            this.schedulerService.unscheduleJob(scheduledJobId);
        }
        for (JobRunnerKey registeredJobRunnerKey : this.registeredJobRunnerKeys) {
            this.schedulerService.unregisterJobRunner(registeredJobRunnerKey);
            this.jobIdsPerRunnerKey.remove(registeredJobRunnerKey);
            this.registeredJobRunnerKeys.remove(registeredJobRunnerKey);
        }
    }
}

