/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.connector.okta;

import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONObject;
import io.vavr.collection.HashSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.connector.ConnectorHttpClient;
import org.kantega.atlaskerb.connector.ConnectorURIBuilder;
import org.kantega.atlaskerb.connector.api.ConnectorAPI;
import org.kantega.atlaskerb.connector.api.GroupHandler;
import org.kantega.atlaskerb.connector.api.MembershipHandler;
import org.kantega.atlaskerb.connector.api.UserHandler;
import org.kantega.atlaskerb.connector.model.crowdapi.GroupItem;
import org.kantega.atlaskerb.connector.model.crowdapi.MembershipItem;
import org.kantega.atlaskerb.connector.model.crowdapi.UserItem;
import org.kantega.atlaskerb.connector.model.crowdapi.UserMember;
import org.kantega.atlaskerb.connector.okta.OktaHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OktaApi
implements ConnectorAPI {
    private final OktaHttpClient client;
    private final String baseUrl;
    private final int limit;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public OktaApi(String domain, String token) {
        this.client = new OktaHttpClient(domain, token);
        this.baseUrl = System.getProperty("connector.okta.url", "https://" + domain);
        this.limit = Integer.parseInt(System.getProperty("connector.okta.limit", "-1"));
    }

    @Override
    public void findAllUsers(UserHandler userHandler) throws InterruptedException {
        String nextLink = this.requestBuilder("/api/v1/users").toString();
        do {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException("findAllUsers aborting");
            }
            ConnectorHttpClient.Response response = this.client.httpGet(nextLink);
            nextLink = this.getNextLink(response.getHeaderFields());
            JSONArray responseJson = response.getAsJSONArray();
            for (int i = 0; i < responseJson.length(); ++i) {
                JSONObject userJson = (JSONObject)responseJson.get(i);
                UserItem user = this.toUserItem(userJson);
                userHandler.handleUser(user);
            }
        } while (nextLink != null);
    }

    @Override
    public void findAllGroups(GroupHandler groupHandler) throws InterruptedException {
        String nextLink = this.requestBuilder("/api/v1/groups").toString();
        do {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException("findAllGroups aborting");
            }
            ConnectorHttpClient.Response response = this.client.httpGet(nextLink);
            nextLink = this.getNextLink(response.getHeaderFields());
            JSONArray responseJson = response.getAsJSONArray();
            for (int i = 0; i < responseJson.length(); ++i) {
                JSONObject groupJson = (JSONObject)responseJson.get(i);
                JSONObject profileJson = groupJson.getJSONObject("profile");
                GroupItem group = new GroupItem();
                group.setName(profileJson.getString("name"));
                group.setDescription(profileJson.getString("description"));
                group.setId(groupJson.getString("id"));
                group.setActive(true);
                groupHandler.handleGroup(group);
            }
        } while (nextLink != null);
    }

    @Override
    public void findAllMemberships(Set<UserItem> includedUsers, Set<GroupItem> includedGroups, MembershipHandler membershipHandler, boolean useNestedGroups) throws InterruptedException {
        HashMap groupNameById = new HashMap();
        if (includedGroups == null) {
            this.findAllGroups(group -> groupNameById.put(group.getId(), group.getName()));
        } else {
            includedGroups.forEach(g -> groupNameById.put(g.getId(), g.getName()));
        }
        for (String groupId : groupNameById.keySet()) {
            MembershipItem membershipItem = new MembershipItem();
            membershipItem.setName((String)groupNameById.get(groupId));
            String nextLink = this.requestBuilder("/api/v1/groups/" + groupId + "/users").toString();
            do {
                ConnectorHttpClient.Response response = this.client.httpGet(nextLink);
                nextLink = this.getNextLink(response.getHeaderFields());
                JSONArray responseJson = response.getAsJSONArray();
                for (int i = 0; i < responseJson.length(); ++i) {
                    JSONObject userJson = (JSONObject)responseJson.get(i);
                    JSONObject profileJson = userJson.getJSONObject("profile");
                    UserMember mem = new UserMember();
                    membershipItem.getUserCollection().getUsers().add(mem);
                    mem.setName(profileJson.getString("login"));
                }
            } while (nextLink != null);
            membershipHandler.handleMembership(membershipItem);
        }
    }

    private ConnectorURIBuilder requestBuilder(String path) {
        ConnectorURIBuilder builder = ConnectorURIBuilder.builder(this.baseUrl + path);
        if (this.limit > 0) {
            builder.queryParam("limit", String.valueOf(this.limit));
        }
        return builder;
    }

    private UserItem toUserItem(JSONObject userJson) {
        UserItem user = new UserItem();
        user.setKey(userJson.getString("id"));
        JSONObject profileJson = userJson.getJSONObject("profile");
        user.setFirstName(profileJson.getString("firstName"));
        user.setLastName(profileJson.getString("lastName"));
        user.setEmail(profileJson.getString("email"));
        user.setName(profileJson.getString("login"));
        user.setUserType(UserItem.UserType.MEMBER);
        user.setActive("ACTIVE".equals(userJson.getString("status")));
        user.setDisplayName(user.getFirstName() + " " + user.getLastName());
        this.log.debug("Username {} from OktaAPI has status from Okta {}.", (Object)user.getName(), (Object)userJson.getString("status"));
        return user;
    }

    private String getNextLink(Map<String, List<String>> headerFields) {
        return (String)((io.vavr.collection.List)HashSet.ofAll(headerFields.entrySet()).filter(entry -> StringUtils.equalsIgnoreCase((CharSequence)((CharSequence)entry.getKey()), (CharSequence)"link")).map(entry -> (List)entry.getValue()).map(io.vavr.collection.List::ofAll).getOrElse((Object)io.vavr.collection.List.empty())).filter(headerVal -> headerVal.contains("rel=\"next\"") && headerVal.contains("<") && headerVal.contains(">")).map(headerVal -> headerVal.substring(headerVal.indexOf("<") + 1, headerVal.indexOf(">"))).getOrNull();
    }
}

