/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.connector.keycloak;

import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONObject;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.http.client.utils.URIBuilder;
import org.kantega.atlaskerb.connector.ConnectorHttpClient;
import org.kantega.atlaskerb.connector.api.ConnectorAPI;
import org.kantega.atlaskerb.connector.api.GroupHandler;
import org.kantega.atlaskerb.connector.api.MembershipHandler;
import org.kantega.atlaskerb.connector.api.UserHandler;
import org.kantega.atlaskerb.connector.keycloak.KeycloakGroupItem;
import org.kantega.atlaskerb.connector.keycloak.KeycloakHttpClient;
import org.kantega.atlaskerb.connector.model.crowdapi.GroupItem;
import org.kantega.atlaskerb.connector.model.crowdapi.MembershipItem;
import org.kantega.atlaskerb.connector.model.crowdapi.UserItem;
import org.kantega.atlaskerb.connector.model.crowdapi.UserMember;

public class KeycloakApi
implements ConnectorAPI {
    private final KeycloakHttpClient client;
    private final URIBuilder uriScheme;
    private final String realm;

    public KeycloakApi(String realm, String clientId, String clientSecret, String username, String password, URIBuilder uriScheme) {
        this.uriScheme = uriScheme;
        this.realm = realm;
        this.client = new KeycloakHttpClient(realm, clientId, clientSecret, username, password, uriScheme);
    }

    @Override
    public void findAllUsers(UserHandler userHandler) throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException("findAllUsers aborting");
        }
        try {
            ConnectorHttpClient.Response response = this.client.httpGet(this.generateUri("/users", new String[][]{{"max", "-1"}, {"briefRepresentation", "false"}}));
            JSONArray responseJson = response.getAsJSONArray();
            for (int i = 0; i < responseJson.length(); ++i) {
                JSONObject userJson = (JSONObject)responseJson.get(i);
                UserItem user = this.toUserItem(userJson);
                userHandler.handleUser(user);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private UserItem toUserItem(JSONObject userJson) {
        UserItem user = new UserItem();
        user.setKey(userJson.getString("id"));
        user.setActive(userJson.getBoolean("enabled"));
        user.setName(userJson.getString("username"));
        user.setUserType(UserItem.UserType.MEMBER);
        if (userJson.has("firstName")) {
            user.setFirstName(userJson.getString("firstName"));
        }
        if (userJson.has("lastName")) {
            user.setLastName(userJson.getString("lastName"));
        }
        if (userJson.has("email")) {
            user.setEmail(userJson.getString("email"));
        }
        if (userJson.has("firstName") && userJson.has("lastName")) {
            user.setDisplayName(user.getFirstName() + " " + user.getLastName());
        } else {
            user.setDisplayName(user.getName());
        }
        return user;
    }

    @Override
    public void findAllGroups(GroupHandler groupHandler) throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException("findAllGroups aborting");
        }
        try {
            ConnectorHttpClient.Response response = this.client.httpGet(this.generateUri("/groups", new String[0][]));
            JSONArray responseJson = response.getAsJSONArray();
            for (int i = 0; i < responseJson.length(); ++i) {
                JSONObject group = (JSONObject)responseJson.get(i);
                this.handleSubgroups(group, groupHandler);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private void handleSubgroups(JSONObject groupJson, GroupHandler groupHandler) {
        GroupItem groupItem = this.toGroupItem(groupJson);
        groupHandler.handleGroup(groupItem);
        JSONArray subgroups = groupJson.getJSONArray("subGroups");
        if (subgroups.length() > 0) {
            for (int i = 0; i < subgroups.length(); ++i) {
                this.handleSubgroups((JSONObject)subgroups.get(i), groupHandler);
            }
        }
    }

    private GroupItem toGroupItem(JSONObject groupJson) {
        GroupItem group = new GroupItem();
        group.setId(groupJson.getString("id"));
        group.setName(groupJson.getString("path").substring(1));
        group.setActive(true);
        return group;
    }

    public Set<KeycloakGroupItem> getKeycloakGroupItems(Set<GroupItem> includedGroups) {
        HashMap<String, KeycloakGroupItem> keycloakGroupItemMap = new HashMap<String, KeycloakGroupItem>();
        for (GroupItem group : includedGroups) {
            String key = group.getName().toLowerCase();
            if (keycloakGroupItemMap.containsKey(key)) {
                ((KeycloakGroupItem)keycloakGroupItemMap.get(key)).addRelatedGroupId(group.getId());
                continue;
            }
            KeycloakGroupItem kcGroupItem = new KeycloakGroupItem(group);
            keycloakGroupItemMap.put(key, kcGroupItem);
        }
        return new HashSet<KeycloakGroupItem>(keycloakGroupItemMap.values());
    }

    @Override
    public void findAllMemberships(Set<UserItem> includedUsers, Set<GroupItem> includedGroups, MembershipHandler membershipHandler, boolean useNestedGroups) throws InterruptedException {
        try {
            Set<KeycloakGroupItem> includedKcGroups = this.getKeycloakGroupItems(includedGroups);
            includedGroups.removeIf(groupItem -> includedKcGroups.stream().noneMatch(g -> g.getId().equals(groupItem.getId())));
            HashMap<String, UserItem> userById = new HashMap<String, UserItem>();
            includedUsers.forEach(user -> userById.put(user.getKey(), (UserItem)user));
            for (KeycloakGroupItem group : includedKcGroups) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException("findAllMemberships aborting");
                }
                Set<UserItem> members = this.fetchMembers(group, userById);
                membershipHandler.handleMembership(this.createMembership(group, members));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private MembershipItem createMembership(GroupItem group, Set<UserItem> members) {
        MembershipItem membership = new MembershipItem();
        membership.setName(group.getName());
        for (UserItem member : members) {
            UserMember mem = new UserMember();
            mem.setName(member.getName());
            membership.getUserCollection().getUsers().add(mem);
        }
        return membership;
    }

    private void addMembersToGroupWithId(String groupId, Set<UserItem> members, Map<String, UserItem> includedUsers) throws UnsupportedEncodingException, InterruptedException {
        ConnectorHttpClient.Response response = this.client.httpGet(this.generateUri("/groups/" + groupId + "/members", new String[][]{{"briefRepresentation", "true"}, {"max", "-1"}}));
        JSONArray responseJson = response.getAsJSONArray();
        for (int i = 0; i < responseJson.length(); ++i) {
            JSONObject user = (JSONObject)responseJson.get(i);
            if (!includedUsers.containsKey(user.get("id").toString())) continue;
            members.add(includedUsers.get(user.get("id").toString()));
        }
    }

    private Set<UserItem> fetchMembers(KeycloakGroupItem group, Map<String, UserItem> includedUsers) throws UnsupportedEncodingException, InterruptedException {
        HashSet<UserItem> members = new HashSet<UserItem>();
        this.addMembersToGroupWithId(group.getId(), members, includedUsers);
        for (int i = 0; i < group.getRelatedGroupIds().size(); ++i) {
            this.addMembersToGroupWithId(group.getRelatedGroupIds().get(i), members, includedUsers);
        }
        return members;
    }

    private String generateUri(String pathAfterRealm, String[][] params) throws UnsupportedEncodingException {
        this.uriScheme.setPath("admin/realms/" + URLEncoder.encode(this.realm, StandardCharsets.UTF_8.name()) + pathAfterRealm);
        for (String[] param : params) {
            this.uriScheme.setParameter(param[0], param[1]);
        }
        return this.uriScheme.toString();
    }
}

