/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.backup;

import com.atlassian.templaterenderer.TemplateRenderer;
import io.vavr.control.Option;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.kantega.atlaskerb.DateTool;
import org.kantega.atlaskerb.PluginKey;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.backup.BackupInfo;
import org.kantega.atlaskerb.backup.BackupService;

public class RestoreAction
extends RequireAdminServlet {
    private final BackupService backupService;
    private final TemplateRenderer renderer;

    @Inject
    public RestoreAction(RequireAdminServletDependencyBucket bucket, BackupService backupService) {
        super(bucket);
        this.renderer = bucket.getTemplateRenderer();
        this.backupService = backupService;
    }

    private void renderPage(HttpServletResponse resp, Map<String, Object> model) throws IOException {
        resp.setContentType("text/html");
        model.put("topMenu", "dashboard");
        model.put("menuItem", "backup");
        model.put("dateTool", new DateTool());
        this.renderer.render("templates/atlaskerb/backup/restore.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        String filenameInput = FilenameUtils.getName((String)req.getParameter("filename"));
        Option<File> maybeBackupFile = this.backupService.getBackupFile(filenameInput);
        if (maybeBackupFile.isDefined()) {
            File backupFile = (File)maybeBackupFile.get();
            if (!backupFile.canRead()) {
                model.put("unreadable", true);
                this.renderPage(resp, model);
                return;
            }
            BackupInfo backup = this.backupService.findBackup(filenameInput);
            if (backup != null) {
                if (req.getParameter("restore") != null) {
                    this.backupService.restoreFromFile(backupFile, req.getParameter("makeBackup") != null);
                    resp.sendRedirect("backup?restored");
                } else {
                    String pluginVersion = PluginKey.getVersion();
                    model.put("pluginVersion", pluginVersion);
                    boolean canRestore = pluginVersion.contains("-SNAPSHOT") || pluginVersion.equals(backup.getPluginVersion());
                    model.put("canRestore", canRestore);
                    model.put("backup", backup);
                    this.renderPage(resp, model);
                }
                return;
            }
        }
        resp.sendRedirect("backup");
    }
}

