/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import com.atlassian.cache.CacheManager;
import com.atlassian.crowd.directory.DbCachingRemoteDirectory;
import com.atlassian.crowd.directory.RemoteCrowdDirectory;
import com.atlassian.crowd.directory.SynchronisableDirectoryProperties;
import com.atlassian.crowd.directory.loader.DbCachingRemoteDirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.Attributes;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.exception.ApplicationAccessDeniedException;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.model.authentication.UserAuthenticationContext;
import com.atlassian.crowd.model.authentication.ValidationFactor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.kantegasso.runtimetrust.Fingerprint;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.collection.Array;
import io.vavr.collection.List;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.PluginKey;
import org.kantega.atlaskerb.SafeRedirect;
import org.kantega.atlaskerb.connector.ConnectorConfManager;
import org.kantega.atlaskerb.diagnostics.AuditLogFacade;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.identityproviders.AttributeInfo;
import org.kantega.atlaskerb.identityproviders.GroupEvaluation;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.ManagedGroup;
import org.kantega.atlaskerb.identityproviders.ResponseEvaluationCode;
import org.kantega.atlaskerb.identityproviders.UserRecipe;
import org.kantega.atlaskerb.identityproviders.saml.evaluation.SAMLResponseEvaluationResult;
import org.kantega.atlaskerb.identityproviders.saml.evaluation.SAMLResponseEvaluator;
import org.kantega.atlaskerb.kerberos.PrincipalEntry;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.SamlIdpConfiguration;
import org.kantega.atlaskerb.saml.cache.AtlassianAuthnStateCache;
import org.kantega.atlaskerb.saml.cache.AtlassianCacheStorageService;
import org.kantega.atlaskerb.saml.logout.SingleLogoutAppHelper;
import org.kantega.atlaskerb.saml.logout.SingleLogoutAppHelperFactory;
import org.kantega.atlaskerb.saml.util.SessionIdentificationHelper;
import org.kantega.atlaskerb.saml.util.XmlUtils;
import org.kantega.atlaskerb.utils.CookieUtil;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.kantega.atlaskerb.utils.TestUtils;
import org.kantega.atlaskerb.websudo.WebSudoServlet;
import org.kantega.samllib.IdGenerator;
import org.kantega.samllib.spi.AuthnStateCache;
import org.kantega.samllib.spi.ServiceProviderSpi;
import org.kantega.samllib.validation.ResultType;
import org.kantega.samllib.validation.SAMLSessionIdentification;
import org.kantega.samllib.validation.SamlLogoutValidationResult;
import org.kantega.samllib.validation.SamlResponseValidationResult;
import org.kantega.samllib.validation.ValidationResult;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.NameIDPolicy;
import org.opensaml.saml.saml2.core.RequestedAuthnContext;
import org.opensaml.saml.saml2.core.impl.AuthnContextClassRefBuilder;
import org.opensaml.saml.saml2.core.impl.AuthnRequestBuilder;
import org.opensaml.saml.saml2.core.impl.IssuerBuilder;
import org.opensaml.saml.saml2.core.impl.NameIDPolicyBuilder;
import org.opensaml.saml.saml2.core.impl.RequestedAuthnContextBuilder;
import org.opensaml.security.credential.Credential;
import org.opensaml.storage.ReplayCache;
import org.opensaml.storage.StorageService;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.X509Certificate;
import org.opensaml.xmlsec.signature.X509Data;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ServiceProviderFactory {
    public static final String SESSION_IDENTIFICATION_KEY = "sessionIdentification";
    private static final Logger log = LoggerFactory.getLogger(ServiceProviderFactory.class);
    private final ConnectorConfManager connectorConfManager;
    private final IdpConfManager idpConfManager;
    private final ReplayCache replayCache;
    private final AuthnStateCache authnStateCache;
    private final KerbConfManager kerbConfManager;
    private final AuditLogFacade auditLogFacade;
    private final IdGenerator random = new IdGenerator();
    private final TemplateRenderer renderer;
    private final HostApp hostApp;
    private final SingleLogoutAppHelper logoutAppHelper;
    private final SAMLResponseEvaluator responseEvaluator;
    private final UserManager userManager;
    private final ApplicationProperties applicationProperties;
    private final SafeRedirect safeRedirect;
    public static final String INSTANT_LOGIN_TARGET_URL = "samlInstantLoginUrl";

    @Inject
    public ServiceProviderFactory(@ComponentImport UserManager userManager, @ComponentImport ApplicationProperties applicationProperties, @ComponentImport CacheManager cacheManager, @ComponentImport TemplateRenderer renderer, IdpConfManager idpConfManager, KerbConfManager kerbConfManager, AuditLogFacade auditLogFacade, ConnectorConfManager connectorConfManager, HostAppFactory hostAppFactory, SAMLResponseEvaluator responseEvaluator, SafeRedirect safeRedirect, SingleLogoutAppHelperFactory singleLogoutAppHelperFactory) {
        this.connectorConfManager = connectorConfManager;
        this.idpConfManager = idpConfManager;
        this.kerbConfManager = kerbConfManager;
        this.auditLogFacade = auditLogFacade;
        this.renderer = renderer;
        this.hostApp = hostAppFactory.getInstance();
        this.logoutAppHelper = singleLogoutAppHelperFactory.getInstance();
        this.responseEvaluator = responseEvaluator;
        this.userManager = userManager;
        this.applicationProperties = applicationProperties;
        this.safeRedirect = safeRedirect;
        this.replayCache = new ReplayCache();
        this.replayCache.setStrict(true);
        this.replayCache.setStorage((StorageService)new AtlassianCacheStorageService(cacheManager));
        this.authnStateCache = new AtlassianAuthnStateCache(cacheManager);
    }

    public static String getTargetLinkUrl(String urlString, String baseUrl) {
        return (String)Try.of((CheckedFunction0 & Serializable)() -> urlString).mapTry(URI::new).filterTry(uri -> uri.isAbsolute() ? ServiceProviderFactory.validateAbsoluteUri(uri, baseUrl) : ServiceProviderFactory.validateRelativeUri(uri)).map(URI::toString).getOrNull();
    }

    private static boolean validateAbsoluteUri(URI uri, String baseUrl) {
        return (Boolean)Try.of((CheckedFunction0 & Serializable)() -> uri).mapTry(URI::toURL).filterTry(url -> Array.of((Object[])new String[]{"http", "https"}).contains((Object)url.getProtocol())).mapTry(URL::toString).filterTry(urlString -> StringUtils.startsWith((CharSequence)urlString, (CharSequence)baseUrl)).filterTry(uriString -> !StringUtils.contains((CharSequence)uriString, (CharSequence)"javascript:")).filterTry(uriString -> !StringUtils.contains((CharSequence)uriString, (CharSequence)"<script")).mapTry((CheckedFunction1 & Serializable)urlString -> true).getOrElse((Object)false);
    }

    private static boolean validateRelativeUri(URI uri) {
        return (Boolean)Try.of((CheckedFunction0 & Serializable)() -> uri).mapTry(URI::toString).filterTry(uriString -> !StringUtils.contains((CharSequence)uriString, (CharSequence)"://")).filterTry(uriString -> !StringUtils.contains((CharSequence)uriString, (CharSequence)"javascript:")).filterTry(uriString -> !StringUtils.contains((CharSequence)uriString, (CharSequence)"<script")).mapTry((CheckedFunction1 & Serializable)urlString -> true).getOrElse((Object)false);
    }

    public ServiceProviderSpi getInstance(SamlIdpConfiguration config) {
        return new SpConfSpi(config);
    }

    private void authenticateUserInCrowdSSO(Principal principal, Directory userDirectory) throws OperationFailedException {
        String appName = (String)userDirectory.getAttributes().get("application.name");
        if (appName != null && this.connectorConfManager.getDirectory(appName) == null) {
            try {
                SynchronisableDirectoryProperties.SyncGroupMembershipsAfterAuth groupSyncMode = SynchronisableDirectoryProperties.SyncGroupMembershipsAfterAuth.forDirectory((Attributes)userDirectory);
                if (groupSyncMode == SynchronisableDirectoryProperties.SyncGroupMembershipsAfterAuth.ALWAYS) {
                    DbCachingRemoteDirectoryInstanceLoader instanceLoader = (DbCachingRemoteDirectoryInstanceLoader)ComponentLocator.getComponent(DbCachingRemoteDirectoryInstanceLoader.class);
                    DbCachingRemoteDirectory directory = (DbCachingRemoteDirectory)instanceLoader.getDirectory(userDirectory);
                    RemoteCrowdDirectory crowdDirectory = (RemoteCrowdDirectory)this.hostApp.getAuthorativeDirectory(directory);
                    try {
                        String token = crowdDirectory.getCrowdClient().authenticateSSOUserWithoutValidatingPassword(new UserAuthenticationContext(principal.getName(), null, new ValidationFactor[0], null));
                        crowdDirectory.getCrowdClient().invalidateSSOToken(token);
                    }
                    catch (OperationFailedException e) {
                        log.debug("REST-call failed. Likely because of a remote jira");
                    }
                    catch (ApplicationAccessDeniedException | ApplicationPermissionException | InactiveAccountException | InvalidAuthenticationException e) {
                        log.error("Error authenticating user remotely", e);
                    }
                }
            }
            catch (NoClassDefFoundError e) {
                log.debug("Unable to perform user sync on login since Crowd API is too old and not compatible with triggering this. Sync will happen on next scheduled synchronisation");
            }
        }
    }

    private void renderErrors(java.util.List<String> errors, SamlResponseValidationResult result) throws IOException {
        HttpServletResponse resp = result.getResponse();
        resp.setContentType("text/html");
        resp.setHeader("Cache-Control", "private, max-age=0, no-cache");
        resp.setStatus(Response.Status.UNAUTHORIZED.getStatusCode());
        Map<String, Object> model = this.newModel();
        model.put("errors", errors);
        model.put("errorPageMessage", this.kerbConfManager.getErrorPageMessage());
        model.put("requestURI", ServiceProviderFactory.getTargetLinkUrl(result.getRelayState(), this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE)));
        model.put("baseUrl", this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE));
        model.put("displayName", this.applicationProperties.getDisplayName());
        this.renderer.render("templates/saml/login-error.vm", model, (Writer)resp.getWriter());
    }

    private void renderLogoutErrors(SamlLogoutValidationResult result, HttpServletResponse resp) throws IOException {
        resp.setContentType("text/html");
        resp.setHeader("Cache-Control", "private, max-age=0, no-cache");
        Map<String, Object> model = this.newModel();
        model.put("errors", result.getResults());
        model.put("errorPageMessage", this.kerbConfManager.getErrorPageMessage());
        model.put("displayName", this.applicationProperties.getDisplayName());
        String id = result.getServiceProviderSpi().getIdentityProviderId();
        IdpConfiguration configuration = this.idpConfManager.getIdentityProviderById(id);
        model.put("idp", configuration.getName());
        this.renderer.render("templates/saml/logout-error.vm", model, (Writer)resp.getWriter());
    }

    private boolean isSystemAdmin(HttpServletRequest request) {
        return HttpUrlUtils.isSystemAdmin(this.userManager, request);
    }

    private void recordTest(SamlResponseValidationResult result, ResponseEvaluationCode code, SAMLResponseEvaluationResult evaluationResult, IdpConfiguration idpConfiguration) throws IOException {
        if (result.getResponseObject() == null) {
            result.getResponse().sendError(400, "Response did not contain a SAML response object");
            return;
        }
        try {
            String xml = result.getResponseObject() == null ? null : XmlUtils.serializeXml(XMLObjectSupport.marshall((XMLObject)result.getResponseObject()));
            this.idpConfManager.recordTestResult(idpConfiguration.getId(), result, evaluationResult, xml, this.kerbConfManager.getRemoteIpAddress(result.getRequest()));
            if (idpConfiguration.getNotificationEmails() != null && !this.isSystemAdmin(result.getRequest())) {
                try {
                    this.sendNotificationEmails(result, idpConfiguration);
                }
                catch (Exception e) {
                    log.error("Could not send notification emails", (Throwable)e);
                }
            }
        }
        catch (MarshallingException e) {
            throw new RuntimeException(e);
        }
        String location = TestUtils.testResultURL(result.getRequest(), idpConfiguration, this.idpConfManager, this.userManager, result.getAuthnRequestID());
        result.getResponse().sendRedirect(location);
    }

    private void sendNotificationEmails(SamlResponseValidationResult result, IdpConfiguration idpConfiguration) {
        if (!this.hostApp.isSMTPSupported() || !this.hostApp.isSMTPEnabled()) {
            return;
        }
        String baseUrl = this.applicationProperties.getBaseUrl(UrlMode.CANONICAL);
        String evalPath = this.idpConfManager.getServiceProviderEvaluateTestUrl(result.getRequest(), idpConfiguration.getId());
        evalPath = evalPath.substring(result.getRequest().getContextPath().length());
        String url = baseUrl + evalPath + "?id=" + result.getAuthnRequestID();
        String subject = "New SAML authentication test result";
        String body = "A new SAML authentication test result was received\n\nVisit the following URL to see the result:\n\n" + url;
        for (String recipient : idpConfiguration.getNotificationEmails().split(",")) {
            if ((recipient = recipient.trim()).isEmpty()) continue;
            this.hostApp.sendEmail(recipient, subject, body);
        }
    }

    protected Map<String, Object> newModel() {
        HashMap<String, Object> model = new HashMap<String, Object>();
        new PluginKey();
        String pluginKey = PluginKey.getPluginKey();
        model.put("pluginKey", pluginKey);
        model.put("pluginResource", pluginKey + ":entrypoint-atlaskerb");
        return model;
    }

    private class SpConfSpi
    implements ServiceProviderSpi {
        private final String USERNAME_ATTR = ServiceProviderSpi.class.getName() + "_username";
        private final SamlIdpConfiguration samlIdpConfiguration;
        private final Map<String, Credential> idpValidationCredentials = new HashMap<String, Credential>();
        private final Credential authnSigningCertCredential;

        public SpConfSpi(SamlIdpConfiguration samlIdpConfiguration) {
            this.samlIdpConfiguration = samlIdpConfiguration;
            for (byte[] certBytes : samlIdpConfiguration.getSigningCerts()) {
                this.idpValidationCredentials.put(Fingerprint.sha1Fingerprint((byte[])certBytes), ServiceProviderFactory.this.idpConfManager.getIdpSigningCredential(certBytes));
            }
            this.authnSigningCertCredential = ServiceProviderFactory.this.idpConfManager.getSpSigningCredential();
        }

        public String getIdentityProviderId() {
            return this.samlIdpConfiguration.getId();
        }

        public ReplayCache getReplayCache() {
            return ServiceProviderFactory.this.replayCache;
        }

        public AuthnStateCache getAuthnStateCache(HttpServletRequest req) {
            return ServiceProviderFactory.this.authnStateCache;
        }

        public String getIdpDestination(HttpServletRequest req) {
            return this.samlIdpConfiguration.getIdpURL();
        }

        public String getACSLocation(HttpServletRequest req) {
            return ServiceProviderFactory.this.idpConfManager.getServiceProviderLoginUrl(req, this.samlIdpConfiguration.getId());
        }

        public String getLogoutLocation(HttpServletRequest req) {
            return ServiceProviderFactory.this.idpConfManager.getServiceProviderLogoutServiceUrl(req, this.samlIdpConfiguration.getId());
        }

        public String getIssuerName(HttpServletRequest req) {
            if (this.samlIdpConfiguration.getIssuerPolicy() == SamlIdpConfiguration.IssuerPolicy.CUSTOM && this.samlIdpConfiguration.getIssuer() != null && !this.samlIdpConfiguration.getIssuer().isEmpty()) {
                return this.samlIdpConfiguration.getIssuer();
            }
            return this.getACSLocation(req);
        }

        public Credential getSigningCredential() {
            return this.authnSigningCertCredential;
        }

        public String nextSamlRequestId() {
            return ServiceProviderFactory.this.random.next();
        }

        public java.util.List<Credential> getIdentityProviderCredentials(Signature signature) {
            if (signature.getKeyInfo() != null && signature.getKeyInfo().getX509Datas() != null) {
                for (X509Data x509Data : signature.getKeyInfo().getX509Datas()) {
                    Iterator iterator = x509Data.getX509Certificates().iterator();
                    if (!iterator.hasNext()) continue;
                    X509Certificate certificate = (X509Certificate)iterator.next();
                    String base64 = certificate.getValue();
                    Credential credential = this.idpValidationCredentials.get(Fingerprint.sha1Fingerprint((byte[])Base64.decodeBase64((String)base64)));
                    if (credential == null) {
                        return Collections.emptyList();
                    }
                    return Collections.singletonList(credential);
                }
            }
            return new ArrayList<Credential>(this.idpValidationCredentials.values());
        }

        public java.util.List<Credential> getAllIdentityProviderCredentials() {
            return new ArrayList<Credential>(this.idpValidationCredentials.values());
        }

        private AuthnRequest createAuthnRequest(HttpServletRequest req) {
            AuthnRequest authnRequest = new AuthnRequestBuilder().buildObject();
            if (this.isForceAuthn(req)) {
                authnRequest.setForceAuthn(Boolean.valueOf(true));
                req.getSession().setAttribute("ForceAuthInitiated", (Object)"true");
            }
            authnRequest.setIsPassive(Boolean.valueOf(false));
            authnRequest.setProtocolBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
            authnRequest.setAssertionConsumerServiceURL(this.getACSLocation(req));
            Issuer issuer = new IssuerBuilder().buildObject();
            issuer.setValue(this.getIssuerName(req));
            issuer.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:entity");
            authnRequest.setIssuer(issuer);
            authnRequest.setDestination(this.getIdpDestination(req));
            authnRequest.setIssueInstant(DateTime.now());
            authnRequest.setID(this.nextSamlRequestId());
            NameIDPolicy nameIDPolicy = new NameIDPolicyBuilder().buildObject();
            nameIDPolicy.setAllowCreate(Boolean.valueOf(true));
            nameIDPolicy.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
            authnRequest.setNameIDPolicy(nameIDPolicy);
            RequestedAuthnContext requestedAuthnContext = new RequestedAuthnContextBuilder().buildObject();
            requestedAuthnContext.setComparison(AuthnContextComparisonTypeEnumeration.EXACT);
            AuthnContextClassRef authnContextClassRef = new AuthnContextClassRefBuilder().buildObject();
            authnContextClassRef.setAuthnContextClassRef("urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport");
            requestedAuthnContext.getAuthnContextClassRefs().add(authnContextClassRef);
            authnRequest.setRequestedAuthnContext(requestedAuthnContext);
            return authnRequest;
        }

        public AuthnRequest buildAuthnRequest(HttpServletRequest request) {
            String customNameIdFormat;
            AuthnRequest authnRequest = this.createAuthnRequest(request);
            switch (this.samlIdpConfiguration.getRequestedAuthnContextPolicy()) {
                case DO_NOT_SEND: {
                    authnRequest.setRequestedAuthnContext(null);
                    break;
                }
                case CUSTOM: {
                    AuthnContextComparisonTypeEnumeration comparison;
                    switch (this.samlIdpConfiguration.getRequestedAuthnContextComparison()) {
                        case MINIMUM: {
                            comparison = AuthnContextComparisonTypeEnumeration.MINIMUM;
                            break;
                        }
                        case MAXIMUM: {
                            comparison = AuthnContextComparisonTypeEnumeration.MAXIMUM;
                            break;
                        }
                        case BETTER: {
                            comparison = AuthnContextComparisonTypeEnumeration.BETTER;
                            break;
                        }
                        default: {
                            comparison = AuthnContextComparisonTypeEnumeration.EXACT;
                        }
                    }
                    authnRequest.getRequestedAuthnContext().setComparison(comparison);
                    java.util.List refs = authnRequest.getRequestedAuthnContext().getAuthnContextClassRefs();
                    refs.clear();
                    for (String ref : this.samlIdpConfiguration.getAuthnContextClassRef().split("\n")) {
                        if ((ref = ref.trim()).isEmpty()) continue;
                        AuthnContextClassRef accr = new AuthnContextClassRefBuilder().buildObject();
                        accr.setAuthnContextClassRef(ref);
                        refs.add(accr);
                    }
                    break;
                }
            }
            authnRequest.getNameIDPolicy().setAllowCreate(Boolean.valueOf(this.samlIdpConfiguration.getAllowCreate() == IdpConfiguration.AllowCreate.TRUE));
            if (this.samlIdpConfiguration.getNameIdFormat() == IdpConfiguration.NameIdFormat.CUSTOM && (customNameIdFormat = this.samlIdpConfiguration.getCustomNameIdFormat()) != null && !customNameIdFormat.trim().isEmpty()) {
                authnRequest.getNameIDPolicy().setFormat(customNameIdFormat.trim());
            }
            return authnRequest;
        }

        public Optional<SAMLSessionIdentification> getSessionIdentification(HttpServletRequest req) {
            return Optional.ofNullable(req.getSession(false)).flatMap(session -> Optional.ofNullable((String)session.getAttribute(ServiceProviderFactory.SESSION_IDENTIFICATION_KEY))).map(SessionIdentificationHelper::fromJson);
        }

        public SAMLSessionIdentification.ValidationPolicy getSessionIdentificationValidationPolicy() {
            return (SAMLSessionIdentification.ValidationPolicy)Option.of((Object)this.samlIdpConfiguration.getSessionIdentificationValidationPolicy()).getOrElse(SAMLSessionIdentification.ValidationPolicy::getDefault);
        }

        public void responseValidationFailed(SamlResponseValidationResult result) throws IOException {
            if (this.isTest(result) && result.getAuthnRequestID() != null) {
                ServiceProviderFactory.this.recordTest(result, ResponseEvaluationCode.FAILED_SAML_VALIDATION, null, this.samlIdpConfiguration);
            } else {
                ArrayList<ResultType> resultTypes = new ArrayList<ResultType>();
                for (ValidationResult validationResult : result.getResults()) {
                    resultTypes.add(validationResult.getType());
                }
                String errorCodes = ((Object)resultTypes).toString();
                log.error("SAML response validation failed with the following error codes: " + errorCodes);
                ServiceProviderFactory.this.renderErrors(Collections.singletonList("SAML Response validation failed: " + errorCodes), result);
            }
        }

        public void responseValidationSucceded(SamlResponseValidationResult result) throws IOException {
            ArrayList<String> errors = new ArrayList<String>();
            SAMLResponseEvaluationResult evaluationResult = ServiceProviderFactory.this.responseEvaluator.evaluate(this.samlIdpConfiguration, result, this.samlIdpConfiguration.getUsernameAttribute(), this.samlIdpConfiguration.getUserLookupAttribute(), this.samlIdpConfiguration.getUserLookupTransform(), this.samlIdpConfiguration.getCustomNameAttribute(), this.samlIdpConfiguration.getCustomGivenNameAttribute(), this.samlIdpConfiguration.getCustomSurnameAttribute(), this.samlIdpConfiguration.getNameAttributeMapping(), this.samlIdpConfiguration.getCustomEmailAttribute(), this.samlIdpConfiguration.getCustomUsernameAttributeName(), true);
            String username = evaluationResult.getSearchedUsername();
            if (this.isTest(result)) {
                ServiceProviderFactory.this.recordTest(result, evaluationResult.getCode(), evaluationResult, this.samlIdpConfiguration);
            } else {
                AttributeInfo configuredUsernameAttribute;
                if (!ServiceProviderFactory.this.idpConfManager.isLicenseValid()) {
                    errors.add("Kantega SSO Plugin license is not valid");
                    ServiceProviderFactory.this.renderErrors(errors, result);
                    return;
                }
                PrincipalEntry principalEntry = evaluationResult.getResolvedPrincipalEntry();
                if (evaluationResult.getAttributeInfos().isEmpty()) {
                    errors.add("The response contained no attribute which could be used as usernames");
                    ServiceProviderFactory.this.auditLogFacade.loginFailed(null, "SAML", "The response contained no attribute which could be used as usernames");
                }
                if ((configuredUsernameAttribute = evaluationResult.getConfiguredUsernameAttributeInfo()) == null) {
                    errors.add("The response did not contain the expected SAML username attribute");
                } else if (evaluationResult.isUserDomainRejected()) {
                    String userDomain = evaluationResult.getUserDomain();
                    if (userDomain != null) {
                        errors.add(String.format("Identity provider does not allow logging in users from domain @%s. Username is %s", userDomain, username));
                        ServiceProviderFactory.this.auditLogFacade.loginFailed(username, "SAML", "Identity provider does not allow logging in users from domain");
                    } else {
                        errors.add(String.format("Identity provider configuration restricts login to usernames with a known domain. The authenticated username %s does not end with a domain", username));
                        ServiceProviderFactory.this.auditLogFacade.loginFailed(username, "SAML", "Identity provider configuration restricts login to usernames with a known domain. The authenticated username does not end with a domain");
                    }
                } else {
                    java.util.List<ManagedGroup> managedOrAutoGroups = this.samlIdpConfiguration.isCreateAllIncomingGroups() ? this.samlIdpConfiguration.getAutoGroups() : this.samlIdpConfiguration.getManagedGroups();
                    ServiceProviderFactory.this.responseEvaluator.evaluateGroups(username, managedOrAutoGroups, ServiceProviderFactory.this.responseEvaluator.findSamlGroups(result.getAssertions()), evaluationResult.getGroupEvaluation(), this.samlIdpConfiguration.isCreateAllIncomingGroups());
                    UserRecipe userRecipe = evaluationResult.getUserRecipe();
                    Optional<Directory> jitDirectory = ServiceProviderFactory.this.hostApp.findJitDirectory(this.samlIdpConfiguration.getJitDirectory());
                    if (jitDirectory.isPresent()) {
                        if (principalEntry == null) {
                            if (this.samlIdpConfiguration.getUserNotFoundPolicy() == IdpConfiguration.UserNotFoundPolicy.CREATE) {
                                principalEntry = this.createUser(jitDirectory.get(), errors, evaluationResult, null, userRecipe, username);
                            } else {
                                if (this.samlIdpConfiguration.isAuthenticatedAnonymousBrowsingEnabled()) {
                                    this.addAuthenticatedAnonymousBrowsingSession(result, username);
                                    return;
                                }
                                errors.add(String.format("Account not found in %s for username %s using SAML", ServiceProviderFactory.this.applicationProperties.getDisplayName(), username));
                                ServiceProviderFactory.this.auditLogFacade.loginFailed(username, "SAML", "Account not found in " + ServiceProviderFactory.this.applicationProperties.getDisplayName());
                            }
                        } else if (!(!this.userExistInJITDirectory(jitDirectory.get(), evaluationResult) || principalEntry.getUserState() != PrincipalEntry.UserState.FOUND && principalEntry.getUserState() != PrincipalEntry.UserState.INACTIVE || this.samlIdpConfiguration.getUserUpdateNamePolicy() != IdpConfiguration.UserUpdateNamePolicy.UPDATE_NAME && this.samlIdpConfiguration.getUserUpdateEmailPolicy() != IdpConfiguration.UserUpdateEmailPolicy.UPDATE_EMAIL && this.samlIdpConfiguration.getUserActivatePolicy() != IdpConfiguration.UserActivatePolicy.ACTIVATE)) {
                            ServiceProviderFactory.this.responseEvaluator.updateUser(evaluationResult.getUserProfile(), jitDirectory.get(), errors, userRecipe, this.samlIdpConfiguration.getUserUpdateNamePolicy(), this.samlIdpConfiguration.getUserUpdateEmailPolicy(), this.samlIdpConfiguration.getUserActivatePolicy(), principalEntry.getUserState(), IdpConfiguration.SSOProtocol.SAML);
                            if (this.samlIdpConfiguration.getUserActivatePolicy() == IdpConfiguration.UserActivatePolicy.ACTIVATE) {
                                Principal p = principalEntry.getPrincipal().get();
                                principalEntry = new PrincipalEntry(p, PrincipalEntry.UserState.FOUND);
                            }
                        }
                        io.vavr.collection.Map rawSamlAttributes = List.ofAll(evaluationResult.getAttributeInfos()).toMap(AttributeInfo::getName, AttributeInfo::getValue);
                        Option.of((Object)this.samlIdpConfiguration).filter(idp -> idp.getUserNotFoundPolicy() == IdpConfiguration.UserNotFoundPolicy.CREATE || idp.getUserUpdateNamePolicy() == IdpConfiguration.UserUpdateNamePolicy.UPDATE_NAME || idp.getUserUpdateEmailPolicy() == IdpConfiguration.UserUpdateEmailPolicy.UPDATE_EMAIL).peek(idp -> io.vavr.collection.HashMap.ofAll(idp.getUserProfileKeyMap()).filterValues(StringUtils::isNotBlank).mapValues(arg_0 -> ((io.vavr.collection.Map)rawSamlAttributes).get(arg_0)).filterValues(Option::isDefined).mapValues(Option::get).forEach((key, value) -> ServiceProviderFactory.this.hostApp.setUserProfileValue(username, (String)key, (String)value)));
                    } else {
                        if (this.samlIdpConfiguration.isAuthenticatedAnonymousBrowsingEnabled()) {
                            this.addAuthenticatedAnonymousBrowsingSession(result, username);
                            return;
                        }
                        errors.add(String.format("Count not create or update user %s with Just-in-time provisioning (JIT). JIT directory is not specified.", username));
                    }
                    if (principalEntry != null && principalEntry.getPrincipal().isPresent()) {
                        Principal principal = principalEntry.getPrincipal().get();
                        Directory userDirectory = evaluationResult.getResolvedUserDirectory();
                        if (userDirectory != null && userDirectory.getType() == DirectoryType.CROWD) {
                            try {
                                ServiceProviderFactory.this.authenticateUserInCrowdSSO(principal, userDirectory);
                            }
                            catch (OperationFailedException e) {
                                ServiceProviderFactory.this.renderErrors(Collections.singletonList(String.format("Failed to authenticate user %s in remote Crowd directory", username)), result);
                                ServiceProviderFactory.this.auditLogFacade.loginFailed(principal.getName(), "SAML", "Failed to authenticate user in remote Crowd directory.");
                                return;
                            }
                        }
                        if (!this.updateGroupMemberships(evaluationResult, principal, username)) {
                            errors.add(String.format("Failed updating group memberships for user %s", username));
                            ServiceProviderFactory.this.auditLogFacade.loginFailed(principal.getName(), "SAML", "Failed updating group memberships for user.");
                        } else {
                            boolean canLogin;
                            boolean isPrincipalFound;
                            HttpServletRequest request = result.getRequest();
                            boolean bl = isPrincipalFound = principalEntry.getUserState() == PrincipalEntry.UserState.FOUND;
                            if (isPrincipalFound) {
                                ServiceProviderFactory.this.hostApp.publishUserAuthenticatedEvent(principalEntry.getPrincipal().get());
                            }
                            if ((canLogin = ServiceProviderFactory.this.hostApp.canLogin(principal, request)) && isPrincipalFound) {
                                CookieUtil.setLastIdpAccountCookie(this.samlIdpConfiguration.getId(), result.getRequest(), result.getResponse());
                                ServiceProviderFactory.this.hostApp.authenticateWithProduct(request, result.getResponse(), principal);
                                WebSudoServlet.setForcedAuthSessionId(request, this.samlIdpConfiguration.getId());
                                request.getSession(true).setAttribute("ksso.saml.idp.id", (Object)this.samlIdpConfiguration.getId());
                                request.getSession(true).setAttribute("ksso.saml.session.user", (Object)username);
                                result.getSessionIdentification().ifPresent(sessionIdentification -> {
                                    String json = SessionIdentificationHelper.toJson(sessionIdentification);
                                    request.getSession(true).setAttribute(ServiceProviderFactory.SESSION_IDENTIFICATION_KEY, (Object)json);
                                });
                                if (ServiceProviderFactory.this.kerbConfManager.isRemembermeCookieEnabled()) {
                                    HttpServletResponse response = result.getResponse();
                                    ServiceProviderFactory.this.hostApp.setRememberMeCookie(request, response, principal.getName());
                                }
                                String relayState = result.getRelayState();
                                String targetUrl = (String)request.getSession().getAttribute(ServiceProviderFactory.INSTANT_LOGIN_TARGET_URL);
                                if (ServiceProviderFactory.this.idpConfManager.isInstantLoginUrlInSession(this.samlIdpConfiguration.getId()) && StringUtils.isNotBlank((CharSequence)targetUrl)) {
                                    relayState = targetUrl;
                                    request.getSession().removeAttribute(ServiceProviderFactory.INSTANT_LOGIN_TARGET_URL);
                                    log.debug("Using redirect URL from web session since this is enabled in Advanced SAML settings");
                                }
                                if (relayState != null && !"None".equals(relayState)) {
                                    if (StringUtils.startsWith((CharSequence)relayState, (CharSequence)(request.getContextPath() + "/plugins/servlet/no.kantega.saml/sp/"))) {
                                        relayState = request.getContextPath() + "/";
                                    }
                                    ServiceProviderFactory.this.safeRedirect.sendRedirect(relayState.replaceAll(" ", "+"), request, result.getResponse());
                                } else {
                                    result.getResponse().sendRedirect(request.getContextPath() + "/");
                                }
                                ServiceProviderFactory.this.auditLogFacade.loginSuccess(principal.getName(), "SAML with IdP: " + this.samlIdpConfiguration.getName() + ", id: " + this.samlIdpConfiguration.getId());
                                return;
                            }
                            if (!canLogin) {
                                errors.add(String.format("Account %s does not have permission to use %s", username, ServiceProviderFactory.this.applicationProperties.getDisplayName()));
                                ServiceProviderFactory.this.auditLogFacade.loginFailed(principal.getName(), "SAML", String.format("Account does not have permission to use %s", ServiceProviderFactory.this.applicationProperties.getDisplayName()));
                            }
                            if (principalEntry.getUserState() == PrincipalEntry.UserState.INACTIVE) {
                                errors.add(String.format("User %s is not active", principal.getName()));
                                ServiceProviderFactory.this.auditLogFacade.loginFailed(principal.getName(), "SAML", "User is not active.");
                            }
                        }
                    } else {
                        if (this.samlIdpConfiguration.isAuthenticatedAnonymousBrowsingEnabled()) {
                            this.addAuthenticatedAnonymousBrowsingSession(result, username);
                            return;
                        }
                        errors.add(String.format("Principal (account) for %s not found. Unable to authenticate user", username));
                    }
                }
                ServiceProviderFactory.this.renderErrors(errors, result);
            }
        }

        private boolean userExistInJITDirectory(Directory directory, SAMLResponseEvaluationResult evaluationResult) {
            return directory.getId().equals(evaluationResult.getResolvedUserDirectory().getId());
        }

        private PrincipalEntry createUser(Directory directory, java.util.List<String> errors, SAMLResponseEvaluationResult evaluationResult, PrincipalEntry principalEntry, UserRecipe userRecipe, String usernameFromIdp) {
            String username = evaluationResult.getSearchedUsername();
            if (userRecipe != null && userRecipe.isComplete()) {
                try {
                    if (IdpConfManager.hasRequiredGroupsForCreation(this.samlIdpConfiguration, evaluationResult.getGroupEvaluation())) {
                        this.addUser(userRecipe, directory, usernameFromIdp);
                        principalEntry = new PrincipalEntry(ServiceProviderFactory.this.userManager.resolve(userRecipe.getUsername().getValue()), PrincipalEntry.UserState.FOUND);
                    } else if (this.samlIdpConfiguration.isManagedGroupsRequiredForJITCreation()) {
                        errors.add("Account could not be created. User did not have any managed groups in the group assertions from " + this.samlIdpConfiguration.getName());
                        ServiceProviderFactory.this.auditLogFacade.loginFailed(evaluationResult.getSearchedUsername(), "SAML", "Account could not be created. User did not have any managed groups in the group assertions from " + this.samlIdpConfiguration.getName());
                    } else if (this.samlIdpConfiguration.getAutoCreateUserPolicy() == IdpConfiguration.AutoCreateUserPolicy.MATCHED_GROUPS) {
                        errors.add("Account could not be created. User did not have any matched auto create groups in the group assertions from " + this.samlIdpConfiguration.getName());
                        ServiceProviderFactory.this.auditLogFacade.loginFailed(evaluationResult.getSearchedUsername(), "SAML", "Account could not be created. User did not have any matched auto create groups in the group assertions from " + this.samlIdpConfiguration.getName());
                    }
                }
                catch (Exception e) {
                    UUID uuid = UUID.randomUUID();
                    String message = String.format("Failed creating account for SAML user %s in directory \"%s\" (Log correlation ID: %s). %s", userRecipe.getUsername().getValue(), directory.getName(), uuid, this.samlIdpConfiguration.getMessageIfJitDirIsAD(userRecipe, ServiceProviderFactory.this.hostApp));
                    ServiceProviderFactory.this.auditLogFacade.loginFailed(username, "SAML", message);
                    log.error(message, (Throwable)e);
                    errors.add(message);
                }
            } else if (userRecipe == null) {
                errors.add(String.format("Account cannot be created because of missing user recipe, username %s", username));
                ServiceProviderFactory.this.auditLogFacade.loginFailed(username, "SAML", "Account can not be created because of missing user recipe.");
            } else {
                if (userRecipe.getName() == null) {
                    errors.add(String.format("Account cannot be created because no name attribute were included in the SAML response, username %s", username));
                    ServiceProviderFactory.this.auditLogFacade.loginFailed(username, "SAML", "Account can not be created because configured name attribute was not included in the SAML response.");
                }
                if (userRecipe.getEmail() == null) {
                    errors.add(String.format("Account cannot be created because no email attribute was included in the SAML response, username %s", username));
                    ServiceProviderFactory.this.auditLogFacade.loginFailed(username, "SAML", "Account can not be created because configured email attribute was not included in the SAML response.");
                }
            }
            return principalEntry;
        }

        public void logoutSuccess(SamlLogoutValidationResult result) throws IOException {
            HttpServletResponse res = result.getResponse();
            HttpServletRequest req = result.getRequest();
            String id = this.getIdentityProviderId();
            SamlIdpConfiguration cfg = ServiceProviderFactory.this.idpConfManager.getSamlIdpById(id);
            String returnUrl = cfg.getSingleLogoutReturnURL();
            if (StringUtils.isNotBlank((CharSequence)returnUrl)) {
                res.sendRedirect(returnUrl);
            } else {
                ServiceProviderFactory.this.logoutAppHelper.dispatchToLogoutConfirmed(req, res, id);
            }
        }

        public void invalidateSession(HttpServletRequest req, HttpServletResponse res) {
            ServiceProviderFactory.this.hostApp.invalidateSession(res, req);
        }

        public void logoutFailed(SamlLogoutValidationResult result) throws IOException {
            ArrayList errs = new ArrayList();
            HttpServletResponse resp = result.getResponse();
            result.getResults().forEach(r -> {
                String ts = r.getType().name();
                errs.add(ts);
                log.debug("logoutFailed: {} => {}", (Object)ts, (Object)String.join((CharSequence)",", r.getModel().keySet()));
            });
            ServiceProviderFactory.this.renderLogoutErrors(result, resp);
        }

        private void addAuthenticatedAnonymousBrowsingSession(SamlResponseValidationResult result, String username) throws IOException {
            ServiceProviderFactory.this.hostApp.addAuthenticatedAnonymousBrowsingSession(username, this.samlIdpConfiguration, result.getRequest(), result.getResponse());
            log.debug("Added authenticated anonymous browsing session after verified SAML login for: " + (String)Option.of((Object)username).getOrElse((Object)"[anonymous]"));
            ServiceProviderFactory.this.auditLogFacade.loginSuccess((String)Option.of((Object)username).getOrElse((Object)"[anonymous]"), "Authenticated anonymous browsing SAML with IdP: " + this.samlIdpConfiguration.getName() + ", id: " + this.samlIdpConfiguration.getId());
        }

        private void addUser(UserRecipe userRecipe, Directory dir, String usernameFromIdp) {
            try {
                ServiceProviderFactory.this.hostApp.addUser(dir, ServiceProviderFactory.this.hostApp.normalizeUsername(userRecipe.getUsername().getValue()), userRecipe.getName().getValue(), userRecipe.getEmail().getValue(), this.samlIdpConfiguration.getDefaultGroupsFilteredForUser(usernameFromIdp), true);
            }
            catch (UserAlreadyExistsException e) {
                log.warn("Was unable to create user {} with just-in-time provisioning because the user already exist locally. Make sure your user directores are synchronized. ", (Object)ServiceProviderFactory.this.hostApp.normalizeUsername(userRecipe.getUsername().getValue()));
            }
        }

        boolean updateGroupMemberships(SAMLResponseEvaluationResult evaluationResult, Principal principal, String usernameFromIdp) {
            GroupEvaluation groupEvaluation = evaluationResult.getGroupEvaluation();
            if (this.samlIdpConfiguration.isCreateAllIncomingGroups() && groupEvaluation.syncUserIdpGroups(ServiceProviderFactory.this.hostApp, principal, this.samlIdpConfiguration.isRemoveNonIdpGroupsFromUser(), this.samlIdpConfiguration.getDefaultGroupsFilteredForUser(usernameFromIdp))) {
                return false;
            }
            Set<String> defaultGroupsForUser = this.samlIdpConfiguration.getDefaultGroupsFilteredForUser(usernameFromIdp);
            if (groupEvaluation.setManagedGroups(ServiceProviderFactory.this.hostApp, principal, defaultGroupsForUser)) {
                return groupEvaluation.setDefaultGroups(ServiceProviderFactory.this.hostApp, principal, defaultGroupsForUser);
            }
            return false;
        }

        public int getIssueInstantLifeTimeMs() {
            return 30000;
        }

        public boolean isForceAuthn(HttpServletRequest request) {
            log.debug("WebSudo isForceAuthn queryString: {}", (Object)request.getQueryString());
            return this.isTest(request) && request.getParameter("force") != null || StringUtils.contains((CharSequence)request.getQueryString(), (CharSequence)"ForceAuthn=true");
        }

        public String getRelayState(HttpServletRequest request, LogoutRequest logoutRequest) {
            return null;
        }

        public String getRelayState(HttpServletRequest request, AuthnRequest authnRequest) {
            String target = request.getParameter("target");
            if (target != null) {
                target = target.replaceAll(" ", "%20");
                return target.replaceAll("~", "%7E");
            }
            if (this.isTest(request)) {
                try {
                    String authnRequestFormatted = XmlUtils.formatXml(XMLObjectSupport.marshall((XMLObject)authnRequest));
                    ServiceProviderFactory.this.idpConfManager.recordTestStarted(this.samlIdpConfiguration.getId(), authnRequest.getID(), authnRequestFormatted, ServiceProviderFactory.this.kerbConfManager.getRemoteIpAddress(request));
                }
                catch (MarshallingException e) {
                    throw new RuntimeException(e);
                }
                return "test";
            }
            return null;
        }

        public boolean isEncryptedAssertionsRequired() {
            return this.samlIdpConfiguration.isEncryptedAssertionsRequired();
        }

        public boolean isSingleLogoutEnabled() {
            return this.samlIdpConfiguration.isSingleLogoutEnabled();
        }

        public String getIdpSingleLogoutServiceURL() {
            return this.samlIdpConfiguration.getSingleLogoutServiceURL();
        }

        private boolean isTest(SamlResponseValidationResult result) {
            return "test".equals(result.getRelayState());
        }

        private boolean isTest(HttpServletRequest request) {
            return TestUtils.isTest(request);
        }
    }
}

