/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.kantegasso.jsonmapping.JsonMapping;
import com.kantegasso.oidc.OidcData;
import com.kantegasso.runtimetrust.Fingerprint;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.collection.HashSet;
import io.vavr.collection.List;
import io.vavr.control.Either;
import io.vavr.control.Try;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;
import org.json.JSONObject;
import org.kantega.atlaskerb.DebugInfo;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.identityproviders.FederatedIdentityResponseEvaluationResult;
import org.kantega.atlaskerb.identityproviders.GroupEvaluation;
import org.kantega.atlaskerb.identityproviders.GroupResult;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.ManagedGroup;
import org.kantega.atlaskerb.identityproviders.ResponseEvaluationCode;
import org.kantega.atlaskerb.identityproviders.oidc.OidcIdpConfiguration;
import org.kantega.atlaskerb.identityproviders.oidc.OidcLibWrapper;
import org.kantega.atlaskerb.identityproviders.oidc.evaluation.OidcResponseEvaluationResult;
import org.kantega.atlaskerb.identityproviders.oidc.evaluation.OidcTestRecord;
import org.kantega.atlaskerb.identityproviders.saml.evaluation.SAMLResponseEvaluationResult;
import org.kantega.atlaskerb.saml.CertDetails;
import org.kantega.atlaskerb.saml.CertTool;
import org.kantega.atlaskerb.saml.SamlIdpConfiguration;
import org.kantega.atlaskerb.saml.SamlXmlParser;
import org.kantega.atlaskerb.saml.TestRecord;
import org.kantega.atlaskerb.saml.login.RedirectProperties;
import org.kantega.atlaskerb.security.XmlSecurity;
import org.kantega.atlaskerb.update.KssoUpdateManager;
import org.kantega.atlaskerb.utils.ErrorUtils;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.kantega.atlaskerb.utils.ListParseUtils;
import org.kantega.samllib.OpenSamlInit;
import org.kantega.samllib.tools.SamlKeyGenerator;
import org.kantega.samllib.validation.SAMLSessionIdentification;
import org.kantega.samllib.validation.SamlResponseValidationResult;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.x509.BasicX509Credential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Component
public class IdpConfManager
implements DebugInfo {
    public static final String IDENTITY_PROVIDERS_URL_ROOT = "providers";
    public static final String MFA_ATTRIBUTE = "mfaAttribute";
    public static final String MFA_REQUIRED = "mfaRequired";
    public static final String SINGLE_LOGOUT_SERVICE_URL = "singleLogoutServiceURL";
    public static final String SINGLE_LOGOUT_RETURN_URL = "singleLogoutReturnURL";
    public static final int IDP_ID_MAX_LENGTH = 20;
    public static final String ENCRYPTED_ASSERTIONS_REQUIRED = "encryptedAssertionsRequired";
    public static final String INSTANT_LOGINURL_IN_SESSION = "instantLoginUrlInSession";
    public static final String USE_POST_BINDING = "usePostBinding";
    private static final String IDP_URL = "idpURL";
    private static final String METADATA_URL = "metadataURL";
    private static final String SINGLE_LOGOUT_ENABLED = "singleLogoutEnabled";
    private static final String TLS_FINGERPRINT = "tlsFingerprint";
    private static final String NAME = "name";
    private static final String PROVIDER_ELEM = "provider";
    private static final String USER_NOT_FOUND_POLICY = "userNotFoundPolicy";
    private static final String OLD_USER_UPDATE_POLICY = "userUpdatePolicy";
    private static final String USER_UPDATE_NAME_POLICY = "userUpdateNamePolicy";
    private static final String USER_UPDATE_EMAIL_POLICY = "userUpdateEmailPolicy";
    private static final String USER_ACTIVATE_POLICY = "userActivatePolicy";
    private static final String DEFAULT_GROUPS = "defaultGroups";
    private static final String DEFAULT_GROUPS_RULES = "defaultGroupsRules";
    private static final String KNOWN_DOMAINS = "knownDomains";
    private static final String AUTO_UPDATE_KNOWN_DOMAINS = "autoAddKnownDomains";
    private static final String REDIRECT_GROUPS = "redirectGroups";
    private static final String JIT_DIRECTORY = "jitDirectory";
    private static final String USER_PROFILE_KEY_MAPPING = "userProfileKeyMapping";
    private static final String ENABLED = "enabled";
    private static final String USERNAME_ATTRIBUTE = "usernameAttribute";
    private static final String CUSTOM_USERNAME_ATTRIBUTE_NAME = "customUsernameAttributeName";
    private static final int DAY = 86400000;
    private static final String TEST_NOTIFICATIONS_EMAIL = "testNotificationEmailAddresses";
    private static final String USERNAME_POLICY = "usernamePolicy";
    private static final String REDIRECT_POLICY = "redirectPolicy";
    private static final String JSM_REDIRECT_PROPERTIES = "jsmRedirectProperties";
    private static final String CERTIFICATE = "certificate";
    private static final String VISIBLE = "visible";
    private static final String HOSTED_DOMAIN = "hostedDomain";
    private static final String SEND_LOGIN_HINT = "sendLoginHint";
    private static final String INVERT_REDIRECT_GROUPS = "invertRedirectGroups";
    private static final String USER_LOOKUP_ATTRIBUTE = "userLookupAttribute";
    private static final String USER_LOOKUP_TRANSFORM = "userLookupTransform";
    private static final String KIND = "kind";
    private static final String PROTOCOL = "protocol";
    private static final String BASE_URL = "baseURL";
    private static final String SAML_STATE_ID = "samlStateId";
    private static final String CUSTOM_NAME_ATTRIBUTE = "customNameAttribute";
    private static final String CUSTOM_GIVEN_NAME_ATTRIBUTE = "customGivenNameAttribute";
    private static final String CUSTOM_SURNAME_ATTRIBUTE = "customSurnameAttribute";
    private static final String NAME_ATTRIBUTE_MAPPING_FIELD = "nameAttributeMapping";
    private static final String CUSTOM_EMAIL_ATTRIBUTE = "customEmailAttribute";
    private static final String REQUESTED_AUTHN_CONTEXT_POLICY = "requestedAuthnContextPolicy";
    private static final String REQUESTED_AUTHN_CONTEXT_COMPARISON = "requestedAuthnContextComparison";
    private static final String AUTHN_CONTEXT_CLASS_REF = "authnContextClassRef";
    private static final String ISSUER_POLICY = "issuerPolicy";
    private static final String ISSUER = "issuer";
    private static final String CREATE_ALL_INCOMING_GROUPS = "createAllIncomingGroups";
    private static final String REMOVE_NON_IDP_GROUPS_FROM_USER = "removeNonIdpGroupsFromUser";
    private static final String MANAGED_GROUP = "managedGroup";
    private static final String AUTO_GROUP = "autoGroup";
    private static final String MANAGED_GROUPS_REQUIRED_FOR_USER_CREATION = "atLeastOneManagedGroupRequiredForJITCreation";
    private static final String AUTO_CREATE_USER_POLICY = "autoCreateUserPolicy";
    private static final String MATCHED_USER_DIRECTORIES = "userDirectories";
    private static final String ALLOW_CREATE = "allowCreate";
    private static final String NAMEID_FORMAT = "nameIdFormat";
    private static final String CUSTOM_NAMEID_FORMAT = "customNameIdFormat";
    private static final String REDIRECT_CUSTOM_PROGRESS_DELAY = "redirectCustomProgressDelay";
    private static final String USERNAME_PASSWORD_LOGIN_LINK_ENABLED = "usernamePasswordLoginLinkEnabled";
    private static final String LOGIN_ENABLED_FOR_JSD = "loginEnabledForJSD";
    private static final String INHERIT_REDIRECT_RULES_IN_JSM = "inheritRedirectRulesInJsm";
    private static final String REGEX_TUPLES = "regexTuples";
    private static final String KNOWN_AUTO_REDIRECT = "knownAutoRedirect";
    private static final String SESSION_IDENTIFICATION_VALIDATION_POLICY = "sessionIdentificationValidationPolicy";
    private static final String AUTO_REFRESH_METADATA_ENABLED = "autoRefreshMetadataEnabled";
    private static final String IDP_GROUPS_ATTRIBUTE = "idpGroupsAttribute";
    private static final String AUTHENTICATED_ANONYMOUS_BROWSING_ENABLED = "authenticatedAnonymousBrowsingEnabled";
    private static final String OIDC_CLIENT_ID = "oidcClientId";
    private static final String OIDC_CLIENT_SECRET = "oidcClientSecret";
    private static final String OIDC_CLIENT_SECRET_EXPIRY = "oidcClientSecretExpiry";
    private static final String OIDC_DISCOVERY_URL = "oidcDiscoveryUrl";
    private static final String OIDC_SCOPES = "oidcScopes";
    private static final String OIDC_ISSUER_ALLOWLIST = "oidcIssuerAllowList";
    private static final Logger log = LoggerFactory.getLogger(IdpConfManager.class);
    private final HostApp hostApp;
    private final ApplicationProperties applicationProperties;
    private final PluginSettings settings;
    private final PluginLicenseManager pluginLicenseManager;
    private final OidcLibWrapper oidcLibWrapper;
    private final AtomicReference<ProviderState> state = new AtomicReference();
    private final SecureRandom secureRandom = new SecureRandom();

    @Inject
    public IdpConfManager(@ComponentImport ApplicationProperties applicationProperties, @ComponentImport PluginSettingsFactory pluginSettingsFactory, @ComponentImport PluginLicenseManager pluginLicenseManager, OidcLibWrapper oidcLibWrapper, HostAppFactory hostAppFactory) {
        this.hostApp = hostAppFactory.getInstance();
        this.hostApp.setIdpConfManager(this);
        this.applicationProperties = applicationProperties;
        this.pluginLicenseManager = pluginLicenseManager;
        this.oidcLibWrapper = oidcLibWrapper;
        OpenSamlInit.init();
        this.settings = pluginSettingsFactory.createGlobalSettings();
        this.readState();
    }

    public static boolean hasRequiredGroupsForCreation(IdpConfiguration idp, GroupEvaluation groupEvaluation) {
        try {
            boolean idpConfiguredWithManagedGroups;
            log.debug("KSSO Group evaluation...");
            log.debug("KSSO groupEvaluation.getAllIdpGroupNames(): " + ListParseUtils.iterableToCommaSeparatedString(groupEvaluation.getAllIdpGroupNames()));
            log.debug("KSSO groupEvaluation.getManagedGroups(): " + (String)io.vavr.control.Option.of(groupEvaluation.getManagedGroups()).map(groups -> groups.stream().map(GroupResult::getName).collect(Collectors.toSet())).map(ListParseUtils::iterableToCommaSeparatedString).getOrElse((Object)"<empty>"));
            log.debug("KSSO groupEvaluation.getUnmanagedIdpGroups(): " + ListParseUtils.iterableToCommaSeparatedString(groupEvaluation.getUnmanagedIdpGroups()));
            log.debug("KSSO groupEvaluation.getUnknownIdpGroups(): " + ListParseUtils.iterableToCommaSeparatedString(groupEvaluation.getUnknownIdpGroups()));
            boolean bl = idpConfiguredWithManagedGroups = !idp.getManagedGroups().isEmpty();
            if (idp.isManagedGroupsRequiredForJITCreation() && idpConfiguredWithManagedGroups && !idp.isCreateAllIncomingGroups()) {
                boolean responseContainsManagedGroup = IdpConfManager.isResponseContainsManagedGroup(groupEvaluation.getManagedGroups());
                log.debug("Running KSSO Managed groups...");
                log.debug("KSSO Response contains managed group: " + responseContainsManagedGroup);
                return responseContainsManagedGroup;
            }
            if (idp.isCreateAllIncomingGroups()) {
                log.debug("Running KSSO Auto create groups...");
                log.debug("KSSO auto create user policy: " + (Object)((Object)idp.getAutoCreateUserPolicy()));
                if (idp.getAutoCreateUserPolicy() == IdpConfiguration.AutoCreateUserPolicy.MATCHED_GROUPS) {
                    boolean responseContainsAutoGroups = IdpConfManager.isResponseContainsAutoGroups(idp, groupEvaluation);
                    log.debug("KSSO Matched groups, responseContainsAutoGroups: " + responseContainsAutoGroups);
                    return responseContainsAutoGroups;
                }
                if (idp.getAutoCreateUserPolicy() == IdpConfiguration.AutoCreateUserPolicy.ANY_GROUP) {
                    boolean responseContainsGroups = IdpConfManager.isResponseContainsAnyGroup(groupEvaluation);
                    log.debug("Response contains group: " + responseContainsGroups);
                    return responseContainsGroups;
                }
                if (idp.getAutoCreateUserPolicy() == IdpConfiguration.AutoCreateUserPolicy.ALWAYS) {
                    log.debug("Always create user, creating user...");
                    return true;
                }
            }
            log.debug("Will create user, no groups required...");
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    private static boolean isResponseContainsAnyGroup(GroupEvaluation groupEvaluation) {
        Set groupNames = (Set)io.vavr.control.Option.of(groupEvaluation.getAllIdpGroupNames()).getOrElse(java.util.HashSet::new);
        return !groupNames.isEmpty();
    }

    private static boolean isResponseContainsManagedGroup(Collection<GroupResult> managedGroups) {
        return managedGroups.stream().anyMatch(GroupResult::isIdpGroupMember);
    }

    private static boolean isResponseContainsAutoGroups(IdpConfiguration idp, GroupEvaluation groupEvaluation) {
        List idpAutoGroups = (List)io.vavr.control.Option.of(idp.getAutoGroups()).map(List::ofAll).map(autoGroups -> autoGroups.map(ManagedGroup::getName)).getOrElse((Object)List.empty());
        List groupNames = (List)io.vavr.control.Option.of((Object)groupEvaluation).flatMap(evaluation -> io.vavr.control.Option.of(evaluation.getAllIdpGroupNames())).map(List::ofAll).getOrElse((Object)List.empty());
        return ListParseUtils.isListIntersection((List<String>)groupNames, (List<String>)idpAutoGroups);
    }

    public static boolean isValidIdpId(String id) {
        return io.vavr.control.Option.of((Object)id).filter(StringUtils::isNotBlank).filter(StringUtils::isAlphanumeric).filter(idStr -> idStr.length() <= 20).isDefined();
    }

    public Map<String, String> getSettings() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (KEYS keys : KEYS.values()) {
            Object value = this.settings.get(keys.key);
            if (!(value instanceof String)) continue;
            result.put(keys.key, (String)value);
        }
        return result;
    }

    public void restoreSettings(Properties props) {
        for (KEYS keys : KEYS.values()) {
            this.settings.remove(keys.key);
        }
        for (KEYS keys : KEYS.values()) {
            String value = props.getProperty(keys.key);
            if (value == null) continue;
            this.settings.put(keys.key, (Object)value);
        }
        this.updateStateId();
        this.currentState();
    }

    public void readState() {
        this.state.set(this.readState(this.currentStateId()));
    }

    private String currentStateId() {
        return (String)this.settings.get(KEYS.SAML_STATE_ID.key);
    }

    private void updateStateId() {
        String nextId = UUID.randomUUID().toString();
        this.settings.put(KEYS.SAML_STATE_ID.key, (Object)nextId);
    }

    private ProviderState readState(String stateId) {
        return new ProviderState(stateId, this.readIdpConfigurations(), this.readDrafts());
    }

    public Collection<IdpConfiguration> getIdentityProviders() {
        return this.currentState().getIdpConfigurations();
    }

    public boolean hasEnabledIdentityProviders() {
        return List.ofAll(this.getIdentityProviders()).exists(IdpConfiguration::isEnabled);
    }

    public boolean hasEnabledSamlProviders() {
        return List.ofAll(this.getIdentityProviders()).exists(idp -> idp.isEnabled() && idp.isSaml());
    }

    public Collection<JSONObject> getDrafts() {
        return this.currentState().getDrafts();
    }

    private ProviderState currentState() {
        String currentStateId;
        ProviderState cachedState = this.state.get();
        if (!cachedState.isCurrent(currentStateId = this.currentStateId())) {
            ProviderState nextState = this.readState(currentStateId);
            if (this.state.compareAndSet(cachedState, nextState)) {
                return nextState;
            }
            return this.state.get();
        }
        return cachedState;
    }

    private Collection<IdpConfiguration> readIdpConfigurations() {
        File providersDir = this.getProvidersDirectory();
        if (!providersDir.exists()) {
            return Collections.emptyList();
        }
        File[] providerDirs = providersDir.listFiles(file -> file.isDirectory() && this.getProviderXmlFile(file).exists());
        if (providerDirs == null) {
            return Collections.emptyList();
        }
        ArrayList<IdpConfiguration> configurations = new ArrayList<IdpConfiguration>();
        for (File providerDir : providerDirs) {
            File providerXmlFile = this.getProviderXmlFile(providerDir);
            try {
                IdpConfiguration provider = this.parseIdpProvider(providerXmlFile);
                configurations.add(provider);
            }
            catch (Exception e) {
                log.error("Exception parsing provider xml file: " + providerXmlFile.getAbsolutePath(), (Throwable)e);
            }
        }
        configurations.sort(Comparator.comparing(IdpConfiguration::getName));
        return configurations;
    }

    private Collection<JSONObject> readDrafts() {
        File draftsDir = this.getDraftsDirectory();
        if (!draftsDir.exists()) {
            return Collections.emptyList();
        }
        File[] providerDirs = draftsDir.listFiles(file -> file.isDirectory() && this.getDraftFile(file).exists());
        if (providerDirs == null) {
            return Collections.emptyList();
        }
        ArrayList<JSONObject> drafts = new ArrayList<JSONObject>();
        for (File providerDir : providerDirs) {
            File draftFile = this.getDraftFile(providerDir);
            try (InputStream is = Files.newInputStream(draftFile.toPath(), new OpenOption[0]);){
                String jsonText = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                JSONObject draft = new JSONObject(jsonText);
                boolean shouldShowDraft = io.vavr.control.Option.of((Object)draft.getJSONObject("commonWizardState")).map(json -> json.optString("submitStatus")).filter(StringUtils::isNotEmpty).filter(status -> !status.equals("submitted")).isDefined();
                if (!shouldShowDraft) continue;
                drafts.add(draft);
            }
            catch (Exception e) {
                log.error("Exception parsing draft json file: " + draftFile.getAbsolutePath(), (Throwable)e);
            }
        }
        return drafts;
    }

    private File getProviderXmlFile(File providerDir) {
        return new File(providerDir, "provider.xml");
    }

    private File getDraftFile(File providerDir) {
        return new File(providerDir, "provider_draft.json");
    }

    private IdpConfiguration parseIdpProvider(File providerFile) {
        RedirectProperties jsmRedirectProperties;
        Node tuplesNode;
        String issuer;
        SamlIdpConfiguration.RequestedAuthnContextPolicy requestedAuthnContextPolicy;
        String usernamePolicyName;
        String deprecatedUserUpdatePolicyName;
        String deprecatedUserUpdatePolicyName2;
        String userUpdateNamePolicyName;
        Document doc = SamlXmlParser.parseProviderDocument(providerFile);
        Element element = doc.getDocumentElement();
        String name = element.getAttribute(NAME);
        String idpURL = element.getAttribute(IDP_URL);
        Map userProfileKeyMapping = (Map)JsonMapping.Read.stringMapFromJson((String)element.getAttribute(USER_PROFILE_KEY_MAPPING)).getOrElse(HashMap::new);
        String mfaAttribute = (String)io.vavr.control.Option.of((Object)element.getAttribute(MFA_ATTRIBUTE)).getOrElse((Object)"");
        boolean mfaRequired = (Boolean)io.vavr.control.Option.of((Object)element.getAttribute(MFA_REQUIRED)).toTry().mapTry(Boolean::parseBoolean).getOrElse((Object)false);
        String userNotFoundPolicyName = element.getAttribute(USER_NOT_FOUND_POLICY);
        IdpConfiguration.UserNotFoundPolicy userNotFoundPolicy = IdpConfiguration.UserNotFoundPolicy.REJECT;
        if (StringUtils.isNotBlank((CharSequence)userNotFoundPolicyName)) {
            userNotFoundPolicy = IdpConfiguration.UserNotFoundPolicy.valueOf(userNotFoundPolicyName);
        }
        IdpConfiguration.UserUpdateNamePolicy userUpdateNamePolicy = StringUtils.isBlank((CharSequence)(userUpdateNamePolicyName = element.getAttribute(USER_UPDATE_NAME_POLICY))) ? (StringUtils.isNotBlank((CharSequence)(deprecatedUserUpdatePolicyName2 = element.getAttribute(OLD_USER_UPDATE_POLICY))) ? KssoUpdateManager.IdpConfigurationUpdate.convertNamePolicyFromOldConfig(IdpConfiguration.UserUpdatePolicy.valueOf(deprecatedUserUpdatePolicyName2)) : IdpConfiguration.UserUpdateNamePolicy.NONE) : IdpConfiguration.UserUpdateNamePolicy.valueOf(userUpdateNamePolicyName);
        String userUpdateEmailPolicyName = element.getAttribute(USER_UPDATE_EMAIL_POLICY);
        IdpConfiguration.UserUpdateEmailPolicy userUpdateEmailPolicy = StringUtils.isBlank((CharSequence)userUpdateNamePolicyName) ? (StringUtils.isNotBlank((CharSequence)(deprecatedUserUpdatePolicyName = element.getAttribute(OLD_USER_UPDATE_POLICY))) ? KssoUpdateManager.IdpConfigurationUpdate.convertEmailPolicyFromOldConfig(IdpConfiguration.UserUpdatePolicy.valueOf(deprecatedUserUpdatePolicyName)) : IdpConfiguration.UserUpdateEmailPolicy.NONE) : IdpConfiguration.UserUpdateEmailPolicy.valueOf(userUpdateEmailPolicyName);
        String autoCreateUserPolicyName = element.getAttribute(AUTO_CREATE_USER_POLICY);
        IdpConfiguration.AutoCreateUserPolicy autoCreateUserPolicy = (IdpConfiguration.AutoCreateUserPolicy)((Object)Try.of((CheckedFunction0 & Serializable)() -> IdpConfiguration.AutoCreateUserPolicy.valueOf(autoCreateUserPolicyName)).getOrElse(() -> (IdpConfiguration.AutoCreateUserPolicy)((Object)((Object)Try.of((CheckedFunction0 & Serializable)() -> Boolean.parseBoolean(element.getAttribute(MANAGED_GROUPS_REQUIRED_FOR_USER_CREATION)) ? IdpConfiguration.AutoCreateUserPolicy.ANY_GROUP : IdpConfiguration.AutoCreateUserPolicy.ALWAYS).getOrElse((Object)IdpConfiguration.AutoCreateUserPolicy.ALWAYS)))));
        String userActivatePolicyName = element.getAttribute(USER_ACTIVATE_POLICY);
        IdpConfiguration.UserActivatePolicy userActivatePolicy = IdpConfiguration.UserActivatePolicy.NONE;
        if (StringUtils.isNotBlank((CharSequence)userActivatePolicyName)) {
            userActivatePolicy = IdpConfiguration.UserActivatePolicy.valueOf(userActivatePolicyName);
        }
        String customUsernameAttributeName = element.getAttribute(CUSTOM_USERNAME_ATTRIBUTE_NAME);
        LinkedHashSet<String> defaultGroups = SamlXmlParser.parseSet(element.getAttribute(DEFAULT_GROUPS));
        Map defaultGroupsRules = (Map)JsonMapping.Read.stringMapFromJson((String)element.getAttribute(DEFAULT_GROUPS_RULES)).getOrElse(new HashMap());
        LinkedHashSet<String> knownDomains = SamlXmlParser.parseSet(element.getAttribute(KNOWN_DOMAINS));
        boolean autoUpdateKnownDomains = "true".equals(element.getAttribute(AUTO_UPDATE_KNOWN_DOMAINS));
        LinkedHashSet<String> redirectGroups = SamlXmlParser.parseSet(element.getAttribute(REDIRECT_GROUPS));
        String metadataURL = element.getAttribute(METADATA_URL);
        String tlsFingerprint = element.getAttribute(TLS_FINGERPRINT);
        String id = providerFile.getParentFile().getName();
        boolean enabled = !"false".equals(element.getAttribute(ENABLED));
        boolean singleLogoutEnabled = Boolean.parseBoolean(element.getAttribute(SINGLE_LOGOUT_ENABLED));
        String singleLogoutserviceURL = element.getAttribute(SINGLE_LOGOUT_SERVICE_URL);
        String singleLogoutReturnURL = element.getAttribute(SINGLE_LOGOUT_RETURN_URL);
        boolean authenticatedAnonymousBrowsingEnabled = Boolean.parseBoolean(element.getAttribute(AUTHENTICATED_ANONYMOUS_BROWSING_ENABLED));
        SAMLSessionIdentification.ValidationPolicy sessionIdentificationValidationPolicy = Optional.of(element.getAttribute(SESSION_IDENTIFICATION_VALIDATION_POLICY)).filter(StringUtils::isNotBlank).map(SAMLSessionIdentification.ValidationPolicy::valueOf).orElse(null);
        String notificationEmails = element.getAttribute(TEST_NOTIFICATIONS_EMAIL);
        if (notificationEmails.isEmpty()) {
            notificationEmails = null;
        }
        IdpConfiguration.UsernamePolicy usernamePolicy = StringUtils.isBlank((CharSequence)(usernamePolicyName = element.getAttribute(USERNAME_POLICY))) ? IdpConfiguration.UsernamePolicy.ANY : IdpConfiguration.UsernamePolicy.valueOf(usernamePolicyName);
        boolean encryptedAssertionsRequired = Optional.ofNullable(element.getAttribute(ENCRYPTED_ASSERTIONS_REQUIRED)).map(Boolean::valueOf).orElse(false);
        boolean instantLoginUrlInSession = Optional.ofNullable(element.getAttribute(INSTANT_LOGINURL_IN_SESSION)).map(Boolean::valueOf).orElse(false);
        boolean usePostBinding = Optional.ofNullable(element.getAttribute(USE_POST_BINDING)).map(Boolean::valueOf).orElse(false);
        ArrayList<byte[]> certs = new ArrayList<byte[]>();
        NodeList certList = element.getElementsByTagName(CERTIFICATE);
        for (int i = 0; i < certList.getLength(); ++i) {
            Element certE = (Element)certList.item(i);
            certs.add(Base64.decodeBase64((String)certE.getTextContent()));
        }
        boolean visible = "true".equals(element.getAttribute(VISIBLE));
        boolean hostedDomain = "true".equals(element.getAttribute(HOSTED_DOMAIN));
        boolean sendLoginHint = !"false".equals(element.getAttribute(SEND_LOGIN_HINT));
        boolean invertUserGroupMatch = "true".equals(element.getAttribute(INVERT_REDIRECT_GROUPS));
        String userLookupVal = element.getAttribute(USER_LOOKUP_ATTRIBUTE);
        IdpConfiguration.UserLookupAttribute userLookupAttribute = IdpConfiguration.UserLookupAttribute.USERNAME;
        if (!userLookupVal.isEmpty()) {
            userLookupAttribute = IdpConfiguration.UserLookupAttribute.valueOf(userLookupVal);
        }
        String userLookupTransformVal = element.getAttribute(USER_LOOKUP_TRANSFORM);
        IdpConfiguration.UserLookupTransform userLookupTransform = IdpConfiguration.UserLookupTransform.NONE;
        if (!userLookupTransformVal.isEmpty()) {
            userLookupTransform = IdpConfiguration.UserLookupTransform.valueOf(userLookupTransformVal);
        }
        IdpConfiguration.Kind kind = (IdpConfiguration.Kind)((Object)Try.of((CheckedFunction0 & Serializable)() -> element.getAttribute(KIND)).filter(StringUtils::isNotBlank).mapTry(IdpConfiguration.Kind::valueOf).getOrElse((Object)IdpConfiguration.Kind.GENERIC));
        IdpConfiguration.SSOProtocol protocol = IdpConfiguration.SSOProtocol.SAML;
        String protocolAttr = element.getAttribute(PROTOCOL);
        if (!protocolAttr.isEmpty()) {
            protocol = IdpConfiguration.SSOProtocol.valueOf(protocolAttr);
        }
        IdpConfiguration.RedirectPolicy redirectPolicy = IdpConfiguration.RedirectPolicy.ALL;
        String redirectPolicyVal = element.getAttribute(REDIRECT_POLICY);
        if (!redirectPolicyVal.isEmpty() && (redirectPolicy = IdpConfiguration.RedirectPolicy.valueOf(redirectPolicyVal)) == IdpConfiguration.RedirectPolicy.MANUAL) {
            redirectPolicy = !knownDomains.isEmpty() ? IdpConfiguration.RedirectPolicy.KNOWN_DOMAIN : IdpConfiguration.RedirectPolicy.USER_DIRECTORY;
        }
        String customNameAttribute = element.getAttribute(CUSTOM_NAME_ATTRIBUTE);
        String customGivenNameAttribute = element.getAttribute(CUSTOM_GIVEN_NAME_ATTRIBUTE);
        String customSurnameAttribute = element.getAttribute(CUSTOM_SURNAME_ATTRIBUTE);
        NAME_ATTRIBUTE_MAPPING nameAttributeMapping = "FIRST_AND_LAST_NAME".equals(element.getAttribute(NAME_ATTRIBUTE_MAPPING_FIELD)) ? NAME_ATTRIBUTE_MAPPING.FIRST_AND_LAST_NAME : NAME_ATTRIBUTE_MAPPING.FULL_NAME;
        String customEmailAttribute = element.getAttribute(CUSTOM_EMAIL_ATTRIBUTE);
        SamlIdpConfiguration.RequestedAuthnContextComparison requestedAuthnContextComparison = SamlIdpConfiguration.RequestedAuthnContextComparison.EXACT;
        String authnContextClassRef = element.getAttribute(AUTHN_CONTEXT_CLASS_REF);
        String requestedAuthnContextPolicyVal = element.getAttribute(REQUESTED_AUTHN_CONTEXT_POLICY);
        if (requestedAuthnContextPolicyVal.isEmpty()) {
            requestedAuthnContextPolicy = SamlIdpConfiguration.RequestedAuthnContextPolicy.CUSTOM;
            authnContextClassRef = "urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport";
            if (kind == IdpConfiguration.Kind.AZURE_AD) {
                requestedAuthnContextPolicy = SamlIdpConfiguration.RequestedAuthnContextPolicy.DO_NOT_SEND;
            }
        } else {
            requestedAuthnContextPolicy = SamlIdpConfiguration.RequestedAuthnContextPolicy.valueOf(requestedAuthnContextPolicyVal);
            String requestedAuthnContextComparisonVal = element.getAttribute(REQUESTED_AUTHN_CONTEXT_COMPARISON);
            if (!requestedAuthnContextComparisonVal.isEmpty()) {
                requestedAuthnContextComparison = SamlIdpConfiguration.RequestedAuthnContextComparison.valueOf(requestedAuthnContextComparisonVal);
            }
            if (authnContextClassRef.isEmpty()) {
                authnContextClassRef = "urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport";
            }
        }
        SamlIdpConfiguration.IssuerPolicy issuerPolicy = SamlIdpConfiguration.IssuerPolicy.DEFAULT;
        String issuerPolicyVal = element.getAttribute(ISSUER_POLICY);
        if (!issuerPolicyVal.isEmpty()) {
            issuerPolicy = SamlIdpConfiguration.IssuerPolicy.valueOf(issuerPolicyVal);
        }
        if ((issuer = element.getAttribute(ISSUER)).isEmpty()) {
            issuer = null;
        }
        IdpConfiguration.AllowCreate allowCreate = IdpConfiguration.AllowCreate.TRUE;
        String allowCreateVal = element.getAttribute(ALLOW_CREATE);
        if (!allowCreateVal.isEmpty()) {
            allowCreate = IdpConfiguration.AllowCreate.valueOf(allowCreateVal);
        }
        IdpConfiguration.NameIdFormat nameIdFormat = IdpConfiguration.NameIdFormat.DEFAULT;
        String nameIdFormatVal = element.getAttribute(NAMEID_FORMAT);
        if (!nameIdFormatVal.isEmpty()) {
            nameIdFormat = IdpConfiguration.NameIdFormat.valueOf(nameIdFormatVal);
        }
        String customNameIdFormat = element.getAttribute(CUSTOM_NAMEID_FORMAT);
        boolean createAllIncomingGroups = (Boolean)io.vavr.control.Option.of((Object)element.getAttribute(CREATE_ALL_INCOMING_GROUPS)).map(Boolean::valueOf).getOrElse((Object)false);
        boolean removeNonIdpGroupsFromUser = (Boolean)io.vavr.control.Option.of((Object)element.getAttribute(REMOVE_NON_IDP_GROUPS_FROM_USER)).map(Boolean::valueOf).getOrElse((Object)false);
        boolean autoRefreshMetadataEnabled = (Boolean)io.vavr.control.Option.of((Object)element.getAttribute(AUTO_REFRESH_METADATA_ENABLED)).map(Boolean::valueOf).getOrElse((Object)false);
        ArrayList<ManagedGroup> managedGroups = new ArrayList<ManagedGroup>(SamlXmlParser.parseGroups(element.getElementsByTagName(MANAGED_GROUP)).values());
        ArrayList<ManagedGroup> autoGroups = new ArrayList<ManagedGroup>(SamlXmlParser.parseGroups(element.getElementsByTagName(AUTO_GROUP)).values());
        boolean atLeastOneManagedGroupRequiredForJITCreation = false;
        String atLeastOneManagedGroupRequiredVal = element.getAttribute(MANAGED_GROUPS_REQUIRED_FOR_USER_CREATION);
        if (!atLeastOneManagedGroupRequiredVal.isEmpty()) {
            atLeastOneManagedGroupRequiredForJITCreation = Boolean.parseBoolean(atLeastOneManagedGroupRequiredVal);
        }
        TreeSet<Long> matchedUserDirectoryIds = new TreeSet<Long>(SamlXmlParser.parseLongSet(element.getAttribute(MATCHED_USER_DIRECTORIES)));
        boolean knownAutoRedirect = !"false".equals(element.getAttribute(KNOWN_AUTO_REDIRECT));
        NodeList regexTuplesNodeList = element.getElementsByTagName(REGEX_TUPLES);
        ArrayList<Pair<String, String>> regexTuples = new ArrayList();
        if (regexTuplesNodeList != null && (tuplesNode = element.getElementsByTagName(REGEX_TUPLES).item(0)) != null) {
            NodeList tupleNodeList = tuplesNode.getChildNodes();
            regexTuples = SamlXmlParser.parseRegexTuples(tupleNodeList);
        }
        Optional<Long> jitDirectory = StringUtils.isNotBlank((CharSequence)element.getAttribute(JIT_DIRECTORY)) && StringUtils.isNumeric((CharSequence)element.getAttribute(JIT_DIRECTORY)) ? Optional.of(Long.valueOf(element.getAttribute(JIT_DIRECTORY))) : Optional.empty();
        java.util.HashSet<String> idpGroupsAttributes = new java.util.HashSet<String>(Arrays.asList(element.getAttribute(IDP_GROUPS_ATTRIBUTE).split(",")));
        idpGroupsAttributes.removeIf(it -> StringUtils.equals((CharSequence)it, (CharSequence)""));
        RedirectProperties redirectProperties = new RedirectProperties(redirectPolicy, redirectGroups, sendLoginHint, knownAutoRedirect, visible, matchedUserDirectoryIds, invertUserGroupMatch);
        Element jsmRedirectPropertiesElement = (Element)element.getElementsByTagName(JSM_REDIRECT_PROPERTIES).item(0);
        if (jsmRedirectPropertiesElement != null) {
            IdpConfiguration.RedirectPolicy jsmRedirectPolicy = IdpConfiguration.RedirectPolicy.ALL;
            String jsmRedirectPolicyVal = jsmRedirectPropertiesElement.getAttribute(REDIRECT_POLICY);
            if (!jsmRedirectPolicyVal.isEmpty()) {
                jsmRedirectPolicy = IdpConfiguration.RedirectPolicy.valueOf(jsmRedirectPolicyVal);
            }
            LinkedHashSet<String> jsmRedirectGroups = SamlXmlParser.parseSet(jsmRedirectPropertiesElement.getAttribute(REDIRECT_GROUPS));
            boolean jsmSendLoginHint = !"false".equals(jsmRedirectPropertiesElement.getAttribute(SEND_LOGIN_HINT));
            boolean jsmKnownAutoRedirect = !"false".equals(jsmRedirectPropertiesElement.getAttribute(KNOWN_AUTO_REDIRECT));
            TreeSet<Long> jsmMatchedUserDirectoryIds = new TreeSet<Long>(SamlXmlParser.parseLongSet(jsmRedirectPropertiesElement.getAttribute(MATCHED_USER_DIRECTORIES)));
            boolean jsmVisible = "true".equals(jsmRedirectPropertiesElement.getAttribute(VISIBLE));
            boolean jsmInvertUserGroupMatch = "true".equals(jsmRedirectPropertiesElement.getAttribute(INVERT_REDIRECT_GROUPS));
            jsmRedirectProperties = new RedirectProperties(jsmRedirectPolicy, jsmRedirectGroups, jsmSendLoginHint, jsmKnownAutoRedirect, jsmVisible, jsmMatchedUserDirectoryIds, jsmInvertUserGroupMatch);
        } else {
            jsmRedirectProperties = redirectProperties;
        }
        if (protocol == IdpConfiguration.SSOProtocol.OIDC) {
            java.util.HashSet scopes;
            String clientId = element.getAttribute(OIDC_CLIENT_ID);
            String clientSecret = element.getAttribute(OIDC_CLIENT_SECRET);
            Long clientSecretExpiry = Long.parseLong(element.getAttribute(OIDC_CLIENT_SECRET_EXPIRY));
            String discoveryUrl = element.getAttribute(OIDC_DISCOVERY_URL);
            String[] issuerAllowList = (String[])Try.of((CheckedFunction0 & Serializable)() -> element.getAttribute(OIDC_ISSUER_ALLOWLIST)).mapTry(StringUtils::deleteWhitespace).mapTry((CheckedFunction1 & Serializable)allowListAsStr -> StringUtils.split((String)allowListAsStr, (String)",")).getOrElse((Object)new String[0]);
            IdpConfiguration.UsernameAttribute usernameAttribute = kind.getDefaultUsernameAttribute(IdpConfiguration.SSOProtocol.OIDC);
            String usernameAttributeValue = element.getAttribute(USERNAME_ATTRIBUTE);
            if (StringUtils.isNotBlank((CharSequence)usernameAttributeValue)) {
                usernameAttribute = IdpConfiguration.UsernameAttribute.valueOf(usernameAttributeValue);
            }
            boolean shouldDoUpdate = false;
            if (!element.hasAttribute(OIDC_SCOPES)) {
                java.util.HashSet migrationScopes = new java.util.HashSet();
                Either<String, OidcData> maybeOidcData = this.oidcLibWrapper.createOidcData((io.vavr.collection.HashMap<String, Object>)io.vavr.collection.HashMap.of((Object)"discovery_url", (Object)discoveryUrl, (Object)"workaround", (Object)((Object)kind)));
                if (maybeOidcData.isLeft()) {
                    log.error(ErrorUtils.createErrorMessage("KSSO-811AXICDRJ", "Failed to run OIDC while parsing IdP: " + (String)maybeOidcData.getLeft()));
                } else {
                    OidcData oidcData = (OidcData)maybeOidcData.get();
                    Either<String, OidcData> maybeDiscovery = this.oidcLibWrapper.discover(oidcData);
                    if (maybeDiscovery.isLeft()) {
                        log.error(ErrorUtils.createErrorMessage("KSSO-Z5BGY9CVOF", "Failed to perform discovery while parsing IdP: " + (String)maybeDiscovery.getLeft()));
                    } else {
                        oidcData = (OidcData)maybeDiscovery.get();
                        List scopesSupported = oidcData.getScopesSupported();
                        HashSet upgradeScopes = HashSet.of((Object[])new String[]{"openid", "address", "email", "profile", "phone", NAME, "groups", "read:user", "user:email"});
                        migrationScopes = scopesSupported.isEmpty() ? upgradeScopes.toJavaSet() : upgradeScopes.filter(arg_0 -> ((List)scopesSupported).contains(arg_0)).toJavaSet();
                    }
                }
                scopes = migrationScopes;
                shouldDoUpdate = true;
            } else {
                scopes = SamlXmlParser.parseSet(element.getAttribute(OIDC_SCOPES));
            }
            OidcIdpConfiguration configuration = new OidcIdpConfiguration(mfaRequired, mfaAttribute, defaultGroups, defaultGroupsRules, autoUpdateKnownDomains, customEmailAttribute, customNameAttribute, customGivenNameAttribute, customSurnameAttribute, nameAttributeMapping, customUsernameAttributeName, enabled, id, jitDirectory, kind, knownDomains, createAllIncomingGroups, removeNonIdpGroupsFromUser, managedGroups, autoGroups, atLeastOneManagedGroupRequiredForJITCreation, name, notificationEmails, regexTuples, singleLogoutEnabled, singleLogoutReturnURL, userActivatePolicy, userLookupAttribute, userLookupTransform, usernameAttribute, usernamePolicy, userNotFoundPolicy, userUpdateNamePolicy, userUpdateEmailPolicy, autoCreateUserPolicy, hostedDomain, idpGroupsAttributes, userProfileKeyMapping, authenticatedAnonymousBrowsingEnabled, tlsFingerprint, clientId, clientSecret, clientSecretExpiry, discoveryUrl, scopes, issuerAllowList, redirectProperties, jsmRedirectProperties);
            if (shouldDoUpdate) {
                this.updateIdpConfiguration(configuration);
            }
            return configuration;
        }
        IdpConfiguration.UsernameAttribute usernameAttribute = kind.getDefaultUsernameAttribute(IdpConfiguration.SSOProtocol.SAML);
        String usernameAttributeValue = element.getAttribute(USERNAME_ATTRIBUTE);
        if (StringUtils.isNotBlank((CharSequence)usernameAttributeValue)) {
            usernameAttribute = IdpConfiguration.UsernameAttribute.valueOf(usernameAttributeValue);
        }
        return new SamlIdpConfiguration(mfaRequired, mfaAttribute, allowCreate, defaultGroups, defaultGroupsRules, autoUpdateKnownDomains, customEmailAttribute, customNameAttribute, customGivenNameAttribute, customSurnameAttribute, nameAttributeMapping, customUsernameAttributeName, enabled, id, jitDirectory, kind, knownDomains, createAllIncomingGroups, removeNonIdpGroupsFromUser, managedGroups, autoGroups, atLeastOneManagedGroupRequiredForJITCreation, name, notificationEmails, regexTuples, singleLogoutEnabled, userActivatePolicy, userLookupAttribute, userLookupTransform, usernameAttribute, usernamePolicy, userNotFoundPolicy, userUpdateNamePolicy, userUpdateEmailPolicy, autoCreateUserPolicy, hostedDomain, idpGroupsAttributes, userProfileKeyMapping, authenticatedAnonymousBrowsingEnabled, tlsFingerprint, authnContextClassRef, customNameIdFormat, encryptedAssertionsRequired, instantLoginUrlInSession, usePostBinding, idpURL, issuer, issuerPolicy, metadataURL, nameIdFormat, sessionIdentificationValidationPolicy, certs, singleLogoutserviceURL, singleLogoutReturnURL, requestedAuthnContextComparison, requestedAuthnContextPolicy, autoRefreshMetadataEnabled, redirectProperties, jsmRedirectProperties);
    }

    public File getProvidersDirectory() {
        return new File(this.getSamlDirectory(), IDENTITY_PROVIDERS_URL_ROOT);
    }

    public File getDraftsDirectory() {
        return new File(this.getSamlDirectory(), "drafts");
    }

    private File getSamlDirectory() {
        return new File(this.hostApp.getHomeDirectory(), "saml");
    }

    public void addIdpConfiguration(IdpConfiguration config) {
        String id = config.getId();
        this.ensureKeysExist(config.getName());
        this.getProviderDirectory(id).mkdirs();
        this.persistProvider(config);
    }

    public void updateIdpConfiguration(IdpConfiguration config) {
        this.getProviderDirectory(config.getId()).mkdirs();
        this.persistProvider(config);
    }

    String generateSamlPrivateKeyPassword() {
        byte[] passwordBytes = new byte[32];
        this.secureRandom.nextBytes(passwordBytes);
        return Fingerprint.sha1Fingerprint((byte[])passwordBytes);
    }

    public int getRedirectProgressDelay() {
        try {
            return Integer.parseInt((String)this.settings.get(REDIRECT_CUSTOM_PROGRESS_DELAY));
        }
        catch (Exception exception) {
            return 2;
        }
    }

    public void setRedirectProgressDelay(String delaySeconds) {
        int savedSeconds = 2;
        try {
            savedSeconds = Integer.parseInt(delaySeconds);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.settings.put(REDIRECT_CUSTOM_PROGRESS_DELAY, (Object)("" + savedSeconds));
    }

    public boolean getUsernamePasswordLinkEnabled() {
        try {
            if (this.settings.get(USERNAME_PASSWORD_LOGIN_LINK_ENABLED) != null) {
                return Boolean.parseBoolean((String)this.settings.get(USERNAME_PASSWORD_LOGIN_LINK_ENABLED));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void setUsernamePasswordLinkEnabled(boolean value) {
        this.settings.put(USERNAME_PASSWORD_LOGIN_LINK_ENABLED, (Object)("" + value));
    }

    public boolean isLoginEnabledForJSM() {
        boolean returnValue = true;
        try {
            if (this.settings.get(LOGIN_ENABLED_FOR_JSD) != null) {
                returnValue = Boolean.parseBoolean((String)this.settings.get(LOGIN_ENABLED_FOR_JSD));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return returnValue;
    }

    public void setInheritRedirectRulesInJsm(boolean value) {
        this.settings.put(INHERIT_REDIRECT_RULES_IN_JSM, (Object)("" + value));
    }

    public boolean getInheritRedirectRulesInJsm() {
        boolean returnValue = true;
        try {
            if (this.settings.get(INHERIT_REDIRECT_RULES_IN_JSM) != null) {
                returnValue = Boolean.parseBoolean((String)this.settings.get(INHERIT_REDIRECT_RULES_IN_JSM));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return returnValue;
    }

    public void setLoginEnabledForJSD(boolean value) {
        this.settings.put(LOGIN_ENABLED_FOR_JSD, (Object)("" + value));
    }

    String getSamlPrivateKeyPassword() {
        return (String)this.settings.get(KEYS.SAML_PRIVATE_KEY_PASSWORD.key);
    }

    void setSamlPrivateKeyPassword(String samlPrivateKeyPassword) {
        this.settings.put(KEYS.SAML_PRIVATE_KEY_PASSWORD.key, (Object)samlPrivateKeyPassword);
    }

    public void ensureKeysExist(String serverName) {
        if (!this.isActiveSigningKeyDefined()) {
            String id = this.generateKeyFile(serverName);
            this.promoteActiveCertificate(id);
        }
    }

    void addStandbyKey(String serverName) {
        this.generateKeyFile(serverName);
    }

    public java.util.List<CertDetails> getStandbyCertificates() {
        if (this.isActiveSigningKeyDefined()) {
            String active = this.getActiveSigningKeyShaId();
            File[] files = this.getSigningKeysDirectory().listFiles(pathname -> pathname.getName().endsWith(".jks") && !pathname.getName().startsWith(active));
            if (files != null && files.length > 0) {
                ArrayList<CertDetails> certs = new ArrayList<CertDetails>();
                for (File file : files) {
                    try {
                        X509Certificate cert = this.parseCert(new SamlKeyGenerator(this.secureRandom).getSigningCertificate(file));
                        certs.add(new CertDetails(cert, file.getName()));
                    }
                    catch (Exception e) {
                        log.error("Exception parsing certificate file: " + file, (Throwable)e);
                    }
                }
                certs.sort((o1, o2) -> o2.getCert().getNotBefore().compareTo(o1.getCert().getNotBefore()));
                return certs;
            }
        }
        return Collections.emptyList();
    }

    public CertDetails getStandbyCertificate(String hash) {
        java.util.List<CertDetails> certs = this.getStandbyCertificates();
        for (CertDetails cert : certs) {
            try {
                if (!hash.equals(CertTool.sha256FingerPrint(cert.getCert().getEncoded()))) continue;
                return cert;
            }
            catch (CertificateEncodingException e) {
                log.warn("Unable to read cert file: " + cert.getFilename());
            }
        }
        return null;
    }

    void promoteActiveCertificate(String id) {
        try {
            File activeSigningKeyFile = this.getActiveSigningKeyMarkerFile();
            File temp = new File(this.getSigningKeysDirectory(), ".temp");
            FileUtils.writeStringToFile((File)temp, (String)id);
            this.renameFile(temp, activeSigningKeyFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void deleteCertificate(String id) {
        new File(this.getSigningKeysDirectory(), id).delete();
    }

    private String generateKeyFile(String serverName) {
        try {
            SamlKeyGenerator samlKeyGenerator = new SamlKeyGenerator(this.secureRandom);
            KeyStore keyStore = samlKeyGenerator.generateKeyStore(serverName, this.getSamlPrivateKeyPassword());
            String sha256 = Fingerprint.sha256Fingerprint((byte[])keyStore.getCertificate("myCert").getEncoded());
            File keyFile = new File(this.getSigningKeysDirectory(), sha256 + ".jks");
            samlKeyGenerator.writeKeyStore(keyFile, keyStore);
            return sha256;
        }
        catch (KeyStoreException | CertificateEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private File getActiveSigningKeyFile() {
        return new File(this.getSigningKeysDirectory(), this.getActiveSigningKeyShaId() + ".jks");
    }

    public boolean isActiveSigningKeyDefined() {
        File markerFile = this.getActiveSigningKeyMarkerFile();
        if (!markerFile.exists()) {
            return false;
        }
        File activeSigningKeyFile = this.getActiveSigningKeyFile(this.getActiveSigningKeyShaId());
        if (!activeSigningKeyFile.exists()) {
            return false;
        }
        try {
            this.getSigningCert();
        }
        catch (Exception e) {
            log.error("Exception parsing signing key file: " + activeSigningKeyFile.getAbsolutePath(), (Throwable)e);
            return false;
        }
        return true;
    }

    public String getActiveSigningKeyShaId() {
        try {
            return FileUtils.readFileToString((File)this.getActiveSigningKeyMarkerFile()).trim();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private File getActiveSigningKeyMarkerFile() {
        return new File(this.getSigningKeysDirectory(), "activekey-sha256.txt");
    }

    private File getActiveSigningKeyFile(String sha256) {
        return new File(this.getSigningKeysDirectory(), sha256 + ".jks");
    }

    public File getSigningKeysDirectory() {
        return new File(this.getSamlDirectory(), "keys");
    }

    private File getProviderDirectory(String uid) {
        File providersDirectory = this.getProvidersDirectory();
        return new File(providersDirectory, uid);
    }

    private void persistProvider(IdpConfiguration config) {
        File providerDir = this.getProviderDirectory(config.getId());
        try {
            String singleLogoutReturnURL;
            Element regexTupleListElement;
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element provider = document.createElement(PROVIDER_ELEM);
            provider.setAttribute(MFA_ATTRIBUTE, config.getMfaAttribute());
            provider.setAttribute(MFA_REQUIRED, Boolean.toString(config.mfaRequired()));
            provider.setAttribute(KIND, config.getKind().name());
            provider.setAttribute(PROTOCOL, config.getProtocol().toString());
            provider.setAttribute(NAME, config.getName());
            provider.setAttribute(USER_NOT_FOUND_POLICY, config.getUserNotFoundPolicy().name());
            provider.setAttribute(USER_UPDATE_NAME_POLICY, config.getUserUpdateNamePolicy().name());
            provider.setAttribute(USER_UPDATE_EMAIL_POLICY, config.getUserUpdateEmailPolicy().name());
            provider.setAttribute(USER_ACTIVATE_POLICY, config.getUserActivatePolicy().name());
            provider.setAttribute(USERNAME_ATTRIBUTE, config.getUsernameAttribute().name());
            provider.setAttribute(AUTO_CREATE_USER_POLICY, config.getAutoCreateUserPolicy().key);
            provider.setAttribute(CUSTOM_USERNAME_ATTRIBUTE_NAME, config.getCustomUsernameAttributeName());
            provider.setAttribute(USERNAME_POLICY, config.getUsernamePolicy().name());
            provider.setAttribute(DEFAULT_GROUPS, this.commaSeparated(config.getDefaultGroups()));
            provider.setAttribute(DEFAULT_GROUPS_RULES, (String)JsonMapping.Write.mapAsJson(config.getDefaultGroupsRules()).map(JSONObject::toString).getOrElse((Object)""));
            provider.setAttribute(KNOWN_DOMAINS, this.commaSeparated(config.getKnownDomains()));
            provider.setAttribute(AUTO_UPDATE_KNOWN_DOMAINS, Boolean.toString(config.isAutoUpdateKnownDomains()));
            provider.setAttribute(CREATE_ALL_INCOMING_GROUPS, Boolean.toString(config.isCreateAllIncomingGroups()));
            provider.setAttribute(REMOVE_NON_IDP_GROUPS_FROM_USER, Boolean.toString(config.isRemoveNonIdpGroupsFromUser()));
            provider.setAttribute(SINGLE_LOGOUT_ENABLED, String.valueOf(config.isSingleLogoutEnabled()));
            provider.setAttribute(MANAGED_GROUPS_REQUIRED_FOR_USER_CREATION, Boolean.toString(config.isManagedGroupsRequiredForJITCreation()));
            provider.setAttribute(ENABLED, Boolean.toString(config.isEnabled()));
            provider.setAttribute(HOSTED_DOMAIN, Boolean.toString(config.isHostedDomain()));
            provider.setAttribute(USER_LOOKUP_ATTRIBUTE, config.getUserLookupAttribute().name());
            provider.setAttribute(USER_LOOKUP_TRANSFORM, config.getUserLookupTransform().name());
            provider.setAttribute(AUTHENTICATED_ANONYMOUS_BROWSING_ENABLED, Boolean.toString(config.isAuthenticatedAnonymousBrowsingEnabled()));
            provider.setAttribute(IDP_GROUPS_ATTRIBUTE, String.join((CharSequence)",", config.getIdpGroupsAttributes()));
            provider.setAttribute(USER_PROFILE_KEY_MAPPING, (String)JsonMapping.Write.mapAsJson(config.getUserProfileKeyMap()).mapTry((CheckedFunction1 & Serializable)json -> json.toString(0)).getOrElse((Object)""));
            this.addGroupElements(provider, MANAGED_GROUP, config.getManagedGroups());
            this.addGroupElements(provider, AUTO_GROUP, config.getAutoGroups());
            if (config.getJitDirectory().isPresent()) {
                provider.setAttribute(JIT_DIRECTORY, String.valueOf(config.getJitDirectory().get()));
            }
            if (config.getCustomNameAttribute() != null) {
                provider.setAttribute(CUSTOM_NAME_ATTRIBUTE, config.getCustomNameAttribute());
            } else {
                provider.removeAttribute(CUSTOM_NAME_ATTRIBUTE);
            }
            if (config.getCustomGivenNameAttribute() != null) {
                provider.setAttribute(CUSTOM_GIVEN_NAME_ATTRIBUTE, config.getCustomGivenNameAttribute());
            } else {
                provider.removeAttribute(CUSTOM_GIVEN_NAME_ATTRIBUTE);
            }
            if (config.getCustomSurnameAttribute() != null) {
                provider.setAttribute(CUSTOM_SURNAME_ATTRIBUTE, config.getCustomSurnameAttribute());
            } else {
                provider.removeAttribute(CUSTOM_SURNAME_ATTRIBUTE);
            }
            if (config.getCustomEmailAttribute() != null) {
                provider.setAttribute(CUSTOM_EMAIL_ATTRIBUTE, config.getCustomEmailAttribute());
            } else {
                provider.removeAttribute(CUSTOM_EMAIL_ATTRIBUTE);
            }
            if (config.getNameAttributeMapping() != null) {
                provider.setAttribute(NAME_ATTRIBUTE_MAPPING_FIELD, config.getNameAttributeMapping().toString());
            }
            if ((regexTupleListElement = SamlXmlParser.listOfTuplesToXml(document, REGEX_TUPLES, config.getUserTransformationRegexes())) != null) {
                provider.appendChild(regexTupleListElement);
            }
            if (StringUtils.isNotBlank((CharSequence)(singleLogoutReturnURL = config.getSingleLogoutReturnURL()))) {
                provider.setAttribute(SINGLE_LOGOUT_RETURN_URL, singleLogoutReturnURL);
            }
            RedirectProperties redirectProperties = config.getRedirectProperties();
            provider.setAttribute(REDIRECT_POLICY, redirectProperties.getRedirectPolicy().name());
            provider.setAttribute(MATCHED_USER_DIRECTORIES, this.commaSeparatedLongs(redirectProperties.getMatchedUserDirectoryIds()));
            provider.setAttribute(REDIRECT_GROUPS, this.commaSeparated(redirectProperties.getRedirectGroups()));
            provider.setAttribute(VISIBLE, Boolean.toString(redirectProperties.isVisible()));
            provider.setAttribute(INVERT_REDIRECT_GROUPS, Boolean.toString(redirectProperties.getInvertUserGroupMatch()));
            provider.setAttribute(KNOWN_AUTO_REDIRECT, Boolean.toString(redirectProperties.isKnownAutoRedirect()));
            provider.setAttribute(SEND_LOGIN_HINT, Boolean.toString(redirectProperties.isSendLoginHint()));
            RedirectProperties jsmRedirectProperties = config.getJsmRedirectProperties();
            Element jsmRedirectPolicy = provider.getOwnerDocument().createElement(JSM_REDIRECT_PROPERTIES);
            jsmRedirectPolicy.setAttribute(REDIRECT_POLICY, jsmRedirectProperties.getRedirectPolicy().name());
            jsmRedirectPolicy.setAttribute(MATCHED_USER_DIRECTORIES, this.commaSeparatedLongs(jsmRedirectProperties.getMatchedUserDirectoryIds()));
            jsmRedirectPolicy.setAttribute(REDIRECT_GROUPS, this.commaSeparated(jsmRedirectProperties.getRedirectGroups()));
            jsmRedirectPolicy.setAttribute(VISIBLE, Boolean.toString(jsmRedirectProperties.isVisible()));
            jsmRedirectPolicy.setAttribute(INVERT_REDIRECT_GROUPS, Boolean.toString(jsmRedirectProperties.getInvertUserGroupMatch()));
            jsmRedirectPolicy.setAttribute(KNOWN_AUTO_REDIRECT, Boolean.toString(jsmRedirectProperties.isKnownAutoRedirect()));
            jsmRedirectPolicy.setAttribute(SEND_LOGIN_HINT, Boolean.toString(jsmRedirectProperties.isSendLoginHint()));
            provider.appendChild(jsmRedirectPolicy);
            provider.setAttribute(TLS_FINGERPRINT, StringUtils.trimToNull((String)config.getTlsFingerprint()));
            config.ifSaml(samlConfig -> {
                String singleLogoutServiceURL;
                provider.setAttribute(IDP_URL, samlConfig.getIdpURL());
                provider.setAttribute(ENCRYPTED_ASSERTIONS_REQUIRED, Boolean.toString(samlConfig.isEncryptedAssertionsRequired()));
                provider.setAttribute(INSTANT_LOGINURL_IN_SESSION, Boolean.toString(samlConfig.isInstantLoginUrlInSession()));
                provider.setAttribute(USE_POST_BINDING, Boolean.toString(samlConfig.isUsePostBinding()));
                provider.setAttribute(REQUESTED_AUTHN_CONTEXT_POLICY, samlConfig.getRequestedAuthnContextPolicy().name());
                provider.setAttribute(REQUESTED_AUTHN_CONTEXT_COMPARISON, samlConfig.getRequestedAuthnContextComparison().name());
                provider.setAttribute(AUTHN_CONTEXT_CLASS_REF, samlConfig.getAuthnContextClassRef());
                provider.setAttribute(ISSUER_POLICY, samlConfig.getIssuerPolicy().name());
                provider.setAttribute(ALLOW_CREATE, samlConfig.getAllowCreate().name());
                provider.setAttribute(NAMEID_FORMAT, samlConfig.getNameIdFormat().name());
                provider.setAttribute(CUSTOM_NAMEID_FORMAT, samlConfig.getCustomNameIdFormat());
                provider.setAttribute(AUTO_REFRESH_METADATA_ENABLED, Boolean.toString(samlConfig.isAutoRefreshMetadataEnabled()));
                this.replaceCertificates(provider, samlConfig.getSigningCerts());
                SAMLSessionIdentification.ValidationPolicy siPolicy = samlConfig.getSessionIdentificationValidationPolicy();
                if (siPolicy != null && siPolicy != SAMLSessionIdentification.ValidationPolicy.getDefault()) {
                    provider.setAttribute(SESSION_IDENTIFICATION_VALIDATION_POLICY, siPolicy.name());
                }
                if (StringUtils.isNotBlank((CharSequence)(singleLogoutServiceURL = samlConfig.getSingleLogoutServiceURL()))) {
                    provider.setAttribute(SINGLE_LOGOUT_SERVICE_URL, singleLogoutServiceURL);
                }
                if (StringUtils.isNotBlank((CharSequence)samlConfig.getMetadataUrl())) {
                    provider.setAttribute(METADATA_URL, samlConfig.getMetadataUrl());
                }
                if (samlConfig.getIssuer() != null) {
                    provider.setAttribute(ISSUER, samlConfig.getIssuer());
                }
            });
            config.ifOidc(oidcConfig -> {
                provider.setAttribute(OIDC_CLIENT_ID, oidcConfig.getClientId());
                provider.setAttribute(OIDC_CLIENT_SECRET, oidcConfig.getClientSecret());
                provider.setAttribute(OIDC_CLIENT_SECRET_EXPIRY, oidcConfig.getClientSecretExpiry().toString());
                provider.setAttribute(OIDC_DISCOVERY_URL, oidcConfig.getDiscoveryUrl());
                provider.setAttribute(OIDC_SCOPES, this.commaSeparated(oidcConfig.getScope()));
                provider.setAttribute(OIDC_ISSUER_ALLOWLIST, this.commaSeparated(oidcConfig.getIssuerAllowList()));
            });
            document.appendChild(provider);
            this.persistProviderDocument(providerDir, document);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    private void replaceCertificates(Element provider, java.util.List<byte[]> signingCerts) {
        NodeList existing = provider.getElementsByTagName(CERTIFICATE);
        LinkedList<Element> toRemove = new LinkedList<Element>();
        for (int i = 0; i < existing.getLength(); ++i) {
            toRemove.add((Element)existing.item(i));
        }
        for (Element element : toRemove) {
            provider.removeChild(element);
        }
        for (byte[] certBytes : signingCerts) {
            this.addCertificate(provider, certBytes);
        }
    }

    private void addCertificate(Element provider, byte[] certBytes) {
        String base64 = Base64.encodeBase64String((byte[])certBytes);
        NodeList existingCerts = provider.getElementsByTagName(CERTIFICATE);
        for (int i = 0; i < existingCerts.getLength(); ++i) {
            if (!base64.equals(existingCerts.item(i).getTextContent())) continue;
            return;
        }
        Element certE = provider.getOwnerDocument().createElement(CERTIFICATE);
        certE.setTextContent(base64);
        provider.appendChild(certE);
    }

    public boolean isSamlSessionActive(HttpServletRequest request) {
        return (Boolean)io.vavr.control.Option.of((Object)request).flatMap(req -> io.vavr.control.Option.of((Object)req.getSession(false))).map(session -> session.getAttribute("ksso.saml.idp.id") != null).getOrElse((Object)false);
    }

    public boolean isOidcSessionActive(HttpServletRequest request) {
        return (Boolean)io.vavr.control.Option.of((Object)request).flatMap(req -> io.vavr.control.Option.of((Object)req.getSession(false))).map(session -> session.getAttribute("ksso.oidc.idp.id") != null).getOrElse((Object)false);
    }

    public boolean isAuthenticatedAnonymousBrowsingSessionActive(HttpServletRequest request) {
        return (Boolean)io.vavr.control.Option.of((Object)request).flatMap(req -> io.vavr.control.Option.of((Object)req.getSession(false))).map(session -> this.findIdentityProviderById((String)session.getAttribute("KSSO_AUTH_ANONYMOUS_BROWSING_SESSION_IDP_ID")).isDefined()).getOrElse((Object)false);
    }

    private void persistProviderDocument(File providerDir, Document document) {
        try {
            File tempFile = new File(providerDir, "_provider.xml");
            Transformer transformer = XmlSecurity.secureTransformer();
            try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile), StandardCharsets.UTF_8);){
                transformer.transform(new DOMSource(document), new StreamResult(out));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.renameFile(tempFile, this.getProviderXmlFile(tempFile.getParentFile()));
            this.updateStateId();
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    private void renameFile(File sourceFile, File destFile) {
        try {
            Files.move(sourceFile.toPath(), destFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String commaSeparated(Set<String> groups) {
        StringBuilder sb = new StringBuilder();
        for (String g : groups) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(g);
        }
        return sb.toString();
    }

    String commaSeparated(String[] items) {
        return (String)io.vavr.control.Option.of((Object)items).map(Arrays::stream).map(stream -> stream.collect(Collectors.toSet())).map(this::commaSeparated).getOrElse((Object)"");
    }

    IdpConfiguration getEnabledIdentityProviderById(String id) {
        IdpConfiguration config = this.getIdentityProviderById(id);
        return config != null && config.isEnabled() ? config : null;
    }

    public IdpConfiguration getIdentityProviderById(String id) {
        for (IdpConfiguration configuration : this.getIdentityProviders()) {
            if (!configuration.getId().equals(id)) continue;
            return configuration;
        }
        return null;
    }

    public io.vavr.control.Option<IdpConfiguration> findIdentityProviderById(String maybeId) {
        return io.vavr.control.Option.of(this.getIdentityProviders()).map(List::ofAll).flatMap(idpConfigurations -> idpConfigurations.find(idpConfiguration -> io.vavr.control.Option.of((Object)idpConfiguration.getId()).exists(id -> io.vavr.control.Option.of((Object)maybeId).contains(id))));
    }

    public io.vavr.control.Option<IdpConfiguration> findIdentityProviderByIdFromPath(HttpServletRequest request) {
        return this.findIdentityProviderById(this.getIdPIdFromPath(request));
    }

    public String getIdentityProvidersSubpathRoot() {
        return IDENTITY_PROVIDERS_URL_ROOT;
    }

    public String getIdPIdFromPath(HttpServletRequest request) {
        return (String)io.vavr.control.Option.of((Object)request).map(HttpUrlUtils::getInternalPath).filter(path -> path.contains(IDENTITY_PROVIDERS_URL_ROOT)).map(path -> StringUtils.substringBetween((String)path, (String)"providers/", (String)"/")).getOrElse((Object)"");
    }

    public SamlIdpConfiguration getSamlIdpById(String id) {
        IdpConfiguration cfg = this.getIdentityProviderById(id);
        if (!(cfg instanceof SamlIdpConfiguration)) {
            throw new RuntimeException(id + " is not SAMLIdpConfiguration: " + cfg.getClass().getSimpleName());
        }
        return (SamlIdpConfiguration)cfg;
    }

    public OidcIdpConfiguration getOidcIdpById(String id) {
        IdpConfiguration cfg = this.getIdentityProviderById(id);
        if (!(cfg instanceof OidcIdpConfiguration)) {
            throw new RuntimeException(id + " is not OidcIdpConfiguration: " + cfg.getClass().getSimpleName());
        }
        return (OidcIdpConfiguration)cfg;
    }

    public boolean isEncryptedAssertionsRequiredForIdpOrDraft(String id) {
        return (Boolean)Try.of((CheckedFunction0 & Serializable)() -> this.getIdentityProviderById(id)).filter(IdpConfiguration::isSaml).map(SamlIdpConfiguration.class::cast).map(SamlIdpConfiguration::isEncryptedAssertionsRequired).getOrElse((Object)false);
    }

    public boolean isInstantLoginUrlInSession(String id) {
        return (Boolean)Try.of((CheckedFunction0 & Serializable)() -> this.getIdentityProviderById(id)).filter(IdpConfiguration::isSaml).map(SamlIdpConfiguration.class::cast).map(SamlIdpConfiguration::isInstantLoginUrlInSession).getOrElse((Object)false);
    }

    public boolean isSingleLogoutEnabledForIdpOrDraft(String id) {
        return (Boolean)io.vavr.control.Option.of((Object)this.getIdentityProviderById(id)).map(IdpConfiguration::isSingleLogoutEnabled).getOrElse((Object)false);
    }

    public byte[] getSigningCert() {
        File signingKeys = this.getActiveSigningKeyFile();
        return new SamlKeyGenerator(this.secureRandom).getSigningCertificate(signingKeys);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Credential getIdpSigningCredential(byte[] buf) {
        try (ByteArrayInputStream in = new ByteArrayInputStream(buf);){
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            X509Certificate certificate = (X509Certificate)certificateFactory.generateCertificate(in);
            BasicX509Credential basicX509Credential = new BasicX509Credential(certificate);
            return basicX509Credential;
        }
        catch (IOException | CertificateException e) {
            throw new RuntimeException(e);
        }
    }

    public Credential getSpSigningCredential() {
        return new SamlKeyGenerator(this.secureRandom).getSpSigningCredentials(this.getActiveSigningKeyFile(), this.getSamlPrivateKeyPassword());
    }

    public String getIdpConfigUrl(HttpServletRequest request) {
        return this.getPluginAdminBase(request) + "/" + this.getIdentityProvidersSubpathRoot();
    }

    private String getPluginAdminBase(HttpServletRequest request) {
        return request.getContextPath() + "/plugins/servlet/no.kantega.kerberosauth.kerberosauth-plugin";
    }

    private String getSAMLRequestCertPath(HttpServletRequest request) {
        return this.getPluginAdminBase(request) + "/certs/request/" + request.getServerName() + "-saml-request-cert.cer";
    }

    public String getSAMLRequestCertUrl(HttpServletRequest request) {
        try {
            URI uri = new URI(request.getRequestURL().toString());
            URI serviceUri = new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), this.getSAMLRequestCertPath(request), null, null);
            return serviceUri.toString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public String getProviderOverviewUrl(HttpServletRequest request, String spId) {
        return this.getIdpConfigUrl(request) + "/" + spId + "/overview";
    }

    public String getProviderAdminUrl(String spId, HttpServletRequest request) {
        return this.getIdpConfigUrl(request) + "/" + spId + "/config";
    }

    public String getServiceProviderLoginUrl(HttpServletRequest req, String id) {
        return this.getServiceProviderUrl(req, id, "/login");
    }

    public String getServiceProviderLoginUrl(String id) {
        return this.getServiceProviderUrl(id, "/login");
    }

    public String getServiceProviderTestUrl(HttpServletRequest req, String id) {
        return this.getIdpConfigUrl(req) + "/" + id + "/test";
    }

    public String getServiceProviderNonAdminTestUrl(HttpServletRequest req, String id) {
        return this.getServiceProviderUrl(req, id, "/usertest");
    }

    public String getServiceProviderNonAdminTestUrl(String id) {
        return this.getServiceProviderUrl(id, "/usertest");
    }

    public String getServiceProviderEvaluateTestUrl(HttpServletRequest req, String id) {
        return this.getIdpConfigUrl(req) + "/" + id + "/evaluate-test";
    }

    public String getServiceProviderMetadataUrl(HttpServletRequest req, String id) {
        return this.getServiceProviderUrl(req, id, "/metadata.xml");
    }

    public String getServiceProviderLogoutServiceUrl(HttpServletRequest req, String id) {
        return this.getServiceProviderUrl(req, id, "/logout");
    }

    private String getServiceProviderUrl(HttpServletRequest req, String id, String path) {
        try {
            URI uri = new URI(req.getRequestURL().toString());
            URI serviceUri = new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), req.getContextPath() + "/plugins/servlet/no.kantega.saml/sp/" + id + path, null, null);
            return serviceUri.toString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private String getServiceProviderUrl(String id, String path) {
        String serviceProviderPath = "/plugins/servlet/no.kantega.saml/sp/";
        String baseUrl = (String)io.vavr.control.Option.of((Object)this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE)).getOrElse((Object)"");
        return baseUrl + "/plugins/servlet/no.kantega.saml/sp/" + id + path;
    }

    public X509Certificate parseCert(byte[] signingCert) {
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X509");
            return (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(signingCert));
        }
        catch (CertificateException e) {
            throw new RuntimeException(e);
        }
    }

    public java.util.List<IdpConfiguration> getProvidersByKind(IdpConfiguration.Kind identityProviderKind) {
        return this.getIdentityProviders().stream().filter(idp -> idp.getKind() == identityProviderKind && idp.isEnabled()).collect(Collectors.toList());
    }

    public java.util.List<IdpConfiguration> getProvidersByRedirectPolicy(IdpConfiguration.RedirectPolicy redirectPolicy) {
        return this.getIdentityProviders().stream().filter(idp -> idp.getRedirectProperties().getRedirectPolicy() == redirectPolicy && idp.isEnabled()).collect(Collectors.toList());
    }

    public java.util.List<IdpConfiguration> getProvidersByJsmRedirectPolicy(IdpConfiguration.RedirectPolicy redirectPolicy) {
        return this.getIdentityProviders().stream().filter(idp -> idp.getJsmRedirectProperties().getRedirectPolicy() == redirectPolicy && idp.isEnabled()).collect(Collectors.toList());
    }

    public void removeIdentityProvider(String id) {
        File providerDirectory = this.getProviderDirectory(id);
        try {
            FileUtils.deleteDirectory((File)providerDirectory);
            this.updateStateId();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void recordTestStarted(String idpConfigurationId, String id, String xml, String remoteAddr) {
        File testDirectory = this.getTestDirectory(idpConfigurationId, id);
        testDirectory.mkdirs();
        try {
            File tmpFile = new File(testDirectory, "_request.xml");
            FileUtils.writeStringToFile((File)tmpFile, (String)xml, (Charset)StandardCharsets.UTF_8);
            File requestFile = this.getRecordedTestRequestFile(idpConfigurationId, id);
            this.renameFile(tmpFile, requestFile);
            Properties props = this.readTestProperties(testDirectory);
            props.setProperty("requestTime", ISODateTimeFormat.dateTime().print((ReadableInstant)DateTime.now()));
            props.setProperty("requestAddress", remoteAddr);
            props.setProperty("ssoProtocol", IdpConfiguration.SSOProtocol.SAML.name());
            this.writeTestProperties(testDirectory, props);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.deleteOldTests(idpConfigurationId, this.getTestDirectories(idpConfigurationId));
    }

    void recordTestResult(String idpConfigurationId, SamlResponseValidationResult result, SAMLResponseEvaluationResult evaluationResult, String xml, String remoteAddr) {
        File testDirectory = this.getTestDirectory(idpConfigurationId, result.getAuthnRequestID());
        testDirectory.mkdirs();
        File tmpFile = new File(testDirectory, "_response.xml");
        File responseFile = this.getRecordedTestResponseFile(idpConfigurationId, result.getAuthnRequestID());
        if (xml != null) {
            try {
                FileUtils.writeStringToFile((File)tmpFile, (String)xml, (Charset)StandardCharsets.UTF_8);
                this.renameFile(tmpFile, responseFile);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        Properties props = this.readTestProperties(testDirectory);
        props.setProperty("ssoProtocol", IdpConfiguration.SSOProtocol.SAML.name());
        this.updateResultProps(evaluationResult, props);
        props.setProperty("responseTime", ISODateTimeFormat.dateTime().print((ReadableInstant)result.getNow()));
        props.setProperty("responseAddress", remoteAddr);
        this.writeTestProperties(testDirectory, props);
    }

    public void recordOidcTestStarted(String idpConfigurationId, String targetUrl, OidcData oidcData) {
        String testId = (String)oidcData.get("state").getOrElse((Object)UUID.randomUUID().toString());
        try {
            File testDirectory = this.getTestDirectory(idpConfigurationId, testId);
            File tmpFile = new File(testDirectory, "_oidcProcedureInit.json");
            String json = (String)oidcData.sanitizedStringRepresentation().getOrElse((Object)"{'error':'Failed test recording'}");
            FileUtils.writeStringToFile((File)tmpFile, (String)json, (Charset)StandardCharsets.UTF_8);
            File requestFile = this.getRecordedTestStartedOIDCProcedureFile(idpConfigurationId, testId);
            this.renameFile(tmpFile, requestFile);
            Properties props = this.readTestProperties(testDirectory);
            props.setProperty("requestTime", ISODateTimeFormat.dateTime().print((ReadableInstant)DateTime.now()));
            io.vavr.control.Option.of((Object)targetUrl).peek(url -> props.setProperty("targetUrl", (String)url));
            props.setProperty("ssoProtocol", IdpConfiguration.SSOProtocol.OIDC.name());
            this.writeTestProperties(testDirectory, props);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            log.warn(ErrorUtils.createErrorMessage("KSSO-51ZKNC8IWP", "Failed saving OIDC test started: " + e));
        }
        this.deleteOldTests(idpConfigurationId, this.getTestDirectories(idpConfigurationId));
    }

    public void recordOidcTestResult(String idpConfigurationId, String testId, OidcResponseEvaluationResult evaluationResult, JSONObject profileJson) {
        File testDirectory = this.getTestDirectory(idpConfigurationId, testId);
        testDirectory.mkdirs();
        File tmpFile = new File(testDirectory, "_response.json");
        File responseFile = this.getRecordedOidcTestResponseFile(idpConfigurationId, testId);
        try {
            FileUtils.writeStringToFile((File)tmpFile, (String)profileJson.toString(), (Charset)StandardCharsets.UTF_8);
            this.renameFile(tmpFile, responseFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Properties props = this.readTestProperties(testDirectory);
        this.updateResultProps(evaluationResult, props);
        props.setProperty("responseTime", ISODateTimeFormat.dateTime().print((ReadableInstant)DateTime.now()));
        props.setProperty("ssoProtocol", IdpConfiguration.SSOProtocol.OIDC.name());
        this.writeTestProperties(testDirectory, props);
    }

    public void recordTestOidcDataBeforeRequest(String idpConfigurationId, String testId, OidcData oidcData, ErrorUtils.KssoError kssoError, ResponseEvaluationCode code) {
        File testDirectory = this.getTestDirectory(idpConfigurationId, testId);
        testDirectory.mkdirs();
        File tmpFile = new File(testDirectory, "_oidcProcedureSetupBeforeRequest.json");
        File responseFile = this.getRecordedTestOidcProcedureFileBeforeRequest(idpConfigurationId, testId);
        try {
            String json = (String)oidcData.sanitizedStringRepresentation().getOrElse((Object)"{'error':'Failed test recording'}");
            FileUtils.writeStringToFile((File)tmpFile, (String)json, (Charset)StandardCharsets.UTF_8);
            this.renameFile(tmpFile, responseFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Properties props = this.readTestProperties(testDirectory);
        io.vavr.control.Option.of((Object)kssoError).peek(error -> {
            props.setProperty("errorCode", error.code);
            props.setProperty("errorMessage", error.message);
            props.setProperty("error", error.toString());
        });
        io.vavr.control.Option.of((Object)((Object)code)).peek(respCode -> props.setProperty("code", respCode.name()));
        props.setProperty("ssoProtocol", IdpConfiguration.SSOProtocol.OIDC.name());
        this.writeTestProperties(testDirectory, props);
    }

    public void recordTestOidcProcedureBeforeRequest(String idpConfigurationId, String testId, OidcData oidcData, ResponseEvaluationCode code) {
        this.recordTestOidcDataBeforeRequest(idpConfigurationId, testId, oidcData, null, code);
    }

    public void recordTestOidcDataAfterResponse(String idpConfigurationId, String testId, OidcData oidcData, ErrorUtils.KssoError kssoError, ResponseEvaluationCode code) {
        File testDirectory = this.getTestDirectory(idpConfigurationId, testId);
        testDirectory.mkdirs();
        File tmpFile = new File(testDirectory, "_oidcProcedureSetupAfterResponse.json");
        File responseFile = this.getRecordedTestOidcProcedureFileAfterResponse(idpConfigurationId, testId);
        try {
            String json = (String)oidcData.sanitizedStringRepresentation().getOrElse((Object)"{'error':'Failed test recording'}");
            FileUtils.writeStringToFile((File)tmpFile, (String)json, (Charset)StandardCharsets.UTF_8);
            this.renameFile(tmpFile, responseFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Properties props = this.readTestProperties(testDirectory);
        props.setProperty("responseTime", ISODateTimeFormat.dateTime().print((ReadableInstant)DateTime.now()));
        props.setProperty("ssoProtocol", IdpConfiguration.SSOProtocol.OIDC.name());
        io.vavr.control.Option.of((Object)kssoError).peek(error -> {
            props.setProperty("errorCode", error.code);
            props.setProperty("errorMessage", error.message);
            props.setProperty("error", error.toString());
        });
        io.vavr.control.Option.of((Object)((Object)code)).peek(respCode -> props.setProperty("code", respCode.name()));
        this.writeTestProperties(testDirectory, props);
    }

    public void recordTestOidcProcedureAfterResponse(String idpConfigurationID, String testId, OidcData oidcData, ResponseEvaluationCode code) {
        this.recordTestOidcDataAfterResponse(idpConfigurationID, testId, oidcData, null, code);
    }

    void updateAndStoreTestresults(String idpConfigurationID, SamlResponseValidationResult result, SAMLResponseEvaluationResult evaluationResult) {
        File testDirectory = this.getTestDirectory(idpConfigurationID, result.getAuthnRequestID());
        Properties props = this.readTestProperties(testDirectory);
        props.setProperty("ssoProtocol", IdpConfiguration.SSOProtocol.SAML.name());
        this.updateResultProps(evaluationResult, props);
        this.writeTestProperties(testDirectory, props);
    }

    void updateAndStoreTestresults(String idpConfigurationID, String testRecordId, OidcResponseEvaluationResult evaluationResult) {
        File testDirectory = this.getTestDirectory(idpConfigurationID, testRecordId);
        Properties props = this.readTestProperties(testDirectory);
        props.setProperty("ssoProtocol", IdpConfiguration.SSOProtocol.OIDC.name());
        this.updateResultProps(evaluationResult, props);
        this.writeTestProperties(testDirectory, props);
    }

    private void updateResultProps(FederatedIdentityResponseEvaluationResult evaluationResult, Properties props) {
        if (evaluationResult != null) {
            ResponseEvaluationCode code = evaluationResult.getCode();
            props.setProperty("code", code.name());
            String username = evaluationResult.getUsername();
            if (username != null) {
                props.setProperty("username", username);
            } else {
                props.remove("username");
            }
            String fullname = evaluationResult.getFullname();
            if (fullname != null) {
                props.setProperty("fullname", fullname);
            }
        }
    }

    Properties getTestProperties(String idpConfigurationID, TestRecord testRecord) {
        return this.readTestProperties(this.getTestDirectory(idpConfigurationID, testRecord.getId()));
    }

    private Properties readTestProperties(File testDirectory) {
        File testPropertiesFile = this.getTestPropertiesFile(testDirectory);
        Properties p = new Properties();
        if (testPropertiesFile.exists()) {
            try (FileInputStream is = new FileInputStream(testPropertiesFile);){
                p.load(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return p;
    }

    private void writeTestProperties(File testDirectory, Properties props) {
        try (FileOutputStream out = new FileOutputStream(this.getTestPropertiesFile(testDirectory));){
            props.store(out, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private File getTestPropertiesFile(File testDirectory) {
        return new File(testDirectory, "test.properties");
    }

    private void deleteOldTests(String idpConfigurationID, File[] testDirs) {
        int MAX_TEST_RECORDS = 10;
        if (testDirs.length > MAX_TEST_RECORDS) {
            for (int i = testDirs.length - 1; i >= MAX_TEST_RECORDS; --i) {
                this.deleteTestDirectory(idpConfigurationID, testDirs[i]);
            }
        }
    }

    private File[] getTestDirectories(String idpConfigurationID) {
        File directory = this.getTestsDirectory(idpConfigurationID);
        File[] testDirs = directory.listFiles(File::isDirectory);
        if (testDirs == null) {
            return new File[0];
        }
        Arrays.sort(testDirs, (o1, o2) -> {
            long diff = o2.lastModified() - o1.lastModified();
            return diff > 0L ? 1 : (diff < 0L ? -1 : 0);
        });
        return testDirs;
    }

    private File getTestDirectory(String idpConfigurationID, String testName) {
        return new File(this.getTestsDirectory(idpConfigurationID), testName);
    }

    private File getTestsDirectory(String idpConfigurationID) {
        File providerDirectory = this.getProviderDirectory(idpConfigurationID);
        return new File(providerDirectory, "tests");
    }

    public java.util.List<TestRecord> getRecordedTests(String idpConfigurationID) {
        ArrayList<TestRecord> records = new ArrayList<TestRecord>();
        for (File dir : this.getTestDirectories(idpConfigurationID)) {
            if (System.currentTimeMillis() - dir.lastModified() > 259200000L) {
                this.deleteTestDirectory(idpConfigurationID, dir);
                continue;
            }
            records.add(this.readRecord(dir));
        }
        return records;
    }

    private TestRecord readRecord(File dir) {
        Properties props = this.readTestProperties(dir);
        return new TestRecord(dir.getName(), new Date(dir.lastModified()), props);
    }

    private OidcTestRecord readOidcRecord(File dir) {
        Properties props = this.readTestProperties(dir);
        return new OidcTestRecord(dir.getName(), new Date(dir.lastModified()), props);
    }

    TestRecord getRecordedTest(String idpConfigurationID, String evaluateId) {
        return this.readRecord(this.getTestDirectory(idpConfigurationID, evaluateId));
    }

    OidcTestRecord getRecordedOIDCTest(String idpConfigurationID, String evaluateId) {
        return this.readOidcRecord(this.getTestDirectory(idpConfigurationID, evaluateId));
    }

    public File getRecordedTestRequestFile(String idpConfigurationID, String id) {
        return new File(this.getTestDirectory(idpConfigurationID, id), "request.xml");
    }

    public File getRecordedTestResponseFile(String idpConfigurationID, String id) {
        return new File(this.getTestDirectory(idpConfigurationID, id), "response.xml");
    }

    public File getRecordedTestStartedOIDCProcedureFile(String idpConfigurationID, String id) {
        return new File(this.getTestDirectory(idpConfigurationID, id), "oidcProcedureInit.json");
    }

    public File getRecordedTestOidcProcedureFileBeforeRequest(String idpConfigurationID, String id) {
        return new File(this.getTestDirectory(idpConfigurationID, id), "oidcProcedureSetupBeforeRequest.json");
    }

    public File getRecordedOidcTestResponseFile(String idpConfigurationID, String id) {
        return new File(this.getTestDirectory(idpConfigurationID, id), "response.json");
    }

    public File getRecordedTestOidcProcedureFileAfterResponse(String idpConfigurationID, String id) {
        return new File(this.getTestDirectory(idpConfigurationID, id), "oidcProcedureSetupAfterResponse.json");
    }

    public void deleteTestDirectory(String idpConfigurationID, String testId) {
        File testDirectory = this.getTestDirectory(idpConfigurationID, testId);
        this.deleteTestDirectory(idpConfigurationID, testDirectory);
    }

    private void deleteTestDirectory(String idpConfigurationID, File testDir) {
        if (this.getTestsDirectory(idpConfigurationID).equals(testDir.getParentFile())) {
            try {
                FileUtils.deleteDirectory((File)testDir);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String nextId() {
        return (String)Try.of((CheckedFunction0 & Serializable)() -> RandomStringUtils.randomAlphanumeric((int)20)).filter(this::idpIdNotTaken).getOrElse(this::nextId);
    }

    private boolean idpIdNotTaken(String id) {
        return this.getIdentityProviderById(id) == null;
    }

    public void updateId(String oldIdpId, String newIdpId) {
        File idpDir = new File(this.getSamlDirectory(), IDENTITY_PROVIDERS_URL_ROOT);
        io.vavr.control.Option.of((Object)oldIdpId).flatMap(oldId -> io.vavr.control.Option.of((Object)this.getIdentityProviderById((String)oldId))).map(IdpConfiguration::getId).map(oldId -> new File(idpDir, (String)oldId)).peek(oldIdpPath -> io.vavr.control.Option.of((Object)newIdpId).filter(IdpConfManager::isValidIdpId).filter(this::idpIdNotTaken).map(newId -> new File(idpDir, (String)newId)).peek(newIdpPath -> Try.run(() -> FileUtils.copyDirectory((File)oldIdpPath, (File)newIdpPath)).andThenTry(() -> FileUtils.deleteDirectory((File)oldIdpPath)).andThenTry(this::updateStateId).andThenTry(this::readState)));
    }

    boolean isIdentityProvider(String id) {
        if (id == null) {
            return false;
        }
        for (IdpConfiguration idpConfiguration : this.getIdentityProviders()) {
            if (!idpConfiguration.getId().equals(id)) continue;
            return true;
        }
        return false;
    }

    public void addIdpCert(String id, byte[] certBytes) {
        if (certBytes == null || certBytes.length == 0) {
            return;
        }
        Document document = SamlXmlParser.parseProviderDocument(this.getProviderXmlFile(this.getProviderDirectory(id)));
        Element element = document.getDocumentElement();
        this.addCertificate(element, certBytes);
        this.persistProviderDocument(this.getProviderDirectory(id), document);
    }

    public void deleteIdpCert(String id, String deleteFingerprint) {
        Document document = SamlXmlParser.parseProviderDocument(this.getProviderXmlFile(this.getProviderDirectory(id)));
        Element element = document.getDocumentElement();
        NodeList certificates = element.getElementsByTagName(CERTIFICATE);
        for (int i = 0; i < certificates.getLength(); ++i) {
            Node certE = certificates.item(i);
            String textContent = certE.getTextContent();
            byte[] certBytes = Base64.decodeBase64((String)textContent);
            String fingerprint = Fingerprint.formatSsha1Fingerprint((byte[])certBytes);
            if (!deleteFingerprint.equals(fingerprint)) continue;
            element.removeChild(certE);
        }
        this.persistProviderDocument(this.getProviderDirectory(id), document);
    }

    public boolean isLicenseValid() {
        Option optionalLicense = this.pluginLicenseManager.getLicense();
        if (!optionalLicense.isDefined()) {
            return false;
        }
        PluginLicense pluginLicense = (PluginLicense)optionalLicense.get();
        return pluginLicense.isValid();
    }

    public int countActiveProviders() {
        return List.ofAll(this.getIdentityProviders()).filter(IdpConfiguration::isEnabled).size();
    }

    public boolean isAnyProvidersSaved() {
        return !this.getIdentityProviders().isEmpty();
    }

    public boolean isAnySettingsConfigured() {
        return List.of((Object[])KEYS.values()).exists(key -> io.vavr.control.Option.of((Object)this.settings.get(((KEYS)key).key)).isDefined());
    }

    public boolean isFederatedSsoEnabled() {
        return !"false".equals(this.settings.get(KEYS.SAML_ENABLED.key));
    }

    public void setFederatedSsoEnabled(boolean idpLoginEnabled) {
        this.settings.put(KEYS.SAML_ENABLED.key, (Object)Boolean.toString(idpLoginEnabled));
    }

    public boolean isWarnSamlKeyExpires() {
        return !"false".equals(this.settings.get(KEYS.WARN_SAML_KEY_EXPIRES.key));
    }

    public void setWarnSamlKeyExpires(boolean warnSamlKeyExpires) {
        this.settings.put(KEYS.WARN_SAML_KEY_EXPIRES.key, (Object)Boolean.toString(warnSamlKeyExpires));
    }

    public void removeDraft(String id) {
        File draftDirectory = new File(this.getDraftsDirectory(), id + ".draft");
        try {
            FileUtils.deleteDirectory((File)draftDirectory);
            this.updateStateId();
        }
        catch (IOException e) {
            log.error("Unable to remove draft.", (Throwable)e);
        }
    }

    public void addDraft(JSONObject data) throws IOException {
        String idp_id = (String)io.vavr.control.Option.of((Object)data.getJSONObject("commonWizardState").getString("idp_id")).getOrElseThrow(() -> new IllegalArgumentException("idp_id invalid"));
        File draftJsonFile = (File)io.vavr.control.Option.of((Object)this.getDraftsDirectory()).map(draftsDir -> new File((File)draftsDir, idp_id + ".draft")).map(draftDir -> new File((File)draftDir, "provider_draft.json")).getOrElseThrow(() -> new InternalError("Could not create draft file"));
        FileUtils.writeStringToFile((File)draftJsonFile, (String)data.toString(), (Charset)StandardCharsets.UTF_8);
        this.updateStateId();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Properties readDraft(String id) {
        File draft = new File(this.getDraftsDirectory(), id + ".draft");
        if (!draft.exists()) {
            return null;
        }
        Properties props = new Properties();
        try (InputStreamReader in = new InputStreamReader(Files.newInputStream(draft.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
            props.load(in);
            Properties properties = props;
            return properties;
        }
        catch (IOException e) {
            log.error("Unable to read drafts.", (Throwable)e);
            return null;
        }
    }

    private String commaSeparatedLongs(Set<Long> longs) {
        StringBuilder sb = new StringBuilder();
        for (Long l : longs) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(l);
        }
        return sb.toString();
    }

    private void addGroupElements(Element provider, String key, Collection<ManagedGroup> managedGroups) {
        for (ManagedGroup managedGroup : managedGroups) {
            Element element = provider.getOwnerDocument().createElement(key);
            element.setAttribute(NAME, managedGroup.getName());
            provider.appendChild(element);
        }
    }

    void updateSigningKeyPassword(String currentPassword, String newPassword) {
        if (currentPassword == null && newPassword == null) {
            return;
        }
        if (currentPassword != null && currentPassword.equals(newPassword)) {
            return;
        }
        if (this.isActiveSigningKeyDefined()) {
            SamlKeyGenerator generator = new SamlKeyGenerator(this.secureRandom);
            File[] keystoreFiles = this.getSigningKeysDirectory().listFiles(pathname -> pathname.getName().endsWith(".jks"));
            if (keystoreFiles != null) {
                for (File file : keystoreFiles) {
                    generator.getPrivateKey(file, currentPassword);
                }
                for (File file : keystoreFiles) {
                    generator.updatePassword(file, currentPassword, newPassword);
                }
            }
        }
    }

    @Override
    public JSONObject asJson() {
        JSONObject json = new JSONObject();
        json.put("settings", this.getSettings());
        json.put("redirectProgressDelay", this.getRedirectProgressDelay());
        return json;
    }

    public static class IdpServletUtil {
        public static String getId(HttpServletRequest req) {
            return (String)io.vavr.control.Option.of((Object)req).map(HttpServletRequest::getPathInfo).map(pathInfo -> pathInfo.replaceAll("(.*providers/)(.+)(/.*)", "$2")).getOrElse((Object)"");
        }
    }

    private static class ProviderState {
        private final String stateId;
        private final Collection<IdpConfiguration> idpConfigurations;
        private final Collection<JSONObject> drafts;

        ProviderState(String stateId, Collection<IdpConfiguration> idpConfigurations, Collection<JSONObject> drafts) {
            this.stateId = stateId;
            this.idpConfigurations = idpConfigurations;
            this.drafts = drafts;
        }

        Collection<IdpConfiguration> getIdpConfigurations() {
            return this.idpConfigurations;
        }

        Collection<JSONObject> getDrafts() {
            return this.drafts;
        }

        boolean isCurrent(String stateId) {
            if (stateId == null) {
                return this.stateId == null;
            }
            return stateId.equals(this.stateId);
        }
    }

    public static enum NAME_ATTRIBUTE_MAPPING {
        FULL_NAME,
        FIRST_AND_LAST_NAME;

    }

    private static enum KEYS {
        SAML_STATE_ID("samlStateId"),
        SAML_ENABLED("samlEnabled"),
        WARN_SAML_KEY_EXPIRES("warnSamlKeyExpires"),
        SAML_PRIVATE_KEY_PASSWORD("samlPrivateKeyPassword"),
        REDIRECT_CUSTOM_PROGRESS_DELAY("redirectCustomProgressDelay"),
        LOGIN_ENABLED_FOR_JSD("loginEnabledForJSD");

        private final String key;

        private KEYS(String key) {
            this.key = key;
        }
    }
}

