/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.jobs;

import com.atlassian.config.ConfigurationException;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.config.JobRunnerKey;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.joda.time.DateTime;
import org.kantega.atlaskerb.InactiveUserCleaner;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.jsoncreatorclasses.DryRunAttributes;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.jsoncreatorclasses.UserCleanupResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UserCleanupJobRunner
implements JobRunner,
Runnable {
    public static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)(UserCleanupJobRunner.class + ".job"));
    private static final Logger log = LoggerFactory.getLogger(UserCleanupJobRunner.class);
    private final HostApp hostApp;

    @Inject
    public UserCleanupJobRunner(HostAppFactory hostAppFactory) {
        this.hostApp = hostAppFactory.getInstance();
    }

    public UserCleanupJobRunner(HostApp hostApp) {
        this.hostApp = hostApp;
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
        try {
            this.hostApp.cleanupInactiveUsers(null, new DryRunAttributes(false, false), DateTime.now(), UUID.randomUUID().toString());
        }
        catch (ConfigurationException e) {
            return JobRunnerResponse.failed((Throwable)e);
        }
        return JobRunnerResponse.success();
    }

    @Override
    public void run() {
        try {
            this.hostApp.setUserCleanupExecuteStatus(InactiveUserCleaner.CleanupStatus.RUNNING);
            UserCleanupResult userCleanupResult = this.hostApp.cleanupInactiveUsers(null, new DryRunAttributes(false, false), DateTime.now(), UUID.randomUUID().toString());
            this.hostApp.setUserCleanupExecuteStatus(InactiveUserCleaner.CleanupStatus.SUCCESS);
        }
        catch (ConfigurationException e) {
            this.hostApp.setUserCleanupExecuteStatus(InactiveUserCleaner.CleanupStatus.FAILED);
            throw new RuntimeException(e);
        }
    }
}

