/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.PluginKey;
import org.kantega.atlaskerb.saml.IdpConfManager;

public class Jira6SamlFilter
implements Filter {
    private final TemplateRenderer templateRenderer;
    private final IdpConfManager idpConfManager;
    private final KerbConfManager kerbConfManager;

    @Inject
    public Jira6SamlFilter(@ComponentImport TemplateRenderer templateRenderer, IdpConfManager idpConfManager, KerbConfManager kerbConfManager) {
        this.templateRenderer = templateRenderer;
        this.idpConfManager = idpConfManager;
        this.kerbConfManager = kerbConfManager;
    }

    public void init(FilterConfig filterConfig) {
    }

    private void appendScript(StringWriter inject, String contextPath, String file) {
        String src = contextPath + "/download/resources/" + file;
        inject.append("<script src=\"").append(src).append("\"></script>");
    }

    private void appendLink(StringWriter inject, String contextPath, String file) {
        String src = contextPath + "/download/resources/" + file;
        inject.append("<link type=\"text/css\" rel=\"stylesheet\" href=\"").append(src).append("\">");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        String url = req.getParameter("url");
        if (url == null || !url.contains("gadgets/login.xml") || !this.idpConfManager.isLicenseValid() || this.idpConfManager.countActiveProviders() == 0) {
            chain.doFilter(request, response);
            return;
        }
        final StringWriter inject = new StringWriter();
        this.appendScript(inject, req.getContextPath(), PluginKey.getPluginKey() + ":entrypoint-saml-login/saml-login.js");
        this.appendScript(inject, req.getContextPath(), "com.atlassian.auiplugin:aui-dropdown2/dropdown2.js");
        this.appendLink(inject, req.getContextPath(), "com.atlassian.auiplugin:aui-buttons/aui-buttons.css");
        this.appendLink(inject, req.getContextPath(), "com.atlassian.auiplugin:aui-dropdown2/dropdown2.css");
        inject.append("<script>window.contextPath = \"").append(req.getContextPath()).append("\";</script>");
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("samlLoginUsernamePlaceholder", this.kerbConfManager.getSamlLoginUsernamePlaceholder());
        model.put("nextButtonText", this.kerbConfManager.getNextButtonText());
        model.put("usernameFieldText", this.kerbConfManager.getUsernameFieldText());
        model.put("idpListTitleText", this.kerbConfManager.getIdpListTitleText());
        model.put("shouldLoginManually", false);
        model.put("redirectProgressDelay", this.idpConfManager.getRedirectProgressDelay() + "s");
        this.templateRenderer.render("templates/atlaskerb/saml-login.vm", model, (Writer)inject);
        chain.doFilter((ServletRequest)req, (ServletResponse)new HttpServletResponseWrapper(resp){
            PrintWriter w;

            public PrintWriter getWriter() throws IOException {
                if (this.w == null) {
                    this.w = new PrintWriter(super.getWriter()){

                        @Override
                        public void write(String s) {
                            super.write(s.replace("</body>", inject + "</body>"));
                        }
                    };
                }
                return this.w;
            }
        });
    }

    public void destroy() {
    }
}

