/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.identityproviders.setup;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.kantegasso.oidc.OidcData;
import com.kantegasso.runtimetrust.FingerprintSSLSocketFactory;
import io.vavr.API;
import io.vavr.CheckedFunction0;
import io.vavr.Predicates;
import io.vavr.Tuple2;
import io.vavr.Value;
import io.vavr.collection.HashMap;
import io.vavr.collection.List;
import io.vavr.collection.Map;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONObject;
import org.kantega.atlaskerb.Bucket;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.IdpConfigurationBuilder;
import org.kantega.atlaskerb.identityproviders.oidc.OidcIdpConfiguration;
import org.kantega.atlaskerb.identityproviders.oidc.OidcLibWrapper;
import org.kantega.atlaskerb.identityproviders.oidc.ResumeOidcLoginServlet;
import org.kantega.atlaskerb.identityproviders.setup.ConfigJit;
import org.kantega.atlaskerb.identityproviders.setup.IdpActionResult;
import org.kantega.atlaskerb.identityproviders.setup.OidcValidator;
import org.kantega.atlaskerb.identityproviders.setup.SamlMetadataParserWrapper;
import org.kantega.atlaskerb.identityproviders.setup.SamlValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
class IdpActions {
    private final ApplicationProperties applicationProperties;
    private final Bucket bucket;
    private final OidcLibWrapper oidcLibWrapper;
    private final OidcValidator oidcValidator;
    private final SamlValidator samlValidator;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Inject
    public IdpActions(@ComponentImport ApplicationProperties applicationProperties, Bucket bucket, OidcValidator oidcValidator, SamlValidator samlValidator) {
        this.applicationProperties = applicationProperties;
        this.bucket = bucket;
        this.oidcLibWrapper = bucket.getOidcLibWrapper();
        this.oidcValidator = oidcValidator;
        this.samlValidator = samlValidator;
    }

    IdpActionResult _undefined(HttpServletRequest req, JSONObject actionObject) {
        return new IdpActionResult(false, "Unrecognized action. Pass a valid JSONObject, with a legal 'action'-value.", (Map<String, ?>)HashMap.of((Object)"action", (Object)actionObject.get("action"), (Object)"legal_actions", (Object)new JSONArray((Object)LegalActions.values())), 400);
    }

    IdpActionResult getStaticData(HttpServletRequest req, JSONObject actionObject) {
        return new IdpActionResult(true, null, (Map<String, ?>)HashMap.ofEntries((Tuple2[])new Tuple2[]{API.Tuple((Object)"legal_actions", (Object)new JSONArray((Object)LegalActions.values())), API.Tuple((Object)"legal_kinds", (Object)new JSONArray((Object)IdpConfiguration.Kind.values())), API.Tuple((Object)"legal_sso_protocols", (Object)new JSONArray((Object)IdpConfiguration.SSOProtocol.values())), API.Tuple((Object)"legal_user_activate_policies", (Object)new JSONArray((Object)IdpConfiguration.UserActivatePolicy.values())), API.Tuple((Object)"legal_user_update_name_policies", (Object)new JSONArray((Object)IdpConfiguration.UserUpdateNamePolicy.values())), API.Tuple((Object)"legal_user_update_email_policies", (Object)new JSONArray((Object)IdpConfiguration.UserUpdateEmailPolicy.values())), API.Tuple((Object)"legal_user_not_found_policies", (Object)new JSONArray((Object)IdpConfiguration.UserNotFoundPolicy.values())), API.Tuple((Object)"legal_username_attributes", (Object)new JSONArray((Object)IdpConfiguration.UsernameAttribute.values())), API.Tuple((Object)"legal_username_policies", (Object)new JSONArray((Object)IdpConfiguration.UsernamePolicy.values())), API.Tuple((Object)"legal_user_lookup_attributes", (Object)new JSONArray((Object)IdpConfiguration.UserLookupAttribute.values())), API.Tuple((Object)"oidc_callback_url", (Object)ResumeOidcLoginServlet.getCallbackUrl(this.applicationProperties))}), 200);
    }

    IdpActionResult oidcCreate(HttpServletRequest req, JSONObject actionObject) {
        JSONObject idp = actionObject.optJSONObject("idp");
        ConfigJit configJit = new ConfigJit(idp);
        IdpConfiguration.Kind kind = (IdpConfiguration.Kind)((Object)Option.of((Object)idp.optString("kind", null)).map(IdpConfiguration.Kind::valueOf).getOrNull());
        IdpConfiguration.UsernameAttribute usernameAttribute = (IdpConfiguration.UsernameAttribute)((Object)Option.of((Object)actionObject.optString("username_attribute", null)).map(IdpConfiguration.UsernameAttribute::valueOf).getOrElse(API.Match((Object)((Object)kind)).of(new API.Match.Case[]{API.Case((API.Match.Pattern0)API.$((Predicate)Predicates.isIn((Object[])new IdpConfiguration.Kind[]{IdpConfiguration.Kind.ADFS})), (Object)((Object)IdpConfiguration.UsernameAttribute.UPN)), API.Case((API.Match.Pattern0)API.$((Predicate)Predicates.isIn((Object[])new IdpConfiguration.Kind[]{IdpConfiguration.Kind.WSO2, IdpConfiguration.Kind.AUTH0, IdpConfiguration.Kind.AWS_COGNITO})), (Object)((Object)IdpConfiguration.UsernameAttribute.USERNAME)), API.Case((API.Match.Pattern0)API.$((Predicate)Predicates.isIn((Object[])new IdpConfiguration.Kind[]{IdpConfiguration.Kind.AZURE_AD, IdpConfiguration.Kind.KEYCLOAK, IdpConfiguration.Kind.OKTA, IdpConfiguration.Kind.ONELOGIN, IdpConfiguration.Kind.PINGFEDERATE, IdpConfiguration.Kind.SALESFORCE})), (Object)((Object)IdpConfiguration.UsernameAttribute.PREFERRED_USERNAME)), API.Case((API.Match.Pattern0)API.$((Predicate)Predicates.isIn((Object[])new IdpConfiguration.Kind[]{IdpConfiguration.Kind.GITHUB, IdpConfiguration.Kind.GITLAB, IdpConfiguration.Kind.GOOGLE})), (Object)((Object)IdpConfiguration.UsernameAttribute.CUSTOM_SAML_ATTRIBUTE_NAME)), API.Case((API.Match.Pattern0)API.$(), (Object)((Object)IdpConfiguration.UsernameAttribute.SUB))})));
        String customUsernameAttributeName = (String)Option.of((Object)actionObject.optString("custom_username_attribute_name", null)).getOrElse(API.Match((Object)((Object)kind)).of(new API.Match.Case[]{API.Case((API.Match.Pattern0)API.$((Object)((Object)IdpConfiguration.Kind.GITHUB)), (Object)"login"), API.Case((API.Match.Pattern0)API.$((Object)((Object)IdpConfiguration.Kind.GITLAB)), (Object)"nickname"), API.Case((API.Match.Pattern0)API.$((Object)((Object)IdpConfiguration.Kind.GOOGLE)), (Object)"email"), API.Case((API.Match.Pattern0)API.$(), (Object)"")}));
        String customNameAttribute = kind.getOidcDefaultNameAttribute();
        String customEmailAttribute = kind.getOidcDefaultEmailAttribute();
        return (IdpActionResult)this.oidcValidator.validateAndCreateOidcConfig(idp).map(maybeOidcConfigBuilder -> maybeOidcConfigBuilder.map(configJit::applyToIdpConfigBuilder).flatMap(Value::toTry).map(idpConfigurationBuilder -> (IdpConfigurationBuilder.Oidc)idpConfigurationBuilder.setUsernameAttribute(usernameAttribute)).map(idpConfigurationBuilder -> (IdpConfigurationBuilder.Oidc)idpConfigurationBuilder.setCustomUsernameAttributeName(customUsernameAttributeName)).map(idpConfigurationBuilder -> (IdpConfigurationBuilder.Oidc)idpConfigurationBuilder.setCustomNameAttribute(customNameAttribute)).map(idpConfigurationBuilder -> (IdpConfigurationBuilder.Oidc)idpConfigurationBuilder.setCustomEmailAttribute(customEmailAttribute)).map(IdpConfigurationBuilder::build).onSuccess(this.bucket.getIdpConfManager()::addIdpConfiguration).mapTry(this.bucket::wrapWithOidcConfig).onFailure(throwable -> this.log.error(throwable.getMessage()))).fold(IdpActionResult::fromValidationErrors, IdpActionResult::fromOidcIdpConfigWithBucketTry);
    }

    private IdpActionResult oidcScopesSupportedExecute(JSONObject actionObject) {
        return (IdpActionResult)this.oidcLibWrapper.createOidcData((HashMap<String, Object>)HashMap.of((Object)"discovery_url", (Object)actionObject.optString("discovery_url"), (Object)"workaround", (Object)OidcIdpConfiguration.extractOidcWorkaround(actionObject.getString("kind")), (Object)"trusted_tls_fingerprint", (Object)actionObject.optString("fingerprint"))).flatMap(this.oidcLibWrapper::discover).map(OidcData::getScopesSupported).map(Value::toJavaList).map(JSONArray::new).map(scopeArray -> HashMap.of((Object)"scopes_supported", (Object)scopeArray)).fold(errorMsg -> new IdpActionResult(false, (String)errorMsg, null, 500), scopeData -> new IdpActionResult(true, null, (Map<String, ?>)scopeData, 200));
    }

    IdpActionResult oidcScopesSupported(HttpServletRequest req, JSONObject actionObject) {
        String fingerprint = actionObject.optString("fingerprint");
        String discoveryUrl = actionObject.optString("discovery_url");
        return (IdpActionResult)Try.of((CheckedFunction0 & Serializable)() -> discoveryUrl).mapTry(URL::new).mapTry(URL::openConnection).peek(urlConnection -> urlConnection.setConnectTimeout(10000)).peek(urlConnection -> urlConnection.setReadTimeout(30000)).peek(urlConnection -> {
            if (urlConnection instanceof HttpsURLConnection) {
                ((HttpsURLConnection)urlConnection).setSSLSocketFactory((SSLSocketFactory)new FingerprintSSLSocketFactory(fingerprint));
            }
        }).mapTry(URLConnection::getInputStream).fold(throwable -> IdpActionResult.fromThrowableMetadataImport(throwable, discoveryUrl), _urlConnection -> this.oidcScopesSupportedExecute(actionObject));
    }

    IdpActionResult samlCreate(HttpServletRequest req, JSONObject actionObject) {
        JSONObject idp = actionObject.optJSONObject("idp");
        ConfigJit configJit = new ConfigJit(idp);
        IdpConfiguration.Kind kind = (IdpConfiguration.Kind)((Object)Option.of((Object)idp.optString("kind", null)).map(IdpConfiguration.Kind::valueOf).getOrNull());
        IdpConfiguration.UsernameAttribute usernameAttribute = (IdpConfiguration.UsernameAttribute)((Object)Option.of((Object)actionObject.optString("username_attribute", null)).map(IdpConfiguration.UsernameAttribute::valueOf).getOrElse(API.Match((Object)((Object)kind)).of(new API.Match.Case[]{API.Case((API.Match.Pattern0)API.$((Predicate)Predicates.isIn((Object[])new IdpConfiguration.Kind[]{IdpConfiguration.Kind.ADFS})), (Object)((Object)IdpConfiguration.UsernameAttribute.UPN)), API.Case((API.Match.Pattern0)API.$((Predicate)Predicates.isIn((Object[])new IdpConfiguration.Kind[]{IdpConfiguration.Kind.AUTH0, IdpConfiguration.Kind.BITIUM, IdpConfiguration.Kind.GOOGLE, IdpConfiguration.Kind.KEYCLOAK, IdpConfiguration.Kind.OKTA, IdpConfiguration.Kind.ONELOGIN, IdpConfiguration.Kind.PINGONE, IdpConfiguration.Kind.PINGFEDERATE, IdpConfiguration.Kind.SALESFORCE, IdpConfiguration.Kind.WSO2})), (Object)((Object)IdpConfiguration.UsernameAttribute.NAME_ID)), API.Case((API.Match.Pattern0)API.$((Predicate)Predicates.isIn((Object[])new IdpConfiguration.Kind[]{IdpConfiguration.Kind.AZURE_AD})), (Object)((Object)IdpConfiguration.UsernameAttribute.NAME)), API.Case((API.Match.Pattern0)API.$((Predicate)Predicates.isIn((Object[])new IdpConfiguration.Kind[]{IdpConfiguration.Kind.AWS_COGNITO, IdpConfiguration.Kind.GITHUB, IdpConfiguration.Kind.GITLAB})), (Object)((Object)IdpConfiguration.UsernameAttribute.CUSTOM_SAML_ATTRIBUTE_NAME)), API.Case((API.Match.Pattern0)API.$(), (Object)((Object)IdpConfiguration.UsernameAttribute.NAME_ID))})));
        String customUsernameAttributeName = (String)Option.of((Object)actionObject.optString("custom_username_attribute_name", null)).getOrElse(API.Match((Object)((Object)kind)).of(new API.Match.Case[]{API.Case((API.Match.Pattern0)API.$((Object)((Object)IdpConfiguration.Kind.AWS_COGNITO)), (Object)"username"), API.Case((API.Match.Pattern0)API.$((Object)((Object)IdpConfiguration.Kind.GITHUB)), (Object)"login"), API.Case((API.Match.Pattern0)API.$((Object)((Object)IdpConfiguration.Kind.GITLAB)), (Object)"nickname"), API.Case((API.Match.Pattern0)API.$(), (Object)"")}));
        return (IdpActionResult)this.samlValidator.validateAndCreateSamlConfig(idp).map(maybeSamlConfigBuilder -> maybeSamlConfigBuilder.map(configJit::applyToIdpConfigBuilder).flatMap(Value::toTry).map(idpConfigurationBuilder -> (IdpConfigurationBuilder.Saml)idpConfigurationBuilder.setUsernameAttribute(usernameAttribute)).map(idpConfigurationBuilder -> (IdpConfigurationBuilder.Saml)idpConfigurationBuilder.setCustomUsernameAttributeName(customUsernameAttributeName)).map(IdpConfigurationBuilder::build).onSuccess(this.bucket.getIdpConfManager()::addIdpConfiguration).mapTry(this.bucket::wrapWithSamlConfig).onFailure(throwable -> this.log.error(throwable.getMessage()))).fold(IdpActionResult::fromValidationErrors, IdpActionResult::fromSamlIdpConfigWithBucketTry);
    }

    IdpActionResult samlImportMetadataFromPaste(HttpServletRequest req, JSONObject actionObject) {
        return (IdpActionResult)SamlMetadataParserWrapper.fromPaste(actionObject.optString("metadata")).fold(IdpActionResult::fromThrowable, IdpActionResult::fromSamlMetadataParserWrapper);
    }

    IdpActionResult samlImportMetadataFromUrl(HttpServletRequest req, JSONObject actionObject) {
        String metadataUrl = actionObject.optString("metadata_url");
        return (IdpActionResult)SamlMetadataParserWrapper.fromUrl(metadataUrl).fold(throwable -> IdpActionResult.fromThrowableMetadataImport(throwable, metadataUrl), IdpActionResult::fromSamlMetadataParserWrapper);
    }

    IdpActionResult samlImportMetadataFromSelfSignedUrl(HttpServletRequest req, JSONObject actionObject) {
        String metadataUrl = actionObject.optString("metadata_url");
        return (IdpActionResult)SamlMetadataParserWrapper.fromUrl(metadataUrl, actionObject.optString("fingerprint")).fold(throwable -> IdpActionResult.fromThrowableMetadataImport(throwable, metadataUrl), IdpActionResult::fromSamlMetadataParserWrapper);
    }

    IdpActionResult idpId(HttpServletRequest req, JSONObject actionObject) {
        return (IdpActionResult)Try.of((CheckedFunction0 & Serializable)() -> {
            String idpId = this.bucket.getIdpConfManager().nextId();
            JSONObject newDraft = new JSONObject();
            JSONObject commonWizardState = new JSONObject();
            commonWizardState.put("idp_id", (Object)idpId);
            commonWizardState.put("display_name", (Object)"");
            String timestamp = OffsetDateTime.now().format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
            commonWizardState.put("timestamp", (Object)timestamp);
            newDraft.put("commonWizardState", (Object)commonWizardState);
            this.bucket.getIdpConfManager().addDraft(newDraft);
            return HashMap.of((Object)"idp_id", (Object)idpId);
        }).fold(IdpActionResult::fromThrowable, data -> new IdpActionResult(true, "", (Map<String, ?>)data, 200));
    }

    IdpActionResult storeDraft(HttpServletRequest req, JSONObject actionObject) {
        return (IdpActionResult)Try.of((CheckedFunction0 & Serializable)() -> {
            JSONObject data = (JSONObject)Option.of((Object)actionObject.getJSONObject("data")).getOrElseThrow(() -> new IllegalArgumentException("data missing from request"));
            String idp_id = (String)Option.of((Object)data.getJSONObject("commonWizardState").getString("idp_id")).getOrElseThrow(() -> new IllegalArgumentException("idp_id invalid"));
            String timestamp = OffsetDateTime.now().format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
            JSONObject newCommonState = data.getJSONObject("commonWizardState").put("timestamp", (Object)timestamp);
            data.put("commonWizardState", (Object)newCommonState);
            this.bucket.getIdpConfManager().addDraft(data);
            return "Stored draft with id: " + idp_id;
        }).fold(IdpActionResult::fromThrowable, message -> new IdpActionResult(true, (String)message, null, 200));
    }

    IdpActionResult deleteDraft(HttpServletRequest req, JSONObject actionObject) {
        return (IdpActionResult)Try.of((CheckedFunction0 & Serializable)() -> {
            JSONObject data = (JSONObject)Option.of((Object)actionObject.getJSONObject("data")).getOrElseThrow(() -> new IllegalArgumentException("data missing from request"));
            String id = (String)Option.of((Object)data.getString("id")).getOrElseThrow(() -> new IllegalArgumentException("id invalid"));
            this.bucket.getIdpConfManager().removeDraft(id);
            return "Deleted draft with id: " + id;
        }).fold(IdpActionResult::fromThrowable, message -> new IdpActionResult(true, (String)message, null, 200));
    }

    IdpActionResult loadDraft(HttpServletRequest req, JSONObject actionObject) {
        return (IdpActionResult)Try.of((CheckedFunction0 & Serializable)() -> {
            JSONObject data = (JSONObject)Option.of((Object)actionObject.getJSONObject("data")).getOrElseThrow(() -> new IllegalArgumentException("data missing from request"));
            String id = (String)Option.of((Object)data.getString("id")).getOrElseThrow(() -> new IllegalArgumentException("id invalid"));
            Collection<JSONObject> drafts = this.bucket.getIdpConfManager().getDrafts();
            return ((JSONObject)List.ofAll(drafts).find(draft -> draft.getJSONObject("commonWizardState").getString("idp_id").equals(id)).getOrElseThrow(() -> new IllegalArgumentException("Draft does not exist"))).toString();
        }).fold(IdpActionResult::fromThrowable, draft -> new IdpActionResult(true, "Loaded draft", (Map<String, ?>)HashMap.ofEntries((Tuple2[])new Tuple2[]{API.Tuple((Object)"draft", (Object)draft)}), 200));
    }

    static enum LegalActions {
        GET_STATIC_DATA,
        OIDC_CREATE,
        OIDC_SCOPES_SUPPORTED,
        SAML_CREATE,
        SAML_IMPORT_METADATA_FROM_PASTE,
        SAML_IMPORT_METADATA_FROM_URL,
        SAML_IMPORT_METADATA_FROM_SELF_SIGNED_URL,
        IDP_ID,
        STORE_DRAFT,
        DELETE_DRAFT,
        LOAD_DRAFT;

    }
}

