/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.apiserver;

import com.atlassian.crowd.embedded.impl.ImmutableDirectory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.upm.api.license.PluginLicenseManager;
import io.prometheus.client.exporter.MetricsServlet;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.kantega.atlaskerb.apiserver.ApiServerConfManager;
import org.kantega.atlaskerb.apiserver.ApiServerConfigState;
import org.kantega.atlaskerb.apiserver.KSSOJettySlf4jLog;
import org.kantega.atlaskerb.connector.ConnectorConfManager;
import org.kantega.atlaskerb.connector.admin.CrowdDirectoryFinder;
import org.kantega.atlaskerb.connector.crowdserver.CrowdApiHandler;
import org.kantega.atlaskerb.connector.model.Directory;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.scim.AtlScimServlet;
import org.kantega.atlaskerb.scim.ScimConfManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class ApiServer
implements InitializingBean,
DisposableBean {
    private final ScimConfManager scimConfManager;
    private final ConnectorConfManager connectorConfManager;
    private final ApiServerConfManager apiServerConfManager;
    private final HostApp hostApp;
    private final PluginLicenseManager pluginLicenseManager;
    private volatile Server server;
    private volatile Exception startException;
    private volatile ApiServerConfigState config;
    private static final Logger log = LoggerFactory.getLogger(ApiServer.class);
    private final TransactionTemplate transactionTemplate;

    @Inject
    public ApiServer(@ComponentImport PluginLicenseManager pluginLicenseManager, @ComponentImport TransactionTemplate transactionTemplate, ScimConfManager scimConfManager, ConnectorConfManager connectorConfManager, ApiServerConfManager apiServerConfManager, HostAppFactory hostAppFactory) {
        this.scimConfManager = scimConfManager;
        this.connectorConfManager = connectorConfManager;
        this.apiServerConfManager = apiServerConfManager;
        this.hostApp = hostAppFactory.getInstance();
        this.pluginLicenseManager = pluginLicenseManager;
        this.transactionTemplate = transactionTemplate;
    }

    private void stop() {
        try {
            if (this.server != null) {
                this.server.stop();
                this.server = null;
                this.startException = null;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void destroy() {
        this.stop();
    }

    public void afterPropertiesSet() {
        this.configChanged(this.apiServerConfManager.getConfig());
    }

    public Exception configChanged(ApiServerConfigState config) {
        if (this.config == null || !this.config.isCurrent(config.getStateId())) {
            this.config = config;
            if (this.server != null) {
                this.stop();
            }
            this.server = null;
            if (config.isEnabled()) {
                try {
                    System.setProperty("org.eclipse.jetty.util.log.class", KSSOJettySlf4jLog.class.getName());
                    Server server = new Server(new InetSocketAddress(config.getAddress(), config.getPort()));
                    ContextHandler crowdContext = this.initCrowdContext();
                    ServletContextHandler scimContext = this.initScimContext();
                    ServletContextHandler promContext = this.initPrometheusContext();
                    ContextHandlerCollection contextHandlerCollection = new ContextHandlerCollection(new ContextHandler[]{crowdContext, scimContext, promContext});
                    server.setHandler((Handler)contextHandlerCollection);
                    server.start();
                    this.server = server;
                    this.startException = null;
                }
                catch (Exception e) {
                    this.startException = e;
                    log.error("Failed starting Jetty on " + config.getAddress() + ":" + config.getPort(), (Throwable)e);
                    return e;
                }
            }
        }
        return null;
    }

    public boolean isRunning() {
        return this.server != null;
    }

    public Exception getStartException() {
        return this.startException;
    }

    public ApiServerConfigState getConfig() {
        return this.config;
    }

    public void updateConnectorDirectories(List<com.atlassian.crowd.embedded.api.Directory> needsUpdate, String serverURL) {
        for (com.atlassian.crowd.embedded.api.Directory directory : needsUpdate) {
            this.transactionTemplate.execute(() -> {
                ImmutableDirectory.Builder builder = ImmutableDirectory.newBuilder((com.atlassian.crowd.embedded.api.Directory)directory);
                HashMap<String, String> attrs = new HashMap<String, String>(directory.getAttributes());
                attrs.put("crowd.server.url", serverURL);
                builder.setAttributes(attrs);
                com.atlassian.crowd.embedded.api.Directory updatedDirectory = builder.toDirectory();
                return this.hostApp.getCrowdDirectoryService().updateDirectory(updatedDirectory);
            });
        }
    }

    public List<com.atlassian.crowd.embedded.api.Directory> findConnectorDirectoriesToUpdate() {
        ArrayList<com.atlassian.crowd.embedded.api.Directory> result = new ArrayList<com.atlassian.crowd.embedded.api.Directory>();
        String serverURL = this.apiServerConfManager.getCrowdServerUrl();
        for (Directory directory : this.connectorConfManager.getDirectories()) {
            com.atlassian.crowd.embedded.api.Directory cwd = new CrowdDirectoryFinder(this.hostApp).findDirectory(directory.getId());
            if (cwd == null || !serverURL.equals(cwd.getAttributes().get("crowd.server.url"))) continue;
            result.add(cwd);
        }
        return result;
    }

    private ServletContextHandler initPrometheusContext() throws Exception {
        ServletContextHandler ctx = new ServletContextHandler(null, "/metrics");
        MetricsServlet servlet = new MetricsServlet();
        ServletHandler servlethandler = new ServletHandler();
        servlethandler.addServletWithMapping(new ServletHolder((Servlet)servlet), "/*");
        ctx.insertHandler((HandlerWrapper)servlethandler);
        servlethandler.initialize();
        return ctx;
    }

    private ServletContextHandler initScimContext() throws Exception {
        ServletContextHandler ctx = new ServletContextHandler(null, "/scim");
        AtlScimServlet servlet = new AtlScimServlet(this.scimConfManager, this.pluginLicenseManager, true);
        ServletHandler servlethandler = new ServletHandler();
        servlethandler.addServletWithMapping(new ServletHolder((Servlet)servlet), "/*");
        ctx.insertHandler((HandlerWrapper)servlethandler);
        servlethandler.initialize();
        return ctx;
    }

    private ContextHandler initCrowdContext() {
        ContextHandler ctx = new ContextHandler("/rest");
        ctx.setHandler((Handler)new CrowdApiHandler(this.connectorConfManager, this.hostApp, this.pluginLicenseManager));
        return ctx;
    }
}

