/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml.logout;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.xsrf.XsrfTokenAccessor;
import com.atlassian.sal.api.xsrf.XsrfTokenValidator;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;
import javax.inject.Inject;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.kantega.atlaskerb.saml.logout.SingleLogoutAppHelper;
import org.kantega.atlaskerb.security.CookieSecurity;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.springframework.stereotype.Component;

@Component
public class SingleLogoutAppHelperFactory {
    private final XsrfTokenAccessor xsrfTokenAccessor;
    private final XsrfTokenValidator xsrfTokenValidator;
    private final SingleLogoutAppHelper instance;
    private final ApplicationProperties applicationProperties;

    @Inject
    public SingleLogoutAppHelperFactory(@ComponentImport ApplicationProperties applicationProperties, @ComponentImport XsrfTokenAccessor xsrfTokenAccessor, @ComponentImport XsrfTokenValidator xsrfTokenValidator) {
        this.applicationProperties = applicationProperties;
        this.xsrfTokenAccessor = xsrfTokenAccessor;
        this.xsrfTokenValidator = xsrfTokenValidator;
        String dn = applicationProperties.getDisplayName().toLowerCase();
        if (dn.contains("jira")) {
            this.instance = new JiraLogoutHelper();
        } else if (dn.contains("confluence")) {
            this.instance = new ConfluenceLogoutHelper();
        } else if (dn.contains("bitbucket")) {
            this.instance = new BitbucketLogoutHelper();
        } else if (dn.contains("fisheye")) {
            this.instance = new FecruLogoutHelper();
        } else if (dn.contains("bamboo")) {
            this.instance = new BambooLogoutHelper();
        } else {
            throw new IllegalStateException("This plugin does not work on " + applicationProperties.getDisplayName());
        }
    }

    public SingleLogoutAppHelper getInstance() {
        return this.instance;
    }

    protected void removeCookie(HttpServletRequest req, HttpServletResponse res, String cookieName) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(cookieName)) continue;
                Cookie delCookie = CookieSecurity.cookieWithDynamicSecurity(this.applicationProperties, cookieName, "");
                delCookie.setMaxAge(0);
                delCookie.setPath(req.getContextPath() + "/");
                delCookie.setComment("HttpOnly");
                res.addCookie(delCookie);
                return;
            }
        }
    }

    class JiraLogoutHelper
    extends DefaultLogoutHelper {
        JiraLogoutHelper() {
            super(true);
        }

        @Override
        public boolean optionallyValidateXsrfToken(HttpServletRequest req, HttpServletResponse res) {
            if (StringUtils.isBlank((CharSequence)this.getIdFromCookieAndSetSessionId(req, res))) {
                return SingleLogoutAppHelperFactory.this.xsrfTokenValidator.validateFormEncodedToken(req);
            }
            return true;
        }

        @Override
        public void dispatchToLogoutConfirmed(HttpServletRequest req, HttpServletResponse res, String idpId) throws IOException {
            Pair<String, String> token = this.getStoredXsrfToken(req, res, true).orElseThrow(() -> new RuntimeException("Couldn't get required stored XSRF token"));
            String returnUrl = String.format("%s/Logout!default.jspa?%s=%s", req.getContextPath(), token.getKey(), HttpUrlUtils.urlEncode((String)token.getValue()));
            String jsdLogoutUrl = this.getCookieValue(req, "krb_logout_uri");
            SingleLogoutAppHelperFactory.this.removeCookie(req, res, "krb_logout_uri");
            if (jsdLogoutUrl != null) {
                String dest = StringUtils.substringAfter((String)jsdLogoutUrl, (String)"/customer/");
                dest = StringUtils.substringBefore((String)dest, (String)"/user/login");
                returnUrl = jsdLogoutUrl + String.format("?nokerberos&destination=%s&slo=finished&logout=true", HttpUrlUtils.urlEncode(dest));
            }
            res.sendRedirect(returnUrl);
        }
    }

    class ConfluenceLogoutHelper
    extends DefaultLogoutHelper {
        ConfluenceLogoutHelper() {
            super(false);
        }

        @Override
        public void dispatchToLogoutConfirmed(HttpServletRequest req, HttpServletResponse res, String idpId) throws IOException {
            res.sendRedirect(req.getContextPath() + "/login.action?logout=true");
        }
    }

    class BitbucketLogoutHelper
    extends DefaultLogoutHelper {
        BitbucketLogoutHelper() {
            super(false);
        }

        @Override
        public void dispatchToLogoutConfirmed(HttpServletRequest req, HttpServletResponse res, String idpId) throws IOException {
            res.sendRedirect(req.getContextPath() + "/j_atl_security_logout?nosaml");
        }
    }

    class FecruLogoutHelper
    extends DefaultLogoutHelper {
        FecruLogoutHelper() {
            super(false);
        }

        @Override
        public void dispatchToLogoutConfirmed(HttpServletRequest req, HttpServletResponse res, String idpId) throws IOException {
            res.sendRedirect(req.getContextPath() + "/logout");
        }
    }

    class BambooLogoutHelper
    extends DefaultLogoutHelper {
        BambooLogoutHelper() {
            super(false);
        }

        @Override
        public void dispatchToLogoutConfirmed(HttpServletRequest req, HttpServletResponse res, String idpId) throws IOException {
            res.sendRedirect(req.getContextPath() + "/start.action");
        }
    }

    abstract class DefaultLogoutHelper
    implements SingleLogoutAppHelper {
        private final boolean useXsrf;

        DefaultLogoutHelper(boolean useXsrf) {
            this.useXsrf = useXsrf;
        }

        @Override
        public boolean optionallyValidateXsrfToken(HttpServletRequest req, HttpServletResponse res) {
            return true;
        }

        @Override
        public Optional<Pair<String, String>> getStoredXsrfToken(HttpServletRequest req, HttpServletResponse res, boolean create) {
            String param = SingleLogoutAppHelperFactory.this.xsrfTokenValidator.getXsrfParameterName();
            String value = SingleLogoutAppHelperFactory.this.xsrfTokenAccessor.getXsrfToken(req, res, false);
            if (param == null || value == null) {
                return Optional.empty();
            }
            return Optional.of(Pair.of((Object)param, (Object)value));
        }

        @Override
        public void initiateLogout(HttpServletRequest req, HttpServletResponse res, String idpId) throws IOException {
            String url = String.format("%s/plugins/servlet/no.kantega.saml/sp/%s/logout?action=init", req.getContextPath(), idpId);
            if (this.useXsrf) {
                Pair<String, String> xrf = this.getStoredXsrfToken(req, res, false).orElseThrow(() -> new RuntimeException("Could not find required XSRF token"));
                url = url + String.format("&%s=%s", xrf.getKey(), HttpUrlUtils.urlEncode((String)xrf.getValue()));
            }
            res.sendRedirect(url);
        }

        @Override
        public String getIdFromCookieAndSetSessionId(HttpServletRequest req, HttpServletResponse res) {
            String idpConfigId = null;
            String cookieValue = this.getCookieValue(req, "krb_custport_logout");
            if (cookieValue != null && !"true".equals(cookieValue)) {
                String value = new String(Base64.getDecoder().decode(cookieValue.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
                idpConfigId = StringUtils.substringBefore((String)value, (String)"#");
                String sessId = StringUtils.substringAfter((String)value, (String)"#");
                req.getSession(true).setAttribute("sessionIdentification", (Object)sessId);
            }
            return idpConfigId;
        }

        protected String getCookieValue(HttpServletRequest req, String cookieName) {
            Cookie[] cookies = req.getCookies();
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (!cookie.getName().equals(cookieName)) continue;
                    return cookie.getValue();
                }
            }
            return null;
        }
    }
}

