/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import io.vavr.API;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.collection.List;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;
import org.joda.time.format.ISODateTimeFormat;
import org.json.JSONObject;
import org.kantega.atlaskerb.DateTool;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.connector.ConnectorConfManager;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.identityproviders.AttributeInfo;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.IdpConfigurationBuilder;
import org.kantega.atlaskerb.identityproviders.ManagedGroup;
import org.kantega.atlaskerb.identityproviders.UserRecipe;
import org.kantega.atlaskerb.identityproviders.oidc.InitiateOidcLogin;
import org.kantega.atlaskerb.identityproviders.oidc.OidcDataCache;
import org.kantega.atlaskerb.identityproviders.oidc.OidcIdpConfiguration;
import org.kantega.atlaskerb.identityproviders.oidc.OidcLibWrapper;
import org.kantega.atlaskerb.identityproviders.oidc.ResumeOidcLoginServlet;
import org.kantega.atlaskerb.identityproviders.oidc.evaluation.OidcResponseEvaluationResult;
import org.kantega.atlaskerb.identityproviders.oidc.evaluation.OidcResponseEvaluator;
import org.kantega.atlaskerb.identityproviders.saml.evaluation.SAMLResponseEvaluationResult;
import org.kantega.atlaskerb.identityproviders.saml.evaluation.SAMLResponseEvaluator;
import org.kantega.atlaskerb.kerberos.PrincipalEntry;
import org.kantega.atlaskerb.kerberos.servlet.TestKerberosAction;
import org.kantega.atlaskerb.saml.CertTool;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.SamlIdpConfiguration;
import org.kantega.atlaskerb.saml.ServiceProviderFactory;
import org.kantega.atlaskerb.saml.TestRecord;
import org.kantega.atlaskerb.saml.util.XmlUtils;
import org.kantega.atlaskerb.userlookup.UserLookupService;
import org.kantega.atlaskerb.utils.TestUtils;
import org.kantega.samllib.spi.AuthnState;
import org.kantega.samllib.spi.AuthnStateCache;
import org.kantega.samllib.spi.ServiceProviderSpi;
import org.kantega.samllib.validation.SamlResponseValidationResult;
import org.kantega.samllib.validation.SamlResponseValidator;
import org.kantega.samllib.validation.ValidationResult;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.xmlsec.signature.impl.X509CertificateImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluateTestServlet
extends RequireAdminServlet {
    private final TemplateRenderer renderer;
    private final UserManager userManager;
    private final IdpConfManager idpConfManager;
    private final KerbConfManager kerbConfManager;
    private final SAMLResponseEvaluator samlResponseEvaluator;
    private final OidcResponseEvaluator oidcResponseEvaluator;
    private final PluginLicenseManager licenseManager;
    private final ParserPool parserPool = XMLObjectProviderRegistrySupport.getParserPool();
    private final ApplicationProperties applicationProperties;
    private final UserLookupService userLookupService;
    private final HostApp hostApp;
    private final OidcDataCache oidcDataCache;
    private final ServiceProviderFactory serviceProviderFactory;
    private final ConnectorConfManager connectorConfManager;
    private final OidcLibWrapper oidcLibWrapper;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    @Inject
    public EvaluateTestServlet(RequireAdminServletDependencyBucket bucket, SAMLResponseEvaluator samlResponseEvaluator, OidcResponseEvaluator oidcResponseEvaluator, OidcDataCache oidcDataCache, ServiceProviderFactory serviceProviderFactory) {
        super(bucket);
        this.renderer = bucket.getTemplateRenderer();
        this.userManager = bucket.getUserManager();
        this.idpConfManager = bucket.getIdpConfManager();
        this.kerbConfManager = bucket.getKerbConfManager();
        this.licenseManager = bucket.getPluginLicenseManager();
        this.applicationProperties = bucket.getApplicationProperties();
        this.userLookupService = bucket.getUserLookupService();
        this.hostApp = bucket.getHostAppFactory().getInstance();
        this.connectorConfManager = bucket.getConnectorConfManager();
        this.samlResponseEvaluator = samlResponseEvaluator;
        this.oidcResponseEvaluator = oidcResponseEvaluator;
        this.oidcDataCache = oidcDataCache;
        this.serviceProviderFactory = serviceProviderFactory;
        this.oidcLibWrapper = bucket.getOidcLibWrapper();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        IdpConfiguration idp = this.idpConfManager.getIdentityProviderById(IdpConfManager.IdpServletUtil.getId(request));
        if (idp == null) {
            response.sendError(404);
            return;
        }
        IdpConfiguration.UserLookupAttribute userLookupAttribute = this.getUserLookupAttributeFromConfig(idp);
        this.runTest(idp, request, response, idp.getUsernameAttribute(), userLookupAttribute, idp.getUserLookupTransform(), idp.getCustomNameAttribute(), idp.getCustomGivenNameAttribute(), idp.getCustomSurnameAttribute(), idp.getNameAttributeMapping(), idp.getCustomEmailAttribute(), idp.getCustomUsernameAttributeName());
    }

    private IdpConfiguration.UserLookupAttribute getUserLookupAttributeFromConfig(IdpConfiguration idp) {
        IdpConfiguration.UserLookupAttribute userLookupAttribute = idp.getUserLookupAttribute();
        if (idp.getUserNotFoundPolicy() == IdpConfiguration.UserNotFoundPolicy.CREATE) {
            userLookupAttribute = IdpConfiguration.UserLookupAttribute.USERNAME;
        }
        return userLookupAttribute;
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        IdpConfiguration current = this.idpConfManager.getIdentityProviderById(IdpConfManager.IdpServletUtil.getId(request));
        if (current == null) {
            response.sendError(404);
            return;
        }
        IdpConfigurationBuilder<?, ?> builder = IdpConfigurationBuilder.ofGeneric(current);
        if (request.getParameter("addKnownDomain") != null) {
            String domain = StringUtils.trim((String)request.getParameter("domain"));
            if (StringUtils.isNotEmpty((CharSequence)domain)) {
                builder.getKnownDomains().add(domain);
            }
        } else if (request.getParameter("allowAllDomains") != null) {
            builder.setUsernamePolicy(IdpConfiguration.UsernamePolicy.ANY);
        }
        if (request.getParameter("manageGroups") != null) {
            TreeSet<ManagedGroup> managed = new TreeSet<ManagedGroup>(current.getManagedGroups());
            this.getGroupUpdates(request).stream().map(ManagedGroup::new).forEach(managed::add);
            builder.setManagedGroups(new ArrayList<ManagedGroup>(managed));
        }
        current = builder.build();
        this.idpConfManager.updateIdpConfiguration(current);
        IdpConfiguration.UsernameAttribute usernameAttribute = this.getUsernameAttribute(request);
        IdpConfiguration.UserLookupAttribute userLookupAttribute = IdpConfiguration.UserLookupAttribute.valueOf(request.getParameter("userLookupAttribute"));
        String customNameAttribute = StringUtils.trimToNull((String)request.getParameter("customNameAttributeSelector"));
        String customGivenNameAttribute = StringUtils.trimToNull((String)request.getParameter("customGivenNameAttributeSelector"));
        String customSurnameAttribute = StringUtils.trimToNull((String)request.getParameter("customSurnameAttributeSelector"));
        String customEmailAttribute = StringUtils.trimToNull((String)request.getParameter("customEmailAttributeSelector"));
        IdpConfManager.NAME_ATTRIBUTE_MAPPING nameAttributeMapping = StringUtils.trimToNull((String)request.getParameter("nameAttributeMapping")) != null && "firstAndLastName".equals(StringUtils.trimToNull((String)request.getParameter("nameAttributeMapping"))) ? IdpConfManager.NAME_ATTRIBUTE_MAPPING.FIRST_AND_LAST_NAME : IdpConfManager.NAME_ATTRIBUTE_MAPPING.FULL_NAME;
        String customUsernameAttributeName = request.getParameter("customUsernameAttributeName");
        if (request.getParameter("saveSettings") != null) {
            IdpConfigurationBuilder<?, ?> b = IdpConfigurationBuilder.ofGeneric(current);
            b.setUsernameAttribute(usernameAttribute);
            b.setUserLookupAttribute(userLookupAttribute);
            b.setCustomNameAttribute(customNameAttribute);
            b.setCustomGivenNameAttribute(customGivenNameAttribute);
            b.setCustomSurnameAttribute(customSurnameAttribute);
            b.setNameAttributeMapping(nameAttributeMapping);
            b.setCustomEmailAttribute(customEmailAttribute);
            b.setCustomUsernameAttributeName(customUsernameAttributeName);
            this.idpConfManager.updateIdpConfiguration((IdpConfiguration)b.build());
            response.sendRedirect("evaluate-test?id=" + request.getParameter("id"));
        } else {
            this.runTest(current, request, response, usernameAttribute, userLookupAttribute, current.getUserLookupTransform(), customNameAttribute, customGivenNameAttribute, customSurnameAttribute, nameAttributeMapping, customEmailAttribute, customUsernameAttributeName);
        }
    }

    private IdpConfiguration.UsernameAttribute getUsernameAttribute(HttpServletRequest request) {
        String usernameAttribute = request.getParameter("usernameAttribute");
        if (StringUtils.isBlank((CharSequence)usernameAttribute)) {
            return IdpConfiguration.UsernameAttribute.CUSTOM_SAML_ATTRIBUTE_NAME;
        }
        try {
            return IdpConfiguration.UsernameAttribute.valueOf(StringUtils.upperCase((String)usernameAttribute));
        }
        catch (IllegalArgumentException e) {
            return IdpConfiguration.UsernameAttribute.CUSTOM_SAML_ATTRIBUTE_NAME;
        }
    }

    private IdpConfiguration.UsernameAttribute getUsernameAttributeOf(String attributeName) {
        try {
            return IdpConfiguration.UsernameAttribute.valueOf(StringUtils.upperCase((String)attributeName));
        }
        catch (IllegalArgumentException e) {
            return IdpConfiguration.UsernameAttribute.CUSTOM_SAML_ATTRIBUTE_NAME;
        }
    }

    @NotNull
    private Set<String> getGroupUpdates(HttpServletRequest request) {
        TreeSet<String> addGroups = new TreeSet<String>();
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String param = (String)parameterNames.nextElement();
            if (!param.startsWith("manage_group_")) continue;
            addGroups.add(param.substring("manage_group_".length()));
        }
        return addGroups;
    }

    private void runTest(IdpConfiguration idp, HttpServletRequest req, HttpServletResponse resp, IdpConfiguration.UsernameAttribute usernameAttribute, IdpConfiguration.UserLookupAttribute userLookupAttribute, IdpConfiguration.UserLookupTransform userLookupTransform, String customNameAttribute, String customGivenNameAttribute, String customSurnameAttribute, IdpConfManager.NAME_ATTRIBUTE_MAPPING nameAttributeMapping, String customEmailAttribute, String customUsernameAttributeName) throws IOException {
        if (req.getParameter("run") != null) {
            if (idp.isSaml()) {
                resp.sendRedirect(this.idpConfManager.getServiceProviderLoginUrl(req, idp.getId()) + "?test");
            } else if (idp.isOidc()) {
                OidcIdpConfiguration oidcIdpConfiguration = (OidcIdpConfiguration)idp;
                String callbackUrl = ResumeOidcLoginServlet.getCallbackUrl(this.applicationProperties);
                InitiateOidcLogin.OidcLoginResult result = InitiateOidcLogin.run(oidcIdpConfiguration, this.idpConfManager, callbackUrl, null, null, this.oidcDataCache, null, this.oidcLibWrapper, TestUtils.isTest(req));
                if (result.isSuccess()) {
                    resp.sendRedirect(result.getAuthorizationUrl());
                } else {
                    resp.sendRedirect("");
                }
            }
            return;
        }
        String id = req.getParameter("id");
        if (id != null) {
            TestRecord record;
            TestRecord testRecord = record = idp.isSaml() ? this.idpConfManager.getRecordedTest(idp.getId(), id) : this.idpConfManager.getRecordedOIDCTest(idp.getId(), id);
            if (record == null) {
                resp.sendError(404);
                return;
            }
            if (idp.isSaml()) {
                this.evaluateTest((SamlIdpConfiguration)idp, record, req, resp, usernameAttribute, userLookupAttribute, userLookupTransform, customNameAttribute, customGivenNameAttribute, customSurnameAttribute, nameAttributeMapping, customEmailAttribute, customUsernameAttributeName);
            } else if (idp.isOidc()) {
                this.evaluateTest((OidcIdpConfiguration)idp, record, req, resp, usernameAttribute, userLookupAttribute, userLookupTransform, customNameAttribute, customGivenNameAttribute, customSurnameAttribute, nameAttributeMapping, customEmailAttribute, customUsernameAttributeName);
            }
        } else {
            resp.sendError(404);
        }
    }

    private void checkNonstandardSeraphAuthenticator(Map<String, Object> model) {
        String nonStandardAuthenticator = this.hostApp.hasNonStandardAuthenticator();
        if (nonStandardAuthenticator != null) {
            model.put("nonStandardSeraphAuthenticator", nonStandardAuthenticator);
            model.put("standardSeraphAuthenticator", this.hostApp.getStandardAuthenticatorClassName());
        }
    }

    private void evaluateTest(SamlIdpConfiguration idp, TestRecord record, HttpServletRequest req, HttpServletResponse resp, IdpConfiguration.UsernameAttribute usernameAttribute, IdpConfiguration.UserLookupAttribute userLookupAttribute, IdpConfiguration.UserLookupTransform userLookupTransform, String customNameAttribute, String customGivenNameAttribute, String customSurnameAttribute, IdpConfManager.NAME_ATTRIBUTE_MAPPING nameAttributeMapping, String customEmailAttribute, String customUsernameAttributeName) throws IOException {
        File responseFile;
        resp.setContentType("text/html");
        resp.setHeader("Cache-Control", "private, max-age=0, no-cache");
        Map<String, Object> model = this.newModel(req);
        this.checkNonstandardSeraphAuthenticator(model);
        model.put("validationResult", null);
        model.put("knownAttributeNames", this.samlResponseEvaluator.getKnownAttributeNames());
        model.put("topMenu", "SAML");
        model.put("menuItem", "providerTest");
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("crowdURL", req.getContextPath() + "/plugins/servlet/embedded-crowd/directories/list");
        model.put("userLookupService", this.userLookupService);
        model.put("idp", idp);
        model.put("record", record);
        model.put("dateTool", new DateTool());
        model.put("dirtySettings", this.isSettingsDirty(idp, usernameAttribute, userLookupAttribute, userLookupTransform, customNameAttribute, customGivenNameAttribute, customSurnameAttribute, customEmailAttribute, customUsernameAttributeName));
        model.put("samlConfigURL", this.idpConfManager.getIdpConfigUrl(req));
        model.put("connectorTypes", this.connectorConfManager.getConnectorTypes());
        model.put("matchingConnectors", this.connectorConfManager.findMatchingConnectors(idp.getKind()));
        model.put("matchingConnectorType", this.connectorConfManager.findMatchingConnectorType(idp.getKind()));
        this.checkLicensing(model);
        model.put("providerUrl", this.idpConfManager.getProviderAdminUrl(idp.getId(), req));
        model.put("loginUrl", this.idpConfManager.getServiceProviderLoginUrl(req, idp.getId()));
        model.put("usernameAttribute", (Object)usernameAttribute);
        model.put("userLookupAttribute", (Object)userLookupAttribute);
        model.put("userLookupTransform", (Object)userLookupTransform);
        model.put("userLookupAttributes", IdpConfiguration.UserLookupAttribute.values());
        model.put("customNameAttribute", customNameAttribute);
        model.put("customGivenNameAttribute", customGivenNameAttribute);
        model.put("customSurnameAttribute", customSurnameAttribute);
        model.put("customEmailAttribute", customEmailAttribute);
        model.put("hasCustomUserAttribute", customNameAttribute != null || customEmailAttribute != null);
        model.put("hasLDAPDirectories", this.userLookupService.hasActiveLDAPDirectories());
        if (customUsernameAttributeName == null) {
            customUsernameAttributeName = idp.getCustomUsernameAttributeName();
        }
        model.put("customUsernameAttributeKey", (Object)IdpConfiguration.UsernameAttribute.CUSTOM_SAML_ATTRIBUTE_NAME);
        model.put("customUsernameAttributeName", customUsernameAttributeName);
        File requestFile = this.idpConfManager.getRecordedTestRequestFile(idp.getId(), record.getId());
        if (requestFile.exists()) {
            AuthnRequest authnRequest = this.parseRequestFile(requestFile);
            model.put("requestXML", XmlUtils.formatXml(authnRequest.getDOM()));
        }
        if ((responseFile = this.idpConfManager.getRecordedTestResponseFile(idp.getId(), record.getId())).exists()) {
            Response response = this.parseResponseFile(responseFile);
            model.put("responseXML", XmlUtils.formatXml(response.getDOM()));
            ServiceProviderSpi instance = this.serviceProviderFactory.getInstance(idp);
            Properties props = this.idpConfManager.getTestProperties(idp.getId(), record);
            DateTime now = (DateTime)Option.of((Object)props.getProperty("responseTime")).onEmpty(() -> model.put("incompleteResponse", true)).map(responseTime -> ISODateTimeFormat.dateTimeParser().parseDateTime(responseTime)).getOrElse((Object)DateTime.now());
            TestPageAuthnStateCache authnStateCache = new TestPageAuthnStateCache();
            authnStateCache.put(record.getId(), new AuthnState());
            SamlResponseValidationResult result = new SamlResponseValidationResult(req, resp, instance, now);
            new SamlResponseValidator(null, (AuthnStateCache)authnStateCache, instance).validate(response, result);
            if (result.hasDecryptedAssertions()) {
                model.put("hasDecryptedAssertions", true);
                model.put("decryptedAssertionsXML", result.getDecryptedAssertions().stream().map(assertion -> XmlUtils.formatXml(assertion.getDOM())).collect(Collectors.toList()));
            }
            java.util.List validationResults = List.ofAll((Iterable)result.getResults()).map(res -> {
                Map resModel = res.getModel();
                JSONObject parsedCert = (JSONObject)io.vavr.collection.HashMap.ofAll((Map)resModel).get((Object)"cert").toTry().mapTry((CheckedFunction1 & Serializable)cert -> (X509CertificateImpl)cert).mapTry(X509CertificateImpl::getValue).filterTry(Objects::nonNull).mapTry(CertTool::parse).mapTry((CheckedFunction1 & Serializable)cert -> {
                    JSONObject certJson = new JSONObject();
                    certJson.put("subjectDn", (Object)cert.getSubjectDN().getName());
                    certJson.put("issuerDn", (Object)cert.getIssuerDN().getName());
                    certJson.put("notBefore", (Object)cert.getNotBefore().toString());
                    certJson.put("notAfter", (Object)cert.getNotAfter().toString());
                    certJson.put("sigAlgName", (Object)cert.getSigAlgName());
                    certJson.put("keySize", (Object)String.valueOf(CertTool.getKeySize(cert)));
                    certJson.put("fingerPrint", (Object)CertTool.fingerPrint(cert.getEncoded()));
                    return certJson;
                }).getOrElse((Object)new JSONObject());
                Map parsedModel = API.Map((Object)"cert", resModel.get("cert"), (Object)"parsedCert", (Object)parsedCert).toJavaMap();
                return new ValidationResult(res.getMessage(), res.getType(), parsedModel);
            }).asJava();
            model.put("samlValidationResults", validationResults);
            SAMLResponseEvaluationResult evaluationResult = this.samlResponseEvaluator.evaluate(idp, result, usernameAttribute, userLookupAttribute, userLookupTransform, customNameAttribute, customGivenNameAttribute, customSurnameAttribute, nameAttributeMapping, customEmailAttribute, customUsernameAttributeName, false);
            model.put("evaluationResult", evaluationResult);
            boolean serviceUrlWithHttps = StringUtils.startsWith((CharSequence)StringUtils.lowerCase((String)this.idpConfManager.getServiceProviderLoginUrl(req, idp.getId())), (CharSequence)"https");
            model.put("notHttps", !serviceUrlWithHttps);
            AttributeInfo configuredAttribute = evaluationResult.getConfiguredUsernameAttributeInfo();
            if (configuredAttribute != null) {
                model.put("configuredUsernameAttribute", configuredAttribute);
                boolean userDomainRejected = evaluationResult.isUserDomainRejected();
                model.put("userDomainRejected", userDomainRejected);
                boolean success = false;
                String username = null;
                if (evaluationResult.getResolvedPrincipalEntry() != null) {
                    PrincipalEntry pe = evaluationResult.getResolvedPrincipalEntry();
                    UserRecipe userRecipe = evaluationResult.getUserRecipe();
                    if (userRecipe != null) {
                        model.put("userRecipe", userRecipe);
                    }
                    if (userRecipe != null && !userRecipe.isComplete()) {
                        model.put("missingUserInfoForJIT", true);
                    }
                    if (pe.getPrincipal().isPresent()) {
                        Principal user = pe.getPrincipal().get();
                        username = user.getName();
                        model.put("usersDirectory", this.hostApp.getDirectoryForUser(user.getName()));
                        model.put("userPrincipal", user);
                        model.put("userProfile", this.userManager.getUserProfile(user.getName()));
                        model.put("contextPath", req.getContextPath());
                        boolean canLogin = this.hostApp.canLogin(user, req);
                        model.put("canLogin", canLogin);
                        success = canLogin && !userDomainRejected && pe.getUserState() == PrincipalEntry.UserState.FOUND;
                    }
                    model.put("isActive", pe.getUserState() != PrincipalEntry.UserState.INACTIVE);
                } else if (evaluationResult.getUserRecipe() != null) {
                    UserRecipe userRecipe = evaluationResult.getUserRecipe();
                    model.put("userRecipe", userRecipe);
                    if (userRecipe.isComplete()) {
                        username = userRecipe.getUsername().getValue();
                        boolean bl = success = !userDomainRejected;
                    }
                }
                if (username != null) {
                    if (username.length() > 20) {
                        model.put("currentUsernameTooLongForJiTInAD", true);
                    }
                    this.samlResponseEvaluator.evaluateGroups(username, idp.getManagedGroups(), this.samlResponseEvaluator.findSamlGroups(result.getAssertions()), evaluationResult.getGroupEvaluation(), idp.isCreateAllIncomingGroups());
                    boolean requiredGroupsForCreation = IdpConfManager.hasRequiredGroupsForCreation(idp, evaluationResult.getGroupEvaluation());
                    model.put("hasRequiredGroupsForCreation", requiredGroupsForCreation);
                    model.put("success", success && requiredGroupsForCreation);
                } else {
                    model.put("success", success);
                }
            }
            this.idpConfManager.updateAndStoreTestresults(idp.getId(), result, evaluationResult);
        }
        TestKerberosAction.addDebugInfo(req, model, this.connectorConfManager, this.idpConfManager, this.kerbConfManager, this.applicationProperties, this.userLookupService, "SAML");
        StringWriter debuginfo = new StringWriter();
        this.renderer.render("templates/atlaskerb/debuginfo.vm", model, (Writer)debuginfo);
        model.put("debugInfo", debuginfo);
        this.checkIfAdIsUsedForJit(idp, model);
        this.renderer.render("templates/idp-login-test/saml-test-result.vm", model, (Writer)resp.getWriter());
    }

    private void checkIfAdIsUsedForJit(IdpConfiguration idp, Map<String, Object> model) {
        Directory jitDir = this.hostApp.getCrowdDirectoryService().findDirectoryById(idp.getJitDirectory().orElse(-1L).longValue());
        if (jitDir != null && jitDir.getType() == DirectoryType.CONNECTOR) {
            model.put("maxUsernameLengthJitInAd", 20);
            model.put("adJitUsernameLengthWarning", true);
        }
    }

    private void evaluateTest(OidcIdpConfiguration idp, TestRecord record, HttpServletRequest req, HttpServletResponse resp, IdpConfiguration.UsernameAttribute usernameAttribute, IdpConfiguration.UserLookupAttribute userLookupAttribute, IdpConfiguration.UserLookupTransform userLookupTransform, String customNameAttribute, String customGivenNameAttribute, String customSurnameAttribute, IdpConfManager.NAME_ATTRIBUTE_MAPPING nameAttributeMapping, String customEmailAttribute, String customUsernameAttributeName) throws IOException {
        File responseFile;
        Try<String> oidcProcedureJson;
        resp.setContentType("text/html");
        resp.setHeader("Cache-Control", "private, max-age=0, no-cache");
        Map<String, Object> model = this.newModel(req);
        this.checkNonstandardSeraphAuthenticator(model);
        model.put("validationResult", null);
        model.put("topMenu", "SAML");
        model.put("menuItem", "providerTest");
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("crowdURL", req.getContextPath() + "/plugins/servlet/embedded-crowd/directories/list");
        model.put("userLookupService", this.userLookupService);
        model.put("idp", idp);
        model.put("record", record);
        model.put("dateTool", new DateTool());
        model.put("dirtySettings", this.isOidcSettingsDirty(idp, usernameAttribute, userLookupAttribute, userLookupTransform, customNameAttribute, customGivenNameAttribute, customSurnameAttribute, customEmailAttribute, customUsernameAttributeName));
        model.put("connectorTypes", this.connectorConfManager.getConnectorTypes());
        model.put("matchingConnectors", this.connectorConfManager.findMatchingConnectors(idp.getKind()));
        model.put("matchingConnectorType", this.connectorConfManager.findMatchingConnectorType(idp.getKind()));
        this.checkLicensing(model);
        model.put("usernameAttribute", (Object)usernameAttribute);
        if (customUsernameAttributeName == null) {
            customUsernameAttributeName = idp.getCustomUsernameAttributeName();
        }
        model.put("customUsernameAttributeKey", (Object)IdpConfiguration.UsernameAttribute.CUSTOM_SAML_ATTRIBUTE_NAME);
        model.put("customUsernameAttributeName", customUsernameAttributeName);
        model.put("userLookupAttribute", (Object)userLookupAttribute);
        model.put("userLookupTransform", (Object)userLookupTransform);
        model.put("userLookupAttributes", IdpConfiguration.UserLookupAttribute.values());
        model.put("customNameAttribute", customNameAttribute);
        model.put("customGivenNameAttribute", customGivenNameAttribute);
        model.put("customSurnameAttribute", customSurnameAttribute);
        model.put("customEmailAttribute", customEmailAttribute);
        model.put("hasCustomUserAttribute", customNameAttribute != null || customEmailAttribute != null);
        model.put("hasLDAPDirectories", this.userLookupService.hasActiveLDAPDirectories());
        Try.of((CheckedFunction0 & Serializable)() -> this.idpConfManager.getTestProperties(idp.getId(), record)).onSuccess(testProperties -> {
            boolean isError = Option.of((Object)testProperties.getProperty("error")).isDefined();
            if (isError) {
                model.put("isErrorTestResult", true);
                model.put("errorCode", testProperties.getProperty("errorCode"));
                model.put("errorMessage", testProperties.getProperty("errorMessage"));
                model.put("oidcTestError", testProperties.getProperty("error"));
            }
            model.put("responseTime", testProperties.getProperty("responseTime"));
        });
        File beforeRequestProcedureFile = this.idpConfManager.getRecordedTestOidcProcedureFileBeforeRequest(idp.getId(), record.getId());
        File initProcedureFile = this.idpConfManager.getRecordedTestStartedOIDCProcedureFile(idp.getId(), record.getId());
        if (beforeRequestProcedureFile.exists()) {
            oidcProcedureJson = TestUtils.readOidcProcedureJsonRepresentationFromFile(beforeRequestProcedureFile);
            oidcProcedureJson.onSuccess(jsonString -> model.put("oidcProcedureJsonBeforeRequest", jsonString));
        } else if (initProcedureFile.exists()) {
            oidcProcedureJson = TestUtils.readOidcProcedureJsonRepresentationFromFile(initProcedureFile);
            oidcProcedureJson.onSuccess(jsonString -> model.put("oidcProcedureJsonBeforeRequest", jsonString));
        }
        File afterResponseProcedureFile = this.idpConfManager.getRecordedTestOidcProcedureFileAfterResponse(idp.getId(), record.getId());
        if (afterResponseProcedureFile.exists()) {
            Try<String> oidcProcedureJson2 = TestUtils.readOidcProcedureJsonRepresentationFromFile(afterResponseProcedureFile);
            oidcProcedureJson2.onSuccess(jsonString -> model.put("oidcProcedureJsonAfterResponse", jsonString));
        }
        if ((responseFile = this.idpConfManager.getRecordedOidcTestResponseFile(idp.getId(), record.getId())).exists()) {
            JSONObject profileJson = EvaluateTestServlet.parseJsonProfile(responseFile);
            model.put("profile", profileJson);
            OidcResponseEvaluationResult evaluationResult = this.oidcResponseEvaluator.evaluate(idp, profileJson, usernameAttribute, customNameAttribute, customGivenNameAttribute, customSurnameAttribute, nameAttributeMapping, customEmailAttribute, customUsernameAttributeName, false);
            model.put("evaluationResult", evaluationResult);
            boolean serviceUrlWithHttps = StringUtils.startsWith((CharSequence)StringUtils.lowerCase((String)this.idpConfManager.getServiceProviderLoginUrl(req, idp.getId())), (CharSequence)"https");
            model.put("notHttps", !serviceUrlWithHttps);
            AttributeInfo configuredAttribute = evaluationResult.getConfiguredUsernameAttributeInfo();
            if (configuredAttribute != null) {
                model.put("configuredUsernameAttribute", configuredAttribute);
                boolean userDomainRejected = evaluationResult.isUserDomainRejected();
                model.put("userDomainRejected", userDomainRejected);
                boolean success = false;
                String username = null;
                if (evaluationResult.getResolvedPrincipalEntry() != null) {
                    PrincipalEntry pe = evaluationResult.getResolvedPrincipalEntry();
                    UserRecipe userRecipe = evaluationResult.getUserRecipe();
                    if (userRecipe != null) {
                        model.put("userRecipe", userRecipe);
                    }
                    if (userRecipe != null && !userRecipe.isComplete()) {
                        model.put("missingUserInfoForJIT", true);
                    }
                    if (pe.getPrincipal().isPresent()) {
                        Principal user = pe.getPrincipal().get();
                        username = user.getName();
                        model.put("usersDirectory", this.hostApp.getDirectoryForUser(user.getName()));
                        model.put("userPrincipal", user);
                        model.put("userProfile", this.userManager.getUserProfile(user.getName()));
                        model.put("contextPath", req.getContextPath());
                        boolean canLogin = this.hostApp.canLogin(user, req);
                        model.put("canLogin", canLogin);
                        success = canLogin && !userDomainRejected && pe.getUserState() == PrincipalEntry.UserState.FOUND;
                    }
                    model.put("isActive", pe.getUserState() != PrincipalEntry.UserState.INACTIVE);
                } else if (evaluationResult.getUserRecipe() != null) {
                    UserRecipe userRecipe = evaluationResult.getUserRecipe();
                    model.put("userRecipe", userRecipe);
                    if (userRecipe.isComplete()) {
                        username = userRecipe.getUsername().getValue();
                        boolean bl = success = !userDomainRejected;
                    }
                }
                if (username != null) {
                    if (username.length() > 20) {
                        model.put("currentUsernameTooLongForJiTInAD", true);
                    }
                    java.util.List<ManagedGroup> managedOrAutoGroups = idp.isCreateAllIncomingGroups() ? idp.getAutoGroups() : idp.getManagedGroups();
                    this.oidcResponseEvaluator.evaluateGroups(username, managedOrAutoGroups, this.oidcResponseEvaluator.findOidcGroups(profileJson, idp.getIdpGroupsAttributes()), evaluationResult.getGroupEvaluation(), idp.isCreateAllIncomingGroups());
                    boolean requiredGroupsForCreation = IdpConfManager.hasRequiredGroupsForCreation(idp, evaluationResult.getGroupEvaluation());
                    model.put("hasRequiredGroupsForCreation", requiredGroupsForCreation);
                    model.put("isCreateAllIncomingGroups", idp.isCreateAllIncomingGroups());
                    if (idp.isCreateAllIncomingGroups()) {
                        model.put("autoCreateUserPolicy", idp.getAutoCreateUserPolicy().getKey());
                    }
                    model.put("success", success && requiredGroupsForCreation);
                } else {
                    model.put("success", success);
                }
            }
            this.idpConfManager.updateAndStoreTestresults(idp.getId(), record.getId(), evaluationResult);
        }
        TestKerberosAction.addDebugInfo(req, model, this.connectorConfManager, this.idpConfManager, this.kerbConfManager, this.applicationProperties, this.userLookupService, "OIDC");
        StringWriter debuginfo = new StringWriter();
        this.renderer.render("templates/atlaskerb/debuginfo.vm", model, (Writer)debuginfo);
        model.put("debugInfo", debuginfo);
        this.checkIfAdIsUsedForJit(idp, model);
        this.renderer.render("templates/idp-login-test/oidc-test-result.vm", model, (Writer)resp.getWriter());
    }

    private boolean isSettingsDirty(IdpConfiguration idp, IdpConfiguration.UsernameAttribute usernameAttribute, IdpConfiguration.UserLookupAttribute userLookupAttribute, IdpConfiguration.UserLookupTransform userLookupTransform, String customNameAttribute, String customGivenNameAttribute, String customSurnameAttribute, String customEmailAttribute, String customUsernameAttributeName) {
        return usernameAttribute != idp.getUsernameAttribute() || userLookupAttribute != this.getUserLookupAttributeFromConfig(idp) || userLookupTransform != idp.getUserLookupTransform() || !StringUtils.equals((CharSequence)idp.getCustomNameAttribute(), (CharSequence)customNameAttribute) || !StringUtils.equals((CharSequence)idp.getCustomGivenNameAttribute(), (CharSequence)customGivenNameAttribute) || !StringUtils.equals((CharSequence)idp.getCustomSurnameAttribute(), (CharSequence)customSurnameAttribute) || !StringUtils.equals((CharSequence)idp.getCustomEmailAttribute(), (CharSequence)customEmailAttribute) || !StringUtils.equals((CharSequence)idp.getCustomUsernameAttributeName(), (CharSequence)customUsernameAttributeName);
    }

    private boolean isOidcSettingsDirty(IdpConfiguration idp, IdpConfiguration.UsernameAttribute usernameAttribute, IdpConfiguration.UserLookupAttribute userLookupAttribute, IdpConfiguration.UserLookupTransform userLookupTransform, String customNameAttribute, String customGivenNameAttribute, String customSurnameAttribute, String customEmailAttribute, String customUsernameAttributeName) {
        return usernameAttribute != idp.getUsernameAttribute() || userLookupAttribute != this.getUserLookupAttributeFromConfig(idp) || userLookupTransform != idp.getUserLookupTransform() || !StringUtils.equals((CharSequence)idp.getCustomNameAttribute(), (CharSequence)customNameAttribute) || !StringUtils.equals((CharSequence)idp.getCustomGivenNameAttribute(), (CharSequence)customGivenNameAttribute) || !StringUtils.equals((CharSequence)idp.getCustomSurnameAttribute(), (CharSequence)customSurnameAttribute) || !StringUtils.equals((CharSequence)idp.getCustomEmailAttribute(), (CharSequence)customEmailAttribute) || !StringUtils.equals((CharSequence)idp.getCustomUsernameAttributeName(), (CharSequence)customUsernameAttributeName);
    }

    private Response parseResponseFile(File responseFile) {
        return (Response)this.parse(responseFile);
    }

    private AuthnRequest parseRequestFile(File requestFile) {
        return (AuthnRequest)this.parse(requestFile);
    }

    private XMLObject parse(File responseFile) {
        XMLObject xMLObject;
        FileInputStream is = new FileInputStream(responseFile);
        try {
            xMLObject = XMLObjectSupport.unmarshallFromInputStream((ParserPool)this.parserPool, (InputStream)is);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | XMLParserException | UnmarshallingException e) {
                throw new RuntimeException(e);
            }
        }
        ((InputStream)is).close();
        return xMLObject;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static JSONObject parseJsonProfile(File responseFile) {
        try (FileInputStream stream = new FileInputStream(responseFile);){
            JSONObject jSONObject;
            try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8);){
                StringBuilder jsonStringBuilder = new StringBuilder();
                while (inputStreamReader.ready()) {
                    jsonStringBuilder.append((char)inputStreamReader.read());
                }
                String jsonString = jsonStringBuilder.toString();
                jSONObject = new JSONObject(jsonString);
            }
            return jSONObject;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void checkLicensing(Map<String, Object> model) {
        if (this.licenseManager.getLicense().isDefined()) {
            PluginLicense license = (PluginLicense)this.licenseManager.getLicense().get();
            model.put("license", license);
            model.put("licenseValid", license.isValid());
        } else {
            model.put("licenseMissing", Boolean.TRUE);
        }
    }

    private static class TestPageAuthnStateCache
    implements AuthnStateCache {
        private final Map<String, AuthnState> cache = new HashMap<String, AuthnState>();

        private TestPageAuthnStateCache() {
        }

        public void put(String authnRequestId, AuthnState state) {
            this.cache.put(authnRequestId, state);
        }

        public AuthnState remove(String authnRequestId) {
            return this.cache.remove(authnRequestId);
        }
    }
}

