/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.rest.resource.internal.config;

import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import io.vavr.CheckedFunction1;
import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.kantega.atlaskerb.rest.util.ResponseUtils;
import org.kantega.atlaskerb.saml.CertTool;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.update.KssoUpdateManager;
import org.kantega.atlaskerb.utils.HttpUrlUtils;

@Path(value="/status")
public class ConfigStatus {
    private final UserManager userManager;
    private final KssoUpdateManager kssoUpdateManager;
    private final IdpConfManager idpConfManager;

    public ConfigStatus(UserManager userManager, KssoUpdateManager kssoUpdateManager, IdpConfManager idpConfManager) {
        this.userManager = userManager;
        this.kssoUpdateManager = kssoUpdateManager;
        this.idpConfManager = idpConfManager;
    }

    @GET
    @Produces(value={"application/json"})
    public Response fetchConfigStatus(@Context HttpServletRequest request) {
        return ResponseUtils.sysadminOnly(request, this.userManager).wrap((CheckedFunction1<UserProfile, Response>)(CheckedFunction1 & Serializable)_u -> {
            boolean isSamlEnabled;
            HashMap<String, Object> statusData = new HashMap<String, Object>();
            statusData.put("isKssoConfigUpdateNeeded", this.kssoUpdateManager.isKssoConfigUpdateNeeded());
            statusData.put("hasUpdateFailures", this.kssoUpdateManager.hasUpdateFailures());
            boolean bl = isSamlEnabled = this.idpConfManager.hasEnabledSamlProviders() && this.idpConfManager.isFederatedSsoEnabled();
            if (isSamlEnabled) {
                X509Certificate activeCert = this.idpConfManager.parseCert(this.idpConfManager.getSigningCert());
                boolean isValidCert = CertTool.isValidCertificate(activeCert, 0);
                boolean isExpiringSoon = CertTool.isExpiringSoon(activeCert);
                statusData.put("isSamlCertificateExpiring", isValidCert && isExpiringSoon);
                statusData.put("isSamlCertificateExpired", !isValidCert);
            }
            statusData.put("requestBaseUrl", HttpUrlUtils.getRequestBaseUrl(request));
            return Response.ok(statusData).build();
        });
    }
}

