/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.identityproviders.setup;

import io.vavr.CheckedFunction0;
import io.vavr.collection.CharSeq;
import io.vavr.collection.HashMap;
import io.vavr.collection.HashSet;
import io.vavr.collection.List;
import io.vavr.collection.Seq;
import io.vavr.collection.Set;
import io.vavr.control.Option;
import io.vavr.control.Try;
import io.vavr.control.Validation;
import java.io.Serializable;
import javax.inject.Inject;
import org.json.JSONArray;
import org.json.JSONObject;
import org.kantega.atlaskerb.Bucket;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.IdpConfigurationBuilder;
import org.kantega.atlaskerb.identityproviders.oidc.OidcLibWrapper;
import org.kantega.atlaskerb.identityproviders.setup.IdpValidationError;
import org.kantega.atlaskerb.identityproviders.setup.IdpValidator;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.springframework.stereotype.Component;

@Component
public class OidcValidator
extends IdpValidator {
    private final OidcLibWrapper oidcLibWrapper;
    private final HostApp hostApp;
    private final IdpConfManager idpConfManager;

    @Inject
    public OidcValidator(Bucket bucket) {
        this.hostApp = bucket.getHostApp();
        this.idpConfManager = bucket.getIdpConfManager();
        this.oidcLibWrapper = bucket.getOidcLibWrapper();
    }

    public Validation<Seq<IdpValidationError>, Try<IdpConfigurationBuilder.Oidc>> validateAndCreateOidcConfig(JSONObject oidcDraft) {
        JSONObject safeDraft = (JSONObject)Option.of((Object)oidcDraft).getOrElse(JSONObject::new);
        Validation maybeOidcConfig = Validation.combine(this.validateIdpId(safeDraft.optString("idp_id", null)), this.validateClientId(safeDraft.optString("client_id", null)), this.validateClientSecret(safeDraft.optString("client_secret", null)), this.validateDiscoveryUrl(safeDraft.optString("discovery_url", null), IdpConfiguration.Kind.valueOf(safeDraft.optString("kind", null))), this.validateName(safeDraft.optString("display_name", null)), this.validateKind(safeDraft.optString("kind", null)), this.validateScope(safeDraft.optJSONArray("scope"), IdpConfiguration.Kind.valueOf(safeDraft.optString("kind", null)))).ap(this::oidcCreate);
        return (Validation)List.of((Object)maybeOidcConfig).filter(Validation::isValid).getOrElse((Object)Validation.invalid((Object)((Seq)List.of((Object)maybeOidcConfig).filter(Validation::isInvalid).map(Validation::getError).fold((Object)List.empty(), Seq::appendAll)).append((Object)IdpValidationError.MISSING_VALUES)));
    }

    private Validation<IdpValidationError, String> validateClientId(String clientId) {
        return (Validation)Option.of((Object)clientId).map(CharSeq::of).map(CharSeq::trim).filter(cs -> cs.length() > 0).map(CharSeq::toString).transform(maybeClientId -> maybeClientId.isDefined() ? Validation.valid((Object)((String)maybeClientId.get())) : Validation.invalid((Object)((Object)IdpValidationError.OIDC_CLIENT_ID)));
    }

    private Validation<IdpValidationError, String> validateClientSecret(String clientSecret) {
        return (Validation)Option.of((Object)clientSecret).map(CharSeq::of).map(CharSeq::trim).filter(cs -> cs.length() < 6000).transform(maybeCs -> maybeCs.isDefined() ? Validation.valid((Object)((CharSeq)maybeCs.getOrElse((Object)CharSeq.of((CharSequence)""))).toString()) : Validation.invalid((Object)((Object)IdpValidationError.OIDC_CLIENT_SECRET)));
    }

    private Validation<IdpValidationError, String> validateDiscoveryUrl(String discoveryUrl, IdpConfiguration.Kind kind) {
        boolean discoveryUrlIsValid = (Boolean)this.oidcLibWrapper.createOidcData((HashMap<String, Object>)HashMap.of((Object)"discovery_url", (Object)discoveryUrl)).flatMap(this.oidcLibWrapper::discover).map(data -> data.get("authorization_endpoint").isDefined()).getOrElse((Object)false) != false || kind == IdpConfiguration.Kind.GITHUB;
        return discoveryUrlIsValid ? Validation.valid((Object)discoveryUrl) : Validation.invalid((Object)((Object)IdpValidationError.OIDC_DISCOVERY_URL));
    }

    private Validation<IdpValidationError, java.util.Set<String>> validateScope(JSONArray scope, IdpConfiguration.Kind kind) {
        return (Validation)Option.of((Object)scope).map(JSONArray::toList).map(HashSet::ofAll).map(scopeSet -> scopeSet.map(Object::toString)).filter(scopeSet -> scopeSet.contains((Object)"openid") || kind == IdpConfiguration.Kind.GITHUB).map(Set::toJavaSet).transform(scope1 -> scope1.isDefined() ? Validation.valid((Object)((java.util.Set)scope1.get())) : Validation.invalid((Object)((Object)IdpValidationError.OIDC_SCOPE)));
    }

    private Try<IdpConfigurationBuilder.Oidc> oidcCreate(String id, String clientId, String clientSecret, String discoveryUrl, String name, IdpConfiguration.Kind kind, java.util.Set<String> scope) {
        return Try.of((CheckedFunction0 & Serializable)() -> (IdpConfigurationBuilder.Oidc)((IdpConfigurationBuilder.Oidc)IdpConfigurationBuilder.oidc(id, kind).setName(name)).setOidcDiscoveryUrl(discoveryUrl).setOidcClientId(clientId).setOidcClientSecret(clientSecret).setScopes(scope).setJitDirectoryIfPresent(this.hostApp.getDefaultJitDirectory()));
    }
}

