/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.identityproviders.setup;

import io.vavr.CheckedFunction0;
import io.vavr.control.Option;
import io.vavr.control.Try;
import io.vavr.control.Validation;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.setup.IdpValidationError;
import org.kantega.atlaskerb.saml.IdpConfManager;

abstract class IdpValidator {
    IdpValidator() {
    }

    Validation<IdpValidationError, String> validateIdpId(String id) {
        return (Validation)Option.of((Object)id).filter(IdpConfManager::isValidIdpId).transform(maybeId -> maybeId.isDefined() ? Validation.valid((Object)((String)maybeId.get())) : Validation.invalid((Object)((Object)IdpValidationError.IDP_ID)));
    }

    Validation<IdpValidationError, IdpConfiguration.Kind> validateKind(String kind) {
        return (Validation)Try.of((CheckedFunction0 & Serializable)() -> IdpConfiguration.Kind.valueOf(kind)).transform(tryKind -> tryKind.isSuccess() ? Validation.valid((Object)((Object)((IdpConfiguration.Kind)((Object)((Object)tryKind.get()))))) : Validation.invalid((Object)((Object)IdpValidationError.KIND)));
    }

    Validation<IdpValidationError, String> validateName(String name) {
        return (Validation)Option.of((Object)name).map(StringUtils::trim).filter(StringUtils::isNotBlank).transform(xxx -> xxx.isDefined() ? Validation.valid((Object)((String)xxx.get())) : Validation.invalid((Object)((Object)IdpValidationError.DISPLAY_NAME)));
    }
}

