/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.identityproviders.saml.evaluation;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.identityproviders.AttributeInfo;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.ResponseEvaluator;
import org.kantega.atlaskerb.identityproviders.UserProperty;
import org.kantega.atlaskerb.identityproviders.UserRecipe;
import org.kantega.atlaskerb.identityproviders.saml.evaluation.SAMLResponseEvaluationResult;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.SamlIdpConfiguration;
import org.kantega.atlaskerb.userlookup.UserLookupService;
import org.kantega.samllib.validation.SamlResponseValidationResult;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.springframework.stereotype.Component;

@Component
public class SAMLResponseEvaluator
extends ResponseEvaluator {
    private final Map<String, String> knownAttributeNames = new HashMap<String, String>();
    private final Map<String, String> nameAttrs = new HashMap<String, String>();
    private final Map<String, String> windowsAccountNameAttrs = new HashMap<String, String>();
    private final Map<String, String> emailAttrs = new HashMap<String, String>();
    private final Map<String, String> givenNameAttrs = new HashMap<String, String>();
    private final Map<String, String> surnameAttrs = new HashMap<String, String>();
    private final Map<String, String> upnAttrs = new HashMap<String, String>();

    @Inject
    public SAMLResponseEvaluator(@ComponentImport UserManager userManager, HostAppFactory hostAppFactory, UserLookupService userLookupService) {
        super(userManager, userLookupService, hostAppFactory.getInstance());
        this.nameAttrs.put("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/name", "Name");
        this.nameAttrs.put("name", "Name");
        this.nameAttrs.put("DisplayName", "Name");
        this.nameAttrs.put("displayName", "Name");
        this.nameAttrs.put("cn", "Common Name");
        this.nameAttrs.put("http://schemas.xmlsoap.org/claims/CommonName", "Common Name");
        this.nameAttrs.put("http://wso2.org/claims/fullname", "Name");
        this.givenNameAttrs.put("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/givenname", "GivenName");
        this.givenNameAttrs.put("givenname", "GivenName");
        this.givenNameAttrs.put("givenName", "GivenName");
        this.surnameAttrs.put("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/surname", "Surname");
        this.surnameAttrs.put("surname", "Surname");
        this.emailAttrs.put("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/emailaddress", "E-Mail");
        this.emailAttrs.put("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/email", "E-Mail");
        this.emailAttrs.put("http://schemas.xmlsoap.org/claims/EmailAddress", "E-Mail");
        this.emailAttrs.put("EmailAddress", "E-Mail");
        this.emailAttrs.put("emailaddress", "E-Mail");
        this.emailAttrs.put("email", "E-Mail");
        this.emailAttrs.put("mail", "E-Mail");
        this.emailAttrs.put("e-mail", "E-Mail");
        this.emailAttrs.put("Email", "E-Mail");
        this.emailAttrs.put("http://wso2.org/claims/emailaddress ", "E-Mail");
        this.windowsAccountNameAttrs.put("http://schemas.microsoft.com/ws/2008/06/identity/claims/windowsaccountname", IdpConfiguration.UsernameAttribute.WINDOWS_ACCOUNT_NAME.getDisplayName());
        this.upnAttrs.put("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/upn", "UPN");
        this.upnAttrs.put("http://schemas.xmlsoap.org/claims/UPN", "UPN");
        this.upnAttrs.put("upn", "UPN");
        this.upnAttrs.put("userPrincipalName", "UPN");
        this.knownAttributeNames.putAll(this.nameAttrs);
        this.knownAttributeNames.putAll(this.givenNameAttrs);
        this.knownAttributeNames.putAll(this.surnameAttrs);
        this.knownAttributeNames.putAll(this.emailAttrs);
        this.knownAttributeNames.putAll(this.upnAttrs);
        this.knownAttributeNames.put("http://schemas.microsoft.com/ws/2008/06/identity/claims/windowsaccountname", "Windows account name");
        this.knownAttributeNames.put("http://schemas.microsoft.com/2015/12/devicecontext/claims/tokenbindingid", "Token Binding ID");
        this.knownAttributeNames.put("http://schemas.xmlsoap.org/claims/Group", "Group");
        this.knownAttributeNames.put("http://schemas.microsoft.com/ws/2008/06/identity/claims/role", "Role");
        this.knownAttributeNames.put("http://schemas.microsoft.com/ws/2008/06/identity/claims/groups", "Group");
        this.knownAttributeNames.put("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified", "Unspecified NameID");
        this.knownAttributeNames.put("urn:oasis:names:tc:SAML:2.0:nameid-format:entity", "Entity NameID");
    }

    public SAMLResponseEvaluationResult evaluate(SamlIdpConfiguration idpConfiguration, SamlResponseValidationResult samlResult, IdpConfiguration.UsernameAttribute usernameAttribute, IdpConfiguration.UserLookupAttribute userLookupAttribute, IdpConfiguration.UserLookupTransform userLookupTransform, String nameAttribute, String givenNameAttribute, String surnameAttribute, IdpConfManager.NAME_ATTRIBUTE_MAPPING nameAttributeMapping, String emailAttribute, String customUsernameAttributeName, boolean addDefaultGroups) {
        if (customUsernameAttributeName == null) {
            customUsernameAttributeName = idpConfiguration.getCustomUsernameAttributeName();
        }
        List<AttributeInfo> attributeInfos = this.findAttributes(samlResult, customUsernameAttributeName);
        SAMLResponseEvaluationResult result = new SAMLResponseEvaluationResult(idpConfiguration, attributeInfos, samlResult, usernameAttribute, nameAttributeMapping, customUsernameAttributeName);
        UserRecipe userRecipe = null;
        if (result.isConfiguredUsernameAttributeFound()) {
            userRecipe = this.findUserRecipe(samlResult.getAssertions(), result.getConfiguredUsernameAttributeInfo(), result.getSearchedUsername(), nameAttribute, givenNameAttribute, surnameAttribute, nameAttributeMapping, emailAttribute);
        }
        return (SAMLResponseEvaluationResult)this.evaluateResult(idpConfiguration, result, userRecipe, addDefaultGroups).mapTry(SAMLResponseEvaluationResult.class::cast).getOrElse((Object)result);
    }

    public Set<String> findSamlGroups(List<Assertion> assertions) {
        TreeSet<String> groups = new TreeSet<String>();
        for (Assertion assertion : assertions) {
            for (AttributeStatement statement : assertion.getAttributeStatements()) {
                for (Attribute attribute : statement.getAttributes()) {
                    if (!StringUtils.equalsAnyIgnoreCase((CharSequence)attribute.getName(), (CharSequence[])new CharSequence[]{"Group", "Groups", "Role", "Roles", "http://schemas.microsoft.com/ws/2008/06/identity/claims/role", "http://schemas.microsoft.com/ws/2008/06/identity/claims/groups", "http://schemas.xmlsoap.org/claims/Group", "geVdsGroupIDmemberOf"})) continue;
                    for (XMLObject value : attribute.getAttributeValues()) {
                        groups.add(value.getDOM().getTextContent());
                    }
                }
            }
        }
        return groups;
    }

    private List<AttributeInfo> findAttributes(SamlResponseValidationResult result, String customUsernameAttributeName) {
        ArrayList<AttributeInfo> attributes = new ArrayList<AttributeInfo>();
        List assertions = result.getAssertions();
        for (Assertion assertion : assertions) {
            if (assertion.getSubject() != null && assertion.getSubject().getSubjectConfirmations() != null) {
                for (SubjectConfirmation subjectConfirmation : assertion.getSubject().getSubjectConfirmations()) {
                    NameID nameID;
                    if (!subjectConfirmation.getMethod().equals("urn:oasis:names:tc:SAML:2.0:cm:bearer") || (nameID = assertion.getSubject().getNameID()) == null) continue;
                    attributes.add(new AttributeInfo(nameID.getFormat(), nameID.getValue(), IdpConfiguration.UsernameAttribute.NAME_ID));
                }
            }
            if (assertion.getAttributeStatements() == null) continue;
            for (AttributeStatement attributeStatement : assertion.getAttributeStatements()) {
                if (attributeStatement.getAttributes() == null) continue;
                for (Attribute attribute : attributeStatement.getAttributes()) {
                    IdpConfiguration.UsernameAttribute usernameAttribute = null;
                    if (this.upnAttrs.containsKey(attribute.getName())) {
                        usernameAttribute = IdpConfiguration.UsernameAttribute.UPN;
                    } else if (this.emailAttrs.containsKey(attribute.getName())) {
                        usernameAttribute = IdpConfiguration.UsernameAttribute.MAIL;
                    } else if (this.nameAttrs.containsKey(attribute.getName())) {
                        usernameAttribute = IdpConfiguration.UsernameAttribute.NAME;
                    } else if (this.windowsAccountNameAttrs.containsKey(attribute.getName())) {
                        usernameAttribute = IdpConfiguration.UsernameAttribute.WINDOWS_ACCOUNT_NAME;
                    }
                    if (customUsernameAttributeName != null && customUsernameAttributeName.equals(attribute.getName())) {
                        usernameAttribute = IdpConfiguration.UsernameAttribute.CUSTOM_SAML_ATTRIBUTE_NAME;
                    }
                    for (XMLObject valueObject : attribute.getAttributeValues()) {
                        attributes.add(new AttributeInfo(attribute.getName(), valueObject.getDOM().getTextContent(), usernameAttribute));
                    }
                }
            }
        }
        return attributes;
    }

    private UserRecipe findUserRecipe(List<Assertion> assertions, AttributeInfo usernameAttribute, String searchedUsername, String nameAttribute, String givenNameAttribute, String surnameAttribute, IdpConfManager.NAME_ATTRIBUTE_MAPPING nameAttributeMapping, String emailAttribute) {
        UserProperty name;
        UserProperty username = new UserProperty(usernameAttribute.getName(), searchedUsername);
        if (IdpConfManager.NAME_ATTRIBUTE_MAPPING.FULL_NAME.equals((Object)nameAttributeMapping)) {
            name = this.findNameUserAttribute(assertions, this.nameAttrs.keySet(), this.givenNameAttrs.keySet(), this.surnameAttrs.keySet(), nameAttribute);
        } else {
            UserProperty givenName = this.findUserAttribute(assertions, Collections.singleton(givenNameAttribute));
            UserProperty surname = this.findUserAttribute(assertions, Collections.singleton(surnameAttribute));
            name = givenName != null && surname != null ? new UserProperty(new String[]{givenName.getAttributeNames()[0], surname.getAttributeNames()[0]}, givenName.getValue() + " " + surname.getValue()) : (givenName != null ? new UserProperty(new String[]{givenName.getAttributeNames()[0]}, givenName.getValue()) : (surname != null ? new UserProperty(new String[]{surname.getAttributeNames()[0]}, surname.getValue()) : null));
        }
        UserProperty email = this.findEmailAttribute(assertions, emailAttribute);
        return new UserRecipe(username, name, email);
    }

    private UserProperty findNameUserAttribute(List<Assertion> assertions, Set<String> nameAttrs, Set<String> givenNameAttrs, Set<String> surnameAttrs, String nameAttribute) {
        if (nameAttribute != null && !"".equals(nameAttribute)) {
            if (IdpConfiguration.UsernameAttribute.NAME_ID.name().equals(nameAttribute)) {
                return this.findNameId(assertions);
            }
            return this.findUserAttribute(assertions, Collections.singleton(nameAttribute));
        }
        UserProperty nameProperty = this.findUserAttribute(assertions, nameAttrs);
        UserProperty givenName = this.findUserAttribute(assertions, givenNameAttrs);
        UserProperty surname = this.findUserAttribute(assertions, surnameAttrs);
        if (givenName != null && surname != null) {
            return new UserProperty(new String[]{givenName.getAttributeNames()[0], surname.getAttributeNames()[0]}, givenName.getValue() + " " + surname.getValue());
        }
        if (nameProperty != null) {
            return nameProperty;
        }
        if (givenName != null) {
            return givenName;
        }
        if (surname != null) {
            return surname;
        }
        return null;
    }

    private UserProperty findNameId(List<Assertion> assertions) {
        for (Assertion assertion : assertions) {
            if (assertion.getSubject() == null || assertion.getSubject().getSubjectConfirmations() == null) continue;
            for (SubjectConfirmation subjectConfirmation : assertion.getSubject().getSubjectConfirmations()) {
                NameID nameID;
                if (!subjectConfirmation.getMethod().equals("urn:oasis:names:tc:SAML:2.0:cm:bearer") || (nameID = assertion.getSubject().getNameID()) == null) continue;
                return new UserProperty(nameID.getFormat(), nameID.getValue());
            }
        }
        return null;
    }

    private UserProperty findEmailAttribute(List<Assertion> assertions, String emailAttribute) {
        if (emailAttribute != null && !"".equals(emailAttribute)) {
            if (IdpConfiguration.UsernameAttribute.NAME_ID.name().equals(emailAttribute)) {
                return this.findNameId(assertions);
            }
            return this.findUserAttribute(assertions, Collections.singleton(emailAttribute));
        }
        return this.findUserAttribute(assertions, this.emailAttrs.keySet());
    }

    private UserProperty findUserAttribute(List<Assertion> assertions, Set<String> attrNames) {
        for (Assertion assertion : assertions) {
            for (AttributeStatement attributeStatement : assertion.getAttributeStatements()) {
                for (Attribute attribute : attributeStatement.getAttributes()) {
                    Iterator iterator;
                    if (!attrNames.contains(attribute.getName()) || !(iterator = attribute.getAttributeValues().iterator()).hasNext()) continue;
                    XMLObject xmlObject = (XMLObject)iterator.next();
                    return new UserProperty(attribute.getName(), xmlObject.getDOM().getTextContent());
                }
            }
        }
        return null;
    }

    public Map<String, String> getKnownAttributeNames() {
        return this.knownAttributeNames;
    }
}

