/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.identityproviders;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.google.common.collect.Sets;
import com.kantegasso.jsonmapping.JsonMapping;
import com.kantegasso.oidc.OidcStringLiterals;
import io.vavr.API;
import io.vavr.Patterns;
import io.vavr.Tuple;
import io.vavr.control.Option;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;
import org.kantega.atlaskerb.DebugInfo;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.identityproviders.ManagedGroup;
import org.kantega.atlaskerb.identityproviders.UserRecipe;
import org.kantega.atlaskerb.identityproviders.oidc.OidcIdpConfiguration;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.SamlIdpConfiguration;
import org.kantega.atlaskerb.saml.login.RedirectProperties;

public abstract class IdpConfiguration
implements DebugInfo {
    public static final String KSSO_AUTH_ANONYMOUS_BROWSING_SESSION_IDP_ID = "KSSO_AUTH_ANONYMOUS_BROWSING_SESSION_IDP_ID";
    public static final String KSSO_AUTH_ANONYMOUS_BROWSING_USER = "KSSO_AUTH_ANONYMOUS_BROWSING_USER";
    protected final UsernameAttribute usernameAttribute;
    private final Set<String> defaultGroups;
    private final Map<String, String> defaultGroupsRules;
    private final Map<String, String> userProfileKeyTransformations;
    private final boolean autoUpdateKnownDomains;
    private final String customEmailAttribute;
    private final String customNameAttribute;
    private final String customGivenNameAttribute;
    private final String customSurnameAttribute;
    private final IdpConfManager.NAME_ATTRIBUTE_MAPPING nameAttributeMapping;
    private final String customUsernameAttributeName;
    private final boolean enabled;
    private final String id;
    private final Set<String> idpGroupsAttributes;
    private final Optional<Long> jitDirectory;
    private final Kind kind;
    private final LinkedHashSet<String> knownDomains;
    private final List<ManagedGroup> managedGroups;
    private final List<ManagedGroup> autoGroups;
    private final boolean managedGroupsRequiredForJITCreation;
    private final String name;
    private final String notificationEmails;
    private final List<Pair<String, String>> userTransformationRegexes;
    private final boolean singleLogoutEnabled;
    private final String singleLogoutReturnURL;
    private final UserActivatePolicy userActivatePolicy;
    private final UserLookupAttribute userLookupAttribute;
    private final UserLookupTransform userLookupTransform;
    private final UsernamePolicy usernamePolicy;
    private final UserNotFoundPolicy userNotFoundPolicy;
    private final UserUpdateNamePolicy userUpdateNamePolicy;
    private final UserUpdateEmailPolicy userUpdateEmailPolicy;
    private final AutoCreateUserPolicy autoCreateUserPolicy;
    private final boolean hostedDomain;
    private final boolean authenticatedAnonymousBrowsingEnabled;
    boolean createAllIncomingGroups;
    boolean removeNonIdpGroupsFromUser;
    private final String mfaAttribute;
    private final boolean requireMfa;
    private final RedirectProperties redirectProperties;
    private final RedirectProperties jsmRedirectProperties;
    public static final int MAX_USERNAME_LENGTH_JIT_IN_AD = 20;

    protected IdpConfiguration(boolean requireMfa, String mfaAttribute, Set<String> defaultGroups, Map<String, String> defaultGroupsRules, boolean autoUpdateKnownDomains, String customEmailAttribute, String customNameAttribute, String customGivenNameAttribute, String customSurnameAttribute, IdpConfManager.NAME_ATTRIBUTE_MAPPING nameAttributeMapping, String customUsernameAttributeName, boolean enabled, String id, Optional<Long> jitDirectory, Kind kind, LinkedHashSet<String> knownDomains, boolean createAllIncomingGroups, boolean removeNonIdpGroupsFromUser, List<ManagedGroup> managedGroups, List<ManagedGroup> autoGroups, boolean managedGroupsRequiredForJITCreation, String name, String notificationEmails, List<Pair<String, String>> userTransformationRegexes, boolean singleLogoutEnabled, UserActivatePolicy userActivatePolicy, UserLookupAttribute userLookupAttribute, UserLookupTransform userLookupTransform, UsernameAttribute usernameAttribute, UsernamePolicy usernamePolicy, UserNotFoundPolicy userNotFoundPolicy, UserUpdateNamePolicy userUpdateNamePolicy, UserUpdateEmailPolicy userUpdateEmailPolicy, AutoCreateUserPolicy autoCreateUserPolicy, boolean hostedDomain, Set<String> idpGroupsAttributes, String singleLogoutReturnURL, Map<String, String> userProfileKeyTransformations, boolean authenticatedAnonymousBrowsingEnabled, RedirectProperties redirectProperties, RedirectProperties jsmRedirectProperties) {
        this.requireMfa = requireMfa;
        this.mfaAttribute = mfaAttribute;
        this.defaultGroups = defaultGroups;
        this.defaultGroupsRules = defaultGroupsRules;
        this.autoUpdateKnownDomains = autoUpdateKnownDomains;
        this.customEmailAttribute = customEmailAttribute;
        this.customNameAttribute = customNameAttribute;
        this.customGivenNameAttribute = customGivenNameAttribute;
        this.customSurnameAttribute = customSurnameAttribute;
        this.nameAttributeMapping = nameAttributeMapping;
        this.customUsernameAttributeName = customUsernameAttributeName;
        this.enabled = enabled;
        this.id = id;
        this.idpGroupsAttributes = idpGroupsAttributes;
        this.jitDirectory = jitDirectory;
        this.kind = kind;
        this.knownDomains = knownDomains;
        this.createAllIncomingGroups = createAllIncomingGroups;
        this.removeNonIdpGroupsFromUser = removeNonIdpGroupsFromUser;
        this.managedGroups = managedGroups;
        this.autoGroups = autoGroups;
        this.managedGroupsRequiredForJITCreation = managedGroupsRequiredForJITCreation;
        this.name = name;
        this.notificationEmails = notificationEmails;
        this.userTransformationRegexes = userTransformationRegexes;
        this.singleLogoutEnabled = singleLogoutEnabled;
        this.singleLogoutReturnURL = singleLogoutReturnURL;
        this.userActivatePolicy = userActivatePolicy;
        this.userLookupAttribute = userLookupAttribute;
        this.userLookupTransform = userLookupTransform;
        this.usernameAttribute = usernameAttribute;
        this.usernamePolicy = usernamePolicy;
        this.userNotFoundPolicy = userNotFoundPolicy;
        this.userUpdateNamePolicy = userUpdateNamePolicy;
        this.userUpdateEmailPolicy = userUpdateEmailPolicy;
        this.autoCreateUserPolicy = autoCreateUserPolicy;
        this.hostedDomain = hostedDomain;
        this.userProfileKeyTransformations = userProfileKeyTransformations;
        this.authenticatedAnonymousBrowsingEnabled = authenticatedAnonymousBrowsingEnabled;
        this.redirectProperties = redirectProperties;
        this.jsmRedirectProperties = jsmRedirectProperties;
    }

    public Map<String, String> getUserProfileKeyMap() {
        return (Map)Option.of(this.userProfileKeyTransformations).getOrElse(Collections.emptyMap());
    }

    public String getSingleLogoutReturnURL() {
        return this.singleLogoutReturnURL;
    }

    public <T> T fold(Function<OidcIdpConfiguration, T> ifOidc, Function<SamlIdpConfiguration, T> ifSaml) {
        if (this instanceof SamlIdpConfiguration) {
            return ifSaml.apply((SamlIdpConfiguration)this);
        }
        return ifOidc.apply((OidcIdpConfiguration)this);
    }

    public void ifOidc(Consumer<OidcIdpConfiguration> consumer) {
        this.fold(cfg -> {
            consumer.accept((OidcIdpConfiguration)cfg);
            return null;
        }, ignored -> null);
    }

    public void ifSaml(Consumer<SamlIdpConfiguration> consumer) {
        this.fold(ignored -> null, cfg -> {
            consumer.accept((SamlIdpConfiguration)cfg);
            return null;
        });
    }

    public String getId() {
        return this.id;
    }

    public Kind getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean mfaSupported() {
        return (Boolean)API.Match((Object)Tuple.of((Object)((Object)this.getProtocol()), (Object)((Object)this.getKind()))).of(new API.Match.Case[]{API.Case((API.Match.Pattern2)Patterns.$Tuple2((API.Match.Pattern)API.$((Object)((Object)SSOProtocol.OIDC)), (API.Match.Pattern)API.$()), (Object)true), API.Case((API.Match.Pattern0)API.$(), (Object)false)});
    }

    public Set<String> getIdpGroupsAttributes() {
        return (Set)Option.of(this.idpGroupsAttributes).getOrElse(Collections.emptySet());
    }

    @Override
    public JSONObject asJson() {
        JSONObject json = new JSONObject();
        json.put("id", (Object)this.getId());
        json.put("name", (Object)this.getName());
        json.put("kind", (Object)this.getKind().toString());
        json.put("enabled", this.isEnabled());
        json.put("defaultGroups", (Object)new JSONArray(this.getDefaultGroups()));
        json.put("defaultGroupsRules", JsonMapping.Write.mapAsJson(this.getDefaultGroupsRules()).getOrElse((Object)new JSONObject()));
        json.put("autoUpdateKnownDomains", this.isAutoUpdateKnownDomains());
        json.put("customEmailAttribute", (Object)this.getCustomEmailAttribute());
        json.put("customNameAttribute", (Object)this.getCustomNameAttribute());
        json.put("customGivenNameAttribute", (Object)this.getCustomGivenNameAttribute());
        json.put("customSurnameAttribute", (Object)this.getCustomSurnameAttribute());
        json.put("nameAttributeMapping", (Object)this.getNameAttributeMapping());
        json.put("customUsernameAttributeName", (Object)this.getCustomUsernameAttributeName());
        json.put("idpGroupsAttributes", (Object)new JSONArray(this.getIdpGroupsAttributes()));
        json.put("jitDirectory", this.getJitDirectory().orElse(null));
        json.put("knownDomains", (Object)new JSONArray(this.getKnownDomains()));
        json.put("createAllIncomingGroups", this.isCreateAllIncomingGroups());
        json.put("removeNonIdpGroupsFromUser", this.isRemoveNonIdpGroupsFromUser());
        json.put("managedGroups", (Object)new JSONArray((Collection)this.getManagedGroups().stream().map(ManagedGroup::getName).collect(Collectors.toList())));
        json.put("managedGroupsRequiredForJITCreation", this.isManagedGroupsRequiredForJITCreation());
        json.put("notificationEmails", (Object)this.getNotificationEmails());
        json.put("userTransformationRegexes", (Object)new JSONArray((Collection)this.getUserTransformationRegexes().stream().map(pair -> new JSONArray((Object)new String[]{(String)pair.getLeft(), (String)pair.getRight()})).collect(Collectors.toList())));
        json.put("singleLogoutEnabled", this.isSingleLogoutEnabled());
        json.put("singleLogoutReturnURL", (Object)this.getSingleLogoutReturnURL());
        json.put("userActivatePolicy", (Object)this.getUserActivatePolicy().name());
        json.put("userLookupAttribute", (Object)this.getUserLookupAttribute().name());
        json.put("userLookupTransform", (Object)this.getUserLookupTransform().name());
        json.put("usernameAttribute", (Object)this.getUsernameAttribute().name());
        json.put("usernamePolicy", (Object)this.getUsernamePolicy().name());
        json.put("userNotFoundPolicy", (Object)this.getUserNotFoundPolicy().name());
        json.put("userUpdateNamePolicy", (Object)this.getUserUpdateNamePolicy().name());
        json.put("userUpdateEmailPolicy", (Object)this.getUserUpdateEmailPolicy().name());
        json.put("hostedDomain", this.isHostedDomain());
        json.put("authenticatedAnonymousBrowsingEnabled", this.isAuthenticatedAnonymousBrowsingEnabled());
        json.put("redirectProperties", (Object)this.getRedirectProperties().asJson());
        json.put("jsmRedirectProperties", (Object)this.getJsmRedirectProperties().asJson());
        return json;
    }

    public abstract boolean isOidc();

    public abstract boolean isSaml();

    public boolean isDomainAllowed(String domain) {
        if (this.getUsernamePolicy() == UsernamePolicy.ANY) {
            return true;
        }
        return domain != null && this.getKnownDomains().contains(domain.toLowerCase());
    }

    public UserUpdateNamePolicy getUserUpdateNamePolicy() {
        return this.userUpdateNamePolicy;
    }

    public UserUpdateEmailPolicy getUserUpdateEmailPolicy() {
        return this.userUpdateEmailPolicy;
    }

    public UserActivatePolicy getUserActivatePolicy() {
        return this.userActivatePolicy;
    }

    public Set<String> getDefaultGroups() {
        return this.defaultGroups;
    }

    public Map<String, String> getDefaultGroupsRules() {
        return this.defaultGroupsRules;
    }

    public Set<String> getDefaultGroupsFilteredForUser(String usernameFromIdp) {
        HashSet<String> filteredGroups = new HashSet<String>();
        for (String group : this.getDefaultGroups()) {
            String groupRule = this.getDefaultGroupsRules().get(group);
            if (StringUtils.isBlank((CharSequence)groupRule)) {
                filteredGroups.add(group);
                continue;
            }
            if (!StringUtils.isNotBlank((CharSequence)groupRule) || usernameFromIdp == null || !usernameFromIdp.matches(groupRule)) continue;
            filteredGroups.add(group);
        }
        return filteredGroups;
    }

    public LinkedHashSet<String> getKnownDomains() {
        return this.knownDomains;
    }

    public Optional<Long> getJitDirectory() {
        return this.jitDirectory;
    }

    public UsernameAttribute getUsernameAttribute() {
        return this.usernameAttribute;
    }

    public UserLookupAttribute getUserLookupAttribute() {
        if (this.userNotFoundPolicy == UserNotFoundPolicy.CREATE) {
            return UserLookupAttribute.USERNAME;
        }
        return this.userLookupAttribute;
    }

    public UserLookupTransform getUserLookupTransform() {
        return this.userLookupTransform;
    }

    public String getMfaAttribute() {
        return this.mfaAttribute;
    }

    public boolean mfaRequired() {
        return this.requireMfa;
    }

    public String getNotificationEmails() {
        return this.notificationEmails;
    }

    public UsernamePolicy getUsernamePolicy() {
        return this.usernamePolicy;
    }

    public boolean isAutoUpdateKnownDomains() {
        return this.autoUpdateKnownDomains;
    }

    public String getCustomNameAttribute() {
        return StringUtils.trimToNull((String)this.customNameAttribute);
    }

    public String getCustomGivenNameAttribute() {
        return StringUtils.trimToNull((String)this.customGivenNameAttribute);
    }

    public String getCustomSurnameAttribute() {
        return StringUtils.trimToNull((String)this.customSurnameAttribute);
    }

    public IdpConfManager.NAME_ATTRIBUTE_MAPPING getNameAttributeMapping() {
        return this.nameAttributeMapping;
    }

    public String getCustomEmailAttribute() {
        return StringUtils.trimToNull((String)this.customEmailAttribute);
    }

    public boolean isCreateAllIncomingGroups() {
        return this.createAllIncomingGroups;
    }

    public boolean isRemoveNonIdpGroupsFromUser() {
        return this.removeNonIdpGroupsFromUser;
    }

    public List<ManagedGroup> getManagedGroups() {
        return this.managedGroups;
    }

    public List<ManagedGroup> getAutoGroups() {
        return this.autoGroups;
    }

    public boolean isManagedGroupsRequiredForJITCreation() {
        return this.managedGroupsRequiredForJITCreation;
    }

    public boolean isHostedDomain() {
        return this.hostedDomain;
    }

    public boolean isSingleLogoutEnabled() {
        return this.singleLogoutEnabled;
    }

    public abstract SSOProtocol getProtocol();

    public UserNotFoundPolicy getUserNotFoundPolicy() {
        return this.userNotFoundPolicy;
    }

    public AutoCreateUserPolicy getAutoCreateUserPolicy() {
        return this.autoCreateUserPolicy;
    }

    public String getCustomUsernameAttributeName() {
        return StringUtils.trimToEmpty((String)this.customUsernameAttributeName);
    }

    public List<Pair<String, String>> getUserTransformationRegexes() {
        return this.userTransformationRegexes;
    }

    public boolean isAuthenticatedAnonymousBrowsingEnabled() {
        return this.authenticatedAnonymousBrowsingEnabled;
    }

    public RedirectProperties getRedirectProperties() {
        return this.redirectProperties;
    }

    public RedirectProperties getJsmRedirectProperties() {
        return this.jsmRedirectProperties;
    }

    @NotNull
    public String getMessageIfJitDirIsAD(UserRecipe userRecipe, HostApp hostApp) {
        String jitMessage = "";
        Directory jitDir = hostApp.getCrowdDirectoryService().findDirectoryById(this.getJitDirectory().orElse(-1L).longValue());
        int usernameLength = userRecipe.getUsername().getValue().length();
        if (jitDir != null && jitDir.getType() == DirectoryType.CONNECTOR && usernameLength > 20) {
            jitMessage = "When creating users in Active Directory, the maximum username length is 20 characters. Your username is " + usernameLength + " characters.";
        }
        return jitMessage;
    }

    public static enum Kind {
        ADFS("AD FS", "AD FS (Active Directory Federation Services)", UsernameAttribute.UPN, UsernameAttribute.UPN, "", "", KindCategory.SERVER, Sets.newHashSet((Object[])new SSOProtocol[]{SSOProtocol.SAML, SSOProtocol.OIDC}), "https://{host url}/adfs/.well-known/openid-configuration"),
        AUTH0("Auth0", "Auth0", UsernameAttribute.NAME_ID, "username", KindCategory.CLOUD, (Set<SSOProtocol>)Sets.newHashSet((Object[])new SSOProtocol[]{SSOProtocol.SAML, SSOProtocol.OIDC}), "https://{identity server}/.well-known/openid-configuration"),
        AWS_COGNITO("AWS Cognito", "AWS Cognito", "username", "username", KindCategory.CLOUD, (Set<SSOProtocol>)Sets.newHashSet((Object[])new SSOProtocol[]{SSOProtocol.OIDC}), "https://cognito-idp.{region}.amazonaws.com/{userPoolId}/.well-known/openid-configuration"),
        AZURE_AD("Azure AD", "Azure AD", UsernameAttribute.NAME, UsernameAttribute.PREFERRED_USERNAME, "name", "email", "", "", KindCategory.CLOUD, Sets.newHashSet((Object[])new SSOProtocol[]{SSOProtocol.OIDC, SSOProtocol.SAML}), "https://login.microsoftonline.com/{tenant}/v2.0/.well-known/openid-configuration", OidcStringLiterals.AZURE_AD),
        BITIUM("Bitium", "Bitium", UsernameAttribute.NAME_ID, KindCategory.CLOUD, Sets.newHashSet((Object[])new SSOProtocol[]{SSOProtocol.SAML})),
        GITHUB("GitHub", "GitHub", "login", "login", KindCategory.CLOUD, Sets.newHashSet((Object[])new SSOProtocol[]{SSOProtocol.OIDC}), null, OidcStringLiterals.GITHUB),
        GITLAB("GitLab", "GitLab", "nickname", "nickname", KindCategory.SERVER, (Set<SSOProtocol>)Sets.newHashSet((Object[])new SSOProtocol[]{SSOProtocol.OIDC}), "https://{host url}/.well-known/openid-configuration"),
        GOOGLE("Google Workspace", "Google Workspace", UsernameAttribute.NAME_ID, UsernameAttribute.CUSTOM_SAML_ATTRIBUTE_NAME, "", "", "", "email", KindCategory.CLOUD, Sets.newHashSet((Object[])new SSOProtocol[]{SSOProtocol.OIDC, SSOProtocol.SAML}), "https://accounts.google.com/.well-known/openid-configuration", OidcStringLiterals.GOOGLE),
        KEYCLOAK("Keycloak", "Keycloak", UsernameAttribute.NAME_ID, UsernameAttribute.PREFERRED_USERNAME, KindCategory.SERVER, (Set<SSOProtocol>)Sets.newHashSet((Object[])new SSOProtocol[]{SSOProtocol.SAML, SSOProtocol.OIDC}), "https://{host url}/auth/realms/{realm}/.well-known/openid-configuration"),
        OKTA("Okta", "Okta", UsernameAttribute.NAME_ID, UsernameAttribute.PREFERRED_USERNAME, KindCategory.CLOUD, (Set<SSOProtocol>)Sets.newHashSet((Object[])new SSOProtocol[]{SSOProtocol.OIDC, SSOProtocol.SAML}), "https://{host url}/.well-known/openid-configuration"),
        ONELOGIN("OneLogin", "OneLogin", UsernameAttribute.NAME_ID, UsernameAttribute.PREFERRED_USERNAME, KindCategory.CLOUD, (Set<SSOProtocol>)Sets.newHashSet((Object[])new SSOProtocol[]{SSOProtocol.OIDC, SSOProtocol.SAML}), "https://{subdomain}.onelogin.com/oidc/2/.well-known/openid-configuration"),
        PINGONE("Ping One", "PingOne", UsernameAttribute.NAME_ID, KindCategory.CLOUD, Sets.newHashSet((Object[])new SSOProtocol[]{SSOProtocol.SAML})),
        PINGFEDERATE("Ping Federate", "Ping Federate", UsernameAttribute.NAME_ID, UsernameAttribute.PREFERRED_USERNAME, KindCategory.SERVER, (Set<SSOProtocol>)Sets.newHashSet((Object[])new SSOProtocol[]{SSOProtocol.SAML, SSOProtocol.OIDC}), "https://{host url}/.well-known/openid-configuration"),
        SALESFORCE("Salesforce", "Salesforce", UsernameAttribute.NAME_ID, UsernameAttribute.PREFERRED_USERNAME, KindCategory.CLOUD, (Set<SSOProtocol>)Sets.newHashSet((Object[])new SSOProtocol[]{SSOProtocol.SAML, SSOProtocol.OIDC}), "https://login.salesforce.com/.well-known/openid-configuration"),
        WSO2("WSO2", "WSO2", UsernameAttribute.NAME_ID, UsernameAttribute.USERNAME, KindCategory.CLOUD, (Set<SSOProtocol>)Sets.newHashSet((Object[])new SSOProtocol[]{SSOProtocol.SAML, SSOProtocol.OIDC}), "https://api.asgardeo.io/t/{organization_name}/oauth2/token/.well-known/openid-configuration"),
        GENERIC("", "Other", UsernameAttribute.NAME_ID, UsernameAttribute.SUB, KindCategory.GENERIC, (Set<SSOProtocol>)Sets.newHashSet((Object[])new SSOProtocol[]{SSOProtocol.SAML, SSOProtocol.OIDC}), "https://{identity server}/.well-known/openid-configuration");

        private final String defaultName;
        private final String displayName;
        private final UsernameAttribute samlDefaultUsernameAttribute;
        private final UsernameAttribute oidcDefaultUsernameAttribute;
        private final String oidcDefaultNameAttribute;
        private final String oidcDefaultEmailAttribute;
        private final String samlCustomUsernameAttributeName;
        private final String oidcCustomUsernameAttributeName;
        private final String suggestedWellknownUrl;
        private final KindCategory category;
        private final Set<SSOProtocol> supportedProtocols;
        private final String oidcLibRepresentation;

        private Kind(String defaultName, String displayName, UsernameAttribute samlDefaultUsernameAttribute, UsernameAttribute oidcDefaultUsernameAttribute, String oidcDefaultNameAttribute, String oidcDefaultEmailAttribute, String samlCustomUsernameAttributeName, String oidcCustomUsernameAttributeName, KindCategory category, Set<SSOProtocol> supportedProtocols, String suggestedWellknownUrl, String oidcLibRepresentation) {
            this.defaultName = defaultName;
            this.displayName = displayName;
            this.samlDefaultUsernameAttribute = samlDefaultUsernameAttribute;
            this.oidcDefaultUsernameAttribute = oidcDefaultUsernameAttribute;
            this.oidcDefaultNameAttribute = oidcDefaultNameAttribute;
            this.oidcDefaultEmailAttribute = oidcDefaultEmailAttribute;
            this.samlCustomUsernameAttributeName = samlCustomUsernameAttributeName;
            this.oidcCustomUsernameAttributeName = oidcCustomUsernameAttributeName;
            this.category = category;
            this.supportedProtocols = supportedProtocols;
            this.suggestedWellknownUrl = suggestedWellknownUrl;
            this.oidcLibRepresentation = oidcLibRepresentation;
        }

        private Kind(String defaultName, String displayName, UsernameAttribute samlDefaultUsernameAttribute, UsernameAttribute oidcDefaultUsernameAttribute, String samlCustomUsernameAttributeName, String oidcCustomUsernameAttributeName, KindCategory category, Set<SSOProtocol> supportedProtocols, String suggestedWellknownUrl) {
            this(defaultName, displayName, samlDefaultUsernameAttribute, oidcDefaultUsernameAttribute, "", "", samlCustomUsernameAttributeName, oidcCustomUsernameAttributeName, category, supportedProtocols, suggestedWellknownUrl, null);
        }

        private Kind(String defaultName, String displayName, UsernameAttribute defaultUsernameAttribute, KindCategory category, Set<SSOProtocol> supportedProtocols) {
            this(defaultName, displayName, defaultUsernameAttribute, defaultUsernameAttribute, "", "", null, null, category, supportedProtocols, null, null);
        }

        private Kind(String defaultName, String displayName, UsernameAttribute samlDefaultUsernameAttribute, UsernameAttribute oidcDefaultUsernameAttribute, KindCategory category, Set<SSOProtocol> supportedProtocols, String suggestedWellknownUrl) {
            this(defaultName, displayName, samlDefaultUsernameAttribute, oidcDefaultUsernameAttribute, "", "", null, null, category, supportedProtocols, suggestedWellknownUrl, null);
        }

        private Kind(String defaultName, String displayName, UsernameAttribute samlDefaultUsernameAttribute, String oidcDefaultUsernameAttribute, KindCategory category, Set<SSOProtocol> supportedProtocols, String suggestedWellknownUrl) {
            this(defaultName, displayName, samlDefaultUsernameAttribute, UsernameAttribute.CUSTOM_SAML_ATTRIBUTE_NAME, "", "", null, oidcDefaultUsernameAttribute, category, supportedProtocols, suggestedWellknownUrl, null);
        }

        private Kind(String defaultName, String displayName, String samlCustomUsernameAttributeName, String oidcCustomUsernameAttributeName, KindCategory category, Set<SSOProtocol> supportedProtocols, String suggestedWellknownUrl) {
            this(defaultName, displayName, UsernameAttribute.CUSTOM_SAML_ATTRIBUTE_NAME, UsernameAttribute.CUSTOM_SAML_ATTRIBUTE_NAME, "", "", samlCustomUsernameAttributeName, oidcCustomUsernameAttributeName, category, supportedProtocols, suggestedWellknownUrl, null);
        }

        private Kind(String defaultName, String displayName, String samlCustomUsernameAttributeName, String oidcCustomUsernameAttributeName, KindCategory category, Set<SSOProtocol> supportedProtocols, String suggestedWellknownUrl, String oidcLibRepresentation) {
            this(defaultName, displayName, UsernameAttribute.CUSTOM_SAML_ATTRIBUTE_NAME, UsernameAttribute.CUSTOM_SAML_ATTRIBUTE_NAME, "", "", samlCustomUsernameAttributeName, oidcCustomUsernameAttributeName, category, supportedProtocols, suggestedWellknownUrl, oidcLibRepresentation);
        }

        public String getDefaultName() {
            return this.defaultName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public UsernameAttribute getDefaultUsernameAttribute(SSOProtocol protocol) {
            if (protocol.equals((Object)SSOProtocol.OIDC)) {
                return this.oidcDefaultUsernameAttribute;
            }
            return this.samlDefaultUsernameAttribute;
        }

        public UsernameAttribute getSamlDefaultUsernameAttribute() {
            return this.samlDefaultUsernameAttribute;
        }

        public UsernameAttribute getOidcDefaultUsernameAttribute() {
            return this.oidcDefaultUsernameAttribute;
        }

        public String getOidcDefaultNameAttribute() {
            return this.oidcDefaultNameAttribute;
        }

        public String getOidcDefaultEmailAttribute() {
            return this.oidcDefaultEmailAttribute;
        }

        public KindCategory getCategory() {
            return this.category;
        }

        public Set<SSOProtocol> getSupportedProtocols() {
            return this.supportedProtocols;
        }

        public String getSamlCustomUsernameAttributeName() {
            return this.samlCustomUsernameAttributeName == null ? "" : this.samlCustomUsernameAttributeName;
        }

        public String getOidcCustomUsernameAttributeName() {
            return this.oidcCustomUsernameAttributeName == null ? "" : this.oidcCustomUsernameAttributeName;
        }

        public String getSuggestedWellknownUrl() {
            return this.suggestedWellknownUrl;
        }

        public String getOidcLibRepresentation() {
            return this.oidcLibRepresentation;
        }
    }

    public static enum UserActivatePolicy {
        NONE,
        ACTIVATE;

    }

    public static enum UserLookupAttribute {
        USERNAME("Username", "username", false),
        MAIL("Mail", "mail", true),
        USER_PRINCIPAL_NAME("User Principal Name", "userPrincipalName", true),
        SAMACCOUNTNAME("SAM Account Name", "sAMAccountName", true),
        EMPLOYEEID("Employee-ID", "employeeId", true);

        private final String attributeName;
        private final String displayName;
        private final boolean ldapOnly;

        private UserLookupAttribute(String displayName, String attributeName, boolean ldapOnly) {
            this.displayName = displayName;
            this.attributeName = attributeName;
            this.ldapOnly = ldapOnly;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public boolean isLdapOnly() {
            return this.ldapOnly;
        }
    }

    public static enum UserLookupTransform {
        NONE,
        NAME_PART,
        REGEX;

    }

    public static enum UsernameAttribute {
        UPN("User Principal Name"),
        MAIL("E-Mail"),
        NAME_ID("Subject's Name ID"),
        NAME("Name"),
        WINDOWS_ACCOUNT_NAME("Windows Account Name"),
        SUB("sub"),
        PREFERRED_USERNAME("preferred_username"),
        USERNAME("username"),
        CUSTOM_SAML_ATTRIBUTE_NAME("Custom username attribute");

        private final String displayName;

        private UsernameAttribute(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }

    public static enum UsernamePolicy {
        ANY,
        KNOWN_DOMAINS;

    }

    public static enum UserNotFoundPolicy {
        REJECT,
        CREATE;

    }

    public static enum UserUpdateNamePolicy {
        NONE,
        UPDATE_NAME;

    }

    public static enum UserUpdateEmailPolicy {
        NONE,
        UPDATE_EMAIL;

    }

    public static enum AutoCreateUserPolicy {
        ALWAYS("ALWAYS"),
        ANY_GROUP("ANY_GROUP"),
        MATCHED_GROUPS("MATCHED_GROUPS");

        public final String key;

        private AutoCreateUserPolicy(String key) {
            this.key = key;
        }

        public final String getKey() {
            return this.key;
        }
    }

    public static enum SSOProtocol {
        UNKNOWN("Unknown"),
        SAML("SAML"),
        OIDC("OpenID Connect");

        private final String name;

        private SSOProtocol(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum AllowCreate {
        TRUE,
        FALSE;

    }

    public static enum NameIdFormat {
        DEFAULT,
        CUSTOM;

    }

    public static enum RedirectPolicy {
        MANUAL,
        FALLBACK,
        ALL,
        HARD,
        NONE,
        KNOWN_DOMAIN,
        USER_DIRECTORY,
        USER_GROUP;

    }

    @Deprecated
    public static enum UserUpdatePolicy {
        NONE,
        UPDATE;

    }

    public static enum KindCategory {
        CLOUD("Cloud"),
        SERVER("On-Premise"),
        GENERIC("General");

        private final String displayName;

        private KindCategory(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

