/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.config.ConfigurationException;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.api.UserWithAttributes;
import com.atlassian.crowd.model.user.TimestampedUser;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.PropertyRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.json.JSONObject;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.jsoncreatorclasses.CleanupLogAttributes;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.jsoncreatorclasses.CleanupRule;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.jsoncreatorclasses.DryRunAttributes;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.jsoncreatorclasses.UserCleanupResult;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.jsoncreatorclasses.UserSummary;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.utils.CleanupAction;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.utils.CleanupResultType;
import org.kantega.atlaskerb.utils.JsonWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.support.CronSequenceGenerator;

public class InactiveUserCleaner {
    private static final Logger log = LoggerFactory.getLogger(InactiveUserCleaner.class);
    final JsonWrapper jsonWrapper;
    final KerbConfManager kerbConfManager;
    final CrowdService crowdService;
    final CrowdDirectoryService crowdDirectoryService;
    final HostApp hostApp;
    private final AtomicReference<CleanupState> state;
    private final ExecutorService workers;

    public ExecutorService getWorkers() {
        return this.workers;
    }

    public InactiveUserCleaner(HostApp hostApp, KerbConfManager kerbConfManager, CrowdService crowdService, CrowdDirectoryService crowdDirectoryService, JsonWrapper jsonWrapper) {
        this.hostApp = hostApp;
        this.jsonWrapper = jsonWrapper;
        this.crowdService = crowdService;
        this.crowdDirectoryService = crowdDirectoryService;
        this.kerbConfManager = kerbConfManager;
        this.state = new AtomicReference<CleanupState>(new CleanupState(CleanupStatus.NOT_RUN));
        this.workers = Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("User-Cleanup-%d").build());
    }

    public CleanupStatus getUserCleanupExecuteStatus() {
        CleanupState cleanupState = this.state.get();
        return cleanupState.status;
    }

    public void setUserCleanupExecuteStatus(CleanupStatus status) {
        CleanupState newState = new CleanupState(status);
        CleanupState current = this.state.get();
        if (current.status != status) {
            this.state.compareAndSet(current, newState);
        }
    }

    @NotNull
    public UserCleanupResult cleanUsers(String currentUserName, DryRunAttributes dryRunAttributes, DateTime runTimestamp, String runId) throws ConfigurationException {
        String dryRunString = dryRunAttributes != null && dryRunAttributes.isDryRun() ? "Test run: " : "Real run: ";
        PropertyRestriction active = Restriction.on((Property)UserTermKeys.ACTIVE).exactlyMatching((Object)Boolean.TRUE);
        ObjectReader objectReader = this.jsonWrapper.objectReader();
        try {
            DateTime now;
            User user2;
            CleanupRule cleanupRule = (CleanupRule)objectReader.readValue(this.kerbConfManager.getUserCleanupRuleJSONString(), CleanupRule.class);
            if (cleanupRule == null) {
                log.warn("User cleanup: Could not find CleanupRule. Skipping user cleanup");
                throw new ConfigurationException("Could not find CleanupRule. Skipping user cleanup");
            }
            if (cleanupRule.getCleanupAction() == CleanupAction.REMOVE_FROM_GROUP && (cleanupRule.getGroupToRemove() == null || cleanupRule.getGroupToRemove().length() == 0)) {
                log.warn("User cleanup: CleanupRule was not configured. Missing groupToRemove value. Skipping user cleanup");
                throw new ConfigurationException("CleanupRule was not configured. Missing groupToRemove value.");
            }
            if (!(cleanupRule.getChangedByUsername() == null || (user2 = this.crowdService.getUser(cleanupRule.getChangedByUsername())) != null && user2.isActive())) {
                log.error("User cleanup rule owner user profile is no longer active or has been deleted. Skipping user cleanup");
                throw new ConfigurationException("User cleanup rule owner user profile is no longer active or has been deleted. Skipping user cleanup");
            }
            ArrayList<UserSummary> affectedUsersList = new ArrayList<UserSummary>();
            log.info("{}User cleanup: Starting user cleanup. {} users not logged in for past {} days", new Object[]{dryRunString, cleanupRule.getCleanupAction() == CleanupAction.REMOVE_FROM_GROUP ? "Removing " + cleanupRule.getGroupToRemove() + " from" : "Deactivating", cleanupRule.getDaysInactiveThreshold()});
            Iterable users = this.crowdService.search((Query)QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)active).returningAtMost(-1));
            Set<Directory> writableUserDirectories = this.hostApp.getWritableUserDirectories();
            Set<Directory> cleanableDirectories = cleanupRule.getDirectoriesWhitelist() == null ? writableUserDirectories : writableUserDirectories.stream().filter(directory -> Arrays.stream(cleanupRule.getDirectoriesWhitelist()).noneMatch(directoryName -> directoryName.equals(directory.getName()))).collect(Collectors.toSet());
            List cleanableDirectoryIds = cleanableDirectories.stream().map(Directory::getId).collect(Collectors.toList());
            if (dryRunAttributes != null && dryRunAttributes.isDryRun() && dryRunAttributes.isSimulateCronDate()) {
                if (cleanupRule.getCronAttributes() != null && cleanupRule.getCronAttributes().getCronSpringSchedule() != null) {
                    CronSequenceGenerator generator = new CronSequenceGenerator(cleanupRule.getCronAttributes().getCronSpringSchedule());
                    Date nextExecutionDate = generator.next(new Date());
                    now = new DateTime((Object)nextExecutionDate);
                } else {
                    now = runTimestamp;
                }
            } else {
                now = runTimestamp;
            }
            log.debug("{}Found {} users. Starting analysing how many needs to be cleaned.", (Object)dryRunString, (Object)StreamSupport.stream(users.spliterator(), false).count());
            try {
                StreamSupport.stream(users.spliterator(), false).forEach(user -> {
                    if (!dryRunAttributes.isDryRun() && this.hostApp.getUserCleanupExecuteStatus() == CleanupStatus.NOT_RUN) {
                        throw new BreakException();
                    }
                    boolean isCurrentLoggedInUser = currentUserName != null && currentUserName.equals(user.getName()) && (dryRunAttributes == null || !dryRunAttributes.isSimulateCronDate());
                    boolean isCurrentCleanupRuleOwner = cleanupRule.getChangedByUsername() != null && cleanupRule.getChangedByUsername().equals(user.getName());
                    boolean userInWhiteList = cleanupRule.getUsersWhitelist() != null && Arrays.stream(cleanupRule.getUsersWhitelist()).noneMatch(whitelistedUser -> user.getName().equals(whitelistedUser));
                    boolean userInCleanableDirectory = cleanableDirectoryIds.contains(user.getDirectoryId());
                    boolean userInWhitelistedGroup = cleanupRule.getGroupsWhitelist() != null && Arrays.stream(cleanupRule.getGroupsWhitelist()).anyMatch(group -> this.hostApp.isUserInGroup(user.getName(), (String)group));
                    boolean userHasGroupToBeRemoved = cleanupRule.getCleanupAction() != CleanupAction.REMOVE_FROM_GROUP || cleanupRule.getGroupToRemove() != null && cleanupRule.getGroupToRemove().length() > 0 && this.hostApp.isUserInGroup(user.getName(), cleanupRule.getGroupToRemove());
                    UserWithAttributes userWithAttributes = this.crowdService.getUserWithAttributes(user.getName());
                    if (!(!userInCleanableDirectory && cleanupRule.getCleanupAction() != CleanupAction.REMOVE_FROM_GROUP || isCurrentCleanupRuleOwner || isCurrentLoggedInUser || userInWhiteList || userInWhitelistedGroup || !userHasGroupToBeRemoved)) {
                        Directory userDirectory = this.crowdDirectoryService.findAllDirectories().stream().filter(directory -> directory.getId().longValue() == user.getDirectoryId()).findFirst().get();
                        String lastLoginMillis = this.hostApp.getLastLoginMillisFromUserWithAttributes(userWithAttributes);
                        if (NumberUtils.isCreatable((String)lastLoginMillis)) {
                            DateTime lastLogin = new DateTime(Long.parseLong(lastLoginMillis));
                            log.debug("{}Checking if user {} should be cleaned. Lastlogin: {}", new Object[]{dryRunString, user.getName(), lastLogin});
                            if (this.shouldCleanupUser(lastLogin, cleanupRule.getDaysInactiveThreshold(), now)) {
                                log.info("{}User cleanup: Cleaning user {}. Not logged in for more than {} days", new Object[]{dryRunString, user.getName(), cleanupRule.getDaysInactiveThreshold()});
                                this.optionallyCleanupUser(dryRunString, dryRunAttributes, cleanupRule, affectedUsersList, (User)user, userDirectory, userInCleanableDirectory);
                            }
                        } else if (lastLoginMillis == null) {
                            DateTime created = new DateTime((Object)((TimestampedUser)user).getCreatedDate());
                            log.debug("{}Checking if user {} should be cleaned. created: {}", new Object[]{dryRunString, user.getName(), created});
                            if (this.shouldCleanupUser(created, cleanupRule.getDaysInactiveThreshold(), now)) {
                                log.info("{}User cleanup: Cleaning user {}. Created more than {} days ago but never logged in.", new Object[]{dryRunString, user.getName(), cleanupRule.getDaysInactiveThreshold()});
                                this.optionallyCleanupUser(dryRunString, dryRunAttributes, cleanupRule, affectedUsersList, (User)user, userDirectory, userInCleanableDirectory);
                            }
                        }
                    }
                });
            }
            catch (BreakException e) {
                log.warn("User cleanup: Cleanup process was cancelled mid run. " + affectedUsersList.size() + " users was affected before cancel. You can find complete list of affected users in the user cleanup log directory");
            }
            return this.createAndSaveUserCleanupResult(dryRunAttributes, affectedUsersList, now, runId);
        }
        catch (IOException e) {
            log.error("User cleanup: Failed to parse userCleanupRule json from config", (Throwable)e);
            throw new ConfigurationException("CleanupRule was not configured properly.", (Throwable)e);
        }
    }

    private void optionallyCleanupUser(String dryRunString, DryRunAttributes dryRunAttributes, CleanupRule cleanupRule, ArrayList<UserSummary> affectedUsersList, User user, Directory userDirectory, boolean userInCleanableDirectory) {
        boolean success = false;
        if (dryRunAttributes == null || !dryRunAttributes.isDryRun()) {
            if (cleanupRule.getCleanupAction() == CleanupAction.REMOVE_FROM_GROUP) {
                success = this.hostApp.removeUserFromGroup((Principal)user, cleanupRule.getGroupToRemove());
            } else if (userInCleanableDirectory) {
                success = this.deactivateUser(userDirectory, user);
            } else {
                log.warn("User {} to be deactivated is in read-only directory.", (Object)user.getName());
            }
        } else {
            success = true;
        }
        if (success) {
            log.debug("{}Adding user {} to affected users", (Object)dryRunString, (Object)user.getName());
            affectedUsersList.add(new UserSummary(user.getName(), user.getEmailAddress()));
        } else {
            log.debug("{}Not adding user {} to affected users", (Object)dryRunString, (Object)user.getName());
        }
    }

    @NotNull
    private UserCleanupResult createAndSaveUserCleanupResult(DryRunAttributes dryRunAttributes, ArrayList<UserSummary> affectedUsersList, DateTime now, String runId) {
        String name = dryRunAttributes != null && dryRunAttributes.isDryRun() ? "dry-run" : "cleaned-users";
        DateTimeFormatter filenameDtf = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH-mm-ss'Z'");
        DateTimeFormatter dtf = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss'Z'");
        String filenameId = now.toString(filenameDtf) + "_" + name;
        UserCleanupResult result = new UserCleanupResult(filenameId, runId, now.toString(dtf), dryRunAttributes != null && dryRunAttributes.isDryRun(), dryRunAttributes != null && dryRunAttributes.isSimulateCronDate(), affectedUsersList.toArray(new UserSummary[0]));
        CleanupResultType logtype = dryRunAttributes != null && dryRunAttributes.isDryRun() ? (dryRunAttributes.isSimulateCronDate() ? CleanupResultType.DRY_SIMULATED_DATE : CleanupResultType.DRY) : CleanupResultType.LIVE;
        try {
            this.saveCleanupLogFile(filenameId, logtype, this.createJsonObjectFromCleanupResult(result));
        }
        catch (Exception e) {
            List<String> usernamesList = Arrays.stream(result.getAffectedUsers()).map(userSummary -> userSummary.getUsername() + ": " + userSummary.getEmail()).collect(Collectors.toList());
            log.warn("User cleanup: Failed to save UserCleanupResults log to file.", (Throwable)e);
            log.warn("User cleanup: The following users where affected by the cleanup operation:");
            usernamesList.forEach(arg_0 -> ((Logger)log).warn(arg_0));
        }
        return result;
    }

    public UserCleanupResult[] getUserCleanupLog(CleanupLogAttributes cleanupLogAttributes) {
        CleanupResultType[] cleanupResultTypes = cleanupLogAttributes.getIncludeAllLogs() ? new CleanupResultType[]{CleanupResultType.DRY, CleanupResultType.DRY_SIMULATED_DATE, CleanupResultType.LIVE} : (cleanupLogAttributes.isDryRun() ? (cleanupLogAttributes.isSimulateCronDate() ? new CleanupResultType[]{CleanupResultType.DRY_SIMULATED_DATE} : new CleanupResultType[]{CleanupResultType.DRY}) : new CleanupResultType[]{CleanupResultType.LIVE});
        return this.getUserCleanupResultsFromFiles(cleanupResultTypes);
    }

    public UserCleanupResult[] getUserCleanupResultsFromFiles(CleanupResultType[] cleanupResultTypes) {
        File baseDirectory = new File(this.hostApp.getHomeDirectory(), "userCleanupLogs");
        ArrayList result = new ArrayList();
        ObjectReader jsonReader = this.jsonWrapper.objectReader();
        List<CleanupResultType> list = Arrays.asList(cleanupResultTypes);
        list.forEach(logType -> {
            File directory = this.getDirectoryFromResultType(baseDirectory, (CleanupResultType)((Object)logType));
            File[] filesInDir = directory.listFiles();
            List<File> files = Arrays.asList(filesInDir == null ? new File[]{} : filesInDir);
            files.forEach(file -> {
                try (FileInputStream is = new FileInputStream((File)file);){
                    String jsonText = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                    if (jsonText != null && jsonText.length() > 0) {
                        result.add((UserCleanupResult)jsonReader.readValue(jsonText, UserCleanupResult.class));
                    }
                }
                catch (IOException e) {
                    log.warn("User cleanup: Failed to get cleanup result from file: " + file.getName(), (Throwable)e);
                }
            });
        });
        return result.stream().sorted(Comparator.comparing(UserCleanupResult::getFilenameId)).collect(Collectors.toList()).toArray(result.toArray(new UserCleanupResult[0]));
    }

    public File getDirectoryFromResultType(File parentDir, CleanupResultType logType) {
        File directory;
        switch (logType) {
            case DRY: {
                directory = new File(parentDir, "dryRuns");
                break;
            }
            case DRY_SIMULATED_DATE: {
                directory = new File(parentDir, "dryRunsWithSimulatedDate");
                break;
            }
            default: {
                directory = new File(parentDir, "liveCleanupLogs");
            }
        }
        return directory;
    }

    public void saveCleanupLogFile(String filenameId, CleanupResultType cleanupResultType, JSONObject jsonData) throws IOException {
        int maxNofFiles;
        File directory;
        File baseDirectory = new File(this.hostApp.getHomeDirectory(), "userCleanupLogs");
        boolean isDry = true;
        switch (cleanupResultType) {
            case DRY: {
                directory = new File(baseDirectory, "dryRuns");
                break;
            }
            case DRY_SIMULATED_DATE: {
                directory = new File(baseDirectory, "dryRunsWithSimulatedDate");
                break;
            }
            default: {
                isDry = false;
                directory = new File(baseDirectory, "liveCleanupLogs");
            }
        }
        File[] filesInDir = directory.listFiles();
        int n = maxNofFiles = isDry ? 1 : 5;
        if (filesInDir != null && filesInDir.length >= maxNofFiles) {
            List sortedFiles = Arrays.stream(filesInDir).sorted(Comparator.comparingLong(File::lastModified)).collect(Collectors.toList());
            while (sortedFiles.size() > maxNofFiles - 1) {
                this.clearCleanupLogFile(((File)sortedFiles.get(1)).getName(), cleanupResultType);
                sortedFiles.remove(1);
            }
        }
        File file = new File(directory, filenameId);
        FileUtils.writeStringToFile((File)file, (String)jsonData.toString(), (Charset)StandardCharsets.UTF_8);
    }

    public boolean clearCleanupLogFile(String filenameId, CleanupResultType cleanupResultType) {
        File baseDirectory = new File(this.hostApp.getHomeDirectory(), "userCleanupLogs");
        File directory = this.getDirectoryFromResultType(baseDirectory, cleanupResultType);
        File fileToDelete = new File(directory, filenameId);
        boolean success = false;
        for (int i = 0; i < 3; ++i) {
            if (fileToDelete.delete()) {
                success = true;
                break;
            }
            try {
                FileUtils.writeStringToFile((File)fileToDelete, (String)"", (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                String msg = "User cleanup: Delete of logfile failed, tried to clear file contents instead. Also failed to clear file contents: " + filenameId;
                log.error(msg, (Throwable)e);
                continue;
            }
            success = true;
        }
        if (!success) {
            String msg = "User cleanup: Failed to delete file: " + filenameId;
            IOException e = new IOException(msg);
            log.error(msg, (Throwable)e);
        }
        return success;
    }

    private JSONObject createJsonObjectFromCleanupResult(UserCleanupResult result) {
        ObjectWriter objectWriter = this.jsonWrapper.objectWriter();
        try {
            String jsonStr = objectWriter.writeValueAsString((Object)result);
            return new JSONObject(jsonStr);
        }
        catch (JsonProcessingException e) {
            return new JSONObject();
        }
    }

    private boolean shouldCleanupUser(DateTime lastUsed, int daysThreshold, DateTime now) {
        DateTime expiryDate = lastUsed.plusDays(daysThreshold);
        return expiryDate.isBefore((ReadableInstant)now);
    }

    private boolean deactivateUser(Directory directory, User user) {
        try {
            this.hostApp.updateUser(directory, user.getName(), user.getDisplayName(), user.getEmailAddress(), false);
            return true;
        }
        catch (Exception e) {
            log.error("User cleanup: Failed to deactivate user " + user.getName(), (Throwable)e);
            return false;
        }
    }

    private static class CleanupState {
        private final CleanupStatus status;

        CleanupState(CleanupStatus status) {
            this.status = status;
        }

        CleanupStatus getStatus() {
            return this.status;
        }

        boolean isCurrent(CleanupStatus status) {
            if (status == null) {
                return this.status == null;
            }
            return status.equals((Object)this.status);
        }
    }

    public static enum CleanupStatus {
        NOT_RUN,
        RUNNING,
        FAILED,
        SUCCESS;

    }

    static class BreakException
    extends RuntimeException {
        BreakException() {
        }
    }
}

