/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.impl.ImmutableDirectory;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.saml.servlet.IdpGroupsServlet;
import org.kantega.atlaskerb.userlookup.UserLookupService;
import org.kantega.atlaskerb.utils.ErrorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisableTraditionalLoginServlet
extends RequireAdminServlet {
    private final KerbConfManager kerbConfManager;
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;
    private final Logger log = LoggerFactory.getLogger(DisableTraditionalLoginServlet.class);

    @Inject
    public DisableTraditionalLoginServlet(RequireAdminServletDependencyBucket bucket, @ComponentImport PluginAccessor pluginAccessor) {
        super(bucket);
        this.kerbConfManager = bucket.getKerbConfManager();
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String query = req.getParameter("query");
        if (query != null) {
            IdpGroupsServlet.printGroupsAsJson(resp, query, this.userManager);
        } else {
            this.buildModelAndRenderTemplate(req, resp, new HashMap<String, Object>());
        }
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        super.doPost(req, resp);
        this.kerbConfManager.setTraditionalLoginPrevented(StringUtils.equals((CharSequence)"on", (CharSequence)req.getParameter("traditionalLoginDisabled")));
        this.kerbConfManager.setTraditionalLoginJsmPrevented(StringUtils.equals((CharSequence)"on", (CharSequence)req.getParameter("traditionalLoginJsmDisabled")));
        String addGroup = StringUtils.trim((String)req.getParameter("addGroup"));
        String removeGroup = req.getParameter("removeGroup");
        if ("usersInGroupsSelected".equals(req.getParameter("usersInGroups"))) {
            if (this.kerbConfManager.getDisallowTraditionalLoginGroups().size() > 0) {
                this.kerbConfManager.setAllowTraditionalLoginGroups(this.kerbConfManager.emptyDisallowTraditionalLoginGroups());
            }
            if (StringUtils.isNotBlank((CharSequence)addGroup)) {
                this.kerbConfManager.addAllowTraditionalLoginGroups(addGroup);
            }
            if (StringUtils.isNotBlank((CharSequence)removeGroup)) {
                this.kerbConfManager.removeAllowTraditionalLoginGroups(removeGroup);
            }
        } else {
            if (this.kerbConfManager.getAllowTraditionalLoginGroups().size() > 0) {
                this.kerbConfManager.setDisallowTraditionalLoginGroups(this.kerbConfManager.emptyAllowTraditionalLoginGroups());
            }
            if (StringUtils.isNotBlank((CharSequence)addGroup)) {
                this.kerbConfManager.addDisallowTraditionalLoginGroups(addGroup);
            }
            if (StringUtils.isNotBlank((CharSequence)removeGroup)) {
                this.kerbConfManager.removeDisallowTraditionalLoginGroups(removeGroup);
            }
        }
        for (Directory directory : this.userLookupService.getActiveUserDirectories()) {
            String enableButton = req.getParameter("traditionalLoginEnable" + directory.getId());
            try {
                ImmutableDirectory.Builder builder = ImmutableDirectory.newBuilder((Directory)directory);
                HashMap<String, String> attrs = new HashMap<String, String>(directory.getAttributes());
                if ("on".equals(enableButton)) {
                    attrs.put("ksso.traditional.login.allowed", "true");
                } else {
                    attrs.put("ksso.traditional.login.allowed", "false");
                }
                builder.setAttributes(attrs);
                this.hostApp.getCrowdDirectoryService().updateDirectory(builder.toDirectory());
            }
            catch (UnsupportedOperationException u) {
                this.log.error(ErrorUtils.createErrorMessage("KSSO-X7O8L3EC10", "Unable to update directory " + directory.getName()), (Throwable)u);
            }
        }
        resp.sendRedirect("disableLogin");
    }

    private void buildModelAndRenderTemplate(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> additionalData) throws IOException {
        Map<String, Object> model = this.buildModel(req);
        model.putAll(additionalData);
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/disableLogin.vm", model, (Writer)resp.getWriter());
    }

    private Map<String, Object> buildModel(HttpServletRequest req) {
        Map<String, Object> model = this.newModel(req);
        this.newModel(req);
        model.put("topMenu", "dashboard");
        model.put("menuItem", "disableLogin");
        model.put("traditionalLoginDisabled", this.kerbConfManager.isTraditionalLoginPrevented());
        model.put("traditionalLoginJsmDisabled", this.kerbConfManager.isTraditionalLoginJsmPrevented());
        model.put("homeDirectory", this.kerbConfManager.getKerberosHomeDirectoryPath());
        model.put("isJsmInstalled", this.kerbConfManager.isJsmInstalled());
        model.put("directories", this.userLookupService.getActiveUserDirectories());
        model.put("KSSO_TRADITIONAL_LOGIN_ALLOWED", "ksso.traditional.login.allowed");
        if (this.kerbConfManager.getDisallowTraditionalLoginGroups().size() > 0) {
            model.put("allowGroupsSelected", false);
            model.put("groups", this.kerbConfManager.getDisallowTraditionalLoginGroups());
        } else {
            model.put("allowGroupsSelected", true);
            model.put("groups", this.kerbConfManager.getAllowTraditionalLoginGroups());
        }
        return model;
    }

    public static boolean isBlockTraditionalLogin(KerbConfManager kerbConfManager, UserLookupService userLookupService) {
        return kerbConfManager.isTraditionalLoginPrevented() && userLookupService.getDirectoriesAllowingTraditionalLogin().size() == 0 && kerbConfManager.getAllowTraditionalLoginGroups().size() == 0 && kerbConfManager.getDisallowTraditionalLoginGroups().size() == 0;
    }

    public static boolean isBlockTraditionalLoginJSM(KerbConfManager kerbConfManager, UserLookupService userLookupService) {
        return kerbConfManager.isTraditionalLoginJsmPrevented() && userLookupService.getDirectoriesAllowingTraditionalLogin().size() == 0 && kerbConfManager.getAllowTraditionalLoginGroups().size() == 0 && kerbConfManager.getDisallowTraditionalLoginGroups().size() == 0;
    }
}

