/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.impl.ImmutableDirectory;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.saml.servlet.IdpGroupsServlet;
import org.kantega.atlaskerb.utils.ErrorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisableKerberosAction
extends RequireAdminServlet {
    private final KerbConfManager kerbConfManager;
    private final TemplateRenderer renderer;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    @Inject
    public DisableKerberosAction(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.kerbConfManager = bucket.getKerbConfManager();
        this.renderer = bucket.getTemplateRenderer();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String query = req.getParameter("query");
        if (query != null) {
            IdpGroupsServlet.printGroupsAsJson(resp, query, this.userManager);
        } else {
            Map<String, Object> model = this.newModel(req);
            model.put("topMenu", "Kerberos");
            model.put("menuItem", "disable");
            model.put("disable", !this.kerbConfManager.isKerberosEnabled());
            model.put("directories", this.userLookupService.getActiveUserDirectories());
            model.put("KSSO_KERBEROS_LOGIN_ALLOWED", "ksso.kerberos.login.allowed");
            if (this.kerbConfManager.getDisallowKerberosLoginGroups().size() > 0) {
                model.put("allowGroupsSelected", false);
                model.put("groups", this.kerbConfManager.getDisallowKerberosLoginGroups());
            } else {
                model.put("allowGroupsSelected", true);
                model.put("groups", this.kerbConfManager.getAllowKerberosLoginGroups());
            }
            if (this.kerbConfManager.getDisallowKerberosLoginGroups().size() > 0) {
                model.put("allowGroupsSelected", false);
                model.put("groups", this.kerbConfManager.getDisallowKerberosLoginGroups());
            } else {
                model.put("allowGroupsSelected", true);
                model.put("groups", this.kerbConfManager.getAllowKerberosLoginGroups());
            }
            resp.setContentType("text/html");
            this.renderer.render("templates/atlaskerb/disable.vm", model, (Writer)resp.getWriter());
        }
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.kerbConfManager.setKerberosEnabled(req.getParameter("disable") == null);
        String addGroup = StringUtils.trim((String)req.getParameter("addGroup"));
        String removeGroup = req.getParameter("removeGroup");
        if ("usersInGroupsSelected".equals(req.getParameter("usersInGroups"))) {
            if (this.kerbConfManager.getDisallowKerberosLoginGroups().size() > 0) {
                this.kerbConfManager.setAllowKerberosLoginGroups(this.kerbConfManager.emptyDisallowKerberosLoginGroups());
            }
            if (StringUtils.isNotBlank((CharSequence)addGroup)) {
                this.kerbConfManager.addAllowKerberosLoginGroups(addGroup);
            }
            if (StringUtils.isNotBlank((CharSequence)removeGroup)) {
                this.kerbConfManager.removeAllowKerberosLoginGroups(removeGroup);
            }
        } else {
            if (this.kerbConfManager.getAllowKerberosLoginGroups().size() > 0) {
                this.kerbConfManager.setDisallowKerberosLoginGroups(this.kerbConfManager.emptyAllowKerberosLoginGroups());
            }
            if (StringUtils.isNotBlank((CharSequence)addGroup)) {
                this.kerbConfManager.addDisallowKerberosLoginGroups(addGroup);
            }
            if (StringUtils.isNotBlank((CharSequence)removeGroup)) {
                this.kerbConfManager.removeDisallowKerberosLoginGroups(removeGroup);
            }
        }
        for (Directory directory : this.userLookupService.getActiveUserDirectories()) {
            String enableButton = req.getParameter("kerberosLoginEnable" + directory.getId());
            try {
                ImmutableDirectory.Builder builder = ImmutableDirectory.newBuilder((Directory)directory);
                HashMap<String, String> attrs = new HashMap<String, String>(directory.getAttributes());
                if ("on".equals(enableButton)) {
                    attrs.put("ksso.kerberos.login.allowed", "true");
                } else {
                    attrs.put("ksso.kerberos.login.allowed", "false");
                }
                builder.setAttributes(attrs);
                this.hostApp.getCrowdDirectoryService().updateDirectory(builder.toDirectory());
            }
            catch (UnsupportedOperationException u) {
                this.log.error(ErrorUtils.createErrorMessage("KSSO-X7O8L3EC11", "Unable to update directory " + directory.getName()), (Throwable)u);
            }
        }
        resp.sendRedirect("disable");
    }
}

