/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.utils;

import io.vavr.API;
import io.vavr.CheckedFunction0;
import io.vavr.Function2;
import io.vavr.Predicates;
import io.vavr.collection.CharSeq;
import io.vavr.collection.List;
import io.vavr.collection.Seq;
import io.vavr.collection.Stream;
import io.vavr.control.Either;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.util.SubnetUtils;
import org.kantega.atlaskerb.utils.KssoStringUtils;
import org.kantega.atlaskerb.utils.ListParseUtils;

public class InternetAddressUtils {
    static final String OLD_IP_ADDRESS_PREFIX_MATCH = "^(?:\\d{1,3}[.]?)|(?:\\d{1,3}[.]\\d{1,3}[.]?)|(?:(\\d{1,3}[.]){2}\\d{1,3}[.]?)$";
    static final String FULL_IPV4_ADDRESS_MATCH = "^(?:\\d{1,3}[.]){3}\\d{1,3}$";
    static final Predicate<CharSeq> isKssoVersion4IpAddressPrefixNotation = ipAddressPrefixNotation -> ipAddressPrefixNotation.matches(OLD_IP_ADDRESS_PREFIX_MATCH);
    static final Predicate<CharSeq> isKssoVersion4Regex = KssoStringUtils.isPrefixedRegex.and(KssoStringUtils.isCompilingRegex);
    static final Predicate<CharSeq> isFullIpv4AddressPattern = ipAddress -> CharSeq.of((CharSequence)ipAddress).matches(FULL_IPV4_ADDRESS_MATCH);
    static final Predicate<CharSeq> isValidInternetAddress = cs -> Try.of((CheckedFunction0 & Serializable)() -> InetAddress.getByName(cs.mkString())).isSuccess();
    static final Predicate<CharSeq> isValidCidrAddress = cs -> Try.of((CheckedFunction0 & Serializable)() -> new SubnetUtils(cs.mkString())).isSuccess();
    static final Predicate<CharSeq> isEmpty = CharSeq::isEmpty;
    static final Predicate<CharSeq> isValidPermission = Predicates.anyOf((Predicate[])new Predicate[]{isEmpty, isValidInternetAddress, isValidCidrAddress, KssoStringUtils.isValidPrefixAndSuffixRegex});
    private static final Function2<String, String, Boolean> isAddressPermitted = (Function2 & Serializable)(adr, permissions) -> {
        Seq<CharSeq> permissionList = ListParseUtils.parseFromNewlines(permissions);
        CharSeq address = CharSeq.of((CharSequence)adr).trim();
        Predicate<CharSeq> isRegexMatch = regexPermission -> CharSeq.of((CharSequence)address).matches(regexPermission.mkString());
        Predicate isValidRegexMatch = Predicates.allOf((Predicate[])new Predicate[]{KssoStringUtils.isValidPrefixAndSuffixRegex, isRegexMatch});
        Predicate<CharSeq> isInternetAddressMatch = addressPermission -> addressPermission.contentEquals((CharSequence)address);
        Predicate isValidInternetAddressMatch = Predicates.allOf((Predicate[])new Predicate[]{isValidInternetAddress, isInternetAddressMatch});
        Predicate<CharSeq> isValidCidrMatch = cidrPermission -> (Boolean)Try.of((CheckedFunction0 & Serializable)() -> new SubnetUtils(cidrPermission.mkString()).getInfo().isInRange(adr)).getOrElse((Object)false);
        Predicate isValidMatch = Predicates.anyOf((Predicate[])new Predicate[]{isValidInternetAddressMatch, isValidCidrMatch, isValidRegexMatch});
        Predicate<Seq> isAnyValidMatch = css -> (Boolean)css.map(isValidMatch::test).foldLeft((Object)false, Boolean::logicalOr);
        return isAnyValidMatch.test(permissionList);
    };

    public static boolean isNotValidPermission(String permission) {
        return !isValidPermission.test(CharSeq.of((CharSequence)permission));
    }

    public static boolean isValidPermission(String permission) {
        return isValidPermission.test(CharSeq.of((CharSequence)permission));
    }

    public static boolean isValidPermissionList(String permissionList) {
        Predicate<Seq> isValidPermissionList = pList -> pList.forAll(isValidPermission);
        return isValidPermissionList.test(ListParseUtils.parseFromNewlines(permissionList));
    }

    public static boolean isAddressPermissionMatch(String addressExpression, String[] permissionListArray) {
        return InternetAddressUtils.isAddressPermissionMatch(addressExpression, ListParseUtils.arrayToStringWithNewlines(permissionListArray));
    }

    public static boolean isAddressPermissionMatch(String adr, String permissions) {
        return (Boolean)isAddressPermitted.apply((Object)adr, (Object)permissions);
    }

    public static class Versioning {
        private static final Function<CharSeq, CharSeq> transformVersion4PrefixNotationToVersion5Regex = ipRestriction -> (CharSeq)Versioning.extractValuesThatMustBeTransformed(ipRestriction).filter(isKssoVersion4IpAddressPrefixNotation).map(oldPrefix -> oldPrefix.prepend(KssoStringUtils.StringLiteral.REGEX_PREFIX.character())).map(regex -> regex.replaceAll("\\.", "\\\\.")).map(regex -> regex.appendAll((Iterable)CharSeq.of((CharSequence)"[\\d\\.]*"))).map(regex -> regex.append(KssoStringUtils.StringLiteral.REGEX_SUFFIX.character())).getOrElse(ipRestriction);
        private static final Function<CharSeq, CharSeq> transformVersion4RegexToVersion5Regex = prefix -> (CharSeq)Versioning.extractValuesThatMustBeTransformed(prefix).filter(isKssoVersion4Regex).map(oldRegex -> oldRegex.append(KssoStringUtils.StringLiteral.REGEX_SUFFIX.character())).getOrElse(prefix);

        private static Either<String, String> validConvertedPermissionOrErrorMessage(@Nonnull String oldFormatPermission) {
            return (Either)Try.of((CheckedFunction0 & Serializable)() -> CharSeq.of((CharSequence)oldFormatPermission)).filterTry(p -> KssoStringUtils.isValidPrefixAndSuffixRegex.or(isFullIpv4AddressPattern.and(isValidInternetAddress)).test((CharSeq)p)).mapTry(CharSeq::mkString).fold(_throwable -> Either.left((Object)("[Could not convert invalid permission: '" + oldFormatPermission + "'. Must be changed manually.]")), Either::right);
        }

        private static Stream<CharSeq> extractValuesThatMustBeTransformed(CharSeq ipRestriction) {
            return Stream.of((Object)ipRestriction).filter(Predicates.not(KssoStringUtils.isValidPrefixAndSuffixRegex).and(Predicates.not(isFullIpv4AddressPattern)));
        }

        private static CharSeq transformToVersion5Format(CharSeq oldIpRestriction) {
            return (CharSeq)API.Match((Object)oldIpRestriction).of(new API.Match.Case[]{API.Case((API.Match.Pattern0)API.$(isKssoVersion4IpAddressPrefixNotation), transformVersion4PrefixNotationToVersion5Regex), API.Case((API.Match.Pattern0)API.$(isKssoVersion4Regex), transformVersion4RegexToVersion5Regex), API.Case((API.Match.Pattern0)API.$(), () -> oldIpRestriction)});
        }

        public static List<Either<String, String>> convertOldIpRestrictionFormatToVersion5Format(String oldFormatIpRestrictions) {
            return (List)Option.of((Object)oldFormatIpRestrictions).filter(StringUtils::isNotBlank).map(restrictions -> ListParseUtils.parseFromNewlines(restrictions).map(Versioning::transformToVersion5Format).map(CharSeq::mkString).map(Versioning::validConvertedPermissionOrErrorMessage).toList()).getOrElse((Object)List.empty());
        }
    }
}

