/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.utils;

import io.vavr.collection.Stream;
import io.vavr.control.Option;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.kantega.samllib.spi.ServiceProviderSpi;

public class CookieUtil {
    private static final String USERNAME_ATTR = ServiceProviderSpi.class.getName() + "_username";
    public static final String LAST_ACCOUNT_COOKIE = "idp_last_account";

    public static void setLastIdpAccountCookie(String idpId, HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession(true);
        String username = (String)session.getAttribute(USERNAME_ATTR);
        session.removeAttribute(USERNAME_ATTR);
        String cookieVal = idpId;
        if (username != null) {
            cookieVal = cookieVal + ":" + username;
        }
        int maxAge = 31536000;
        String discoverPath = request.getContextPath() + "/plugins/servlet/no.kantega.saml";
        Date expiresDate = new Date(System.currentTimeMillis() + 31536000000L);
        SimpleDateFormat df = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss zzz", Locale.US);
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        String setCookie = "idp_last_account=\"" + cookieVal + "\"; Version=1; Comment=HttpOnly; Max-Age=" + 31536000 + "; Expires=" + df.format(expiresDate) + "; Path=" + discoverPath;
        response.addHeader("Set-Cookie", setCookie);
    }

    public static Option<String> getPreviouslyKnownLoginUsername(HttpServletRequest req) {
        return ((Stream)Option.of((Object)req.getCookies()).map(Stream::of).getOrElse((Object)Stream.empty())).filter(cookie -> LAST_ACCOUNT_COOKIE.equals(cookie.getName())).map(Cookie::getValue).map(value -> value.contains(":") ? value.substring(value.indexOf(":") + 1) : "").headOption();
    }

    public static Option<String> getPreviouslyKnownLoginId(HttpServletRequest req) {
        return ((Stream)Option.of((Object)req.getCookies()).map(Stream::of).getOrElse((Object)Stream.empty())).filter(cookie -> LAST_ACCOUNT_COOKIE.equals(cookie.getName())).map(Cookie::getValue).map(value -> value.contains(":") ? value.substring(0, value.indexOf(":")) : value).headOption();
    }

    public static void keepUsernameInSession(HttpServletRequest req, String username) {
        if (username != null) {
            req.getSession().setAttribute(USERNAME_ATTR, (Object)username);
        } else {
            req.getSession().removeAttribute(USERNAME_ATTR);
        }
    }
}

